/*
 * Decompiled with CFR 0.152.
 */
package com.machinepublishers.jbrowserdriver;

import com.machinepublishers.jbrowserdriver.Element;
import com.machinepublishers.jbrowserdriver.ElementRemote;
import com.machinepublishers.jbrowserdriver.FileRemover;
import com.machinepublishers.jbrowserdriver.Intercept;
import com.machinepublishers.jbrowserdriver.JBrowserDriverRemote;
import com.machinepublishers.jbrowserdriver.JBrowserDriverServer;
import com.machinepublishers.jbrowserdriver.Job;
import com.machinepublishers.jbrowserdriver.Keyboard;
import com.machinepublishers.jbrowserdriver.KeyboardRemote;
import com.machinepublishers.jbrowserdriver.Logs;
import com.machinepublishers.jbrowserdriver.LogsRemote;
import com.machinepublishers.jbrowserdriver.Mouse;
import com.machinepublishers.jbrowserdriver.MouseRemote;
import com.machinepublishers.jbrowserdriver.Navigation;
import com.machinepublishers.jbrowserdriver.NavigationRemote;
import com.machinepublishers.jbrowserdriver.Options;
import com.machinepublishers.jbrowserdriver.OptionsLocal;
import com.machinepublishers.jbrowserdriver.OptionsRemote;
import com.machinepublishers.jbrowserdriver.PortGroup;
import com.machinepublishers.jbrowserdriver.Settings;
import com.machinepublishers.jbrowserdriver.SocketFactory;
import com.machinepublishers.jbrowserdriver.SocketLock;
import com.machinepublishers.jbrowserdriver.TargetLocator;
import com.machinepublishers.jbrowserdriver.TargetLocatorRemote;
import com.machinepublishers.jbrowserdriver.Util;
import com.machinepublishers.jbrowserdriver.diagnostics.Test;
import io.github.lukehutch.fastclasspathscanner.classpath.ClasspathFinder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.rmi.registry.LocateRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.Killable;
import org.openqa.selenium.logging.LogEntries;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.ErrorHandler;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.SessionId;
import org.zeroturnaround.exec.ProcessExecutor;
import org.zeroturnaround.exec.listener.ProcessListener;
import org.zeroturnaround.exec.stream.LogOutputStream;
import org.zeroturnaround.process.PidProcess;
import org.zeroturnaround.process.Processes;

public class JBrowserDriver
extends RemoteWebDriver
implements Killable {
    public static final String KEYBOARD_DELETE = "jbrowserdriver-keyboard-delete";
    private static final Intercept intercept;
    private static final Set<SocketLock> locks;
    private static final Set<Job> waiting;
    private static final Set<PortGroup> portGroupsActive;
    private static final List<String> args;
    private static final Set<String> filteredLogs;
    private static final AtomicLong sessionIdCounter;
    private final JBrowserDriverRemote remote;
    private final Logs logs;
    private final AtomicReference<Process> process = new AtomicReference();
    private final AtomicBoolean processEnded = new AtomicBoolean();
    private final AtomicReference<PortGroup> configuredPortGroup = new AtomicReference();
    private final AtomicReference<PortGroup> actualPortGroup = new AtomicReference();
    private final AtomicReference<OptionsLocal> options = new AtomicReference();
    private final SessionId sessionId;
    private final SocketLock lock = new SocketLock();
    private final File tmpDir;
    private final FileRemover shutdownHook;

    public static List<String> test() {
        return Test.run();
    }

    public JBrowserDriver() {
        this(Settings.builder().build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JBrowserDriver(Capabilities capabilities) {
        this(Settings.builder().build(capabilities));
        if (!(capabilities instanceof Serializable)) {
            capabilities = new DesiredCapabilities(capabilities);
        }
        try {
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                this.remote.storeCapabilities(capabilities);
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JBrowserDriver(Settings settings) {
        Set<SocketLock> set = locks;
        synchronized (set) {
            locks.add(this.lock);
        }
        File tmpDir = null;
        try {
            tmpDir = Files.createTempDirectory("jbd_tmp_", new FileAttribute[0]).toFile();
        }
        catch (Throwable t) {
            Util.handleException(t);
        }
        this.tmpDir = tmpDir;
        this.shutdownHook = new FileRemover(tmpDir);
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        Job job = new Job(settings, this.configuredPortGroup);
        Object object = waiting;
        synchronized (object) {
            waiting.add(job);
            waiting.notifyAll();
        }
        object = job;
        synchronized (object) {
            while (this.configuredPortGroup.get() == null) {
                try {
                    job.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.sessionId = new SessionId(this.launchProcess(settings, this.configuredPortGroup.get()));
        if (this.actualPortGroup.get() == null) {
            Util.handleException(new IllegalStateException("Could not launch browser."));
        }
        JBrowserDriverRemote instanceTmp = null;
        try {
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                instanceTmp = (JBrowserDriverRemote)LocateRegistry.getRegistry(settings.host(), (int)this.actualPortGroup.get().child, new SocketFactory(settings.host(), this.actualPortGroup.get(), locks)).lookup("JBrowserDriverRemote");
                instanceTmp.setUp(settings);
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
        }
        this.remote = instanceTmp;
        LogsRemote logsRemote = null;
        try {
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                logsRemote = this.remote.logs();
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
        }
        this.logs = new Logs(logsRemote, this.lock);
    }

    protected void finalize() throws Throwable {
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            this.shutdownHook.run();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String launchProcess(final Settings settings, final PortGroup portGroup) {
        final AtomicBoolean ready = new AtomicBoolean();
        final AtomicReference<String> logPrefix = new AtomicReference<String>("");
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ArrayList<String> myArgs = new ArrayList<String>(args);
                myArgs.add("-Djava.io.tmpdir=" + JBrowserDriver.this.tmpDir.getAbsolutePath());
                myArgs.add("-Djava.rmi.server.hostname=" + settings.host());
                myArgs.addAll(settings.javaOptions());
                myArgs.add(JBrowserDriverServer.class.getName());
                myArgs.add(Long.toString(portGroup.child));
                myArgs.add(Long.toString(portGroup.parent));
                myArgs.add(Long.toString(portGroup.parentAlt));
                try {
                    new ProcessExecutor().environment(System.getenv()).addListener(new ProcessListener(){

                        public void afterStop(Process process) {
                            intercept.deallocate();
                        }

                        public void beforeStart(ProcessExecutor executor) {
                            intercept.allocate();
                        }

                        public void afterStart(Process proc, ProcessExecutor executor) {
                            JBrowserDriver.this.process.set(proc);
                        }
                    }).redirectOutput((OutputStream)new LogOutputStream(){
                        boolean done = false;

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        protected void processLine(String line) {
                            if (line != null && !line.isEmpty()) {
                                if (!this.done) {
                                    AtomicBoolean atomicBoolean = ready;
                                    synchronized (atomicBoolean) {
                                        if (line.startsWith("ready on ports ")) {
                                            String[] parts = line.substring("ready on ports ".length()).split("/");
                                            JBrowserDriver.this.actualPortGroup.set(new PortGroup(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2])));
                                            logPrefix.set("[Instance " + sessionIdCounter.incrementAndGet() + "][Port " + ((PortGroup)((JBrowserDriver)JBrowserDriver.this).actualPortGroup.get()).child + "]");
                                            ready.set(true);
                                            ready.notifyAll();
                                            this.done = true;
                                        } else {
                                            JBrowserDriver.log(settings.logger(), (String)logPrefix.get(), line);
                                        }
                                    }
                                } else {
                                    JBrowserDriver.log(settings.logger(), (String)logPrefix.get(), line);
                                }
                            }
                        }
                    }).redirectError((OutputStream)new LogOutputStream(){

                        protected void processLine(String line) {
                            JBrowserDriver.log(settings.logger(), (String)logPrefix.get(), line);
                        }
                    }).destroyOnExit().command(myArgs).execute();
                }
                catch (Throwable t) {
                    Util.handleException(t);
                }
                JBrowserDriver.this.endProcess();
                FileUtils.deleteQuietly((File)JBrowserDriver.this.tmpDir);
                AtomicBoolean atomicBoolean = ready;
                synchronized (atomicBoolean) {
                    ready.set(true);
                    ready.notifyAll();
                }
            }
        }).start();
        AtomicBoolean atomicBoolean = ready;
        synchronized (atomicBoolean) {
            while (!ready.get()) {
                try {
                    ready.wait();
                    break;
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
        return logPrefix.get();
    }

    private static void log(Logger logger, String prefix, String message) {
        if (logger != null && !filteredLogs.contains(message)) {
            LogRecord record = null;
            if (message.startsWith(">")) {
                String[] parts = message.substring(1).split("/", 3);
                record = new LogRecord(Level.parse(parts[0]), prefix + " " + parts[2]);
                record.setSourceMethodName(parts[1]);
                record.setSourceClassName(JBrowserDriver.class.getName());
            } else {
                record = new LogRecord(Level.WARNING, prefix + " " + message);
                record.setSourceMethodName(null);
                record.setSourceClassName(JBrowserDriver.class.getName());
            }
            logger.log(record);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        try {
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                this.remote.init();
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(Settings settings) {
        try {
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                this.remote.reset(settings);
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(Capabilities capabilities) {
        Settings settings = Settings.builder().build(capabilities);
        try {
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                this.remote.reset(settings);
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
        }
        if (!(capabilities instanceof Serializable)) {
            capabilities = new DesiredCapabilities(capabilities);
        }
        try {
            SocketLock t = this.lock;
            synchronized (t) {
                this.remote.storeCapabilities(capabilities);
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        try {
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                this.remote.reset();
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPageSource() {
        try {
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                return this.remote.getPageSource();
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCurrentUrl() {
        try {
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                return this.remote.getCurrentUrl();
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStatusCode() {
        try {
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                return this.remote.getStatusCode();
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pageWait() {
        try {
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                this.remote.pageWait();
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTitle() {
        try {
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                return this.remote.getTitle();
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void get(String url) {
        try {
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                this.remote.get(url);
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebElement findElement(By by) {
        try {
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                return Element.constructElement(this.remote.findElement(by), this, this.lock);
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WebElement> findElements(By by) {
        try {
            List<ElementRemote> elements;
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                elements = this.remote.findElements(by);
            }
            return Element.constructList(elements, this, this.lock);
        }
        catch (Throwable t) {
            Util.handleException(t);
            return new ArrayList<WebElement>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebElement findElementById(String id) {
        try {
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                return Element.constructElement(this.remote.findElementById(id), this, this.lock);
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WebElement> findElementsById(String id) {
        try {
            List<ElementRemote> elements;
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                elements = this.remote.findElementsById(id);
            }
            return Element.constructList(elements, this, this.lock);
        }
        catch (Throwable t) {
            Util.handleException(t);
            return new ArrayList<WebElement>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebElement findElementByXPath(String expr) {
        try {
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                return Element.constructElement(this.remote.findElementByXPath(expr), this, this.lock);
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WebElement> findElementsByXPath(String expr) {
        try {
            List<ElementRemote> elements;
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                elements = this.remote.findElementsByXPath(expr);
            }
            return Element.constructList(elements, this, this.lock);
        }
        catch (Throwable t) {
            Util.handleException(t);
            return new ArrayList<WebElement>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebElement findElementByLinkText(String text) {
        try {
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                return Element.constructElement(this.remote.findElementByLinkText(text), this, this.lock);
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebElement findElementByPartialLinkText(String text) {
        try {
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                return Element.constructElement(this.remote.findElementByPartialLinkText(text), this, this.lock);
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WebElement> findElementsByLinkText(String text) {
        try {
            List<ElementRemote> elements;
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                elements = this.remote.findElementsByLinkText(text);
            }
            return Element.constructList(elements, this, this.lock);
        }
        catch (Throwable t) {
            Util.handleException(t);
            return new ArrayList<WebElement>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WebElement> findElementsByPartialLinkText(String text) {
        try {
            List<ElementRemote> elements;
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                elements = this.remote.findElementsByPartialLinkText(text);
            }
            return Element.constructList(elements, this, this.lock);
        }
        catch (Throwable t) {
            Util.handleException(t);
            return new ArrayList<WebElement>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebElement findElementByClassName(String cssClass) {
        try {
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                return Element.constructElement(this.remote.findElementByClassName(cssClass), this, this.lock);
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WebElement> findElementsByClassName(String cssClass) {
        try {
            List<ElementRemote> elements;
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                elements = this.remote.findElementsByClassName(cssClass);
            }
            return Element.constructList(elements, this, this.lock);
        }
        catch (Throwable t) {
            Util.handleException(t);
            return new ArrayList<WebElement>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebElement findElementByName(String name) {
        try {
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                return Element.constructElement(this.remote.findElementByName(name), this, this.lock);
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WebElement> findElementsByName(String name) {
        try {
            List<ElementRemote> elements;
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                elements = this.remote.findElementsByName(name);
            }
            return Element.constructList(elements, this, this.lock);
        }
        catch (Throwable t) {
            Util.handleException(t);
            return new ArrayList<WebElement>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebElement findElementByCssSelector(String expr) {
        try {
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                return Element.constructElement(this.remote.findElementByCssSelector(expr), this, this.lock);
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WebElement> findElementsByCssSelector(String expr) {
        try {
            List<ElementRemote> elements;
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                elements = this.remote.findElementsByCssSelector(expr);
            }
            return Element.constructList(elements, this, this.lock);
        }
        catch (Throwable t) {
            Util.handleException(t);
            return new ArrayList<WebElement>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebElement findElementByTagName(String tagName) {
        try {
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                return Element.constructElement(this.remote.findElementByTagName(tagName), this, this.lock);
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WebElement> findElementsByTagName(String tagName) {
        try {
            List<ElementRemote> elements;
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                elements = this.remote.findElementsByTagName(tagName);
            }
            return Element.constructList(elements, this, this.lock);
        }
        catch (Throwable t) {
            Util.handleException(t);
            return new ArrayList<WebElement>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeAsyncScript(String script, Object ... args) {
        try {
            Object result;
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                result = this.remote.executeAsyncScript(script, Element.scriptParams(args));
            }
            return Element.constructObject(result, this, this.lock);
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeScript(String script, Object ... args) {
        try {
            Object result;
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                result = this.remote.executeScript(script, Element.scriptParams(args));
            }
            return Element.constructObject(result, this, this.lock);
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.openqa.selenium.interactions.Keyboard getKeyboard() {
        try {
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                KeyboardRemote keyboard = this.remote.getKeyboard();
                if (keyboard == null) {
                    return null;
                }
                return new Keyboard(keyboard, this.lock);
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.openqa.selenium.interactions.Mouse getMouse() {
        try {
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                MouseRemote mouse = this.remote.getMouse();
                if (mouse == null) {
                    return null;
                }
                return new Mouse(mouse, this.lock);
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Capabilities getCapabilities() {
        try {
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                return this.remote.getCapabilities();
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                this.remote.close();
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
        }
        Set<String> handles = this.getWindowHandles();
        if (handles == null || handles.isEmpty()) {
            this.quit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getWindowHandle() {
        try {
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                return this.remote.getWindowHandle();
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getWindowHandles() {
        try {
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                return this.remote.getWindowHandles();
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebDriver.Options manage() {
        if (this.options.get() == null) {
            try {
                SocketLock socketLock = this.lock;
                synchronized (socketLock) {
                    OptionsRemote optionsRemote = this.remote.manage();
                    if (optionsRemote == null) {
                        return null;
                    }
                    return new Options(optionsRemote, this.logs, this.lock);
                }
            }
            catch (Throwable t) {
                Util.handleException(t);
                return null;
            }
        }
        return this.options.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebDriver.Navigation navigate() {
        try {
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                NavigationRemote navigation = this.remote.navigate();
                if (navigation == null) {
                    return null;
                }
                return new Navigation(navigation, this.lock);
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endProcess() {
        if (this.processEnded.compareAndSet(false, true)) {
            Process proc = this.process.get();
            if (proc != null) {
                while (proc.isAlive()) {
                    try {
                        PidProcess pidProcess = Processes.newPidProcess((Process)proc);
                        try {
                            if (pidProcess.destroyGracefully().waitFor(10L, TimeUnit.SECONDS)) continue;
                            throw new RuntimeException();
                        }
                        catch (Throwable t1) {
                            if (pidProcess.destroyForcefully().waitFor(10L, TimeUnit.SECONDS)) continue;
                            throw new RuntimeException();
                        }
                    }
                    catch (Throwable t2) {
                        try {
                            proc.destroyForcibly().waitFor(10L, TimeUnit.SECONDS);
                        }
                        catch (Throwable throwable) {}
                    }
                }
            }
            Set<Object> set = locks;
            synchronized (set) {
                locks.remove(this.lock);
            }
            set = waiting;
            synchronized (set) {
                portGroupsActive.remove(this.configuredPortGroup.get());
                waiting.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveData() {
        try {
            OptionsRemote optionsRemote;
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                optionsRemote = this.remote.manage();
            }
            Set<Cookie> cookiesLocal = optionsRemote.getCookies();
            LogsRemote logsRemote = optionsRemote.logs();
            final LogEntries entries = logsRemote.getRemote(null).toLogEntries();
            final Set<String> types = logsRemote.getAvailableLogTypes();
            org.openqa.selenium.logging.Logs logsLocal = new org.openqa.selenium.logging.Logs(){

                public Set<String> getAvailableLogTypes() {
                    return types;
                }

                public LogEntries get(String logType) {
                    return entries;
                }
            };
            this.options.set(new OptionsLocal(cookiesLocal, logsLocal));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quit() {
        this.saveData();
        try {
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                this.remote.quit();
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
        }
        finally {
            this.endProcess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebDriver.TargetLocator switchTo() {
        try {
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                TargetLocatorRemote locator = this.remote.switchTo();
                if (locator == null) {
                    return null;
                }
                return new TargetLocator(locator, this, this.lock);
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    public void kill() {
        this.endProcess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <X> X getScreenshotAs(OutputType<X> outputType) throws WebDriverException {
        try {
            byte[] bytes;
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                bytes = this.remote.getScreenshot();
            }
            if (bytes == null) {
                return null;
            }
            return (X)outputType.convertFromPngBytes(bytes);
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File cacheDir() {
        try {
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                return this.remote.cacheDir();
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File attachmentsDir() {
        try {
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                return this.remote.attachmentsDir();
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File mediaDir() {
        try {
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                return this.remote.mediaDir();
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    public SessionId getSessionId() {
        return this.sessionId;
    }

    public ErrorHandler getErrorHandler() {
        return super.getErrorHandler();
    }

    public CommandExecutor getCommandExecutor() {
        return super.getCommandExecutor();
    }

    public FileDetector getFileDetector() {
        return super.getFileDetector();
    }

    static {
        Intercept interceptTmp = null;
        try {
            interceptTmp = new Intercept();
        }
        catch (Throwable t) {
            Util.handleException(t);
        }
        intercept = interceptTmp;
        locks = new HashSet<SocketLock>();
        waiting = new LinkedHashSet<Job>();
        portGroupsActive = new LinkedHashSet<PortGroup>();
        filteredLogs = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("Warning: Single GUI Threadiong is enabled, FPS should be slower")));
        sessionIdCounter = new AtomicLong();
        ArrayList<String> argsTmp = new ArrayList<String>();
        try {
            File javaBin = new File(System.getProperty("java.home") + "/bin/java");
            if (!javaBin.exists()) {
                javaBin = new File(javaBin.getCanonicalPath() + ".exe");
            }
            argsTmp.add(javaBin.getCanonicalPath());
            for (Object keyObj : System.getProperties().keySet()) {
                String key = keyObj.toString();
                if (key == null || !key.startsWith("jbd.rmi.")) continue;
                argsTmp.add("-D" + key.substring("jbd.rmi.".length()) + "=" + System.getProperty(key));
            }
            ArrayList items = new ClasspathFinder().getUniqueClasspathElements();
            File classpathDir = Files.createTempDirectory("jbd_classpath_", new FileAttribute[0]).toFile();
            Runtime.getRuntime().addShutdownHook(new FileRemover(classpathDir));
            ArrayList<String> paths = new ArrayList<String>();
            for (File curItem : items) {
                paths.add(curItem.getAbsoluteFile().toURI().toURL().toExternalForm());
                if (!curItem.isFile() || !curItem.getPath().endsWith(".jar")) continue;
                ZipFile jar = new ZipFile(curItem);
                Throwable throwable = null;
                try {
                    Enumeration<? extends ZipEntry> entries = jar.entries();
                    while (entries.hasMoreElements()) {
                        ZipEntry entry = entries.nextElement();
                        if (!entry.getName().endsWith(".jar")) continue;
                        InputStream in = jar.getInputStream(entry);
                        Throwable throwable2 = null;
                        try {
                            File childJar = new File(classpathDir, Util.randomFileName() + ".jar");
                            Files.copy(in, childJar.toPath(), new CopyOption[0]);
                            paths.add(childJar.getAbsoluteFile().toURI().toURL().toExternalForm());
                            childJar.deleteOnExit();
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (in == null) continue;
                            if (throwable2 != null) {
                                try {
                                    in.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            in.close();
                        }
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (jar == null) continue;
                    if (throwable != null) {
                        try {
                            jar.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    jar.close();
                }
            }
            Manifest manifest = new Manifest();
            manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
            manifest.getMainAttributes().put(Attributes.Name.CLASS_PATH, StringUtils.join(paths, (char)' '));
            File classpathJar = new File(classpathDir, "classpath.jar");
            classpathJar.deleteOnExit();
            new JarOutputStream((OutputStream)new FileOutputStream(classpathJar), manifest).close();
            argsTmp.add("-classpath");
            argsTmp.add(classpathJar.getCanonicalPath());
        }
        catch (Throwable t) {
            Util.handleException(t);
        }
        args = Collections.unmodifiableList(argsTmp);
        Thread work = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Set set = waiting;
                synchronized (set) {
                    block8: while (true) {
                        while (true) {
                            ArrayList<Job> selectedJobs = new ArrayList<Job>();
                            for (Job job : waiting) {
                                for (PortGroup curPortGroup : job.settings.portGroups()) {
                                    boolean conflicts = false;
                                    for (PortGroup curUsed : portGroupsActive) {
                                        if (!curUsed.conflicts(curPortGroup)) continue;
                                        conflicts = true;
                                        break;
                                    }
                                    if (conflicts) continue;
                                    job.portGroup.set(curPortGroup);
                                    break;
                                }
                                if (job.portGroup.get() == null) continue;
                                selectedJobs.add(job);
                                portGroupsActive.add(job.portGroup.get());
                            }
                            for (Job job : selectedJobs) {
                                waiting.remove(job);
                                Job job2 = job;
                                synchronized (job2) {
                                    job.notifyAll();
                                }
                            }
                            try {
                                waiting.wait();
                                continue block8;
                            }
                            catch (InterruptedException interruptedException) {
                                continue;
                            }
                            break;
                        }
                    }
                }
            }
        });
        work.setDaemon(true);
        work.setName("JBrowserDriver queued instance handler");
        work.start();
    }
}

