/*
 * Decompiled with CFR 0.152.
 */
package com.machinepublishers.jbrowserdriver;

import com.machinepublishers.jbrowserdriver.LogsServer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.http.client.cache.HttpCacheEntry;
import org.apache.http.client.cache.HttpCacheStorage;
import org.apache.http.client.cache.HttpCacheUpdateCallback;
import org.apache.http.client.cache.HttpCacheUpdateException;

class HttpCache
implements HttpCacheStorage {
    private final File cacheDir;

    HttpCache(File cacheDir) {
        this.cacheDir = cacheDir;
    }

    public void updateEntry(String key, HttpCacheUpdateCallback callback) throws IOException, HttpCacheUpdateException {
        HttpCacheEntry entry = callback.update(this.getEntry(key));
        this.removeEntry(key);
        this.putEntry(key, entry);
    }

    public void removeEntry(String key) throws IOException {
        File file = new File(this.cacheDir, DigestUtils.sha1Hex((String)key));
        if (file.exists()) {
            try (Lock lock = new Lock(file, false);){
                file.delete();
            }
        }
    }

    public void putEntry(String key, HttpCacheEntry entry) throws IOException {
        File file = new File(this.cacheDir, DigestUtils.sha1Hex((String)key));
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try (Lock lock = new Lock(file, false);){
                BufferedOutputStream bufferOut = new BufferedOutputStream(lock.streamOut);
                try (ObjectOutputStream objectOut = new ObjectOutputStream(bufferOut);){
                    objectOut.writeObject(entry);
                }
            }
        }
    }

    /*
     * Loose catch block
     */
    public HttpCacheEntry getEntry(String key) throws IOException {
        block34: {
            File file = new File(this.cacheDir, DigestUtils.sha1Hex((String)key));
            if (!file.exists()) break block34;
            Throwable throwable = null;
            try (Lock lock = new Lock(file, true);){
                HttpCacheEntry httpCacheEntry;
                Throwable throwable2;
                ObjectInputStream objectIn;
                block32: {
                    block33: {
                        BufferedInputStream bufferIn = new BufferedInputStream(lock.streamIn);
                        objectIn = new ObjectInputStream(bufferIn);
                        throwable2 = null;
                        httpCacheEntry = (HttpCacheEntry)objectIn.readObject();
                        if (objectIn == null) break block32;
                        if (throwable2 == null) break block33;
                        try {
                            objectIn.close();
                        }
                        catch (Throwable throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        break block32;
                    }
                    objectIn.close();
                }
                return httpCacheEntry;
                catch (Throwable throwable4) {
                    try {
                        try {
                            try {
                                throwable2 = throwable4;
                                throw throwable4;
                            }
                            catch (Throwable throwable5) {
                                if (objectIn != null) {
                                    if (throwable2 != null) {
                                        try {
                                            objectIn.close();
                                        }
                                        catch (Throwable throwable6) {
                                            throwable2.addSuppressed(throwable6);
                                        }
                                    } else {
                                        objectIn.close();
                                    }
                                }
                                throw throwable5;
                            }
                        }
                        catch (Throwable t) {
                            LogsServer.instance().exception(t);
                            if (lock != null) {
                                if (throwable != null) {
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable throwable7) {
                                        throwable.addSuppressed(throwable7);
                                    }
                                } else {
                                    lock.close();
                                }
                            }
                        }
                    }
                    catch (Throwable throwable8) {
                        throwable = throwable8;
                        throw throwable8;
                    }
                    catch (Throwable throwable9) {
                        throw throwable9;
                    }
                }
            }
        }
        return null;
    }

    private static class Lock
    implements Closeable {
        private static final Set<String> locks = new HashSet<String>();
        private String lockName;
        private FileLock fileLock;
        private FileInputStream streamIn;
        private FileOutputStream streamOut;
        private FileChannel channel;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Lock(File file, boolean read) {
            this.lockName = file.getAbsolutePath();
            Set<String> set = locks;
            synchronized (set) {
                block11: while (true) {
                    try {
                        while (true) {
                            if (!locks.contains(this.lockName)) {
                                locks.add(this.lockName);
                                break block11;
                            }
                            locks.wait();
                        }
                    }
                    catch (Throwable throwable) {
                        continue;
                    }
                    break;
                }
            }
            try {
                if (read) {
                    this.streamIn = new FileInputStream(file);
                    this.channel = this.streamIn.getChannel();
                } else {
                    this.streamOut = new FileOutputStream(file);
                    this.channel = this.streamOut.getChannel();
                }
                while (true) {
                    try {
                        this.fileLock = this.channel.lock(0L, Long.MAX_VALUE, read);
                    }
                    catch (Throwable t) {
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable t) {
                LogsServer.instance().exception(t);
                this.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            if (this.fileLock != null && this.channel != null && this.channel.isOpen()) {
                try {
                    this.fileLock.release();
                }
                catch (Throwable t) {
                    LogsServer.instance().exception(t);
                }
            }
            if (this.streamIn != null) {
                try {
                    this.streamIn.close();
                }
                catch (Throwable t) {
                    LogsServer.instance().exception(t);
                }
            }
            if (this.streamOut != null) {
                try {
                    this.streamOut.close();
                }
                catch (Throwable t) {
                    LogsServer.instance().exception(t);
                }
            }
            Set<String> set = locks;
            synchronized (set) {
                locks.remove(this.lockName);
                locks.notifyAll();
            }
        }
    }
}

