/*
 * Decompiled with CFR 0.152.
 */
package com.machinepublishers.jbrowserdriver;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import netscape.javascript.JSObject;

class Frames {
    private Frame root;

    Frames() {
    }

    long rootId() {
        return this.root == null ? 0L : this.root.id;
    }

    void reset(long id) {
        Frame frame = this.findFrame(this.root, id);
        if (frame != null) {
            frame.children.clear();
        }
    }

    void add(long id, JSObject doc, JSObject owner, long parentId) {
        Frame frame = new Frame(id, doc, owner, parentId);
        Frame foundFrame = this.findFrame(this.root, id);
        if (foundFrame != null) {
            frame.children.addAll(foundFrame.children);
        }
        if (this.root == null || id == this.root.id) {
            this.root = frame;
        } else {
            Frame foundParent = this.findFrame(this.root, parentId);
            if (foundParent != null) {
                foundParent.children.remove(frame);
                foundParent.children.add(frame);
            }
        }
    }

    boolean conatins(JSObject doc) {
        return this.findId(this.root, doc) != 0L;
    }

    long id(JSObject doc) {
        return this.findId(this.root, doc);
    }

    List<Long> ancestors(long frameId) {
        Frame frame;
        ArrayList<Long> ancestors = new ArrayList<Long>();
        while ((frame = this.findFrame(this.root, frameId)) != null && frame.parentId != 0L) {
            ancestors.add(frame.parentId);
            frameId = frame.parentId;
        }
        return ancestors;
    }

    private long findId(Frame cur, JSObject toFind) {
        if (cur == null) {
            return 0L;
        }
        if (cur.doc.equals(toFind) || cur.owner != null && cur.owner.equals(toFind)) {
            return cur.id;
        }
        for (Frame next : cur.children) {
            long id = this.findId(next, toFind);
            if (id == 0L) continue;
            return id;
        }
        return 0L;
    }

    private Frame findFrame(Frame cur, long toFind) {
        if (cur == null) {
            return null;
        }
        if (cur.id == toFind) {
            return cur;
        }
        for (Frame next : cur.children) {
            Frame found = this.findFrame(next, toFind);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    private static final class Frame {
        final Long id;
        final JSObject doc;
        final JSObject owner;
        final Long parentId;
        final Set<Frame> children = new HashSet<Frame>();

        Frame(long id, JSObject doc, JSObject owner, long parentId) {
            this.id = id;
            this.doc = doc;
            this.owner = owner;
            this.parentId = parentId;
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof Frame) {
                return this.id.equals(((Frame)other).id);
            }
            return false;
        }

        public String toString() {
            return this.id.toString();
        }
    }
}

