/*
 * Decompiled with CFR 0.152.
 */
package com.machinepublishers.jbrowserdriver;

import com.machinepublishers.jbrowserdriver.AlertServer;
import com.machinepublishers.jbrowserdriver.AppThread;
import com.machinepublishers.jbrowserdriver.ContextItem;
import com.machinepublishers.jbrowserdriver.JBrowserDriverServer;
import com.machinepublishers.jbrowserdriver.KeyboardServer;
import com.machinepublishers.jbrowserdriver.MouseServer;
import com.machinepublishers.jbrowserdriver.NavigationServer;
import com.machinepublishers.jbrowserdriver.OptionsServer;
import com.machinepublishers.jbrowserdriver.Robot;
import com.machinepublishers.jbrowserdriver.TargetLocatorServer;
import com.machinepublishers.jbrowserdriver.TimeoutsServer;
import com.machinepublishers.jbrowserdriver.Util;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.openqa.selenium.Capabilities;

class Context {
    final AtomicBoolean initialized = new AtomicBoolean();
    final AtomicReference<TimeoutsServer> timeouts = new AtomicReference();
    final AtomicReference<TargetLocatorServer> targetLocator = new AtomicReference();
    final AtomicReference<OptionsServer> options = new AtomicReference();
    final AtomicReference<KeyboardServer> keyboard = new AtomicReference();
    final AtomicReference<MouseServer> mouse = new AtomicReference();
    final AtomicReference<Capabilities> capabilities = new AtomicReference();
    final AtomicReference<NavigationServer> navigation = new AtomicReference();
    final AtomicReference<AlertServer> alert = new AtomicReference();
    final AtomicReference<Robot> robot = new AtomicReference();
    final AtomicInteger statusCode = new AtomicInteger(-1);
    private final Map<String, ContextItem> itemMap = new LinkedHashMap<String, ContextItem>();
    private final List<ContextItem> items = new ArrayList<ContextItem>();
    private int current = 0;
    private final Object lock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Context() {
        Object object = this.lock = new Object();
        synchronized (object) {
            ContextItem newContext = new ContextItem();
            this.items.add(newContext);
            this.itemMap.put(newContext.itemId.get(), newContext);
            try {
                this.timeouts.set(new TimeoutsServer());
                this.alert.set(new AlertServer(this.timeouts));
            }
            catch (RemoteException e) {
                Util.handleException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reset(JBrowserDriverServer driver) {
        this.removeItems();
        Object object = this.lock;
        synchronized (object) {
            this.statusCode.set(-1);
            ContextItem newContext = new ContextItem();
            newContext.init(driver, this);
            this.items.add(newContext);
            this.itemMap.put(newContext.itemId.get(), newContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init(JBrowserDriverServer driver) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.items.isEmpty()) {
                this.items.get(this.current).init(driver, this);
            }
            if (this.initialized.compareAndSet(false, true)) {
                this.robot.set(new Robot(this));
                try {
                    this.targetLocator.set(new TargetLocatorServer(driver, this));
                    this.keyboard.set(new KeyboardServer(this.robot));
                    this.mouse.set(new MouseServer(this.robot));
                    this.navigation.set(new NavigationServer(new AtomicReference<JBrowserDriverServer>(driver), this, this.statusCode));
                    this.options.set(new OptionsServer(this, this.timeouts));
                }
                catch (RemoteException e) {
                    Util.handleException(e);
                }
            }
        }
    }

    ContextItem item() {
        if (this.current < this.items.size()) {
            return this.items.get(this.current);
        }
        return null;
    }

    List<ContextItem> items() {
        return this.items;
    }

    String itemId() {
        return AppThread.exec(this.statusCode, new AppThread.Sync<String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String perform() {
                Object object = Context.this.lock;
                synchronized (object) {
                    return ((ContextItem)((Context)Context.this).items.get((int)((Context)Context.this).current)).itemId.get();
                }
            }
        });
    }

    Set<String> itemIds() {
        return AppThread.exec(this.statusCode, new AppThread.Sync<Set<String>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Set<String> perform() {
                Object object = Context.this.lock;
                synchronized (object) {
                    return new LinkedHashSet<String>(Context.this.itemMap.keySet());
                }
            }
        });
    }

    ContextItem spawn(final JBrowserDriverServer driver) {
        final Context thisObj = this;
        return AppThread.exec(this.statusCode, new AppThread.Sync<ContextItem>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ContextItem perform() {
                Object object = Context.this.lock;
                synchronized (object) {
                    ContextItem newContext = new ContextItem();
                    newContext.init(driver, thisObj);
                    newContext.stage.get().toBack();
                    Context.this.items.add(newContext);
                    Context.this.itemMap.put(newContext.itemId.get(), newContext);
                    return newContext;
                }
            }
        });
    }

    void setCurrent(final String id) {
        AppThread.exec(this.statusCode, new AppThread.Sync<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object perform() {
                Object object = Context.this.lock;
                synchronized (object) {
                    Context.this.current = Context.this.items.indexOf(Context.this.itemMap.get(id));
                    ((ContextItem)((Context)Context.this).items.get((int)((Context)Context.this).current)).stage.get().toFront();
                    return null;
                }
            }
        });
    }

    void removeItem() {
        AppThread.exec(this.statusCode, new AppThread.Sync<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object perform() {
                Object object = Context.this.lock;
                synchronized (object) {
                    ((ContextItem)((Context)Context.this).items.get((int)((Context)Context.this).current)).stage.get().close();
                    Context.this.itemMap.remove(((ContextItem)((Context)Context.this).items.remove((int)((Context)Context.this).current)).itemId.get());
                    Context.this.current = 0;
                    return null;
                }
            }
        });
    }

    void removeItem(final String itemId) {
        AppThread.exec(this.statusCode, new AppThread.Sync<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object perform() {
                Object object = Context.this.lock;
                synchronized (object) {
                    ((ContextItem)((Context)Context.this).itemMap.remove((Object)itemId)).stage.get().close();
                    Context.this.items.remove(itemId);
                    Context.this.current = 0;
                    return null;
                }
            }
        });
    }

    void removeItems() {
        AppThread.exec(this.statusCode, new AppThread.Sync<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object perform() {
                Object object = Context.this.lock;
                synchronized (object) {
                    for (ContextItem curItem : Context.this.items) {
                        curItem.stage.get().close();
                    }
                    Context.this.items.clear();
                    Context.this.itemMap.clear();
                    Context.this.current = 0;
                    return null;
                }
            }
        });
    }
}

