/*
 * Decompiled with CFR 0.152.
 */
package com.lyra.rest.client;

import com.lyra.rest.client.ClientException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

class ClientCryptUtil {
    private static final char[] DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final String DEFAULT_CHARSET_NAME = "UTF-8";
    static final String ALGORITHM_HMAC_SHA256 = "sha256_hmac";
    static final String[] SUPPORTED_ALGORITHMS = new String[]{"sha256_hmac"};

    private ClientCryptUtil() {
    }

    static boolean isAlgorithmSupported(String algorithm) {
        return Arrays.asList(SUPPORTED_ALGORITHMS).contains(algorithm);
    }

    static String calculateHash(String src, String key, String algorithm) {
        if (src == null) {
            throw new ClientException("Provided message is null. It is impossible to generate the hash!");
        }
        if (key == null) {
            throw new ClientException("Provided key is null. It is impossible to generate the hash without a key!");
        }
        try {
            src = src.replace("\\/", "/");
            byte[] messageBytes = src.getBytes(DEFAULT_CHARSET_NAME);
            byte[] keyBytes = key.getBytes(DEFAULT_CHARSET_NAME);
            switch (algorithm) {
                default: 
            }
            return new String(ClientCryptUtil.encodeHex(ClientCryptUtil.getHashHmacSha256(keyBytes, messageBytes), DIGITS_LOWER));
        }
        catch (Exception e) {
            throw new ClientException("Unexpected error generating message hash", e);
        }
    }

    private static byte[] getHashHmacSha256(byte[] keyBytes, byte[] text) throws NoSuchAlgorithmException, InvalidKeyException {
        Mac hmacSha256;
        try {
            hmacSha256 = Mac.getInstance("HmacSHA256");
        }
        catch (NoSuchAlgorithmException nsae) {
            hmacSha256 = Mac.getInstance("HMAC-SHA-256");
        }
        SecretKeySpec macKey = new SecretKeySpec(keyBytes, "RAW");
        hmacSha256.init(macKey);
        return hmacSha256.doFinal(text);
    }

    private static char[] encodeHex(byte[] data, char[] toDigits) {
        int l = data.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            out[j++] = toDigits[(0xF0 & data[i]) >>> 4];
            out[j++] = toDigits[0xF & data[i]];
        }
        return out;
    }
}

