/*
 * Decompiled with CFR 0.152.
 */
package com.lyra.rest.client;

public class ClientConfiguration {
    public static final String CONFIGURATION_KEY_USERNAME = "username";
    public static final String CONFIGURATION_KEY_PASSWORD = "password";
    public static final String CONFIGURATION_KEY_REST_API_SERVER_NAME = "restApiServerName";
    public static final String CONFIGURATION_KEY_PROXY_HOST = "proxyHost";
    public static final String CONFIGURATION_KEY_PROXY_PORT = "proxyPort";
    public static final String CONFIGURATION_KEY_CONNECTION_TIMEOUT = "connectionTimeout";
    public static final String CONFIGURATION_KEY_REQUEST_TIMEOUT = "requestTimeout";
    public static final String CONFIGURATION_KEY_HASH_KEY = "hashKey";
    private String username;
    private String password;
    private String restApiServerName;
    private String proxyHost;
    private String proxyPort;
    private String connectionTimeout;
    private String requestTimeout;
    private String hashKey;

    ClientConfiguration(String username, String password, String restApiServerName, String proxyHost, String proxyPort, String connectionTimeout, String requestTimeout, String hashKey) {
        this.username = username;
        this.password = password;
        this.restApiServerName = restApiServerName;
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.connectionTimeout = connectionTimeout;
        this.requestTimeout = requestTimeout;
        this.hashKey = hashKey;
    }

    public static ClientConfigurationBuilder builder() {
        return new ClientConfigurationBuilder();
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getRestApiServerName() {
        return this.restApiServerName;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public String getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public String getRequestTimeout() {
        return this.requestTimeout;
    }

    public String getHashKey() {
        return this.hashKey;
    }

    public static class ClientConfigurationBuilder {
        private String username;
        private String password;
        private String restApiServerName;
        private String proxyHost;
        private String proxyPort;
        private String connectionTimeout;
        private String requestTimeout;
        private String hashKey;

        ClientConfigurationBuilder() {
        }

        public ClientConfigurationBuilder username(String username) {
            this.username = username;
            return this;
        }

        public ClientConfigurationBuilder password(String password) {
            this.password = password;
            return this;
        }

        public ClientConfigurationBuilder restApiServerName(String restApiServerName) {
            this.restApiServerName = restApiServerName;
            return this;
        }

        public ClientConfigurationBuilder proxyHost(String proxyHost) {
            this.proxyHost = proxyHost;
            return this;
        }

        public ClientConfigurationBuilder proxyPort(String proxyPort) {
            this.proxyPort = proxyPort;
            return this;
        }

        public ClientConfigurationBuilder connectionTimeout(String connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        public ClientConfigurationBuilder requestTimeout(String requestTimeout) {
            this.requestTimeout = requestTimeout;
            return this;
        }

        public ClientConfigurationBuilder hashKey(String hashKey) {
            this.hashKey = hashKey;
            return this;
        }

        public ClientConfiguration build() {
            return new ClientConfiguration(this.username, this.password, this.restApiServerName, this.proxyHost, this.proxyPort, this.connectionTimeout, this.requestTimeout, this.hashKey);
        }

        public String toString() {
            return "ClientConfiguration.ClientConfigurationBuilder(username=" + this.username + ", password=" + this.password + ", restApiServerName=" + this.restApiServerName + ", proxyHost=" + this.proxyHost + ", proxyPort=" + this.proxyPort + ", connectionTimeout=" + this.connectionTimeout + ", requestTimeout=" + this.requestTimeout + ", hashKey=" + this.hashKey + ")";
        }
    }
}

