/*
 * Decompiled with CFR 0.152.
 */
package com.lyft.kronos.internal.ntp;

import com.lyft.kronos.Clock;
import com.lyft.kronos.DefaultParam;
import com.lyft.kronos.KronosTime;
import com.lyft.kronos.SyncListener;
import com.lyft.kronos.internal.ntp.NTPSyncException;
import com.lyft.kronos.internal.ntp.SntpClient;
import com.lyft.kronos.internal.ntp.SntpResponseCache;
import com.lyft.kronos.internal.ntp.SntpService;
import com.lyft.kronos.internal.ntp.SntpServiceImpl;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0001+B_\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u0012J\n\u0010\"\u001a\u0004\u0018\u00010#H\u0016J\b\u0010$\u001a\u00020%H\u0002J\b\u0010&\u001a\u00020%H\u0016J\b\u0010'\u001a\u00020(H\u0016J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\fH\u0002J\b\u0010*\u001a\u00020%H\u0016R\u000e\u0010\u0010\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\n \u001a*\u0004\u0018\u00010\u00190\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001b\u001a\u0004\u0018\u00010\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001f\u001a\u0010\u0012\f\u0012\n \u001a*\u0004\u0018\u00010!0!0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/lyft/kronos/internal/ntp/SntpServiceImpl;", "Lcom/lyft/kronos/internal/ntp/SntpService;", "sntpClient", "Lcom/lyft/kronos/internal/ntp/SntpClient;", "deviceClock", "Lcom/lyft/kronos/Clock;", "responseCache", "Lcom/lyft/kronos/internal/ntp/SntpResponseCache;", "ntpSyncListener", "Lcom/lyft/kronos/SyncListener;", "ntpHosts", "", "", "requestTimeoutMs", "", "minWaitTimeBetweenSyncMs", "cacheExpirationMs", "maxNtpResponseTimeMs", "(Lcom/lyft/kronos/internal/ntp/SntpClient;Lcom/lyft/kronos/Clock;Lcom/lyft/kronos/internal/ntp/SntpResponseCache;Lcom/lyft/kronos/SyncListener;Ljava/util/List;JJJJ)V", "cacheSyncAge", "getCacheSyncAge", "()J", "cachedSyncTime", "Ljava/util/concurrent/atomic/AtomicLong;", "executor", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "response", "Lcom/lyft/kronos/internal/ntp/SntpClient$Response;", "getResponse", "()Lcom/lyft/kronos/internal/ntp/SntpClient$Response;", "state", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/lyft/kronos/internal/ntp/SntpServiceImpl$State;", "currentTime", "Lcom/lyft/kronos/KronosTime;", "ensureServiceIsRunning", "", "shutdown", "sync", "", "host", "syncInBackground", "State", "kronos-java"})
public final class SntpServiceImpl
implements SntpService {
    private final AtomicReference<State> state;
    private final AtomicLong cachedSyncTime;
    private final ExecutorService executor;
    private final SntpClient sntpClient;
    private final Clock deviceClock;
    private final SntpResponseCache responseCache;
    private final SyncListener ntpSyncListener;
    private final List<String> ntpHosts;
    private final long requestTimeoutMs;
    private final long minWaitTimeBetweenSyncMs;
    private final long cacheExpirationMs;
    private final long maxNtpResponseTimeMs;

    private final SntpClient.Response getResponse() {
        SntpClient.Response response;
        boolean isCachedFromPreviousBoot;
        SntpClient.Response response2 = this.responseCache.get();
        boolean bl = isCachedFromPreviousBoot = this.state.get() == State.IDLE && response2 != null && !response2.isFromSameBoot();
        if (isCachedFromPreviousBoot) {
            this.responseCache.clear();
            response = null;
        } else {
            response = response2;
        }
        return response;
    }

    private final long getCacheSyncAge() {
        return this.deviceClock.getElapsedTimeMs() - this.cachedSyncTime.get();
    }

    @Override
    @Nullable
    public KronosTime currentTime() {
        this.ensureServiceIsRunning();
        SntpClient.Response response = this.getResponse();
        if (response == null) {
            if (this.getCacheSyncAge() >= this.minWaitTimeBetweenSyncMs) {
                this.syncInBackground();
            }
            return null;
        }
        long responseAge = response.getResponseAge();
        if (responseAge >= this.cacheExpirationMs && this.getCacheSyncAge() >= this.minWaitTimeBetweenSyncMs) {
            this.syncInBackground();
        }
        return new KronosTime(response.getCurrentTimeMs(), responseAge);
    }

    @Override
    public void syncInBackground() {
        this.ensureServiceIsRunning();
        if (this.state.get() != State.SYNCING) {
            this.executor.submit(new Runnable(this){
                final /* synthetic */ SntpServiceImpl this$0;

                public final void run() {
                    this.this$0.sync();
                }
                {
                    this.this$0 = sntpServiceImpl;
                }
            });
        }
    }

    @Override
    public void shutdown() {
        this.ensureServiceIsRunning();
        this.state.set(State.STOPPED);
        this.executor.shutdown();
    }

    @Override
    public boolean sync() {
        this.ensureServiceIsRunning();
        for (String host : this.ntpHosts) {
            if (!this.sync(host)) continue;
            return true;
        }
        return false;
    }

    private final void ensureServiceIsRunning() {
        if (this.state.get() == State.STOPPED) {
            throw (Throwable)new IllegalStateException("Service already shutdown");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean sync(String host) {
        if (this.state.getAndSet(State.SYNCING) != State.SYNCING) {
            long t1 = this.deviceClock.getElapsedTimeMs();
            SyncListener syncListener = this.ntpSyncListener;
            if (syncListener != null) {
                syncListener.onStartSync(host);
            }
            try {
                SntpClient.Response response;
                SntpClient.Response response2 = response = this.sntpClient.requestTime(host, this.requestTimeoutMs);
                Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"response");
                if (response2.getCurrentTimeMs() < 0L) {
                    throw (Throwable)new NTPSyncException("Invalid time " + response.getCurrentTimeMs() + " received from " + host);
                }
                long responseTime = this.deviceClock.getElapsedTimeMs() - t1;
                if (responseTime > this.maxNtpResponseTimeMs) {
                    throw (Throwable)new NTPSyncException("Ignoring response from " + host + " because the network latency (" + responseTime + " ms) is longer than the required value (" + this.maxNtpResponseTimeMs + " ms");
                }
                this.responseCache.update(response);
                long cachedOffset = response.getOffsetMs();
                SyncListener syncListener2 = this.ntpSyncListener;
                if (syncListener2 != null) {
                    syncListener2.onSuccess(cachedOffset, responseTime);
                }
                boolean bl = true;
                return bl;
            }
            catch (Throwable e) {
                SyncListener syncListener3 = this.ntpSyncListener;
                if (syncListener3 != null) {
                    syncListener3.onError(host, e);
                }
            }
            finally {
                this.state.set(State.IDLE);
                this.cachedSyncTime.set(this.deviceClock.getElapsedTimeMs());
            }
        }
        return false;
    }

    @JvmOverloads
    public SntpServiceImpl(@NotNull SntpClient sntpClient, @NotNull Clock deviceClock, @NotNull SntpResponseCache responseCache, @Nullable SyncListener ntpSyncListener, @NotNull List<String> ntpHosts, long requestTimeoutMs, long minWaitTimeBetweenSyncMs, long cacheExpirationMs, long maxNtpResponseTimeMs) {
        Intrinsics.checkNotNullParameter((Object)sntpClient, (String)"sntpClient");
        Intrinsics.checkNotNullParameter((Object)deviceClock, (String)"deviceClock");
        Intrinsics.checkNotNullParameter((Object)responseCache, (String)"responseCache");
        Intrinsics.checkNotNullParameter(ntpHosts, (String)"ntpHosts");
        this.sntpClient = sntpClient;
        this.deviceClock = deviceClock;
        this.responseCache = responseCache;
        this.ntpSyncListener = ntpSyncListener;
        this.ntpHosts = ntpHosts;
        this.requestTimeoutMs = requestTimeoutMs;
        this.minWaitTimeBetweenSyncMs = minWaitTimeBetweenSyncMs;
        this.cacheExpirationMs = cacheExpirationMs;
        this.maxNtpResponseTimeMs = maxNtpResponseTimeMs;
        this.state = new AtomicReference<State>(State.IDLE);
        this.cachedSyncTime = new AtomicLong(0L);
        this.executor = Executors.newSingleThreadExecutor(executor.1.INSTANCE);
    }

    public /* synthetic */ SntpServiceImpl(SntpClient sntpClient, Clock clock, SntpResponseCache sntpResponseCache, SyncListener syncListener, List list, long l, long l2, long l3, long l4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            l = DefaultParam.INSTANCE.getTIMEOUT_MS();
        }
        if ((n & 0x40) != 0) {
            l2 = DefaultParam.INSTANCE.getMIN_WAIT_TIME_BETWEEN_SYNC_MS();
        }
        if ((n & 0x80) != 0) {
            l3 = DefaultParam.INSTANCE.getCACHE_EXPIRATION_MS();
        }
        if ((n & 0x100) != 0) {
            l4 = DefaultParam.INSTANCE.getMAX_NTP_RESPONSE_TIME_MS();
        }
        this(sntpClient, clock, sntpResponseCache, syncListener, list, l, l2, l3, l4);
    }

    @JvmOverloads
    public SntpServiceImpl(@NotNull SntpClient sntpClient, @NotNull Clock deviceClock, @NotNull SntpResponseCache responseCache, @Nullable SyncListener ntpSyncListener, @NotNull List<String> ntpHosts, long requestTimeoutMs, long minWaitTimeBetweenSyncMs, long cacheExpirationMs) {
        this(sntpClient, deviceClock, responseCache, ntpSyncListener, ntpHosts, requestTimeoutMs, minWaitTimeBetweenSyncMs, cacheExpirationMs, 0L, 256, null);
    }

    @JvmOverloads
    public SntpServiceImpl(@NotNull SntpClient sntpClient, @NotNull Clock deviceClock, @NotNull SntpResponseCache responseCache, @Nullable SyncListener ntpSyncListener, @NotNull List<String> ntpHosts, long requestTimeoutMs, long minWaitTimeBetweenSyncMs) {
        this(sntpClient, deviceClock, responseCache, ntpSyncListener, ntpHosts, requestTimeoutMs, minWaitTimeBetweenSyncMs, 0L, 0L, 384, null);
    }

    @JvmOverloads
    public SntpServiceImpl(@NotNull SntpClient sntpClient, @NotNull Clock deviceClock, @NotNull SntpResponseCache responseCache, @Nullable SyncListener ntpSyncListener, @NotNull List<String> ntpHosts, long requestTimeoutMs) {
        this(sntpClient, deviceClock, responseCache, ntpSyncListener, ntpHosts, requestTimeoutMs, 0L, 0L, 0L, 448, null);
    }

    @JvmOverloads
    public SntpServiceImpl(@NotNull SntpClient sntpClient, @NotNull Clock deviceClock, @NotNull SntpResponseCache responseCache, @Nullable SyncListener ntpSyncListener, @NotNull List<String> ntpHosts) {
        this(sntpClient, deviceClock, responseCache, ntpSyncListener, ntpHosts, 0L, 0L, 0L, 0L, 480, null);
    }

    @Override
    public long currentTimeMs() {
        return SntpService.DefaultImpls.currentTimeMs(this);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/lyft/kronos/internal/ntp/SntpServiceImpl$State;", "", "(Ljava/lang/String;I)V", "IDLE", "SYNCING", "STOPPED", "kronos-java"})
    private static final class State
    extends Enum<State> {
        public static final /* enum */ State IDLE;
        public static final /* enum */ State SYNCING;
        public static final /* enum */ State STOPPED;
        private static final /* synthetic */ State[] $VALUES;

        static {
            State[] stateArray = new State[3];
            State[] stateArray2 = stateArray;
            stateArray[0] = IDLE = new State();
            stateArray[1] = SYNCING = new State();
            stateArray[2] = STOPPED = new State();
            $VALUES = stateArray;
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String string) {
            return Enum.valueOf(State.class, string);
        }
    }
}

