/*
 * Decompiled with CFR 0.152.
 */
package com.loopj.android.http;

import android.util.Log;
import com.loopj.android.http.TextHttpResponseHandler;
import org.apache.http.Header;

public abstract class BaseJsonHttpResponseHandler<JSON_TYPE>
extends TextHttpResponseHandler {
    private static final String LOG_TAG = "BaseJsonHttpResponseHandler";

    public BaseJsonHttpResponseHandler() {
        this("UTF-8");
    }

    public BaseJsonHttpResponseHandler(String encoding) {
        super(encoding);
    }

    public abstract void onSuccess(int var1, Header[] var2, String var3, JSON_TYPE var4);

    public abstract void onFailure(int var1, Header[] var2, Throwable var3, String var4, JSON_TYPE var5);

    @Override
    public final void onSuccess(final int statusCode, final Header[] headers, final String responseString) {
        if (statusCode != 204) {
            Runnable parser = new Runnable(){

                @Override
                public void run() {
                    try {
                        final Object jsonResponse = BaseJsonHttpResponseHandler.this.parseResponse(responseString, false);
                        BaseJsonHttpResponseHandler.this.postRunnable(new Runnable(){

                            @Override
                            public void run() {
                                BaseJsonHttpResponseHandler.this.onSuccess(statusCode, headers, responseString, jsonResponse);
                            }
                        });
                    }
                    catch (Throwable t) {
                        Log.d((String)BaseJsonHttpResponseHandler.LOG_TAG, (String)"parseResponse thrown an problem", (Throwable)t);
                        BaseJsonHttpResponseHandler.this.postRunnable(new Runnable(){

                            @Override
                            public void run() {
                                BaseJsonHttpResponseHandler.this.onFailure(statusCode, headers, t, responseString, null);
                            }
                        });
                    }
                }
            };
            if (!this.getUseSynchronousMode() && !this.getUsePoolThread()) {
                new Thread(parser).start();
            } else {
                parser.run();
            }
        } else {
            this.onSuccess(statusCode, headers, null, null);
        }
    }

    @Override
    public final void onFailure(final int statusCode, final Header[] headers, final String responseString, final Throwable throwable) {
        if (responseString != null) {
            Runnable parser = new Runnable(){

                @Override
                public void run() {
                    try {
                        final Object jsonResponse = BaseJsonHttpResponseHandler.this.parseResponse(responseString, true);
                        BaseJsonHttpResponseHandler.this.postRunnable(new Runnable(){

                            @Override
                            public void run() {
                                BaseJsonHttpResponseHandler.this.onFailure(statusCode, headers, throwable, responseString, jsonResponse);
                            }
                        });
                    }
                    catch (Throwable t) {
                        Log.d((String)BaseJsonHttpResponseHandler.LOG_TAG, (String)"parseResponse thrown an problem", (Throwable)t);
                        BaseJsonHttpResponseHandler.this.postRunnable(new Runnable(){

                            @Override
                            public void run() {
                                BaseJsonHttpResponseHandler.this.onFailure(statusCode, headers, throwable, responseString, null);
                            }
                        });
                    }
                }
            };
            if (!this.getUseSynchronousMode() && !this.getUsePoolThread()) {
                new Thread(parser).start();
            } else {
                parser.run();
            }
        } else {
            this.onFailure(statusCode, headers, throwable, null, null);
        }
    }

    protected abstract JSON_TYPE parseResponse(String var1, boolean var2) throws Throwable;
}

