/*
 * Decompiled with CFR 0.152.
 */
package com.loopj.android.http;

import android.util.Log;
import com.loopj.android.http.AsyncHttpClient;
import com.loopj.android.http.Base64OutputStream;
import com.loopj.android.http.RequestParams;
import com.loopj.android.http.ResponseHandlerInterface;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.message.BasicHeader;

public class JsonStreamerEntity
implements HttpEntity {
    private static final String LOG_TAG = "JsonStreamerEntity";
    private static final UnsupportedOperationException ERR_UNSUPPORTED = new UnsupportedOperationException("Unsupported operation in this implementation.");
    private static final int BUFFER_SIZE = 4096;
    private final byte[] buffer = new byte[4096];
    private static final StringBuilder BUILDER = new StringBuilder(128);
    private static final byte[] JSON_TRUE = "true".getBytes();
    private static final byte[] JSON_FALSE = "false".getBytes();
    private static final byte[] JSON_NULL = "null".getBytes();
    private static final byte[] STREAM_NAME = JsonStreamerEntity.escape("name");
    private static final byte[] STREAM_TYPE = JsonStreamerEntity.escape("type");
    private static final byte[] STREAM_CONTENTS = JsonStreamerEntity.escape("contents");
    private static final byte[] STREAM_ELAPSED = JsonStreamerEntity.escape("_elapsed");
    private static final Header HEADER_JSON_CONTENT = new BasicHeader("Content-Type", "application/json");
    private static final Header HEADER_GZIP_ENCODING = new BasicHeader("Content-Encoding", "gzip");
    private final Map<String, Object> jsonParams = new HashMap<String, Object>();
    private final Header contentEncoding;
    private final ResponseHandlerInterface progressHandler;

    public JsonStreamerEntity(ResponseHandlerInterface progressHandler, boolean useGZipCompression) {
        this.progressHandler = progressHandler;
        this.contentEncoding = useGZipCompression ? HEADER_GZIP_ENCODING : null;
    }

    public void addPart(String key, Object value) {
        this.jsonParams.put(key, value);
    }

    public boolean isRepeatable() {
        return false;
    }

    public boolean isChunked() {
        return false;
    }

    public boolean isStreaming() {
        return false;
    }

    public long getContentLength() {
        return -1L;
    }

    public Header getContentEncoding() {
        return this.contentEncoding;
    }

    public Header getContentType() {
        return HEADER_JSON_CONTENT;
    }

    public void consumeContent() throws IOException, UnsupportedOperationException {
    }

    public InputStream getContent() throws IOException, UnsupportedOperationException {
        throw ERR_UNSUPPORTED;
    }

    public void writeTo(OutputStream out) throws IOException {
        if (out == null) {
            throw new IllegalStateException("Output stream cannot be null.");
        }
        long now = System.currentTimeMillis();
        OutputStream os = null != this.contentEncoding ? new GZIPOutputStream(out, 4096) : out;
        os.write(123);
        Set<String> keys = this.jsonParams.keySet();
        for (String key : keys) {
            Object value = this.jsonParams.get(key);
            if (value == null) continue;
            os.write(JsonStreamerEntity.escape(key));
            os.write(58);
            boolean isFileWrapper = value instanceof RequestParams.FileWrapper;
            if (isFileWrapper || value instanceof RequestParams.StreamWrapper) {
                os.write(123);
                if (isFileWrapper) {
                    this.writeToFromFile(os, (RequestParams.FileWrapper)value);
                } else {
                    this.writeToFromStream(os, (RequestParams.StreamWrapper)value);
                }
                os.write(125);
            } else if (value instanceof Boolean) {
                os.write((Boolean)value != false ? JSON_TRUE : JSON_FALSE);
            } else if (value instanceof Long) {
                os.write((((Number)value).longValue() + "").getBytes());
            } else if (value instanceof Double) {
                os.write((((Number)value).doubleValue() + "").getBytes());
            } else if (value instanceof Float) {
                os.write((((Number)value).floatValue() + "").getBytes());
            } else if (value instanceof Integer) {
                os.write((((Number)value).intValue() + "").getBytes());
            } else {
                os.write(value.toString().getBytes());
            }
            os.write(44);
        }
        os.write(STREAM_ELAPSED);
        os.write(58);
        long elapsedTime = System.currentTimeMillis() - now;
        os.write((elapsedTime + "}").getBytes());
        Log.i((String)LOG_TAG, (String)("Uploaded JSON in " + Math.floor(elapsedTime / 1000L) + " seconds"));
        os.flush();
        AsyncHttpClient.silentCloseOutputStream(os);
    }

    private void writeToFromStream(OutputStream os, RequestParams.StreamWrapper entry) throws IOException {
        int bytesRead;
        this.writeMetaData(os, entry.name, entry.contentType);
        Base64OutputStream bos = new Base64OutputStream(os, 18);
        while ((bytesRead = entry.inputStream.read(this.buffer)) != -1) {
            bos.write(this.buffer, 0, bytesRead);
        }
        AsyncHttpClient.silentCloseOutputStream(bos);
        this.endMetaData(os);
        if (entry.autoClose) {
            AsyncHttpClient.silentCloseInputStream(entry.inputStream);
        }
    }

    private void writeToFromFile(OutputStream os, RequestParams.FileWrapper wrapper) throws IOException {
        int bytesRead;
        this.writeMetaData(os, wrapper.file.getName(), wrapper.contentType);
        int bytesWritten = 0;
        int totalSize = (int)wrapper.file.length();
        FileInputStream in = new FileInputStream(wrapper.file);
        Base64OutputStream bos = new Base64OutputStream(os, 18);
        while ((bytesRead = in.read(this.buffer)) != -1) {
            bos.write(this.buffer, 0, bytesRead);
            this.progressHandler.sendProgressMessage(bytesWritten += bytesRead, totalSize);
        }
        AsyncHttpClient.silentCloseOutputStream(bos);
        this.endMetaData(os);
        AsyncHttpClient.silentCloseInputStream(in);
    }

    private void writeMetaData(OutputStream os, String name, String contentType) throws IOException {
        os.write(STREAM_NAME);
        os.write(58);
        os.write(JsonStreamerEntity.escape(name));
        os.write(44);
        os.write(STREAM_TYPE);
        os.write(58);
        os.write(JsonStreamerEntity.escape(contentType));
        os.write(44);
        os.write(STREAM_CONTENTS);
        os.write(58);
        os.write(34);
    }

    private void endMetaData(OutputStream os) throws IOException {
        os.write(34);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] escape(String string) {
        if (string == null) {
            return JSON_NULL;
        }
        BUILDER.append('\"');
        int length = string.length();
        int pos = -1;
        block12: while (++pos < length) {
            char ch = string.charAt(pos);
            switch (ch) {
                case '\"': {
                    BUILDER.append("\\\"");
                    continue block12;
                }
                case '\\': {
                    BUILDER.append("\\\\");
                    continue block12;
                }
                case '\b': {
                    BUILDER.append("\\b");
                    continue block12;
                }
                case '\f': {
                    BUILDER.append("\\f");
                    continue block12;
                }
                case '\n': {
                    BUILDER.append("\\n");
                    continue block12;
                }
                case '\r': {
                    BUILDER.append("\\r");
                    continue block12;
                }
                case '\t': {
                    BUILDER.append("\\t");
                    continue block12;
                }
            }
            if (ch >= '\u0000' && ch <= '\u001f' || ch >= '\u007f' && ch <= '\u009f' || ch >= '\u2000' && ch <= '\u20ff') {
                String intString = Integer.toHexString(ch);
                BUILDER.append("\\u");
                int intLength = 4 - intString.length();
                for (int zero = 0; zero < intLength; ++zero) {
                    BUILDER.append('0');
                }
                BUILDER.append(intString.toUpperCase(Locale.US));
                continue;
            }
            BUILDER.append(ch);
        }
        BUILDER.append('\"');
        try {
            byte[] byArray = BUILDER.toString().getBytes();
            return byArray;
        }
        finally {
            BUILDER.setLength(0);
        }
    }
}

