/*
 * Decompiled with CFR 0.152.
 */
package com.loopj.android.http;

import android.os.Message;
import com.loopj.android.http.AsyncHttpResponseHandler;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class JsonHttpResponseHandler
extends AsyncHttpResponseHandler {
    protected static final int SUCCESS_JSON_MESSAGE = 100;

    public void onSuccess(JSONObject response) {
    }

    public void onSuccess(JSONArray response) {
    }

    public void onSuccess(int statusCode, JSONObject response) {
        this.onSuccess(response);
    }

    public void onSuccess(int statusCode, JSONArray response) {
        this.onSuccess(response);
    }

    public void onFailure(Throwable e, JSONObject errorResponse) {
    }

    public void onFailure(Throwable e, JSONArray errorResponse) {
    }

    @Override
    protected void sendSuccessMessage(int statusCode, String responseBody) {
        if (statusCode != 204) {
            try {
                Object jsonResponse = this.parseResponse(responseBody);
                this.sendMessage(this.obtainMessage(100, new Object[]{statusCode, jsonResponse}));
            }
            catch (JSONException e) {
                this.sendFailureMessage((Throwable)e, responseBody);
            }
        } else {
            this.sendMessage(this.obtainMessage(100, new Object[]{statusCode, new JSONObject()}));
        }
    }

    @Override
    protected void handleMessage(Message msg) {
        switch (msg.what) {
            case 100: {
                Object[] response = (Object[])msg.obj;
                this.handleSuccessJsonMessage((Integer)response[0], response[1]);
                break;
            }
            default: {
                super.handleMessage(msg);
            }
        }
    }

    protected void handleSuccessJsonMessage(int statusCode, Object jsonResponse) {
        if (jsonResponse instanceof JSONObject) {
            this.onSuccess(statusCode, (JSONObject)jsonResponse);
        } else if (jsonResponse instanceof JSONArray) {
            this.onSuccess(statusCode, (JSONArray)jsonResponse);
        } else {
            this.onFailure((Throwable)new JSONException("Unexpected type " + jsonResponse.getClass().getName()), (JSONObject)null);
        }
    }

    protected Object parseResponse(String responseBody) throws JSONException {
        Object result = null;
        if ((responseBody = responseBody.trim()).startsWith("{") || responseBody.startsWith("[")) {
            result = new JSONTokener(responseBody).nextValue();
        }
        if (result == null) {
            result = responseBody;
        }
        return result;
    }

    @Override
    protected void handleFailureMessage(Throwable e, String responseBody) {
        try {
            if (responseBody != null) {
                Object jsonResponse = this.parseResponse(responseBody);
                if (jsonResponse instanceof JSONObject) {
                    this.onFailure(e, (JSONObject)jsonResponse);
                } else if (jsonResponse instanceof JSONArray) {
                    this.onFailure(e, (JSONArray)jsonResponse);
                } else {
                    this.onFailure(e, responseBody);
                }
            } else {
                this.onFailure(e, "");
            }
        }
        catch (JSONException ex) {
            this.onFailure(e, responseBody);
        }
    }
}

