/*
 * Decompiled with CFR 0.152.
 */
package com.loopj.android.http;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpResponseException;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.util.EntityUtils;

public class AsyncHttpResponseHandler {
    protected static final int SUCCESS_MESSAGE = 0;
    protected static final int FAILURE_MESSAGE = 1;
    protected static final int START_MESSAGE = 2;
    protected static final int FINISH_MESSAGE = 3;
    private Handler handler;

    public AsyncHttpResponseHandler() {
        if (Looper.myLooper() != null) {
            this.handler = new Handler(){

                public void handleMessage(Message msg) {
                    AsyncHttpResponseHandler.this.handleMessage(msg);
                }
            };
        }
    }

    public void onStart() {
    }

    public void onFinish() {
    }

    public void onSuccess(String content) {
    }

    public void onSuccess(int statusCode, String content) {
        this.onSuccess(content);
    }

    public void onFailure(Throwable error) {
    }

    public void onFailure(Throwable error, String content) {
        this.onFailure(error);
    }

    protected void sendSuccessMessage(int statusCode, String responseBody) {
        this.sendMessage(this.obtainMessage(0, new Object[]{new Integer(statusCode), responseBody}));
    }

    protected void sendFailureMessage(Throwable e, String responseBody) {
        this.sendMessage(this.obtainMessage(1, new Object[]{e, responseBody}));
    }

    protected void sendFailureMessage(Throwable e, byte[] responseBody) {
        this.sendMessage(this.obtainMessage(1, new Object[]{e, responseBody}));
    }

    protected void sendStartMessage() {
        this.sendMessage(this.obtainMessage(2, null));
    }

    protected void sendFinishMessage() {
        this.sendMessage(this.obtainMessage(3, null));
    }

    protected void handleSuccessMessage(int statusCode, String responseBody) {
        this.onSuccess(statusCode, responseBody);
    }

    protected void handleFailureMessage(Throwable e, String responseBody) {
        this.onFailure(e, responseBody);
    }

    protected void handleMessage(Message msg) {
        switch (msg.what) {
            case 0: {
                Object[] response = (Object[])msg.obj;
                this.handleSuccessMessage((Integer)response[0], (String)response[1]);
                break;
            }
            case 1: {
                Object[] response = (Object[])msg.obj;
                this.handleFailureMessage((Throwable)response[0], (String)response[1]);
                break;
            }
            case 2: {
                this.onStart();
                break;
            }
            case 3: {
                this.onFinish();
            }
        }
    }

    protected void sendMessage(Message msg) {
        if (this.handler != null) {
            this.handler.sendMessage(msg);
        } else {
            this.handleMessage(msg);
        }
    }

    protected Message obtainMessage(int responseMessage, Object response) {
        Message msg = null;
        if (this.handler != null) {
            msg = this.handler.obtainMessage(responseMessage, response);
        } else {
            msg = new Message();
            msg.what = responseMessage;
            msg.obj = response;
        }
        return msg;
    }

    void sendResponseMessage(HttpResponse response) {
        StatusLine status = response.getStatusLine();
        String responseBody = null;
        try {
            BufferedHttpEntity entity = null;
            HttpEntity temp = response.getEntity();
            if (temp != null) {
                entity = new BufferedHttpEntity(temp);
                responseBody = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            }
        }
        catch (IOException e) {
            this.sendFailureMessage((Throwable)e, (String)null);
        }
        if (status.getStatusCode() >= 300) {
            this.sendFailureMessage((Throwable)new HttpResponseException(status.getStatusCode(), status.getReasonPhrase()), responseBody);
        } else {
            this.sendSuccessMessage(status.getStatusCode(), responseBody);
        }
    }
}

