/*
 * Decompiled with CFR 0.152.
 */
package com.logmein.gotowebinar.api.common;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.logmein.gotowebinar.api.model.ActivationState;
import com.logmein.gotowebinar.api.model.AudioType;
import com.logmein.gotowebinar.api.model.Product;
import com.logmein.gotowebinar.api.model.Registrant;
import com.logmein.gotowebinar.api.model.RegistrantDetailed;
import com.logmein.gotowebinar.api.model.RegistrationQuestion;
import com.logmein.gotowebinar.api.model.TollCountries;
import com.logmein.gotowebinar.api.model.TollFreeCountries;
import com.logmein.gotowebinar.api.model.UserSubscriptionState;
import com.logmein.gotowebinar.api.model.WebhookState;
import com.logmein.gotowebinar.api.model.Webinar;
import com.logmein.gotowebinar.api.model.WebinarByKey;
import com.logmein.gotowebinar.api.model.WebinarReqUpdate;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class JsonUtil {
    public static ObjectMapper mapper;
    private static SimpleDateFormat sdf;

    private static Module getModule() {
        SimpleModule module = new SimpleModule("BooleanAsString", new Version(1, 0, 0, null, null, null));
        module.addDeserializer(Boolean.class, (JsonDeserializer)new JsonDeserializer<Boolean>(){

            public Boolean deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
                String value = jp.getValueAsString();
                return "true".equalsIgnoreCase(value);
            }
        });
        module.addDeserializer(ActivationState.class, (JsonDeserializer)new JsonDeserializer<ActivationState>(){

            public ActivationState deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
                return JsonUtil.getEnumFromString(ActivationState.class, jp.getValueAsString());
            }
        });
        module.addDeserializer(AudioType.class, (JsonDeserializer)new JsonDeserializer<AudioType>(){

            public AudioType deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
                return JsonUtil.getEnumFromString(AudioType.class, jp.getValueAsString());
            }
        });
        module.addDeserializer(Product.class, (JsonDeserializer)new JsonDeserializer<Product>(){

            public Product deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
                return JsonUtil.getEnumFromString(Product.class, jp.getValueAsString());
            }
        });
        module.addDeserializer(Registrant.StatusEnum.class, (JsonDeserializer)new JsonDeserializer<Registrant.StatusEnum>(){

            public Registrant.StatusEnum deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
                return JsonUtil.getEnumFromString(Registrant.StatusEnum.class, jp.getValueAsString());
            }
        });
        module.addDeserializer(RegistrantDetailed.StatusEnum.class, (JsonDeserializer)new JsonDeserializer<RegistrantDetailed.StatusEnum>(){

            public RegistrantDetailed.StatusEnum deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
                return JsonUtil.getEnumFromString(RegistrantDetailed.StatusEnum.class, jp.getValueAsString());
            }
        });
        module.addDeserializer(RegistrantDetailed.TypeEnum.class, (JsonDeserializer)new JsonDeserializer<RegistrantDetailed.TypeEnum>(){

            public RegistrantDetailed.TypeEnum deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
                return JsonUtil.getEnumFromString(RegistrantDetailed.TypeEnum.class, jp.getValueAsString());
            }
        });
        module.addDeserializer(RegistrationQuestion.TypeEnum.class, (JsonDeserializer)new JsonDeserializer<RegistrationQuestion.TypeEnum>(){

            public RegistrationQuestion.TypeEnum deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
                return JsonUtil.getEnumFromString(RegistrationQuestion.TypeEnum.class, jp.getValueAsString());
            }
        });
        module.addDeserializer(TollCountries.class, (JsonDeserializer)new JsonDeserializer<TollCountries>(){

            public TollCountries deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
                return JsonUtil.getEnumFromString(TollCountries.class, jp.getValueAsString());
            }
        });
        module.addDeserializer(TollFreeCountries.class, (JsonDeserializer)new JsonDeserializer<TollFreeCountries>(){

            public TollFreeCountries deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
                return JsonUtil.getEnumFromString(TollFreeCountries.class, jp.getValueAsString());
            }
        });
        module.addDeserializer(UserSubscriptionState.class, (JsonDeserializer)new JsonDeserializer<UserSubscriptionState>(){

            public UserSubscriptionState deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
                return JsonUtil.getEnumFromString(UserSubscriptionState.class, jp.getValueAsString());
            }
        });
        module.addDeserializer(WebhookState.class, (JsonDeserializer)new JsonDeserializer<WebhookState>(){

            public WebhookState deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
                return JsonUtil.getEnumFromString(WebhookState.class, jp.getValueAsString());
            }
        });
        module.addDeserializer(Webinar.LocaleEnum.class, (JsonDeserializer)new JsonDeserializer<Webinar.LocaleEnum>(){

            public Webinar.LocaleEnum deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
                return JsonUtil.getEnumFromString(Webinar.LocaleEnum.class, jp.getValueAsString());
            }
        });
        module.addDeserializer(WebinarByKey.LocaleEnum.class, (JsonDeserializer)new JsonDeserializer<WebinarByKey.LocaleEnum>(){

            public WebinarByKey.LocaleEnum deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
                return JsonUtil.getEnumFromString(WebinarByKey.LocaleEnum.class, jp.getValueAsString());
            }
        });
        module.addDeserializer(WebinarReqUpdate.LocaleEnum.class, (JsonDeserializer)new JsonDeserializer<WebinarReqUpdate.LocaleEnum>(){

            public WebinarReqUpdate.LocaleEnum deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
                return JsonUtil.getEnumFromString(WebinarReqUpdate.LocaleEnum.class, jp.getValueAsString());
            }
        });
        return module;
    }

    public static ObjectMapper getJsonMapper() {
        return mapper;
    }

    public static <T extends Enum<T>> T getEnumFromString(Class<T> c, String string) {
        try {
            return Enum.valueOf(c, string);
        }
        catch (NullPointerException ex) {
            return null;
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    public static String Stringify(Object obj) {
        if (obj == null) {
            return "";
        }
        if (obj instanceof Date) {
            return sdf.format((Date)obj);
        }
        return obj.toString();
    }

    static {
        sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX");
        mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        mapper.setDateFormat((DateFormat)sdf);
        mapper.registerModule(JsonUtil.getModule());
        mapper.setVisibility(PropertyAccessor.SETTER, JsonAutoDetect.Visibility.NONE);
        mapper.setVisibility(PropertyAccessor.GETTER, JsonAutoDetect.Visibility.NONE);
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

