/*
 * Decompiled with CFR 0.152.
 */
package com.logmein.gotowebinar.api.common;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapType;
import com.logmein.gotowebinar.api.common.ApiException;
import com.logmein.gotowebinar.api.common.JsonUtil;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.LoggingFilter;
import com.sun.jersey.multipart.FormDataMultiPart;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.core.Response;

public class ApiInvoker {
    private static ApiInvoker INSTANCE = new ApiInvoker();
    private Map<String, Client> hostMap = new HashMap<String, Client>();
    private Map<String, String> defaultHeaderMap = new HashMap<String, String>(){
        {
            this.put("CALLING_CLIENT", "GoToWebinar Java SDK version 2.3.0");
        }
    };
    private boolean isDebug = false;

    public void enableDebug() {
        this.isDebug = true;
    }

    public static ApiInvoker getInstance() {
        return INSTANCE;
    }

    public void addDefaultHeader(String key, String value) {
        this.defaultHeaderMap.put(key, value);
    }

    public String escapeString(String str) {
        try {
            return URLEncoder.encode(str, "utf8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            return str;
        }
    }

    public static Object deserialize(String json, String containerType, Class cls) throws ApiException {
        try {
            json = ApiInvoker.correctDateFormat(json);
            if ("List".equals(containerType)) {
                CollectionType typeInfo = JsonUtil.getJsonMapper().getTypeFactory().constructCollectionType(List.class, cls);
                List response = (List)JsonUtil.getJsonMapper().readValue(json, (JavaType)typeInfo);
                return response;
            }
            if ("Map".equals(containerType)) {
                MapType typeInfo = JsonUtil.getJsonMapper().getTypeFactory().constructMapType(Map.class, String.class, cls);
                Map response = (Map)JsonUtil.getJsonMapper().readValue(json, (JavaType)typeInfo);
                return response;
            }
            if (String.class.equals((Object)cls)) {
                if (json != null && json.startsWith("\"") && json.endsWith("\"")) {
                    return json.substring(1, json.length() - 1);
                }
                return json;
            }
            return JsonUtil.getJsonMapper().readValue(json, cls);
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    public static String serialize(Object obj) throws ApiException {
        try {
            if (obj == null) {
                return null;
            }
            return JsonUtil.getJsonMapper().writeValueAsString(obj);
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public String invokeAPI(String host, String path, String method, Map<String, String> queryParams, Object body, Map<String, String> headerParams, Map<String, String> formParams, String contentType) throws ApiException {
        void var12_27;
        Client client = this.getClient(host);
        StringBuilder b = new StringBuilder();
        for (String string : queryParams.keySet()) {
            String value = queryParams.get(string);
            if (value == null) continue;
            if (b.toString().length() == 0) {
                b.append("?");
            } else {
                b.append("&");
            }
            b.append(this.escapeString(string)).append("=").append(this.escapeString(value));
        }
        WebResource.Builder builder = client.resource(host + path + b.toString()).accept(new String[]{"application/json"});
        for (String key : headerParams.keySet()) {
            builder.header(key, (Object)headerParams.get(key));
        }
        for (String key : this.defaultHeaderMap.keySet()) {
            if (headerParams.containsKey(key)) continue;
            builder.header(key, (Object)this.defaultHeaderMap.get(key));
        }
        Object var12_15 = null;
        if (method.equals("GET")) {
            ClientResponse clientResponse = (ClientResponse)builder.get(ClientResponse.class);
        } else if (method.equals("HEAD")) {
            ClientResponse clientResponse = builder.head();
        } else if (method.equals("POST")) {
            if (contentType.equals("application/x-www-form-urlencoded")) {
                ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)builder.type(contentType)).post(ClientResponse.class, (Object)this.urlEncodeFormParams(formParams));
            } else if (body == null) {
                ClientResponse clientResponse = (ClientResponse)builder.post(ClientResponse.class, null);
            } else if (body instanceof FormDataMultiPart) {
                ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)builder.type(contentType)).post(ClientResponse.class, body);
            } else {
                ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)builder.type(contentType)).post(ClientResponse.class, (Object)ApiInvoker.serialize(body));
            }
        } else if (method.equals("PUT")) {
            if (contentType.equals("application/x-www-form-urlencoded")) {
                ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)builder.type(contentType)).put(ClientResponse.class, (Object)this.urlEncodeFormParams(formParams));
            } else if (body == null) {
                ClientResponse clientResponse = (ClientResponse)builder.put(ClientResponse.class, null);
            } else {
                ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)builder.type(contentType)).put(ClientResponse.class, (Object)ApiInvoker.serialize(body));
            }
        } else if (method.equals("DELETE")) {
            if (body == null) {
                ClientResponse clientResponse = (ClientResponse)builder.delete(ClientResponse.class, null);
            } else {
                ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)builder.type(contentType)).delete(ClientResponse.class, (Object)ApiInvoker.serialize(body));
            }
        } else {
            throw new ApiException("Unexpected method " + method);
        }
        if (var12_27.getStatusInfo().getReasonPhrase().equals(ClientResponse.Status.NO_CONTENT.getReasonPhrase())) {
            return null;
        }
        if (var12_27.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL) {
            return (String)var12_27.getEntity(String.class);
        }
        throw new ApiException(var12_27.getStatusInfo().getStatusCode(), (String)var12_27.getEntity(String.class));
    }

    private Client getClient(String host) {
        if (!this.hostMap.containsKey(host)) {
            Client client = Client.create();
            if (this.isDebug) {
                client.addFilter((ClientFilter)new LoggingFilter());
            }
            this.hostMap.put(host, client);
        }
        return this.hostMap.get(host);
    }

    private String urlEncodeFormParams(Map<String, String> formParams) {
        StringBuilder sb = new StringBuilder();
        for (String key : formParams.keySet()) {
            String value = formParams.get(key);
            if (value == null || value.trim().equals("")) continue;
            if (sb.length() > 0) {
                sb.append("&");
            }
            try {
                sb.append(URLEncoder.encode(key, "utf8")).append("=").append(URLEncoder.encode(value, "utf8"));
            }
            catch (Exception exception) {}
        }
        return sb.toString();
    }

    private static String correctDateFormat(String json) throws ApiException {
        if (json != null && !json.isEmpty()) {
            Pattern pattern;
            Matcher matcher;
            if (json.matches(".*T\\d{2}:\\d{2}:\\d{2}\\.\\+0{4}.*")) {
                json = json.replaceAll("\\.\\+0{4}", "Z");
            }
            if ((matcher = (pattern = Pattern.compile("(T\\d{2}:\\d{2}:\\d{2})\"")).matcher(json)).find()) {
                String machtResult = matcher.group(1);
                json = matcher.replaceAll(machtResult + "Z\"");
            }
            Pattern pattern2 = Pattern.compile("((.{2,3})\\s(.{2,3})\\s(\\d{2})\\s(\\d{2}:\\d{2}:\\d{2})\\s(\\d{4}))");
            Matcher matcher2 = pattern2.matcher(json);
            SimpleDateFormat df = new SimpleDateFormat("MMMM d hh:mm:ss yyyy");
            SimpleDateFormat df2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            while (matcher2.find()) {
                try {
                    String replacement = df2.format(df.parse(matcher2.group(3) + " " + matcher2.group(4) + " " + matcher2.group(5) + " " + matcher2.group(6)));
                    json = matcher2.replaceFirst(replacement);
                    matcher2.reset(json);
                }
                catch (ParseException e) {
                    throw new ApiException(e);
                }
            }
            Pattern pattern3 = Pattern.compile("((\\d{2})\\\\?/(\\d{2})\\\\?/(\\d{4})\\s(\\d{2}:\\d{2}:\\d{2}))");
            Matcher matcher3 = pattern3.matcher(json);
            while (matcher3.find()) {
                try {
                    String replacement = df2.format(df2.parse(matcher3.group(4) + "-" + matcher3.group(2) + "-" + matcher3.group(3) + "T" + matcher3.group(5) + "Z"));
                    json = matcher3.replaceFirst(replacement);
                    matcher3.reset(json);
                }
                catch (ParseException e) {
                    throw new ApiException(e);
                }
            }
            Pattern pattern4 = Pattern.compile("(T\\d{2}:\\d{2}:\\d{2}\\.\\d{3}Z)\"");
            Matcher matcher4 = pattern4.matcher(json);
            while (matcher4.find()) {
                String matchedResult = matcher4.group(1);
                json = matcher4.replaceFirst(matchedResult.substring(0, matchedResult.indexOf(46)) + "Z\"");
                matcher4.reset(json);
            }
        }
        return json;
    }
}

