/*
 * Decompiled with CFR 0.152.
 */
package com.logmein.gotowebinar.api;

import com.logmein.gotowebinar.api.common.ApiException;
import com.logmein.gotowebinar.api.common.ApiInvoker;
import com.logmein.gotowebinar.api.common.JsonUtil;
import com.logmein.gotowebinar.api.model.Audio;
import com.logmein.gotowebinar.api.model.AudioUpdate;
import com.logmein.gotowebinar.api.model.BrokerWebinar;
import com.logmein.gotowebinar.api.model.CreatedWebinar;
import com.logmein.gotowebinar.api.model.DateTimeRange;
import com.logmein.gotowebinar.api.model.ReportingAttendeeResponse;
import com.logmein.gotowebinar.api.model.ReportingWebinarsResponse;
import com.logmein.gotowebinar.api.model.SessionPerformance;
import com.logmein.gotowebinar.api.model.WebinarByKey;
import com.logmein.gotowebinar.api.model.WebinarReqCreate;
import com.logmein.gotowebinar.api.model.WebinarReqUpdate;
import com.sun.jersey.multipart.FormDataMultiPart;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WebinarsApi {
    private String basePath = "https://api.getgo.com/G2W/rest/v2";
    private ApiInvoker apiInvoker = ApiInvoker.getInstance();

    public WebinarsApi() {
    }

    public WebinarsApi(String basePath) {
        this.basePath = basePath;
    }

    public ApiInvoker getInvoker() {
        return this.apiInvoker;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void cancelWebinar(String authorization, Long organizerKey, Long webinarKey, Boolean sendCancellationEmails) throws ApiException {
        String contentType;
        FormDataMultiPart postBody = null;
        if (authorization == null) {
            throw new ApiException("Required parameter authorization is null.");
        }
        if (organizerKey == null) {
            throw new ApiException("Required parameter organizerKey is null.");
        }
        if (webinarKey == null) {
            throw new ApiException("Required parameter webinarKey is null.");
        }
        String path = "/organizers/{organizerKey}/webinars/{webinarKey}".replaceAll("\\{format\\}", "json").replaceAll("\\{organizerKey\\}", this.apiInvoker.escapeString(organizerKey.toString())).replaceAll("\\{webinarKey\\}", this.apiInvoker.escapeString(webinarKey.toString()));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        String sendCancellationEmailsString = JsonUtil.Stringify(sendCancellationEmails);
        if (!"null".equals(sendCancellationEmailsString)) {
            queryParams.put("sendCancellationEmails", sendCancellationEmailsString);
        }
        headerParams.put("Authorization", authorization);
        String[] contentTypes = new String[]{"application/json"};
        String string = contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        if (contentType.startsWith("multipart/form-data")) {
            boolean hasFields = false;
            FormDataMultiPart mp = new FormDataMultiPart();
            if (hasFields) {
                postBody = mp;
            }
        }
        this.apiInvoker.invokeAPI(this.basePath, path, "DELETE", queryParams, postBody, headerParams, formParams, contentType);
    }

    public CreatedWebinar createWebinar(String authorization, Long organizerKey, WebinarReqCreate body) throws ApiException {
        String response;
        String contentType;
        WebinarReqCreate postBody = body;
        if (authorization == null) {
            throw new ApiException("Required parameter authorization is null.");
        }
        if (organizerKey == null) {
            throw new ApiException("Required parameter organizerKey is null.");
        }
        if (body == null) {
            throw new ApiException("Required parameter body is null.");
        }
        String path = "/organizers/{organizerKey}/webinars".replaceAll("\\{format\\}", "json").replaceAll("\\{organizerKey\\}", this.apiInvoker.escapeString(organizerKey.toString()));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        headerParams.put("Authorization", authorization);
        String[] contentTypes = new String[]{"application/json"};
        String string = contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        if (contentType.startsWith("multipart/form-data")) {
            boolean hasFields = false;
            FormDataMultiPart mp = new FormDataMultiPart();
            if (hasFields) {
                postBody = mp;
            }
        }
        if ((response = this.apiInvoker.invokeAPI(this.basePath, path, "POST", queryParams, postBody, headerParams, formParams, contentType)) != null) {
            return (CreatedWebinar)ApiInvoker.deserialize(response, "", CreatedWebinar.class);
        }
        return null;
    }

    public ReportingWebinarsResponse getAllAccountWebinars(String authorization, Long accountKey, Date fromTime, Date toTime, Long page, Long size) throws ApiException {
        String response;
        String contentType;
        String sizeString;
        String pageString;
        String toTimeString;
        FormDataMultiPart postBody = null;
        if (authorization == null) {
            throw new ApiException("Required parameter authorization is null.");
        }
        if (accountKey == null) {
            throw new ApiException("Required parameter accountKey is null.");
        }
        if (fromTime == null) {
            throw new ApiException("Required parameter fromTime is null.");
        }
        if (toTime == null) {
            throw new ApiException("Required parameter toTime is null.");
        }
        String path = "/accounts/{accountKey}/webinars".replaceAll("\\{format\\}", "json").replaceAll("\\{accountKey\\}", this.apiInvoker.escapeString(accountKey.toString()));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        String fromTimeString = JsonUtil.Stringify(fromTime);
        if (!"null".equals(fromTimeString)) {
            queryParams.put("fromTime", fromTimeString);
        }
        if (!"null".equals(toTimeString = JsonUtil.Stringify(toTime))) {
            queryParams.put("toTime", toTimeString);
        }
        if (!"null".equals(pageString = JsonUtil.Stringify(page))) {
            queryParams.put("page", pageString);
        }
        if (!"null".equals(sizeString = JsonUtil.Stringify(size))) {
            queryParams.put("size", sizeString);
        }
        headerParams.put("Authorization", authorization);
        String[] contentTypes = new String[]{"application/json"};
        String string = contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        if (contentType.startsWith("multipart/form-data")) {
            boolean hasFields = false;
            FormDataMultiPart mp = new FormDataMultiPart();
            if (hasFields) {
                postBody = mp;
            }
        }
        if ((response = this.apiInvoker.invokeAPI(this.basePath, path, "GET", queryParams, postBody, headerParams, formParams, contentType)) != null) {
            return (ReportingWebinarsResponse)ApiInvoker.deserialize(response, "", ReportingWebinarsResponse.class);
        }
        return null;
    }

    public ReportingAttendeeResponse getAttendeesForAllWebinarSessions(String authorization, Long organizerKey, Long webinarKey, Long page, Long size) throws ApiException {
        String response;
        String contentType;
        String sizeString;
        FormDataMultiPart postBody = null;
        if (authorization == null) {
            throw new ApiException("Required parameter authorization is null.");
        }
        if (organizerKey == null) {
            throw new ApiException("Required parameter organizerKey is null.");
        }
        if (webinarKey == null) {
            throw new ApiException("Required parameter webinarKey is null.");
        }
        String path = "/organizers/{organizerKey}/webinars/{webinarKey}/attendees".replaceAll("\\{format\\}", "json").replaceAll("\\{organizerKey\\}", this.apiInvoker.escapeString(organizerKey.toString())).replaceAll("\\{webinarKey\\}", this.apiInvoker.escapeString(webinarKey.toString()));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        String pageString = JsonUtil.Stringify(page);
        if (!"null".equals(pageString)) {
            queryParams.put("page", pageString);
        }
        if (!"null".equals(sizeString = JsonUtil.Stringify(size))) {
            queryParams.put("size", sizeString);
        }
        headerParams.put("Authorization", authorization);
        String[] contentTypes = new String[]{"application/json"};
        String string = contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        if (contentType.startsWith("multipart/form-data")) {
            boolean hasFields = false;
            FormDataMultiPart mp = new FormDataMultiPart();
            if (hasFields) {
                postBody = mp;
            }
        }
        if ((response = this.apiInvoker.invokeAPI(this.basePath, path, "GET", queryParams, postBody, headerParams, formParams, contentType)) != null) {
            return (ReportingAttendeeResponse)ApiInvoker.deserialize(response, "", ReportingAttendeeResponse.class);
        }
        return null;
    }

    public Audio getAudioInformation(String authorization, Long organizerKey, Long webinarKey) throws ApiException {
        String response;
        String contentType;
        FormDataMultiPart postBody = null;
        if (authorization == null) {
            throw new ApiException("Required parameter authorization is null.");
        }
        if (organizerKey == null) {
            throw new ApiException("Required parameter organizerKey is null.");
        }
        if (webinarKey == null) {
            throw new ApiException("Required parameter webinarKey is null.");
        }
        String path = "/organizers/{organizerKey}/webinars/{webinarKey}/audio".replaceAll("\\{format\\}", "json").replaceAll("\\{organizerKey\\}", this.apiInvoker.escapeString(organizerKey.toString())).replaceAll("\\{webinarKey\\}", this.apiInvoker.escapeString(webinarKey.toString()));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        headerParams.put("Authorization", authorization);
        String[] contentTypes = new String[]{"application/json"};
        String string = contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        if (contentType.startsWith("multipart/form-data")) {
            boolean hasFields = false;
            FormDataMultiPart mp = new FormDataMultiPart();
            if (hasFields) {
                postBody = mp;
            }
        }
        if ((response = this.apiInvoker.invokeAPI(this.basePath, path, "GET", queryParams, postBody, headerParams, formParams, contentType)) != null) {
            return (Audio)ApiInvoker.deserialize(response, "", Audio.class);
        }
        return null;
    }

    public List<BrokerWebinar> getInSessionWebinars(String authorization, Long organizerKey, Date fromTime, Date toTime) throws ApiException {
        String response;
        String contentType;
        String toTimeString;
        FormDataMultiPart postBody = null;
        if (authorization == null) {
            throw new ApiException("Required parameter authorization is null.");
        }
        if (organizerKey == null) {
            throw new ApiException("Required parameter organizerKey is null.");
        }
        String path = "/organizers/{organizerKey}/insessionWebinars".replaceAll("\\{format\\}", "json").replaceAll("\\{organizerKey\\}", this.apiInvoker.escapeString(organizerKey.toString()));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        String fromTimeString = JsonUtil.Stringify(fromTime);
        if (!"null".equals(fromTimeString)) {
            queryParams.put("fromTime", fromTimeString);
        }
        if (!"null".equals(toTimeString = JsonUtil.Stringify(toTime))) {
            queryParams.put("toTime", toTimeString);
        }
        headerParams.put("Authorization", authorization);
        String[] contentTypes = new String[]{"application/json"};
        String string = contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        if (contentType.startsWith("multipart/form-data")) {
            boolean hasFields = false;
            FormDataMultiPart mp = new FormDataMultiPart();
            if (hasFields) {
                postBody = mp;
            }
        }
        if ((response = this.apiInvoker.invokeAPI(this.basePath, path, "GET", queryParams, postBody, headerParams, formParams, contentType)) != null) {
            return (List)ApiInvoker.deserialize(response, "List", BrokerWebinar.class);
        }
        return null;
    }

    public Map<String, SessionPerformance> getPerformanceForAllWebinarSessions(String authorization, Long organizerKey, Long webinarKey) throws ApiException {
        String response;
        String contentType;
        FormDataMultiPart postBody = null;
        if (authorization == null) {
            throw new ApiException("Required parameter authorization is null.");
        }
        if (organizerKey == null) {
            throw new ApiException("Required parameter organizerKey is null.");
        }
        if (webinarKey == null) {
            throw new ApiException("Required parameter webinarKey is null.");
        }
        String path = "/organizers/{organizerKey}/webinars/{webinarKey}/performance".replaceAll("\\{format\\}", "json").replaceAll("\\{organizerKey\\}", this.apiInvoker.escapeString(organizerKey.toString())).replaceAll("\\{webinarKey\\}", this.apiInvoker.escapeString(webinarKey.toString()));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        headerParams.put("Authorization", authorization);
        String[] contentTypes = new String[]{"application/json"};
        String string = contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        if (contentType.startsWith("multipart/form-data")) {
            boolean hasFields = false;
            FormDataMultiPart mp = new FormDataMultiPart();
            if (hasFields) {
                postBody = mp;
            }
        }
        if ((response = this.apiInvoker.invokeAPI(this.basePath, path, "GET", queryParams, postBody, headerParams, formParams, contentType)) != null) {
            return (Map)ApiInvoker.deserialize(response, "Map", SessionPerformance.class);
        }
        return null;
    }

    public WebinarByKey getWebinar(String authorization, Long organizerKey, Long webinarKey) throws ApiException {
        String response;
        String contentType;
        FormDataMultiPart postBody = null;
        if (authorization == null) {
            throw new ApiException("Required parameter authorization is null.");
        }
        if (organizerKey == null) {
            throw new ApiException("Required parameter organizerKey is null.");
        }
        if (webinarKey == null) {
            throw new ApiException("Required parameter webinarKey is null.");
        }
        String path = "/organizers/{organizerKey}/webinars/{webinarKey}".replaceAll("\\{format\\}", "json").replaceAll("\\{organizerKey\\}", this.apiInvoker.escapeString(organizerKey.toString())).replaceAll("\\{webinarKey\\}", this.apiInvoker.escapeString(webinarKey.toString()));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        headerParams.put("Authorization", authorization);
        String[] contentTypes = new String[]{"application/json"};
        String string = contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        if (contentType.startsWith("multipart/form-data")) {
            boolean hasFields = false;
            FormDataMultiPart mp = new FormDataMultiPart();
            if (hasFields) {
                postBody = mp;
            }
        }
        if ((response = this.apiInvoker.invokeAPI(this.basePath, path, "GET", queryParams, postBody, headerParams, formParams, contentType)) != null) {
            return (WebinarByKey)ApiInvoker.deserialize(response, "", WebinarByKey.class);
        }
        return null;
    }

    public List<DateTimeRange> getWebinarMeetingTimes(String authorization, Long organizerKey, Long webinarKey) throws ApiException {
        String response;
        String contentType;
        FormDataMultiPart postBody = null;
        if (authorization == null) {
            throw new ApiException("Required parameter authorization is null.");
        }
        if (organizerKey == null) {
            throw new ApiException("Required parameter organizerKey is null.");
        }
        if (webinarKey == null) {
            throw new ApiException("Required parameter webinarKey is null.");
        }
        String path = "/organizers/{organizerKey}/webinars/{webinarKey}/meetingtimes".replaceAll("\\{format\\}", "json").replaceAll("\\{organizerKey\\}", this.apiInvoker.escapeString(organizerKey.toString())).replaceAll("\\{webinarKey\\}", this.apiInvoker.escapeString(webinarKey.toString()));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        headerParams.put("Authorization", authorization);
        String[] contentTypes = new String[]{"application/json"};
        String string = contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        if (contentType.startsWith("multipart/form-data")) {
            boolean hasFields = false;
            FormDataMultiPart mp = new FormDataMultiPart();
            if (hasFields) {
                postBody = mp;
            }
        }
        if ((response = this.apiInvoker.invokeAPI(this.basePath, path, "GET", queryParams, postBody, headerParams, formParams, contentType)) != null) {
            return (List)ApiInvoker.deserialize(response, "List", DateTimeRange.class);
        }
        return null;
    }

    public ReportingWebinarsResponse getWebinars(String authorization, Long organizerKey, Date fromTime, Date toTime, Long page, Long size) throws ApiException {
        String response;
        String contentType;
        String sizeString;
        String pageString;
        String toTimeString;
        FormDataMultiPart postBody = null;
        if (authorization == null) {
            throw new ApiException("Required parameter authorization is null.");
        }
        if (organizerKey == null) {
            throw new ApiException("Required parameter organizerKey is null.");
        }
        if (fromTime == null) {
            throw new ApiException("Required parameter fromTime is null.");
        }
        if (toTime == null) {
            throw new ApiException("Required parameter toTime is null.");
        }
        String path = "/organizers/{organizerKey}/webinars".replaceAll("\\{format\\}", "json").replaceAll("\\{organizerKey\\}", this.apiInvoker.escapeString(organizerKey.toString()));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        String fromTimeString = JsonUtil.Stringify(fromTime);
        if (!"null".equals(fromTimeString)) {
            queryParams.put("fromTime", fromTimeString);
        }
        if (!"null".equals(toTimeString = JsonUtil.Stringify(toTime))) {
            queryParams.put("toTime", toTimeString);
        }
        if (!"null".equals(pageString = JsonUtil.Stringify(page))) {
            queryParams.put("page", pageString);
        }
        if (!"null".equals(sizeString = JsonUtil.Stringify(size))) {
            queryParams.put("size", sizeString);
        }
        headerParams.put("Authorization", authorization);
        String[] contentTypes = new String[]{"application/json"};
        String string = contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        if (contentType.startsWith("multipart/form-data")) {
            boolean hasFields = false;
            FormDataMultiPart mp = new FormDataMultiPart();
            if (hasFields) {
                postBody = mp;
            }
        }
        if ((response = this.apiInvoker.invokeAPI(this.basePath, path, "GET", queryParams, postBody, headerParams, formParams, contentType)) != null) {
            return (ReportingWebinarsResponse)ApiInvoker.deserialize(response, "", ReportingWebinarsResponse.class);
        }
        return null;
    }

    public void updateAudioInformation(String authorization, Long organizerKey, Long webinarKey, Boolean notifyParticipants, AudioUpdate body) throws ApiException {
        String contentType;
        AudioUpdate postBody = body;
        if (authorization == null) {
            throw new ApiException("Required parameter authorization is null.");
        }
        if (organizerKey == null) {
            throw new ApiException("Required parameter organizerKey is null.");
        }
        if (webinarKey == null) {
            throw new ApiException("Required parameter webinarKey is null.");
        }
        if (body == null) {
            throw new ApiException("Required parameter body is null.");
        }
        String path = "/organizers/{organizerKey}/webinars/{webinarKey}/audio".replaceAll("\\{format\\}", "json").replaceAll("\\{organizerKey\\}", this.apiInvoker.escapeString(organizerKey.toString())).replaceAll("\\{webinarKey\\}", this.apiInvoker.escapeString(webinarKey.toString()));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        String notifyParticipantsString = JsonUtil.Stringify(notifyParticipants);
        if (!"null".equals(notifyParticipantsString)) {
            queryParams.put("notifyParticipants", notifyParticipantsString);
        }
        headerParams.put("Authorization", authorization);
        String[] contentTypes = new String[]{"application/json"};
        String string = contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        if (contentType.startsWith("multipart/form-data")) {
            boolean hasFields = false;
            FormDataMultiPart mp = new FormDataMultiPart();
            if (hasFields) {
                postBody = mp;
            }
        }
        this.apiInvoker.invokeAPI(this.basePath, path, "POST", queryParams, postBody, headerParams, formParams, contentType);
    }

    public void updateWebinar(String authorization, Long organizerKey, Long webinarKey, Boolean notifyParticipants, WebinarReqUpdate body) throws ApiException {
        String contentType;
        WebinarReqUpdate postBody = body;
        if (authorization == null) {
            throw new ApiException("Required parameter authorization is null.");
        }
        if (organizerKey == null) {
            throw new ApiException("Required parameter organizerKey is null.");
        }
        if (webinarKey == null) {
            throw new ApiException("Required parameter webinarKey is null.");
        }
        if (body == null) {
            throw new ApiException("Required parameter body is null.");
        }
        String path = "/organizers/{organizerKey}/webinars/{webinarKey}".replaceAll("\\{format\\}", "json").replaceAll("\\{organizerKey\\}", this.apiInvoker.escapeString(organizerKey.toString())).replaceAll("\\{webinarKey\\}", this.apiInvoker.escapeString(webinarKey.toString()));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        String notifyParticipantsString = JsonUtil.Stringify(notifyParticipants);
        if (!"null".equals(notifyParticipantsString)) {
            queryParams.put("notifyParticipants", notifyParticipantsString);
        }
        headerParams.put("Authorization", authorization);
        String[] contentTypes = new String[]{"application/json"};
        String string = contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        if (contentType.startsWith("multipart/form-data")) {
            boolean hasFields = false;
            FormDataMultiPart mp = new FormDataMultiPart();
            if (hasFields) {
                postBody = mp;
            }
        }
        this.apiInvoker.invokeAPI(this.basePath, path, "PUT", queryParams, postBody, headerParams, formParams, contentType);
    }
}

