/*
 * Decompiled with CFR 0.152.
 */
package com.logmein.gotowebinar.api;

import com.logmein.gotowebinar.api.common.ApiException;
import com.logmein.gotowebinar.api.common.ApiInvoker;
import com.logmein.gotowebinar.api.common.JsonUtil;
import com.logmein.gotowebinar.api.model.CreateUserSubscriptionRequest;
import com.logmein.gotowebinar.api.model.CreateWebhookRequest;
import com.logmein.gotowebinar.api.model.SecretKeyRequest;
import com.logmein.gotowebinar.api.model.SecretKeyResponse;
import com.logmein.gotowebinar.api.model.UpdateUserSubscriptionsRequest;
import com.logmein.gotowebinar.api.model.UpdateWebhooksRequest;
import com.logmein.gotowebinar.api.model.UserSubscription;
import com.logmein.gotowebinar.api.model.UserSubscriptionResponse;
import com.logmein.gotowebinar.api.model.Webhook;
import com.logmein.gotowebinar.api.model.WebhooksResponse;
import com.sun.jersey.multipart.FormDataMultiPart;
import java.util.HashMap;
import java.util.List;

public class WebhooksApi {
    private String basePath = "https://api.getgo.com/G2W/rest/v2";
    private ApiInvoker apiInvoker = ApiInvoker.getInstance();

    public WebhooksApi() {
    }

    public WebhooksApi(String basePath) {
        this.basePath = basePath;
    }

    public ApiInvoker getInvoker() {
        return this.apiInvoker;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public SecretKeyResponse createSecretKey(String authorization, SecretKeyRequest body) throws ApiException {
        String response;
        String contentType;
        SecretKeyRequest postBody = body;
        if (authorization == null) {
            throw new ApiException("Required parameter authorization is null.");
        }
        if (body == null) {
            throw new ApiException("Required parameter body is null.");
        }
        String path = "/webhooks/secretkey".replaceAll("\\{format\\}", "json");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        headerParams.put("Authorization", authorization);
        String[] contentTypes = new String[]{"application/json"};
        String string = contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        if (contentType.startsWith("multipart/form-data")) {
            boolean hasFields = false;
            FormDataMultiPart mp = new FormDataMultiPart();
            if (hasFields) {
                postBody = mp;
            }
        }
        if ((response = this.apiInvoker.invokeAPI(this.basePath, path, "POST", queryParams, postBody, headerParams, formParams, contentType)) != null) {
            return (SecretKeyResponse)ApiInvoker.deserialize(response, "", SecretKeyResponse.class);
        }
        return null;
    }

    public UserSubscriptionResponse createUserSubscriptions(String authorization, List<CreateUserSubscriptionRequest> body) throws ApiException {
        String response;
        String contentType;
        FormDataMultiPart postBody = body;
        if (authorization == null) {
            throw new ApiException("Required parameter authorization is null.");
        }
        if (body == null) {
            throw new ApiException("Required parameter body is null.");
        }
        String path = "/userSubscriptions".replaceAll("\\{format\\}", "json");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        headerParams.put("Authorization", authorization);
        String[] contentTypes = new String[]{"application/json"};
        String string = contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        if (contentType.startsWith("multipart/form-data")) {
            boolean hasFields = false;
            FormDataMultiPart mp = new FormDataMultiPart();
            if (hasFields) {
                postBody = mp;
            }
        }
        if ((response = this.apiInvoker.invokeAPI(this.basePath, path, "POST", queryParams, postBody, headerParams, formParams, contentType)) != null) {
            return (UserSubscriptionResponse)ApiInvoker.deserialize(response, "", UserSubscriptionResponse.class);
        }
        return null;
    }

    public WebhooksResponse createWebhooks(String authorization, List<CreateWebhookRequest> body) throws ApiException {
        String response;
        String contentType;
        FormDataMultiPart postBody = body;
        if (authorization == null) {
            throw new ApiException("Required parameter authorization is null.");
        }
        if (body == null) {
            throw new ApiException("Required parameter body is null.");
        }
        String path = "/webhooks".replaceAll("\\{format\\}", "json");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        headerParams.put("Authorization", authorization);
        String[] contentTypes = new String[]{"application/json"};
        String string = contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        if (contentType.startsWith("multipart/form-data")) {
            boolean hasFields = false;
            FormDataMultiPart mp = new FormDataMultiPart();
            if (hasFields) {
                postBody = mp;
            }
        }
        if ((response = this.apiInvoker.invokeAPI(this.basePath, path, "POST", queryParams, postBody, headerParams, formParams, contentType)) != null) {
            return (WebhooksResponse)ApiInvoker.deserialize(response, "", WebhooksResponse.class);
        }
        return null;
    }

    public void deleteUserSubscriptions(String authorization, List<String> body) throws ApiException {
        String contentType;
        FormDataMultiPart postBody = body;
        if (authorization == null) {
            throw new ApiException("Required parameter authorization is null.");
        }
        if (body == null) {
            throw new ApiException("Required parameter body is null.");
        }
        String path = "/userSubscriptions".replaceAll("\\{format\\}", "json");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        headerParams.put("Authorization", authorization);
        String[] contentTypes = new String[]{"application/json"};
        String string = contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        if (contentType.startsWith("multipart/form-data")) {
            boolean hasFields = false;
            FormDataMultiPart mp = new FormDataMultiPart();
            if (hasFields) {
                postBody = mp;
            }
        }
        this.apiInvoker.invokeAPI(this.basePath, path, "DELETE", queryParams, postBody, headerParams, formParams, contentType);
    }

    public void deleteWebhooks(String authorization, List<String> body) throws ApiException {
        String contentType;
        FormDataMultiPart postBody = body;
        if (authorization == null) {
            throw new ApiException("Required parameter authorization is null.");
        }
        if (body == null) {
            throw new ApiException("Required parameter body is null.");
        }
        String path = "/webhooks".replaceAll("\\{format\\}", "json");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        headerParams.put("Authorization", authorization);
        String[] contentTypes = new String[]{"application/json"};
        String string = contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        if (contentType.startsWith("multipart/form-data")) {
            boolean hasFields = false;
            FormDataMultiPart mp = new FormDataMultiPart();
            if (hasFields) {
                postBody = mp;
            }
        }
        this.apiInvoker.invokeAPI(this.basePath, path, "DELETE", queryParams, postBody, headerParams, formParams, contentType);
    }

    public UserSubscription getUserSubscription(String authorization, String userSubscriptionsKey) throws ApiException {
        String response;
        String contentType;
        FormDataMultiPart postBody = null;
        if (authorization == null) {
            throw new ApiException("Required parameter authorization is null.");
        }
        if (userSubscriptionsKey == null) {
            throw new ApiException("Required parameter userSubscriptionsKey is null.");
        }
        String path = "/userSubscriptions/{userSubscriptionsKey}".replaceAll("\\{format\\}", "json").replaceAll("\\{userSubscriptionsKey\\}", this.apiInvoker.escapeString(userSubscriptionsKey.toString()));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        headerParams.put("Authorization", authorization);
        String[] contentTypes = new String[]{"application/json"};
        String string = contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        if (contentType.startsWith("multipart/form-data")) {
            boolean hasFields = false;
            FormDataMultiPart mp = new FormDataMultiPart();
            if (hasFields) {
                postBody = mp;
            }
        }
        if ((response = this.apiInvoker.invokeAPI(this.basePath, path, "GET", queryParams, postBody, headerParams, formParams, contentType)) != null) {
            return (UserSubscription)ApiInvoker.deserialize(response, "", UserSubscription.class);
        }
        return null;
    }

    public UserSubscriptionResponse getUserSubscriptions(String authorization, String product) throws ApiException {
        String response;
        String contentType;
        FormDataMultiPart postBody = null;
        if (authorization == null) {
            throw new ApiException("Required parameter authorization is null.");
        }
        if (product == null) {
            throw new ApiException("Required parameter product is null.");
        }
        String path = "/userSubscriptions".replaceAll("\\{format\\}", "json");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        String productString = JsonUtil.Stringify(product);
        if (!"null".equals(productString)) {
            queryParams.put("product", productString);
        }
        headerParams.put("Authorization", authorization);
        String[] contentTypes = new String[]{"application/json"};
        String string = contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        if (contentType.startsWith("multipart/form-data")) {
            boolean hasFields = false;
            FormDataMultiPart mp = new FormDataMultiPart();
            if (hasFields) {
                postBody = mp;
            }
        }
        if ((response = this.apiInvoker.invokeAPI(this.basePath, path, "GET", queryParams, postBody, headerParams, formParams, contentType)) != null) {
            return (UserSubscriptionResponse)ApiInvoker.deserialize(response, "", UserSubscriptionResponse.class);
        }
        return null;
    }

    public Webhook getWebhook(String authorization, String webhookKey) throws ApiException {
        String response;
        String contentType;
        FormDataMultiPart postBody = null;
        if (authorization == null) {
            throw new ApiException("Required parameter authorization is null.");
        }
        if (webhookKey == null) {
            throw new ApiException("Required parameter webhookKey is null.");
        }
        String path = "/webhooks/{webhookKey}".replaceAll("\\{format\\}", "json").replaceAll("\\{webhookKey\\}", this.apiInvoker.escapeString(webhookKey.toString()));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        headerParams.put("Authorization", authorization);
        String[] contentTypes = new String[]{"application/json"};
        String string = contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        if (contentType.startsWith("multipart/form-data")) {
            boolean hasFields = false;
            FormDataMultiPart mp = new FormDataMultiPart();
            if (hasFields) {
                postBody = mp;
            }
        }
        if ((response = this.apiInvoker.invokeAPI(this.basePath, path, "GET", queryParams, postBody, headerParams, formParams, contentType)) != null) {
            return (Webhook)ApiInvoker.deserialize(response, "", Webhook.class);
        }
        return null;
    }

    public WebhooksResponse getWebhooks(String authorization, String product) throws ApiException {
        String response;
        String contentType;
        FormDataMultiPart postBody = null;
        if (authorization == null) {
            throw new ApiException("Required parameter authorization is null.");
        }
        if (product == null) {
            throw new ApiException("Required parameter product is null.");
        }
        String path = "/webhooks".replaceAll("\\{format\\}", "json");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        String productString = JsonUtil.Stringify(product);
        if (!"null".equals(productString)) {
            queryParams.put("product", productString);
        }
        headerParams.put("Authorization", authorization);
        String[] contentTypes = new String[]{"application/json"};
        String string = contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        if (contentType.startsWith("multipart/form-data")) {
            boolean hasFields = false;
            FormDataMultiPart mp = new FormDataMultiPart();
            if (hasFields) {
                postBody = mp;
            }
        }
        if ((response = this.apiInvoker.invokeAPI(this.basePath, path, "GET", queryParams, postBody, headerParams, formParams, contentType)) != null) {
            return (WebhooksResponse)ApiInvoker.deserialize(response, "", WebhooksResponse.class);
        }
        return null;
    }

    public void updateUserSubscriptions(String authorization, List<UpdateUserSubscriptionsRequest> body) throws ApiException {
        String contentType;
        FormDataMultiPart postBody = body;
        if (authorization == null) {
            throw new ApiException("Required parameter authorization is null.");
        }
        if (body == null) {
            throw new ApiException("Required parameter body is null.");
        }
        String path = "/userSubscriptions".replaceAll("\\{format\\}", "json");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        headerParams.put("Authorization", authorization);
        String[] contentTypes = new String[]{"application/json"};
        String string = contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        if (contentType.startsWith("multipart/form-data")) {
            boolean hasFields = false;
            FormDataMultiPart mp = new FormDataMultiPart();
            if (hasFields) {
                postBody = mp;
            }
        }
        this.apiInvoker.invokeAPI(this.basePath, path, "PUT", queryParams, postBody, headerParams, formParams, contentType);
    }

    public void updateWebhooks(String authorization, List<UpdateWebhooksRequest> body) throws ApiException {
        String contentType;
        FormDataMultiPart postBody = body;
        if (authorization == null) {
            throw new ApiException("Required parameter authorization is null.");
        }
        if (body == null) {
            throw new ApiException("Required parameter body is null.");
        }
        String path = "/webhooks".replaceAll("\\{format\\}", "json");
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        headerParams.put("Authorization", authorization);
        String[] contentTypes = new String[]{"application/json"};
        String string = contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        if (contentType.startsWith("multipart/form-data")) {
            boolean hasFields = false;
            FormDataMultiPart mp = new FormDataMultiPart();
            if (hasFields) {
                postBody = mp;
            }
        }
        this.apiInvoker.invokeAPI(this.basePath, path, "PUT", queryParams, postBody, headerParams, formParams, contentType);
    }
}

