/*
 * Decompiled with CFR 0.152.
 */
package com.logmein.gotowebinar.api;

import com.logmein.gotowebinar.api.common.ApiException;
import com.logmein.gotowebinar.api.common.ApiInvoker;
import com.logmein.gotowebinar.api.common.JsonUtil;
import com.logmein.gotowebinar.api.model.Attendee;
import com.logmein.gotowebinar.api.model.AttendeeQuestion;
import com.logmein.gotowebinar.api.model.Poll;
import com.logmein.gotowebinar.api.model.ReportingSessionsResponse;
import com.logmein.gotowebinar.api.model.SessionPerformance;
import com.sun.jersey.multipart.FormDataMultiPart;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class SessionsApi {
    private String basePath = "https://api.getgo.com/G2W/rest/v2";
    private ApiInvoker apiInvoker = ApiInvoker.getInstance();

    public SessionsApi() {
    }

    public SessionsApi(String basePath) {
        this.basePath = basePath;
    }

    public ApiInvoker getInvoker() {
        return this.apiInvoker;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public ReportingSessionsResponse getAllSessions(String authorization, Long organizerKey, Long webinarKey, Long page, Long size) throws ApiException {
        String response;
        String contentType;
        String sizeString;
        FormDataMultiPart postBody = null;
        if (authorization == null) {
            throw new ApiException("Required parameter authorization is null.");
        }
        if (organizerKey == null) {
            throw new ApiException("Required parameter organizerKey is null.");
        }
        if (webinarKey == null) {
            throw new ApiException("Required parameter webinarKey is null.");
        }
        String path = "/organizers/{organizerKey}/webinars/{webinarKey}/sessions".replaceAll("\\{format\\}", "json").replaceAll("\\{organizerKey\\}", this.apiInvoker.escapeString(organizerKey.toString())).replaceAll("\\{webinarKey\\}", this.apiInvoker.escapeString(webinarKey.toString()));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        String pageString = JsonUtil.Stringify(page);
        if (!"null".equals(pageString)) {
            queryParams.put("page", pageString);
        }
        if (!"null".equals(sizeString = JsonUtil.Stringify(size))) {
            queryParams.put("size", sizeString);
        }
        headerParams.put("Authorization", authorization);
        String[] contentTypes = new String[]{"application/json"};
        String string = contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        if (contentType.startsWith("multipart/form-data")) {
            boolean hasFields = false;
            FormDataMultiPart mp = new FormDataMultiPart();
            if (hasFields) {
                postBody = mp;
            }
        }
        if ((response = this.apiInvoker.invokeAPI(this.basePath, path, "GET", queryParams, postBody, headerParams, formParams, contentType)) != null) {
            return (ReportingSessionsResponse)ApiInvoker.deserialize(response, "", ReportingSessionsResponse.class);
        }
        return null;
    }

    public ReportingSessionsResponse getOrganizerSessions(String authorization, Long organizerKey, Date fromTime, Date toTime, Long page, Long size) throws ApiException {
        String response;
        String contentType;
        String sizeString;
        String pageString;
        String toTimeString;
        FormDataMultiPart postBody = null;
        if (authorization == null) {
            throw new ApiException("Required parameter authorization is null.");
        }
        if (organizerKey == null) {
            throw new ApiException("Required parameter organizerKey is null.");
        }
        if (fromTime == null) {
            throw new ApiException("Required parameter fromTime is null.");
        }
        if (toTime == null) {
            throw new ApiException("Required parameter toTime is null.");
        }
        String path = "/organizers/{organizerKey}/sessions".replaceAll("\\{format\\}", "json").replaceAll("\\{organizerKey\\}", this.apiInvoker.escapeString(organizerKey.toString()));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        String fromTimeString = JsonUtil.Stringify(fromTime);
        if (!"null".equals(fromTimeString)) {
            queryParams.put("fromTime", fromTimeString);
        }
        if (!"null".equals(toTimeString = JsonUtil.Stringify(toTime))) {
            queryParams.put("toTime", toTimeString);
        }
        if (!"null".equals(pageString = JsonUtil.Stringify(page))) {
            queryParams.put("page", pageString);
        }
        if (!"null".equals(sizeString = JsonUtil.Stringify(size))) {
            queryParams.put("size", sizeString);
        }
        headerParams.put("Authorization", authorization);
        String[] contentTypes = new String[]{"application/json"};
        String string = contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        if (contentType.startsWith("multipart/form-data")) {
            boolean hasFields = false;
            FormDataMultiPart mp = new FormDataMultiPart();
            if (hasFields) {
                postBody = mp;
            }
        }
        if ((response = this.apiInvoker.invokeAPI(this.basePath, path, "GET", queryParams, postBody, headerParams, formParams, contentType)) != null) {
            return (ReportingSessionsResponse)ApiInvoker.deserialize(response, "", ReportingSessionsResponse.class);
        }
        return null;
    }

    public SessionPerformance getPerformance(String authorization, Long organizerKey, Long webinarKey, Long sessionKey) throws ApiException {
        String response;
        String contentType;
        FormDataMultiPart postBody = null;
        if (authorization == null) {
            throw new ApiException("Required parameter authorization is null.");
        }
        if (organizerKey == null) {
            throw new ApiException("Required parameter organizerKey is null.");
        }
        if (webinarKey == null) {
            throw new ApiException("Required parameter webinarKey is null.");
        }
        if (sessionKey == null) {
            throw new ApiException("Required parameter sessionKey is null.");
        }
        String path = "/organizers/{organizerKey}/webinars/{webinarKey}/sessions/{sessionKey}/performance".replaceAll("\\{format\\}", "json").replaceAll("\\{organizerKey\\}", this.apiInvoker.escapeString(organizerKey.toString())).replaceAll("\\{webinarKey\\}", this.apiInvoker.escapeString(webinarKey.toString())).replaceAll("\\{sessionKey\\}", this.apiInvoker.escapeString(sessionKey.toString()));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        headerParams.put("Authorization", authorization);
        String[] contentTypes = new String[]{"application/json"};
        String string = contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        if (contentType.startsWith("multipart/form-data")) {
            boolean hasFields = false;
            FormDataMultiPart mp = new FormDataMultiPart();
            if (hasFields) {
                postBody = mp;
            }
        }
        if ((response = this.apiInvoker.invokeAPI(this.basePath, path, "GET", queryParams, postBody, headerParams, formParams, contentType)) != null) {
            return (SessionPerformance)ApiInvoker.deserialize(response, "", SessionPerformance.class);
        }
        return null;
    }

    public List<Poll> getPolls(String authorization, Long organizerKey, Long webinarKey, Long sessionKey) throws ApiException {
        String response;
        String contentType;
        FormDataMultiPart postBody = null;
        if (authorization == null) {
            throw new ApiException("Required parameter authorization is null.");
        }
        if (organizerKey == null) {
            throw new ApiException("Required parameter organizerKey is null.");
        }
        if (webinarKey == null) {
            throw new ApiException("Required parameter webinarKey is null.");
        }
        if (sessionKey == null) {
            throw new ApiException("Required parameter sessionKey is null.");
        }
        String path = "/organizers/{organizerKey}/webinars/{webinarKey}/sessions/{sessionKey}/polls".replaceAll("\\{format\\}", "json").replaceAll("\\{organizerKey\\}", this.apiInvoker.escapeString(organizerKey.toString())).replaceAll("\\{webinarKey\\}", this.apiInvoker.escapeString(webinarKey.toString())).replaceAll("\\{sessionKey\\}", this.apiInvoker.escapeString(sessionKey.toString()));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        headerParams.put("Authorization", authorization);
        String[] contentTypes = new String[]{"application/json"};
        String string = contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        if (contentType.startsWith("multipart/form-data")) {
            boolean hasFields = false;
            FormDataMultiPart mp = new FormDataMultiPart();
            if (hasFields) {
                postBody = mp;
            }
        }
        if ((response = this.apiInvoker.invokeAPI(this.basePath, path, "GET", queryParams, postBody, headerParams, formParams, contentType)) != null) {
            return (List)ApiInvoker.deserialize(response, "List", Poll.class);
        }
        return null;
    }

    public List<AttendeeQuestion> getQuestions(String authorization, Long organizerKey, Long webinarKey, Long sessionKey) throws ApiException {
        String response;
        String contentType;
        FormDataMultiPart postBody = null;
        if (authorization == null) {
            throw new ApiException("Required parameter authorization is null.");
        }
        if (organizerKey == null) {
            throw new ApiException("Required parameter organizerKey is null.");
        }
        if (webinarKey == null) {
            throw new ApiException("Required parameter webinarKey is null.");
        }
        if (sessionKey == null) {
            throw new ApiException("Required parameter sessionKey is null.");
        }
        String path = "/organizers/{organizerKey}/webinars/{webinarKey}/sessions/{sessionKey}/questions".replaceAll("\\{format\\}", "json").replaceAll("\\{organizerKey\\}", this.apiInvoker.escapeString(organizerKey.toString())).replaceAll("\\{webinarKey\\}", this.apiInvoker.escapeString(webinarKey.toString())).replaceAll("\\{sessionKey\\}", this.apiInvoker.escapeString(sessionKey.toString()));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        headerParams.put("Authorization", authorization);
        String[] contentTypes = new String[]{"application/json"};
        String string = contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        if (contentType.startsWith("multipart/form-data")) {
            boolean hasFields = false;
            FormDataMultiPart mp = new FormDataMultiPart();
            if (hasFields) {
                postBody = mp;
            }
        }
        if ((response = this.apiInvoker.invokeAPI(this.basePath, path, "GET", queryParams, postBody, headerParams, formParams, contentType)) != null) {
            return (List)ApiInvoker.deserialize(response, "List", AttendeeQuestion.class);
        }
        return null;
    }

    public List<Poll> getSurveys(String authorization, Long organizerKey, Long webinarKey, Long sessionKey) throws ApiException {
        String response;
        String contentType;
        FormDataMultiPart postBody = null;
        if (authorization == null) {
            throw new ApiException("Required parameter authorization is null.");
        }
        if (organizerKey == null) {
            throw new ApiException("Required parameter organizerKey is null.");
        }
        if (webinarKey == null) {
            throw new ApiException("Required parameter webinarKey is null.");
        }
        if (sessionKey == null) {
            throw new ApiException("Required parameter sessionKey is null.");
        }
        String path = "/organizers/{organizerKey}/webinars/{webinarKey}/sessions/{sessionKey}/surveys".replaceAll("\\{format\\}", "json").replaceAll("\\{organizerKey\\}", this.apiInvoker.escapeString(organizerKey.toString())).replaceAll("\\{webinarKey\\}", this.apiInvoker.escapeString(webinarKey.toString())).replaceAll("\\{sessionKey\\}", this.apiInvoker.escapeString(sessionKey.toString()));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        headerParams.put("Authorization", authorization);
        String[] contentTypes = new String[]{"application/json"};
        String string = contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        if (contentType.startsWith("multipart/form-data")) {
            boolean hasFields = false;
            FormDataMultiPart mp = new FormDataMultiPart();
            if (hasFields) {
                postBody = mp;
            }
        }
        if ((response = this.apiInvoker.invokeAPI(this.basePath, path, "GET", queryParams, postBody, headerParams, formParams, contentType)) != null) {
            return (List)ApiInvoker.deserialize(response, "List", Poll.class);
        }
        return null;
    }

    public List<Attendee> getWebinarSession(String authorization, Long organizerKey, Long webinarKey, Long sessionKey) throws ApiException {
        String response;
        String contentType;
        FormDataMultiPart postBody = null;
        if (authorization == null) {
            throw new ApiException("Required parameter authorization is null.");
        }
        if (organizerKey == null) {
            throw new ApiException("Required parameter organizerKey is null.");
        }
        if (webinarKey == null) {
            throw new ApiException("Required parameter webinarKey is null.");
        }
        if (sessionKey == null) {
            throw new ApiException("Required parameter sessionKey is null.");
        }
        String path = "/organizers/{organizerKey}/webinars/{webinarKey}/sessions/{sessionKey}".replaceAll("\\{format\\}", "json").replaceAll("\\{organizerKey\\}", this.apiInvoker.escapeString(organizerKey.toString())).replaceAll("\\{webinarKey\\}", this.apiInvoker.escapeString(webinarKey.toString())).replaceAll("\\{sessionKey\\}", this.apiInvoker.escapeString(sessionKey.toString()));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        headerParams.put("Authorization", authorization);
        String[] contentTypes = new String[]{"application/json"};
        String string = contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        if (contentType.startsWith("multipart/form-data")) {
            boolean hasFields = false;
            FormDataMultiPart mp = new FormDataMultiPart();
            if (hasFields) {
                postBody = mp;
            }
        }
        if ((response = this.apiInvoker.invokeAPI(this.basePath, path, "GET", queryParams, postBody, headerParams, formParams, contentType)) != null) {
            return (List)ApiInvoker.deserialize(response, "List", Attendee.class);
        }
        return null;
    }
}

