/*
 * Decompiled with CFR 0.152.
 */
package com.logmein.gotowebinar.api;

import com.logmein.gotowebinar.api.common.ApiException;
import com.logmein.gotowebinar.api.common.ApiInvoker;
import com.logmein.gotowebinar.api.common.JsonUtil;
import com.logmein.gotowebinar.api.model.Registrant;
import com.logmein.gotowebinar.api.model.RegistrantCreated;
import com.logmein.gotowebinar.api.model.RegistrantDetailed;
import com.logmein.gotowebinar.api.model.RegistrantFields;
import com.logmein.gotowebinar.api.model.RegistrationFields;
import com.sun.jersey.multipart.FormDataMultiPart;
import java.util.HashMap;
import java.util.List;

public class RegistrantsApi {
    private String basePath = "https://api.getgo.com/G2W/rest/v2";
    private ApiInvoker apiInvoker = ApiInvoker.getInstance();

    public RegistrantsApi() {
    }

    public RegistrantsApi(String basePath) {
        this.basePath = basePath;
    }

    public ApiInvoker getInvoker() {
        return this.apiInvoker;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public RegistrantCreated createRegistrant(String authorization, Long organizerKey, Long webinarKey, String accept, Boolean resendConfirmation, RegistrantFields body) throws ApiException {
        String response;
        String contentType;
        RegistrantFields postBody = body;
        if (authorization == null) {
            throw new ApiException("Required parameter authorization is null.");
        }
        if (organizerKey == null) {
            throw new ApiException("Required parameter organizerKey is null.");
        }
        if (webinarKey == null) {
            throw new ApiException("Required parameter webinarKey is null.");
        }
        if (body == null) {
            throw new ApiException("Required parameter body is null.");
        }
        String path = "/organizers/{organizerKey}/webinars/{webinarKey}/registrants".replaceAll("\\{format\\}", "json").replaceAll("\\{organizerKey\\}", this.apiInvoker.escapeString(organizerKey.toString())).replaceAll("\\{webinarKey\\}", this.apiInvoker.escapeString(webinarKey.toString()));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        String resendConfirmationString = JsonUtil.Stringify(resendConfirmation);
        if (!"null".equals(resendConfirmationString)) {
            queryParams.put("resendConfirmation", resendConfirmationString);
        }
        headerParams.put("Authorization", authorization);
        headerParams.put("Accept", accept);
        String[] contentTypes = new String[]{"application/json"};
        String string = contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        if (contentType.startsWith("multipart/form-data")) {
            boolean hasFields = false;
            FormDataMultiPart mp = new FormDataMultiPart();
            if (hasFields) {
                postBody = mp;
            }
        }
        if ((response = this.apiInvoker.invokeAPI(this.basePath, path, "POST", queryParams, postBody, headerParams, formParams, contentType)) != null) {
            return (RegistrantCreated)ApiInvoker.deserialize(response, "", RegistrantCreated.class);
        }
        return null;
    }

    public void deleteRegistrant(String authorization, Long organizerKey, Long webinarKey, Long registrantKey) throws ApiException {
        String contentType;
        FormDataMultiPart postBody = null;
        if (authorization == null) {
            throw new ApiException("Required parameter authorization is null.");
        }
        if (organizerKey == null) {
            throw new ApiException("Required parameter organizerKey is null.");
        }
        if (webinarKey == null) {
            throw new ApiException("Required parameter webinarKey is null.");
        }
        if (registrantKey == null) {
            throw new ApiException("Required parameter registrantKey is null.");
        }
        String path = "/organizers/{organizerKey}/webinars/{webinarKey}/registrants/{registrantKey}".replaceAll("\\{format\\}", "json").replaceAll("\\{organizerKey\\}", this.apiInvoker.escapeString(organizerKey.toString())).replaceAll("\\{webinarKey\\}", this.apiInvoker.escapeString(webinarKey.toString())).replaceAll("\\{registrantKey\\}", this.apiInvoker.escapeString(registrantKey.toString()));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        headerParams.put("Authorization", authorization);
        String[] contentTypes = new String[]{"application/json"};
        String string = contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        if (contentType.startsWith("multipart/form-data")) {
            boolean hasFields = false;
            FormDataMultiPart mp = new FormDataMultiPart();
            if (hasFields) {
                postBody = mp;
            }
        }
        this.apiInvoker.invokeAPI(this.basePath, path, "DELETE", queryParams, postBody, headerParams, formParams, contentType);
    }

    public List<Registrant> getAllRegistrantsForWebinar(String authorization, Long organizerKey, Long webinarKey) throws ApiException {
        String response;
        String contentType;
        FormDataMultiPart postBody = null;
        if (authorization == null) {
            throw new ApiException("Required parameter authorization is null.");
        }
        if (organizerKey == null) {
            throw new ApiException("Required parameter organizerKey is null.");
        }
        if (webinarKey == null) {
            throw new ApiException("Required parameter webinarKey is null.");
        }
        String path = "/organizers/{organizerKey}/webinars/{webinarKey}/registrants".replaceAll("\\{format\\}", "json").replaceAll("\\{organizerKey\\}", this.apiInvoker.escapeString(organizerKey.toString())).replaceAll("\\{webinarKey\\}", this.apiInvoker.escapeString(webinarKey.toString()));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        headerParams.put("Authorization", authorization);
        String[] contentTypes = new String[]{"application/json"};
        String string = contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        if (contentType.startsWith("multipart/form-data")) {
            boolean hasFields = false;
            FormDataMultiPart mp = new FormDataMultiPart();
            if (hasFields) {
                postBody = mp;
            }
        }
        if ((response = this.apiInvoker.invokeAPI(this.basePath, path, "GET", queryParams, postBody, headerParams, formParams, contentType)) != null) {
            return (List)ApiInvoker.deserialize(response, "List", Registrant.class);
        }
        return null;
    }

    public RegistrantDetailed getRegistrant(String authorization, Long organizerKey, Long webinarKey, Long registrantKey) throws ApiException {
        String response;
        String contentType;
        FormDataMultiPart postBody = null;
        if (authorization == null) {
            throw new ApiException("Required parameter authorization is null.");
        }
        if (organizerKey == null) {
            throw new ApiException("Required parameter organizerKey is null.");
        }
        if (webinarKey == null) {
            throw new ApiException("Required parameter webinarKey is null.");
        }
        if (registrantKey == null) {
            throw new ApiException("Required parameter registrantKey is null.");
        }
        String path = "/organizers/{organizerKey}/webinars/{webinarKey}/registrants/{registrantKey}".replaceAll("\\{format\\}", "json").replaceAll("\\{organizerKey\\}", this.apiInvoker.escapeString(organizerKey.toString())).replaceAll("\\{webinarKey\\}", this.apiInvoker.escapeString(webinarKey.toString())).replaceAll("\\{registrantKey\\}", this.apiInvoker.escapeString(registrantKey.toString()));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        headerParams.put("Authorization", authorization);
        String[] contentTypes = new String[]{"application/json"};
        String string = contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        if (contentType.startsWith("multipart/form-data")) {
            boolean hasFields = false;
            FormDataMultiPart mp = new FormDataMultiPart();
            if (hasFields) {
                postBody = mp;
            }
        }
        if ((response = this.apiInvoker.invokeAPI(this.basePath, path, "GET", queryParams, postBody, headerParams, formParams, contentType)) != null) {
            return (RegistrantDetailed)ApiInvoker.deserialize(response, "", RegistrantDetailed.class);
        }
        return null;
    }

    public RegistrationFields getRegistrationFields(String authorization, Long organizerKey, Long webinarKey) throws ApiException {
        String response;
        String contentType;
        FormDataMultiPart postBody = null;
        if (authorization == null) {
            throw new ApiException("Required parameter authorization is null.");
        }
        if (organizerKey == null) {
            throw new ApiException("Required parameter organizerKey is null.");
        }
        if (webinarKey == null) {
            throw new ApiException("Required parameter webinarKey is null.");
        }
        String path = "/organizers/{organizerKey}/webinars/{webinarKey}/registrants/fields".replaceAll("\\{format\\}", "json").replaceAll("\\{organizerKey\\}", this.apiInvoker.escapeString(organizerKey.toString())).replaceAll("\\{webinarKey\\}", this.apiInvoker.escapeString(webinarKey.toString()));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        headerParams.put("Authorization", authorization);
        String[] contentTypes = new String[]{"application/json"};
        String string = contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        if (contentType.startsWith("multipart/form-data")) {
            boolean hasFields = false;
            FormDataMultiPart mp = new FormDataMultiPart();
            if (hasFields) {
                postBody = mp;
            }
        }
        if ((response = this.apiInvoker.invokeAPI(this.basePath, path, "GET", queryParams, postBody, headerParams, formParams, contentType)) != null) {
            return (RegistrationFields)ApiInvoker.deserialize(response, "", RegistrationFields.class);
        }
        return null;
    }
}

