/*
 * Decompiled with CFR 0.152.
 */
package com.logmein.gotowebinar.api;

import com.logmein.gotowebinar.api.common.ApiException;
import com.logmein.gotowebinar.api.common.ApiInvoker;
import com.logmein.gotowebinar.api.common.JsonUtil;
import com.logmein.gotowebinar.api.model.Coorganizer;
import com.logmein.gotowebinar.api.model.CoorganizerReqCreate;
import com.sun.jersey.multipart.FormDataMultiPart;
import java.util.HashMap;
import java.util.List;

public class CoorganizersApi {
    private String basePath = "https://api.getgo.com/G2W/rest/v2";
    private ApiInvoker apiInvoker = ApiInvoker.getInstance();

    public CoorganizersApi() {
    }

    public CoorganizersApi(String basePath) {
        this.basePath = basePath;
    }

    public ApiInvoker getInvoker() {
        return this.apiInvoker;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public List<Coorganizer> createCoorganizers(String authorization, Long organizerKey, Long webinarKey, List<CoorganizerReqCreate> body) throws ApiException {
        String response;
        String contentType;
        FormDataMultiPart postBody = body;
        if (authorization == null) {
            throw new ApiException("Required parameter authorization is null.");
        }
        if (organizerKey == null) {
            throw new ApiException("Required parameter organizerKey is null.");
        }
        if (webinarKey == null) {
            throw new ApiException("Required parameter webinarKey is null.");
        }
        if (body == null) {
            throw new ApiException("Required parameter body is null.");
        }
        String path = "/organizers/{organizerKey}/webinars/{webinarKey}/coorganizers".replaceAll("\\{format\\}", "json").replaceAll("\\{organizerKey\\}", this.apiInvoker.escapeString(organizerKey.toString())).replaceAll("\\{webinarKey\\}", this.apiInvoker.escapeString(webinarKey.toString()));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        headerParams.put("Authorization", authorization);
        String[] contentTypes = new String[]{"application/json"};
        String string = contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        if (contentType.startsWith("multipart/form-data")) {
            boolean hasFields = false;
            FormDataMultiPart mp = new FormDataMultiPart();
            if (hasFields) {
                postBody = mp;
            }
        }
        if ((response = this.apiInvoker.invokeAPI(this.basePath, path, "POST", queryParams, postBody, headerParams, formParams, contentType)) != null) {
            return (List)ApiInvoker.deserialize(response, "List", Coorganizer.class);
        }
        return null;
    }

    public void deleteCoorganizer(String authorization, Long organizerKey, Long webinarKey, Long coorganizerKey, Boolean external) throws ApiException {
        String contentType;
        FormDataMultiPart postBody = null;
        if (authorization == null) {
            throw new ApiException("Required parameter authorization is null.");
        }
        if (organizerKey == null) {
            throw new ApiException("Required parameter organizerKey is null.");
        }
        if (webinarKey == null) {
            throw new ApiException("Required parameter webinarKey is null.");
        }
        if (coorganizerKey == null) {
            throw new ApiException("Required parameter coorganizerKey is null.");
        }
        String path = "/organizers/{organizerKey}/webinars/{webinarKey}/coorganizers/{coorganizerKey}".replaceAll("\\{format\\}", "json").replaceAll("\\{organizerKey\\}", this.apiInvoker.escapeString(organizerKey.toString())).replaceAll("\\{webinarKey\\}", this.apiInvoker.escapeString(webinarKey.toString())).replaceAll("\\{coorganizerKey\\}", this.apiInvoker.escapeString(coorganizerKey.toString()));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        String externalString = JsonUtil.Stringify(external);
        if (!"null".equals(externalString)) {
            queryParams.put("external", externalString);
        }
        headerParams.put("Authorization", authorization);
        String[] contentTypes = new String[]{"application/json"};
        String string = contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        if (contentType.startsWith("multipart/form-data")) {
            boolean hasFields = false;
            FormDataMultiPart mp = new FormDataMultiPart();
            if (hasFields) {
                postBody = mp;
            }
        }
        this.apiInvoker.invokeAPI(this.basePath, path, "DELETE", queryParams, postBody, headerParams, formParams, contentType);
    }

    public List<Coorganizer> getCoorganizers(String authorization, Long organizerKey, Long webinarKey) throws ApiException {
        String response;
        String contentType;
        FormDataMultiPart postBody = null;
        if (authorization == null) {
            throw new ApiException("Required parameter authorization is null.");
        }
        if (organizerKey == null) {
            throw new ApiException("Required parameter organizerKey is null.");
        }
        if (webinarKey == null) {
            throw new ApiException("Required parameter webinarKey is null.");
        }
        String path = "/organizers/{organizerKey}/webinars/{webinarKey}/coorganizers".replaceAll("\\{format\\}", "json").replaceAll("\\{organizerKey\\}", this.apiInvoker.escapeString(organizerKey.toString())).replaceAll("\\{webinarKey\\}", this.apiInvoker.escapeString(webinarKey.toString()));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        headerParams.put("Authorization", authorization);
        String[] contentTypes = new String[]{"application/json"};
        String string = contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        if (contentType.startsWith("multipart/form-data")) {
            boolean hasFields = false;
            FormDataMultiPart mp = new FormDataMultiPart();
            if (hasFields) {
                postBody = mp;
            }
        }
        if ((response = this.apiInvoker.invokeAPI(this.basePath, path, "GET", queryParams, postBody, headerParams, formParams, contentType)) != null) {
            return (List)ApiInvoker.deserialize(response, "List", Coorganizer.class);
        }
        return null;
    }

    public void resendCoorganizerInvitation(String authorization, Long organizerKey, Long webinarKey, Long coorganizerKey, Boolean external) throws ApiException {
        String contentType;
        FormDataMultiPart postBody = null;
        if (authorization == null) {
            throw new ApiException("Required parameter authorization is null.");
        }
        if (organizerKey == null) {
            throw new ApiException("Required parameter organizerKey is null.");
        }
        if (webinarKey == null) {
            throw new ApiException("Required parameter webinarKey is null.");
        }
        if (coorganizerKey == null) {
            throw new ApiException("Required parameter coorganizerKey is null.");
        }
        String path = "/organizers/{organizerKey}/webinars/{webinarKey}/coorganizers/{coorganizerKey}/resendInvitation".replaceAll("\\{format\\}", "json").replaceAll("\\{organizerKey\\}", this.apiInvoker.escapeString(organizerKey.toString())).replaceAll("\\{webinarKey\\}", this.apiInvoker.escapeString(webinarKey.toString())).replaceAll("\\{coorganizerKey\\}", this.apiInvoker.escapeString(coorganizerKey.toString()));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        String externalString = JsonUtil.Stringify(external);
        if (!"null".equals(externalString)) {
            queryParams.put("external", externalString);
        }
        headerParams.put("Authorization", authorization);
        String[] contentTypes = new String[]{"application/json"};
        String string = contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        if (contentType.startsWith("multipart/form-data")) {
            boolean hasFields = false;
            FormDataMultiPart mp = new FormDataMultiPart();
            if (hasFields) {
                postBody = mp;
            }
        }
        this.apiInvoker.invokeAPI(this.basePath, path, "POST", queryParams, postBody, headerParams, formParams, contentType);
    }
}

