/*
 * Decompiled with CFR 0.152.
 */
package com.logmein.gotowebinar.api;

import com.logmein.gotowebinar.api.common.ApiException;
import com.logmein.gotowebinar.api.common.ApiInvoker;
import com.logmein.gotowebinar.api.model.Attendee;
import com.logmein.gotowebinar.api.model.AttendeeQuestion;
import com.logmein.gotowebinar.api.model.PollAnswer;
import com.logmein.gotowebinar.api.model.Registrant;
import com.sun.jersey.multipart.FormDataMultiPart;
import java.util.HashMap;
import java.util.List;

public class AttendeesApi {
    private String basePath = "https://api.getgo.com/G2W/rest/v2";
    private ApiInvoker apiInvoker = ApiInvoker.getInstance();

    public AttendeesApi() {
    }

    public AttendeesApi(String basePath) {
        this.basePath = basePath;
    }

    public ApiInvoker getInvoker() {
        return this.apiInvoker;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public Registrant getAttendee(String authorization, Long organizerKey, Long webinarKey, Long sessionKey, Long registrantKey) throws ApiException {
        String response;
        String contentType;
        FormDataMultiPart postBody = null;
        if (authorization == null) {
            throw new ApiException("Required parameter authorization is null.");
        }
        if (organizerKey == null) {
            throw new ApiException("Required parameter organizerKey is null.");
        }
        if (webinarKey == null) {
            throw new ApiException("Required parameter webinarKey is null.");
        }
        if (sessionKey == null) {
            throw new ApiException("Required parameter sessionKey is null.");
        }
        if (registrantKey == null) {
            throw new ApiException("Required parameter registrantKey is null.");
        }
        String path = "/organizers/{organizerKey}/webinars/{webinarKey}/sessions/{sessionKey}/attendees/{registrantKey}".replaceAll("\\{format\\}", "json").replaceAll("\\{organizerKey\\}", this.apiInvoker.escapeString(organizerKey.toString())).replaceAll("\\{webinarKey\\}", this.apiInvoker.escapeString(webinarKey.toString())).replaceAll("\\{sessionKey\\}", this.apiInvoker.escapeString(sessionKey.toString())).replaceAll("\\{registrantKey\\}", this.apiInvoker.escapeString(registrantKey.toString()));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        headerParams.put("Authorization", authorization);
        String[] contentTypes = new String[]{"application/json"};
        String string = contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        if (contentType.startsWith("multipart/form-data")) {
            boolean hasFields = false;
            FormDataMultiPart mp = new FormDataMultiPart();
            if (hasFields) {
                postBody = mp;
            }
        }
        if ((response = this.apiInvoker.invokeAPI(this.basePath, path, "GET", queryParams, postBody, headerParams, formParams, contentType)) != null) {
            return (Registrant)ApiInvoker.deserialize(response, "", Registrant.class);
        }
        return null;
    }

    public List<PollAnswer> getAttendeePollAnswers(String authorization, Long organizerKey, Long webinarKey, Long sessionKey, Long registrantKey) throws ApiException {
        String response;
        String contentType;
        FormDataMultiPart postBody = null;
        if (authorization == null) {
            throw new ApiException("Required parameter authorization is null.");
        }
        if (organizerKey == null) {
            throw new ApiException("Required parameter organizerKey is null.");
        }
        if (webinarKey == null) {
            throw new ApiException("Required parameter webinarKey is null.");
        }
        if (sessionKey == null) {
            throw new ApiException("Required parameter sessionKey is null.");
        }
        if (registrantKey == null) {
            throw new ApiException("Required parameter registrantKey is null.");
        }
        String path = "/organizers/{organizerKey}/webinars/{webinarKey}/sessions/{sessionKey}/attendees/{registrantKey}/polls".replaceAll("\\{format\\}", "json").replaceAll("\\{organizerKey\\}", this.apiInvoker.escapeString(organizerKey.toString())).replaceAll("\\{webinarKey\\}", this.apiInvoker.escapeString(webinarKey.toString())).replaceAll("\\{sessionKey\\}", this.apiInvoker.escapeString(sessionKey.toString())).replaceAll("\\{registrantKey\\}", this.apiInvoker.escapeString(registrantKey.toString()));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        headerParams.put("Authorization", authorization);
        String[] contentTypes = new String[]{"application/json"};
        String string = contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        if (contentType.startsWith("multipart/form-data")) {
            boolean hasFields = false;
            FormDataMultiPart mp = new FormDataMultiPart();
            if (hasFields) {
                postBody = mp;
            }
        }
        if ((response = this.apiInvoker.invokeAPI(this.basePath, path, "GET", queryParams, postBody, headerParams, formParams, contentType)) != null) {
            return (List)ApiInvoker.deserialize(response, "List", PollAnswer.class);
        }
        return null;
    }

    public List<AttendeeQuestion> getAttendeeQuestions(String authorization, Long organizerKey, Long webinarKey, Long sessionKey, Long registrantKey) throws ApiException {
        String response;
        String contentType;
        FormDataMultiPart postBody = null;
        if (authorization == null) {
            throw new ApiException("Required parameter authorization is null.");
        }
        if (organizerKey == null) {
            throw new ApiException("Required parameter organizerKey is null.");
        }
        if (webinarKey == null) {
            throw new ApiException("Required parameter webinarKey is null.");
        }
        if (sessionKey == null) {
            throw new ApiException("Required parameter sessionKey is null.");
        }
        if (registrantKey == null) {
            throw new ApiException("Required parameter registrantKey is null.");
        }
        String path = "/organizers/{organizerKey}/webinars/{webinarKey}/sessions/{sessionKey}/attendees/{registrantKey}/questions".replaceAll("\\{format\\}", "json").replaceAll("\\{organizerKey\\}", this.apiInvoker.escapeString(organizerKey.toString())).replaceAll("\\{webinarKey\\}", this.apiInvoker.escapeString(webinarKey.toString())).replaceAll("\\{sessionKey\\}", this.apiInvoker.escapeString(sessionKey.toString())).replaceAll("\\{registrantKey\\}", this.apiInvoker.escapeString(registrantKey.toString()));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        headerParams.put("Authorization", authorization);
        String[] contentTypes = new String[]{"application/json"};
        String string = contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        if (contentType.startsWith("multipart/form-data")) {
            boolean hasFields = false;
            FormDataMultiPart mp = new FormDataMultiPart();
            if (hasFields) {
                postBody = mp;
            }
        }
        if ((response = this.apiInvoker.invokeAPI(this.basePath, path, "GET", queryParams, postBody, headerParams, formParams, contentType)) != null) {
            return (List)ApiInvoker.deserialize(response, "List", AttendeeQuestion.class);
        }
        return null;
    }

    public List<PollAnswer> getAttendeeSurveyAnswers(String authorization, Long organizerKey, Long webinarKey, Long sessionKey, Long registrantKey) throws ApiException {
        String response;
        String contentType;
        FormDataMultiPart postBody = null;
        if (authorization == null) {
            throw new ApiException("Required parameter authorization is null.");
        }
        if (organizerKey == null) {
            throw new ApiException("Required parameter organizerKey is null.");
        }
        if (webinarKey == null) {
            throw new ApiException("Required parameter webinarKey is null.");
        }
        if (sessionKey == null) {
            throw new ApiException("Required parameter sessionKey is null.");
        }
        if (registrantKey == null) {
            throw new ApiException("Required parameter registrantKey is null.");
        }
        String path = "/organizers/{organizerKey}/webinars/{webinarKey}/sessions/{sessionKey}/attendees/{registrantKey}/surveys".replaceAll("\\{format\\}", "json").replaceAll("\\{organizerKey\\}", this.apiInvoker.escapeString(organizerKey.toString())).replaceAll("\\{webinarKey\\}", this.apiInvoker.escapeString(webinarKey.toString())).replaceAll("\\{sessionKey\\}", this.apiInvoker.escapeString(sessionKey.toString())).replaceAll("\\{registrantKey\\}", this.apiInvoker.escapeString(registrantKey.toString()));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        headerParams.put("Authorization", authorization);
        String[] contentTypes = new String[]{"application/json"};
        String string = contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        if (contentType.startsWith("multipart/form-data")) {
            boolean hasFields = false;
            FormDataMultiPart mp = new FormDataMultiPart();
            if (hasFields) {
                postBody = mp;
            }
        }
        if ((response = this.apiInvoker.invokeAPI(this.basePath, path, "GET", queryParams, postBody, headerParams, formParams, contentType)) != null) {
            return (List)ApiInvoker.deserialize(response, "List", PollAnswer.class);
        }
        return null;
    }

    public List<Attendee> getAttendees(String authorization, Long organizerKey, Long webinarKey, Long sessionKey) throws ApiException {
        String response;
        String contentType;
        FormDataMultiPart postBody = null;
        if (authorization == null) {
            throw new ApiException("Required parameter authorization is null.");
        }
        if (organizerKey == null) {
            throw new ApiException("Required parameter organizerKey is null.");
        }
        if (webinarKey == null) {
            throw new ApiException("Required parameter webinarKey is null.");
        }
        if (sessionKey == null) {
            throw new ApiException("Required parameter sessionKey is null.");
        }
        String path = "/organizers/{organizerKey}/webinars/{webinarKey}/sessions/{sessionKey}/attendees".replaceAll("\\{format\\}", "json").replaceAll("\\{organizerKey\\}", this.apiInvoker.escapeString(organizerKey.toString())).replaceAll("\\{webinarKey\\}", this.apiInvoker.escapeString(webinarKey.toString())).replaceAll("\\{sessionKey\\}", this.apiInvoker.escapeString(sessionKey.toString()));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, String> formParams = new HashMap<String, String>();
        headerParams.put("Authorization", authorization);
        String[] contentTypes = new String[]{"application/json"};
        String string = contentType = contentTypes.length > 0 ? contentTypes[0] : "application/json";
        if (contentType.startsWith("multipart/form-data")) {
            boolean hasFields = false;
            FormDataMultiPart mp = new FormDataMultiPart();
            if (hasFields) {
                postBody = mp;
            }
        }
        if ((response = this.apiInvoker.invokeAPI(this.basePath, path, "GET", queryParams, postBody, headerParams, formParams, contentType)) != null) {
            return (List)ApiInvoker.deserialize(response, "List", Attendee.class);
        }
        return null;
    }
}

