/*
 * Decompiled with CFR 0.152.
 */
package com.loginradius.androidsdk.api;

import com.loginradius.androidsdk.handler.ApiInterface;
import com.loginradius.androidsdk.handler.AsyncHandler;
import com.loginradius.androidsdk.handler.ExceptionResponse;
import com.loginradius.androidsdk.handler.RestRequest;
import com.loginradius.androidsdk.helper.LoginRadiusSDK;
import com.loginradius.androidsdk.resource.QueryMapHelper;
import com.loginradius.androidsdk.resource.QueryParams;
import com.loginradius.androidsdk.response.VerifyResponse;
import com.loginradius.androidsdk.response.login.LoginData;
import com.loginradius.androidsdk.response.register.RegisterResponse;
import io.reactivex.Observer;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.observers.DisposableObserver;
import io.reactivex.schedulers.Schedulers;

public class SmartLoginAPI {
    ApiInterface apiService = (ApiInterface)RestRequest.getClient().create(ApiInterface.class);

    public SmartLoginAPI() {
        if (!LoginRadiusSDK.validate()) {
            throw new LoginRadiusSDK.InitializeException();
        }
    }

    public void login(QueryParams queryParams, final AsyncHandler<RegisterResponse> handler) {
        this.apiService.getSmartLogin("identity/v2/auth/login/smartlogin", QueryMapHelper.getMapSmartLoginByEmail(queryParams)).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<RegisterResponse>(){

            public void onComplete() {
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onNext(RegisterResponse response) {
                handler.onSuccess(response);
            }
        });
    }

    public void ping(QueryParams queryParams, final AsyncHandler<LoginData> handler) {
        this.apiService.getSmartLoginPing("identity/v2/auth/login/smartlogin/ping", QueryMapHelper.getMapSmartLoginPing(queryParams)).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<LoginData>(){

            public void onComplete() {
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onNext(LoginData response) {
                handler.onSuccess(response);
            }
        });
    }

    public void verifyToken(QueryParams queryParams, final AsyncHandler<VerifyResponse> handler) {
        this.apiService.getSmartLoginVerifyToken("identity/v2/auth/email/smartlogin", QueryMapHelper.getMapSmartLoginVerifyToken(queryParams)).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<VerifyResponse>(){

            public void onComplete() {
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onNext(VerifyResponse value) {
                handler.onSuccess(value);
            }
        });
    }
}

