/*
 * Decompiled with CFR 0.152.
 */
package com.loginradius.androidsdk.api;

import com.google.gson.JsonObject;
import com.loginradius.androidsdk.handler.ApiInterface;
import com.loginradius.androidsdk.handler.AsyncHandler;
import com.loginradius.androidsdk.handler.ExceptionResponse;
import com.loginradius.androidsdk.handler.RestRequest;
import com.loginradius.androidsdk.helper.LoginRadiusSDK;
import com.loginradius.androidsdk.resource.QueryMapHelper;
import com.loginradius.androidsdk.resource.QueryParams;
import com.loginradius.androidsdk.response.customobject.CreateCustomObject;
import com.loginradius.androidsdk.response.customobject.ReadCustomObject;
import com.loginradius.androidsdk.response.register.DeleteResponse;
import io.reactivex.Observer;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.observers.DisposableObserver;
import io.reactivex.schedulers.Schedulers;

public class CustomObjectAPI {
    ApiInterface apiService = (ApiInterface)RestRequest.getClient().create(ApiInterface.class);

    public CustomObjectAPI() {
        if (!LoginRadiusSDK.validate()) {
            throw new LoginRadiusSDK.InitializeException();
        }
    }

    public void createCustomObject(QueryParams queryParams, JsonObject update, final AsyncHandler<CreateCustomObject> handler) {
        this.apiService.getCreateCustomObject("identity/v2/auth/customobject", "Bearer " + queryParams.getAccess_token(), QueryMapHelper.getMapCreateCustomObject(queryParams), update).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<CreateCustomObject>(){

            public void onComplete() {
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onNext(CreateCustomObject response) {
                handler.onSuccess(response);
            }
        });
    }

    public void deleteCustomObject(QueryParams queryParams, final AsyncHandler<DeleteResponse> handler) {
        String url = "identity/v2/auth/customobject/" + queryParams.getObjectRecordId();
        this.apiService.getDeleteCustomObject(url, "Bearer " + queryParams.getAccess_token(), QueryMapHelper.getMapDeleteCustomObject(queryParams)).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<DeleteResponse>(){

            public void onComplete() {
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onNext(DeleteResponse response) {
                handler.onSuccess(response);
            }
        });
    }

    public void readCustomObjectById(QueryParams queryParams, final AsyncHandler<CreateCustomObject> handler) {
        String url = "identity/v2/auth/customobject/" + queryParams.getObjectRecordId();
        this.apiService.getReadCustomobjectById(url, "Bearer " + queryParams.getAccess_token(), QueryMapHelper.getMapReadCustomObjectbyId(queryParams)).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<CreateCustomObject>(){

            public void onComplete() {
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onNext(CreateCustomObject response) {
                handler.onSuccess(response);
            }
        });
    }

    public void readCustomObjectByToken(QueryParams queryParams, final AsyncHandler<ReadCustomObject> handler) {
        this.apiService.getReadCustomobjectByToken("identity/v2/auth/customobject", "Bearer " + queryParams.getAccess_token(), QueryMapHelper.getMapReadCustomobjectByToken(queryParams)).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<ReadCustomObject>(){

            public void onComplete() {
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onNext(ReadCustomObject response) {
                handler.onSuccess(response);
            }
        });
    }

    public void updateCustomObject(QueryParams queryParams, JsonObject update, final AsyncHandler<CreateCustomObject> handler) {
        String url = "identity/v2/auth/customobject/" + queryParams.getObjectRecordId();
        this.apiService.getUpdateCustomObject(url, "Bearer " + queryParams.getAccess_token(), QueryMapHelper.getMapUpdateCustomObject(queryParams), update).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new DisposableObserver<CreateCustomObject>(){

            public void onComplete() {
            }

            public void onError(Throwable e) {
                ExceptionResponse exceptionResponse = ExceptionResponse.HandleException(e);
                handler.onFailure(exceptionResponse.t, exceptionResponse.message);
            }

            public void onNext(CreateCustomObject response) {
                handler.onSuccess(response);
            }
        });
    }
}

