/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.mockito.inline;

import com.android.dx.mockito.inline.InvocationHandlerAdapter;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class MockMethodAdvice {
    private final Map<Object, InvocationHandlerAdapter> interceptors;
    private final Pattern methodPattern = Pattern.compile("(.*)#(.*)\\((.*)\\)");
    private static final Pattern ARRAY_PATTERN = Pattern.compile("(\\[\\])+");
    private final SelfCallInfo selfCallInfo = new SelfCallInfo();
    private static final Map<String, String> PRIMITIVE_CLASS_TO_SIGNATURE = Map.of("byte", "B", "short", "S", "int", "I", "long", "J", "char", "C", "float", "F", "double", "D", "boolean", "Z");

    MockMethodAdvice(Map<Object, InvocationHandlerAdapter> interceptors) {
        this.interceptors = interceptors;
    }

    private static Object tryInvoke(Method origin, Object instance, Object[] arguments) throws Throwable {
        try {
            return origin.invoke(instance, arguments);
        }
        catch (InvocationTargetException exception) {
            throw exception.getCause();
        }
    }

    private static Throwable hideRecursiveCall(Throwable throwable, int current, Class<?> targetType) {
        try {
            StackTraceElement next;
            StackTraceElement[] stack = throwable.getStackTrace();
            int skip = 0;
            while (!(next = stack[stack.length - current - ++skip]).getClassName().equals(targetType.getName())) {
            }
            int top = stack.length - current - skip;
            StackTraceElement[] cleared = new StackTraceElement[stack.length - skip];
            System.arraycopy(stack, 0, cleared, 0, top);
            System.arraycopy(stack, top + skip, cleared, top, current);
            throwable.setStackTrace(cleared);
            return throwable;
        }
        catch (RuntimeException ignored) {
            return throwable;
        }
    }

    private static Optional<Class<?>> parseTypeName(String argTypeName) {
        int index = argTypeName.indexOf("[");
        if (index == -1) {
            return Optional.empty();
        }
        String typeName = argTypeName.substring(0, index);
        String rest = argTypeName.substring(index, argTypeName.length());
        if (!ARRAY_PATTERN.matcher(rest).matches()) {
            return Optional.empty();
        }
        int dimensionCount = (int)argTypeName.chars().filter(ch -> ch == 91).count();
        String classSignature = PRIMITIVE_CLASS_TO_SIGNATURE.getOrDefault(typeName, "L" + typeName + ";");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < dimensionCount; ++i) {
            sb.append("[");
        }
        sb.append(classSignature);
        String fullTypeSignature = sb.toString();
        try {
            return Optional.of(Class.forName(fullTypeSignature));
        }
        catch (ClassNotFoundException e) {
            return Optional.empty();
        }
    }

    public Method getOrigin(Object instance, String methodWithTypeAndSignature) throws Throwable {
        if (!this.isMocked(instance)) {
            return null;
        }
        Matcher methodComponents = this.methodPattern.matcher(methodWithTypeAndSignature);
        boolean wasFound = methodComponents.find();
        if (!wasFound) {
            throw new IllegalArgumentException();
        }
        String[] argTypeNames = methodComponents.group(3).split(",");
        ArrayList argTypes = new ArrayList(argTypeNames.length);
        block20: for (String argTypeName : argTypeNames) {
            if (argTypeName.equals("")) continue;
            switch (argTypeName) {
                case "byte": {
                    argTypes.add(Byte.TYPE);
                    continue block20;
                }
                case "short": {
                    argTypes.add(Short.TYPE);
                    continue block20;
                }
                case "int": {
                    argTypes.add(Integer.TYPE);
                    continue block20;
                }
                case "long": {
                    argTypes.add(Long.TYPE);
                    continue block20;
                }
                case "char": {
                    argTypes.add(Character.TYPE);
                    continue block20;
                }
                case "float": {
                    argTypes.add(Float.TYPE);
                    continue block20;
                }
                case "double": {
                    argTypes.add(Double.TYPE);
                    continue block20;
                }
                case "boolean": {
                    argTypes.add(Boolean.TYPE);
                    continue block20;
                }
                default: {
                    Optional<Class<?>> arrayClass = MockMethodAdvice.parseTypeName(argTypeName);
                    if (arrayClass.isPresent()) {
                        argTypes.add(arrayClass.get());
                        continue block20;
                    }
                    argTypes.add(Class.forName(argTypeName));
                }
            }
        }
        Method origin = Class.forName(methodComponents.group(1)).getDeclaredMethod(methodComponents.group(2), argTypes.toArray(new Class[0]));
        if (this.isOverridden(instance, origin)) {
            return null;
        }
        return origin;
    }

    public Callable<?> handle(Object instance, Method origin, Object[] arguments) throws Throwable {
        InvocationHandlerAdapter interceptor = this.interceptors.get(instance);
        if (interceptor == null) {
            return null;
        }
        return new ReturnValueWrapper(interceptor.interceptEntryHook(instance, origin, arguments, new SuperMethodCall(this.selfCallInfo, origin, instance, arguments)));
    }

    public boolean isMock(Object instance) {
        return this.interceptors.containsKey(instance);
    }

    public boolean isMocked(Object instance) {
        return this.selfCallInfo.shouldMockMethod(instance) && this.isMock(instance);
    }

    public boolean isOverridden(Object instance, Method origin) {
        Class<?> currentType = instance.getClass();
        while (true) {
            try {
                return !origin.equals(currentType.getDeclaredMethod(origin.getName(), origin.getParameterTypes()));
            }
            catch (NoSuchMethodException ignored) {
                if ((currentType = currentType.getSuperclass()) != null) continue;
                return true;
            }
            break;
        }
    }

    private static class SelfCallInfo
    extends ThreadLocal<Object> {
        private SelfCallInfo() {
        }

        boolean shouldMockMethod(Object value) {
            Object current = this.get();
            if (current == value) {
                this.set(null);
                return false;
            }
            return true;
        }
    }

    private static class ReturnValueWrapper
    implements Callable<Object> {
        private final Object returned;

        private ReturnValueWrapper(Object returned) {
            this.returned = returned;
        }

        @Override
        public Object call() {
            return this.returned;
        }
    }

    private static class SuperMethodCall
    implements InvocationHandlerAdapter.SuperMethod {
        private final SelfCallInfo selfCallInfo;
        private final Method origin;
        private final WeakReference<Object> instance;
        private final Object[] arguments;

        private SuperMethodCall(SelfCallInfo selfCallInfo, Method origin, Object instance, Object[] arguments) {
            this.selfCallInfo = selfCallInfo;
            this.origin = origin;
            this.instance = new WeakReference<Object>(instance);
            this.arguments = arguments;
        }

        @Override
        public Object invoke() throws Throwable {
            if (!Modifier.isPublic(this.origin.getDeclaringClass().getModifiers() & this.origin.getModifiers())) {
                this.origin.setAccessible(true);
            }
            this.selfCallInfo.set(this.instance.get());
            return MockMethodAdvice.tryInvoke(this.origin, this.instance.get(), this.arguments);
        }
    }
}

