/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.mockito.inline;

import com.android.dx.stock.ProxyBuilder;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationFactory;
import org.mockito.invocation.MockHandler;

final class InvocationHandlerAdapter
implements InvocationHandler {
    private MockHandler handler;

    InvocationHandlerAdapter(MockHandler handler) {
        this.handler = handler;
    }

    private static boolean isEqualsMethod(Method method) {
        return method.getName().equals("equals") && method.getParameterTypes().length == 1 && method.getParameterTypes()[0] == Object.class;
    }

    private static boolean isHashCodeMethod(Method method) {
        return method.getName().equals("hashCode") && method.getParameterTypes().length == 0;
    }

    Object interceptEntryHook(Object mock, Method method, Object[] rawArgs, final SuperMethod superMethod) throws Throwable {
        Object[] args = rawArgs;
        if (rawArgs == null) {
            args = new Object[]{};
        }
        return this.handler.handle(Mockito.framework().getInvocationFactory().createInvocation(mock, Mockito.withSettings().build(mock.getClass()), method, new InvocationFactory.RealMethodBehavior(){

            public Object call() throws Throwable {
                return superMethod.invoke();
            }
        }, args));
    }

    @Override
    public Object invoke(final Object proxy, final Method method, final Object[] rawArgs) throws Throwable {
        Object[] args = rawArgs;
        if (rawArgs == null) {
            args = new Object[]{};
        }
        if (InvocationHandlerAdapter.isEqualsMethod(method)) {
            return proxy == args[0];
        }
        if (InvocationHandlerAdapter.isHashCodeMethod(method)) {
            return System.identityHashCode(proxy);
        }
        return this.handler.handle(Mockito.framework().getInvocationFactory().createInvocation(proxy, Mockito.withSettings().build(proxy.getClass().getSuperclass()), method, new InvocationFactory.RealMethodBehavior(){

            public Object call() throws Throwable {
                return ProxyBuilder.callSuper((Object)proxy, (Method)method, (Object[])rawArgs);
            }
        }, args));
    }

    MockHandler getHandler() {
        return this.handler;
    }

    void setHandler(MockHandler handler) {
        this.handler = handler;
    }

    static interface SuperMethod {
        public Object invoke() throws Throwable;
    }
}

