/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.mockito.inline;

import com.android.dx.mockito.inline.IllegalClassFormatException;
import com.android.dx.mockito.inline.InvocationHandlerAdapter;
import com.android.dx.mockito.inline.JvmtiAgent;
import com.android.dx.mockito.inline.MockFeatures;
import com.android.dx.mockito.inline.MockMethodAdvice;
import com.android.dx.mockito.inline.UnmodifiableClassException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.mockito.exceptions.base.MockitoException;

class ClassTransformer {
    private static final Set<Class<? extends Serializable>> EXCLUDES = new HashSet<Class>(Arrays.asList(Class.class, Boolean.class, Byte.class, Short.class, Character.class, Integer.class, Long.class, Float.class, Double.class, String.class));
    private final JvmtiAgent agent;
    private final Set<Class<?>> mockedTypes;
    private final String identifier;
    private static final Object lock = new Object();

    ClassTransformer(JvmtiAgent agent, Class dispatcherClass, Map<Object, InvocationHandlerAdapter> mocks) {
        this.agent = agent;
        this.mockedTypes = Collections.synchronizedSet(new HashSet());
        this.identifier = String.valueOf(System.identityHashCode(this));
        MockMethodAdvice advice = new MockMethodAdvice(mocks);
        try {
            dispatcherClass.getMethod("set", String.class, Object.class).invoke(null, this.identifier, advice);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
        agent.addTransformer(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> void mockClass(MockFeatures<T> features) {
        boolean subclassingRequired;
        boolean bl = subclassingRequired = !features.interfaces.isEmpty() || Modifier.isAbstract(features.mockedType.getModifiers());
        if (subclassingRequired && !features.mockedType.isArray() && !features.mockedType.isPrimitive() && Modifier.isFinal(features.mockedType.getModifiers())) {
            throw new MockitoException("Unsupported settings with this type '" + features.mockedType.getName() + "'");
        }
        Object object = lock;
        synchronized (object) {
            boolean wasAdded;
            HashSet types = new HashSet();
            Class type = features.mockedType;
            while (wasAdded = this.mockedTypes.add(type)) {
                if (!EXCLUDES.contains(type)) {
                    types.add(type);
                }
                if ((type = type.getSuperclass()) != null && !type.isInterface()) continue;
            }
            if (!types.isEmpty()) {
                try {
                    this.agent.requestTransformClasses(types.toArray(new Class[types.size()]));
                }
                catch (UnmodifiableClassException exception) {
                    for (Class clazz : types) {
                        this.mockedTypes.remove(clazz);
                    }
                    throw new MockitoException("Could not modify all classes " + types, (Throwable)exception);
                }
            }
        }
    }

    byte[] transform(Class<?> classBeingRedefined, byte[] classfileBuffer) throws IllegalClassFormatException {
        if (classBeingRedefined == null || !this.mockedTypes.contains(classBeingRedefined)) {
            return null;
        }
        try {
            return this.nativeRedefine(this.identifier, classfileBuffer);
        }
        catch (Throwable throwable) {
            throw new IllegalClassFormatException();
        }
    }

    boolean shouldTransform(Class<?> classBeingRedefined) {
        return classBeingRedefined != null && this.mockedTypes.contains(classBeingRedefined);
    }

    private native byte[] nativeRedefine(String var1, byte[] var2);
}

