/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.model.message;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.linecorp.bot.model.message.Message;
import com.linecorp.bot.model.message.quickreply.QuickReply;
import com.linecorp.bot.model.message.sender.Sender;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;

@JsonTypeName(value="text")
@JsonDeserialize(builder=TextMessageBuilder.class)
public final class TextMessage
implements Message {
    @NonNull
    private final String text;
    private final QuickReply quickReply;
    private final Sender sender;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final List<Emoji> emojis;

    public TextMessage(String text) {
        this(text, null, null, null);
    }

    public TextMessage(@NonNull String text, QuickReply quickReply) {
        this(text, quickReply, null, null);
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
    }

    @Generated
    public static TextMessageBuilder builder() {
        return new TextMessageBuilder();
    }

    @Generated
    public TextMessageBuilder toBuilder() {
        return new TextMessageBuilder().text(this.text).quickReply(this.quickReply).sender(this.sender).emojis(this.emojis);
    }

    @NonNull
    @Generated
    public String getText() {
        return this.text;
    }

    @Override
    @Generated
    public QuickReply getQuickReply() {
        return this.quickReply;
    }

    @Override
    @Generated
    public Sender getSender() {
        return this.sender;
    }

    @Generated
    public List<Emoji> getEmojis() {
        return this.emojis;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TextMessage)) {
            return false;
        }
        TextMessage other = (TextMessage)o;
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        QuickReply this$quickReply = this.getQuickReply();
        QuickReply other$quickReply = other.getQuickReply();
        if (this$quickReply == null ? other$quickReply != null : !((Object)this$quickReply).equals(other$quickReply)) {
            return false;
        }
        Sender this$sender = this.getSender();
        Sender other$sender = other.getSender();
        if (this$sender == null ? other$sender != null : !((Object)this$sender).equals(other$sender)) {
            return false;
        }
        List<Emoji> this$emojis = this.getEmojis();
        List<Emoji> other$emojis = other.getEmojis();
        return !(this$emojis == null ? other$emojis != null : !((Object)this$emojis).equals(other$emojis));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        QuickReply $quickReply = this.getQuickReply();
        result = result * 59 + ($quickReply == null ? 43 : ((Object)$quickReply).hashCode());
        Sender $sender = this.getSender();
        result = result * 59 + ($sender == null ? 43 : ((Object)$sender).hashCode());
        List<Emoji> $emojis = this.getEmojis();
        result = result * 59 + ($emojis == null ? 43 : ((Object)$emojis).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TextMessage(text=" + this.getText() + ", quickReply=" + this.getQuickReply() + ", sender=" + this.getSender() + ", emojis=" + this.getEmojis() + ")";
    }

    @Generated
    private TextMessage(@NonNull String text, QuickReply quickReply, Sender sender, List<Emoji> emojis) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        this.text = text;
        this.quickReply = quickReply;
        this.sender = sender;
        this.emojis = emojis;
    }

    @JsonDeserialize(builder=EmojiBuilder.class)
    public static final class Emoji {
        private final int index;
        private final String productId;
        private final String emojiId;

        @Generated
        Emoji(int index, String productId, String emojiId) {
            this.index = index;
            this.productId = productId;
            this.emojiId = emojiId;
        }

        @Generated
        public static EmojiBuilder builder() {
            return new EmojiBuilder();
        }

        @Generated
        public EmojiBuilder toBuilder() {
            return new EmojiBuilder().index(this.index).productId(this.productId).emojiId(this.emojiId);
        }

        @Generated
        public int getIndex() {
            return this.index;
        }

        @Generated
        public String getProductId() {
            return this.productId;
        }

        @Generated
        public String getEmojiId() {
            return this.emojiId;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Emoji)) {
                return false;
            }
            Emoji other = (Emoji)o;
            if (this.getIndex() != other.getIndex()) {
                return false;
            }
            String this$productId = this.getProductId();
            String other$productId = other.getProductId();
            if (this$productId == null ? other$productId != null : !this$productId.equals(other$productId)) {
                return false;
            }
            String this$emojiId = this.getEmojiId();
            String other$emojiId = other.getEmojiId();
            return !(this$emojiId == null ? other$emojiId != null : !this$emojiId.equals(other$emojiId));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getIndex();
            String $productId = this.getProductId();
            result = result * 59 + ($productId == null ? 43 : $productId.hashCode());
            String $emojiId = this.getEmojiId();
            result = result * 59 + ($emojiId == null ? 43 : $emojiId.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "TextMessage.Emoji(index=" + this.getIndex() + ", productId=" + this.getProductId() + ", emojiId=" + this.getEmojiId() + ")";
        }

        @JsonPOJOBuilder(withPrefix="")
        public static class EmojiBuilder {
            @Generated
            private int index;
            @Generated
            private String productId;
            @Generated
            private String emojiId;

            @Generated
            EmojiBuilder() {
            }

            @Generated
            public EmojiBuilder index(int index) {
                this.index = index;
                return this;
            }

            @Generated
            public EmojiBuilder productId(String productId) {
                this.productId = productId;
                return this;
            }

            @Generated
            public EmojiBuilder emojiId(String emojiId) {
                this.emojiId = emojiId;
                return this;
            }

            @Generated
            public Emoji build() {
                return new Emoji(this.index, this.productId, this.emojiId);
            }

            @Generated
            public String toString() {
                return "TextMessage.Emoji.EmojiBuilder(index=" + this.index + ", productId=" + this.productId + ", emojiId=" + this.emojiId + ")";
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class TextMessageBuilder {
        @Generated
        private String text;
        @Generated
        private QuickReply quickReply;
        @Generated
        private Sender sender;
        @Generated
        private List<Emoji> emojis;

        @Generated
        TextMessageBuilder() {
        }

        @Generated
        public TextMessageBuilder text(@NonNull String text) {
            if (text == null) {
                throw new NullPointerException("text is marked non-null but is null");
            }
            this.text = text;
            return this;
        }

        @Generated
        public TextMessageBuilder quickReply(QuickReply quickReply) {
            this.quickReply = quickReply;
            return this;
        }

        @Generated
        public TextMessageBuilder sender(Sender sender) {
            this.sender = sender;
            return this;
        }

        @Generated
        public TextMessageBuilder emojis(List<Emoji> emojis) {
            this.emojis = emojis;
            return this;
        }

        @Generated
        public TextMessage build() {
            return new TextMessage(this.text, this.quickReply, this.sender, this.emojis);
        }

        @Generated
        public String toString() {
            return "TextMessage.TextMessageBuilder(text=" + this.text + ", quickReply=" + this.quickReply + ", sender=" + this.sender + ", emojis=" + this.emojis + ")";
        }
    }
}

