/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.internal;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;

public class DatetimePickerFieldSerializer
extends JsonSerializer<Temporal> {
    private static final DateTimeFormatter DATETIMEPICKER_LOCAL_TIME = DateTimeFormatter.ofPattern("HH:mm");
    private static final DateTimeFormatter DATETIMEPICKER_LOCAL_DATETIME = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm");

    public void serialize(Temporal value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
        gen.writeString(this.serialize(value));
    }

    String serialize(Temporal value) {
        if (value instanceof LocalTime) {
            return DATETIMEPICKER_LOCAL_TIME.format(value);
        }
        if (value instanceof LocalDate) {
            return DateTimeFormatter.ISO_LOCAL_DATE.format(value);
        }
        if (value instanceof LocalDateTime) {
            return DATETIMEPICKER_LOCAL_DATETIME.format(value);
        }
        throw new IllegalArgumentException("Illegal value type: " + value.getClass());
    }
}

