/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.linecorp.bot.client.ChannelTokenSupplier;
import com.linecorp.bot.client.FixedChannelTokenSupplier;
import com.linecorp.bot.client.HeaderInterceptor;
import com.linecorp.bot.client.LineClientConstants;
import com.linecorp.bot.client.LineMessagingService;
import com.linecorp.bot.client.RetryableLineMessagingClient;
import com.linecorp.bot.client.RetryableLineMessagingClientImpl;
import com.linecorp.bot.model.objectmapper.ModelObjectMapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import lombok.NonNull;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class RetryableLineMessagingClientBuilder {
    private static final ObjectMapper objectMapper = ModelObjectMapper.createNewObjectMapper();
    private URI apiEndPoint = LineClientConstants.DEFAULT_API_END_POINT;
    private URI blobEndPoint = LineClientConstants.DEFAULT_BLOB_END_POINT;
    private long connectTimeout = 10000L;
    private long readTimeout = 10000L;
    private long writeTimeout = 10000L;
    private ChannelTokenSupplier channelTokenSupplier;
    private Retrofit.Builder retrofitBuilder;
    private boolean addAuthenticationHeader = true;
    private OkHttpClient.Builder okHttpClientBuilder;
    private List<Interceptor> additionalInterceptors = new ArrayList<Interceptor>();

    RetryableLineMessagingClientBuilder() {
    }

    public RetryableLineMessagingClientBuilder apiEndPoint(URI apiEndPoint) {
        this.apiEndPoint = Objects.requireNonNull(apiEndPoint, "apiEndPoint");
        return this;
    }

    public RetryableLineMessagingClientBuilder channelToken(String channelToken) {
        this.channelTokenSupplier(FixedChannelTokenSupplier.of(channelToken));
        return this;
    }

    public RetryableLineMessagingClientBuilder okHttpClientBuilder(@NonNull OkHttpClient.Builder okHttpClientBuilder, boolean addAuthenticationHeader) {
        if (okHttpClientBuilder == null) {
            throw new NullPointerException("okHttpClientBuilder is marked non-null but is null");
        }
        this.okHttpClientBuilder = okHttpClientBuilder;
        this.addAuthenticationHeader = addAuthenticationHeader;
        return this;
    }

    <T> T buildRetrofitIface(URI apiEndPoint, Class<T> retrofitIFace) {
        if (this.okHttpClientBuilder == null) {
            this.okHttpClientBuilder = new OkHttpClient.Builder();
        }
        if (this.addAuthenticationHeader) {
            this.okHttpClientBuilder.addInterceptor((Interceptor)RetryableLineMessagingClientBuilder.buildAuthenticationInterceptor(this.channelTokenSupplier));
        }
        if (this.additionalInterceptors != null) {
            this.additionalInterceptors.forEach(arg_0 -> ((OkHttpClient.Builder)this.okHttpClientBuilder).addInterceptor(arg_0));
        }
        this.okHttpClientBuilder.addInterceptor(RetryableLineMessagingClientBuilder.buildLoggingInterceptor());
        this.okHttpClientBuilder.connectTimeout(this.connectTimeout, TimeUnit.MILLISECONDS).readTimeout(this.readTimeout, TimeUnit.MILLISECONDS).writeTimeout(this.writeTimeout, TimeUnit.MILLISECONDS);
        OkHttpClient okHttpClient = this.okHttpClientBuilder.build();
        if (this.retrofitBuilder == null) {
            this.retrofitBuilder = RetryableLineMessagingClientBuilder.createDefaultRetrofitBuilder();
        }
        this.retrofitBuilder.client(okHttpClient);
        this.retrofitBuilder.baseUrl(apiEndPoint.toString());
        Retrofit retrofit = this.retrofitBuilder.build();
        return (T)retrofit.create(retrofitIFace);
    }

    static HeaderInterceptor buildAuthenticationInterceptor(ChannelTokenSupplier channelTokenSupplier) {
        Objects.requireNonNull(channelTokenSupplier, "channelTokenSupplier");
        return HeaderInterceptor.forChannelTokenSupplier(channelTokenSupplier);
    }

    static Interceptor buildLoggingInterceptor() {
        Logger slf4jLogger = LoggerFactory.getLogger((String)"com.linecorp.bot.client.wire");
        return new HttpLoggingInterceptor(arg_0 -> ((Logger)slf4jLogger).info(arg_0)).setLevel(HttpLoggingInterceptor.Level.BODY);
    }

    static Retrofit.Builder createDefaultRetrofitBuilder() {
        return new Retrofit.Builder().addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)objectMapper));
    }

    public RetryableLineMessagingClient build() {
        return new RetryableLineMessagingClientImpl(this.buildRetrofitIface(this.apiEndPoint, LineMessagingService.class));
    }

    @Generated
    public String toString() {
        return "RetryableLineMessagingClientBuilder(apiEndPoint=" + this.apiEndPoint + ", blobEndPoint=" + this.blobEndPoint + ", connectTimeout=" + this.connectTimeout + ", readTimeout=" + this.readTimeout + ", writeTimeout=" + this.writeTimeout + ", channelTokenSupplier=" + this.channelTokenSupplier + ", retrofitBuilder=" + this.retrofitBuilder + ", addAuthenticationHeader=" + this.addAuthenticationHeader + ", okHttpClientBuilder=" + this.okHttpClientBuilder + ", additionalInterceptors=" + this.additionalInterceptors + ")";
    }

    @Generated
    public RetryableLineMessagingClientBuilder blobEndPoint(URI blobEndPoint) {
        this.blobEndPoint = blobEndPoint;
        return this;
    }

    @Generated
    public RetryableLineMessagingClientBuilder connectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    @Generated
    public RetryableLineMessagingClientBuilder readTimeout(long readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    @Generated
    public RetryableLineMessagingClientBuilder writeTimeout(long writeTimeout) {
        this.writeTimeout = writeTimeout;
        return this;
    }

    @Generated
    public RetryableLineMessagingClientBuilder channelTokenSupplier(ChannelTokenSupplier channelTokenSupplier) {
        this.channelTokenSupplier = channelTokenSupplier;
        return this;
    }

    @Generated
    public RetryableLineMessagingClientBuilder retrofitBuilder(Retrofit.Builder retrofitBuilder) {
        this.retrofitBuilder = retrofitBuilder;
        return this;
    }

    @Generated
    public RetryableLineMessagingClientBuilder addAuthenticationHeader(boolean addAuthenticationHeader) {
        this.addAuthenticationHeader = addAuthenticationHeader;
        return this;
    }

    @Generated
    public RetryableLineMessagingClientBuilder additionalInterceptors(List<Interceptor> additionalInterceptors) {
        this.additionalInterceptors = additionalInterceptors;
        return this;
    }
}

