/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.linecorp.bot.client.LineMessagingClientImpl;
import com.linecorp.bot.client.ManageAudienceClient;
import com.linecorp.bot.client.ManageAudienceService;
import com.linecorp.bot.model.manageaudience.AudienceGroupCreateRoute;
import com.linecorp.bot.model.manageaudience.AudienceGroupStatus;
import com.linecorp.bot.model.manageaudience.request.AddAudienceToAudienceGroupRequest;
import com.linecorp.bot.model.manageaudience.request.CreateAudienceGroupRequest;
import com.linecorp.bot.model.manageaudience.request.CreateClickBasedAudienceGroupRequest;
import com.linecorp.bot.model.manageaudience.request.CreateImpBasedAudienceGroupRequest;
import com.linecorp.bot.model.manageaudience.request.UpdateAudienceGroupAuthorityLevelRequest;
import com.linecorp.bot.model.manageaudience.request.UpdateAudienceGroupDescriptionRequest;
import com.linecorp.bot.model.manageaudience.response.CreateAudienceGroupResponse;
import com.linecorp.bot.model.manageaudience.response.CreateClickBasedAudienceGroupResponse;
import com.linecorp.bot.model.manageaudience.response.CreateImpBasedAudienceGroupResponse;
import com.linecorp.bot.model.manageaudience.response.GetAudienceDataResponse;
import com.linecorp.bot.model.manageaudience.response.GetAudienceGroupAuthorityLevelResponse;
import com.linecorp.bot.model.manageaudience.response.GetAudienceGroupsResponse;
import com.linecorp.bot.model.oauth.ChannelAccessTokenException;
import com.linecorp.bot.model.objectmapper.ModelObjectMapper;
import com.linecorp.bot.model.response.BotApiResponse;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;
import retrofit2.http.Body;

class ManageAudienceClientImpl
implements ManageAudienceClient {
    private static final ObjectMapper objectMapper = ModelObjectMapper.createNewObjectMapper();
    private final ManageAudienceService retrofitImpl;

    @Override
    public CompletableFuture<CreateAudienceGroupResponse> createAudienceGroup(CreateAudienceGroupRequest request) {
        return ManageAudienceClientImpl.toFuture(this.retrofitImpl.createAudienceGroup(request));
    }

    @Override
    public CompletableFuture<BotApiResponse> addAudienceToAudienceGroup(AddAudienceToAudienceGroupRequest request) {
        return ManageAudienceClientImpl.toBotApiFuture(this.retrofitImpl.addAudienceToAudienceGroup(request));
    }

    @Override
    public CompletableFuture<CreateClickBasedAudienceGroupResponse> createClickBasedAudienceGroup(CreateClickBasedAudienceGroupRequest request) {
        return ManageAudienceClientImpl.toFuture(this.retrofitImpl.createClickBasedAudienceGroup(request));
    }

    @Override
    public CompletableFuture<CreateImpBasedAudienceGroupResponse> createImpBasedAudienceGroup(CreateImpBasedAudienceGroupRequest request) {
        return ManageAudienceClientImpl.toFuture(this.retrofitImpl.createImpBasedAudienceGroup(request));
    }

    @Override
    public CompletableFuture<BotApiResponse> updateAudienceGroupDescription(long audienceGroupId, UpdateAudienceGroupDescriptionRequest request) {
        return ManageAudienceClientImpl.toBotApiFuture(this.retrofitImpl.updateAudienceGroupDescription(audienceGroupId, request));
    }

    @Override
    public CompletableFuture<BotApiResponse> deleteAudienceGroup(long audienceGroupId) {
        return ManageAudienceClientImpl.toBotApiFuture(this.retrofitImpl.deleteAudienceGroup(audienceGroupId));
    }

    @Override
    public CompletableFuture<GetAudienceGroupsResponse> getAudienceGroups(long page, String description, AudienceGroupStatus status, Long size, Boolean includesExternalPublicGroups, AudienceGroupCreateRoute createRoute) {
        return ManageAudienceClientImpl.toFuture(this.retrofitImpl.getAudienceGroups(page, description, status, size, includesExternalPublicGroups, createRoute));
    }

    @Override
    public CompletableFuture<GetAudienceDataResponse> getAudienceData(long audienceGroupId) {
        return ManageAudienceClientImpl.toFuture(this.retrofitImpl.getAudienceData(audienceGroupId));
    }

    @Override
    public CompletableFuture<GetAudienceGroupAuthorityLevelResponse> getAudienceGroupAuthorityLevel() {
        return ManageAudienceClientImpl.toFuture(this.retrofitImpl.getAudienceGroupAuthorityLevel());
    }

    @Override
    public CompletableFuture<BotApiResponse> updateAudienceGroupAuthorityLevel(@Body UpdateAudienceGroupAuthorityLevelRequest request) {
        return ManageAudienceClientImpl.toBotApiFuture(this.retrofitImpl.updateAudienceGroupAuthorityLevel(request));
    }

    private static <T> CompletableFuture<T> toFuture(Call<T> call) {
        CallbackCompletableFuture future = new CallbackCompletableFuture();
        call.enqueue(future);
        return future;
    }

    static CompletableFuture<BotApiResponse> toBotApiFuture(Call<Void> callToWrap) {
        LineMessagingClientImpl.VoidToBotApiCallbackAdaptor completableFuture = new LineMessagingClientImpl.VoidToBotApiCallbackAdaptor();
        callToWrap.enqueue((Callback)completableFuture);
        return completableFuture;
    }

    @Generated
    public ManageAudienceClientImpl(ManageAudienceService retrofitImpl) {
        this.retrofitImpl = retrofitImpl;
    }

    static class CallbackCompletableFuture<T>
    extends CompletableFuture<T>
    implements Callback<T> {
        CallbackCompletableFuture() {
        }

        public void onResponse(Call<T> call, Response<T> response) {
            if (response.isSuccessful()) {
                this.complete(response.body());
                return;
            }
            if (response.code() == 400) {
                try {
                    this.completeExceptionally((Throwable)objectMapper.readValue(response.errorBody().string(), ChannelAccessTokenException.class));
                    return;
                }
                catch (IOException e) {
                    this.completeExceptionally(e);
                }
            }
            this.completeExceptionally((Throwable)new ChannelAccessTokenException(response.message()));
        }

        public void onFailure(Call<T> call, Throwable t) {
            this.completeExceptionally((Throwable)new ChannelAccessTokenException(t.getMessage(), t));
        }
    }
}

