/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.client;

import com.linecorp.bot.client.LineBlobClient;
import com.linecorp.bot.client.LineBlobService;
import com.linecorp.bot.client.LineMessagingClientImpl;
import com.linecorp.bot.client.MessageContentResponse;
import com.linecorp.bot.client.exception.GeneralLineMessagingException;
import com.linecorp.bot.model.response.BotApiResponse;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

class LineBlobClientImpl
implements LineBlobClient {
    private final LineBlobService retrofitImpl;

    @Override
    public CompletableFuture<MessageContentResponse> getMessageContent(String messageId) {
        return LineBlobClientImpl.toMessageContentResponseFuture(this.retrofitImpl.getMessageContent(messageId));
    }

    @Override
    public CompletableFuture<MessageContentResponse> getRichMenuImage(String richMenuId) {
        return LineBlobClientImpl.toMessageContentResponseFuture(this.retrofitImpl.getRichMenuImage(richMenuId));
    }

    @Override
    public CompletableFuture<BotApiResponse> setRichMenuImage(String richMenuId, String contentType, byte[] content) {
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)contentType), (byte[])content);
        return LineMessagingClientImpl.toBotApiFuture(this.retrofitImpl.uploadRichMenuImage(richMenuId, requestBody));
    }

    private static CompletableFuture<MessageContentResponse> toMessageContentResponseFuture(Call<ResponseBody> callToWrap) {
        ResponseBodyCallbackAdaptor future = new ResponseBodyCallbackAdaptor();
        callToWrap.enqueue((Callback)future);
        return future;
    }

    @Generated
    public LineBlobClientImpl(LineBlobService retrofitImpl) {
        this.retrofitImpl = retrofitImpl;
    }

    static class ResponseBodyCallbackAdaptor
    extends CompletableFuture<MessageContentResponse>
    implements Callback<ResponseBody> {
        ResponseBodyCallbackAdaptor() {
        }

        public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
            if (!response.isSuccessful()) {
                this.completeExceptionally(LineMessagingClientImpl.EXCEPTION_CONVERTER.apply(response));
                return;
            }
            try {
                this.complete(this.convert(response));
            }
            catch (RuntimeException exceptionInConvert) {
                this.completeExceptionally(new GeneralLineMessagingException(exceptionInConvert.getMessage(), null, exceptionInConvert));
            }
        }

        public void onFailure(Call<ResponseBody> call, Throwable t) {
            this.completeExceptionally(new GeneralLineMessagingException(t.getMessage(), null, t));
        }

        private MessageContentResponse convert(Response<ResponseBody> response) {
            return MessageContentResponse.builder().length(((ResponseBody)response.body()).contentLength()).allHeaders(response.headers().toMultimap()).mimeType(((ResponseBody)response.body()).contentType().toString()).stream(((ResponseBody)response.body()).byteStream()).build();
        }
    }
}

