/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.bot.client;

import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.linecorp.bot.client.exception.BadRequestException;
import com.linecorp.bot.client.exception.ConflictException;
import com.linecorp.bot.client.exception.ForbiddenException;
import com.linecorp.bot.client.exception.GeneralLineMessagingException;
import com.linecorp.bot.client.exception.LineMessagingException;
import com.linecorp.bot.client.exception.LineServerException;
import com.linecorp.bot.client.exception.NotFoundException;
import com.linecorp.bot.client.exception.TooManyRequestsException;
import com.linecorp.bot.client.exception.UnauthorizedException;
import com.linecorp.bot.model.error.ErrorResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.function.Function;
import okhttp3.ResponseBody;
import retrofit2.Response;

class ExceptionConverter
implements Function<Response<?>, LineMessagingException> {
    public static final ObjectReader OBJECT_READER = new ObjectMapper().readerFor(ErrorResponse.class);

    ExceptionConverter() {
    }

    @Override
    public LineMessagingException apply(Response<?> response) {
        String requestId = response.headers().get("x-line-request-id");
        try {
            return ExceptionConverter.applyInternal(requestId, response);
        }
        catch (Exception e) {
            ErrorResponse errorResponse = new ErrorResponse(requestId, null, null);
            return new GeneralLineMessagingException(e.getMessage(), errorResponse, e);
        }
    }

    private static LineMessagingException applyInternal(String requestId, Response<?> response) throws IOException {
        int code = response.code();
        ResponseBody responseBody = response.errorBody();
        ErrorResponse errorResponse = (ErrorResponse)OBJECT_READER.with((InjectableValues)new InjectableValues.Std(Collections.singletonMap("requestId", requestId))).readValue(responseBody.byteStream());
        switch (code) {
            case 400: {
                return new BadRequestException(errorResponse.getMessage(), errorResponse);
            }
            case 401: {
                return new UnauthorizedException(errorResponse.getMessage(), errorResponse);
            }
            case 403: {
                return new ForbiddenException(errorResponse.getMessage(), errorResponse);
            }
            case 404: {
                return new NotFoundException(errorResponse.getMessage(), errorResponse);
            }
            case 409: {
                return new ConflictException(errorResponse.getMessage(), errorResponse);
            }
            case 429: {
                return new TooManyRequestsException(errorResponse.getMessage(), errorResponse);
            }
            case 500: {
                return new LineServerException(errorResponse.getMessage(), errorResponse);
            }
        }
        return new GeneralLineMessagingException(errorResponse.getMessage(), errorResponse, null);
    }
}

