/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.rxjava2;

import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.rxjava2.RequestContextObserver;
import com.linecorp.armeria.common.util.SafeCloseable;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import java.util.concurrent.Callable;

final class RequestContextCallableObservable<T>
extends Observable<T>
implements Callable<T> {
    private final ObservableSource<T> source;
    private final RequestContext assemblyContext;

    RequestContextCallableObservable(ObservableSource<T> source, RequestContext assemblyContext) {
        this.source = source;
        this.assemblyContext = assemblyContext;
    }

    protected void subscribeActual(Observer<? super T> s) {
        try (SafeCloseable ignored = this.assemblyContext.push();){
            this.source.subscribe(new RequestContextObserver<T>(s, this.assemblyContext));
        }
    }

    @Override
    public T call() throws Exception {
        try (SafeCloseable ignored = this.assemblyContext.push();){
            Object v = ((Callable)this.source).call();
            return (T)v;
        }
    }
}

