/*
 * Decompiled with CFR 0.152.
 */
package haxe.format;

import haxe.ds.StringMap;
import haxe.jvm.DynamicObject;
import haxe.jvm.EmptyConstructor;
import haxe.jvm.Function;
import haxe.jvm.Jvm;
import haxe.jvm.Object;
import haxe.jvm.annotation.ClassReflectionInformation;
import haxe.root.Array;
import haxe.root.Date;
import haxe.root.Reflect;
import haxe.root.Std;
import haxe.root.StringBuf;
import haxe.root.StringTools;
import haxe.root.Type;
import haxe.root.ValueType;

@ClassReflectionInformation(hasSuperClass=false)
public class JsonPrinter
extends Object {
    public StringBuf buf;
    public Function replacer;
    public String indent;
    public boolean pretty;
    public int nind;

    public static String print(java.lang.Object o, Function replacer, String space) {
        JsonPrinter printer = new JsonPrinter(replacer, space);
        printer.write("", o);
        return printer.buf.toString();
    }

    public void write(java.lang.Object k, java.lang.Object v) {
        if (this.replacer != null) {
            v = this.replacer.invoke(k, v);
        }
        ValueType _g = Type.typeof(v);
        switch (_g.ordinal()) {
            case 0: {
                this.buf.add("null");
                break;
            }
            case 1: {
                String v2 = Std.string(v);
                this.buf.add(v2);
                return;
            }
            case 2: {
                String v3 = Double.isFinite(Jvm.toDouble(v)) ? Std.string(v) : "null";
                this.buf.add(v3);
                return;
            }
            case 3: {
                this.buf.add(Jvm.toBoolean(v) ? "true" : "false");
                break;
            }
            case 4: {
                this.fieldsString(v, Reflect.fields(v));
                break;
            }
            case 5: {
                this.buf.add("\"<fun>\"");
                break;
            }
            case 6: {
                Class _g2 = ((ValueType.TClass)_g).c;
                if (_g2 == String.class) {
                    this.quote((String)v);
                    return;
                }
                if (_g2 == Array.class) {
                    Array v4 = (Array)v;
                    this.buf.addChar(91);
                    int len = v4.length;
                    int last = len - 1;
                    int _g3 = 0;
                    while (_g3 < len) {
                        String v5;
                        int i;
                        if ((i = _g3++) > 0) {
                            this.buf.addChar(44);
                        } else {
                            ++this.nind;
                        }
                        if (this.pretty) {
                            this.buf.addChar(10);
                        }
                        if (this.pretty) {
                            v5 = StringTools.lpad("", this.indent, this.nind * this.indent.length());
                            this.buf.add(v5);
                        }
                        this.write(i, v4.__get(i));
                        if (i != last) continue;
                        --this.nind;
                        if (this.pretty) {
                            this.buf.addChar(10);
                        }
                        if (!this.pretty) continue;
                        v5 = StringTools.lpad("", this.indent, this.nind * this.indent.length());
                        this.buf.add(v5);
                    }
                    this.buf.addChar(93);
                    return;
                }
                if (_g2 == StringMap.class) {
                    StringMap v6 = (StringMap)v;
                    DynamicObject o = new DynamicObject();
                    for (String k2 : v6.hashMap.keySet()) {
                        Reflect.setField(o, k2, v6.get(k2));
                    }
                    DynamicObject v7 = o;
                    this.fieldsString(v7, Reflect.fields(v7));
                    return;
                }
                if (_g2 == Date.class) {
                    Date v8 = (Date)v;
                    this.quote(v8.toString());
                    return;
                }
                this.classString(v);
                return;
            }
            case 7: {
                int i = Type.enumIndex((Enum)v);
                String v9 = Std.string(i);
                this.buf.add(v9);
                return;
            }
            case 8: {
                this.buf.add("\"???\"");
            }
        }
    }

    public void classString(java.lang.Object v) {
        this.fieldsString(v, Type.getInstanceFields(Type.getClass(v)));
    }

    public void fieldsString(java.lang.Object v, Array fields) {
        this.buf.addChar(123);
        int len = fields.length;
        int last = len - 1;
        boolean first = true;
        int _g = 0;
        while (_g < len) {
            String v2;
            int i;
            String f;
            java.lang.Object value;
            if (Reflect.isFunction(value = Reflect.field(v, f = (String)fields.__get(i = _g++)))) continue;
            if (first) {
                ++this.nind;
                first = false;
            } else {
                this.buf.addChar(44);
            }
            if (this.pretty) {
                this.buf.addChar(10);
            }
            if (this.pretty) {
                v2 = StringTools.lpad("", this.indent, this.nind * this.indent.length());
                this.buf.add(v2);
            }
            this.quote(f);
            this.buf.addChar(58);
            if (this.pretty) {
                this.buf.addChar(32);
            }
            this.write(f, value);
            if (i != last) continue;
            --this.nind;
            if (this.pretty) {
                this.buf.addChar(10);
            }
            if (!this.pretty) continue;
            v2 = StringTools.lpad("", this.indent, this.nind * this.indent.length());
            this.buf.add(v2);
        }
        this.buf.addChar(125);
    }

    public void quote(String s) {
        this.buf.addChar(34);
        int i = 0;
        int length = s.length();
        block9: while (i < length) {
            char c = s.charAt(i++);
            switch (c) {
                default: {
                    this.buf.addChar(c);
                    continue block9;
                }
                case '\b': {
                    this.buf.add("\\b");
                    continue block9;
                }
                case '\t': {
                    this.buf.add("\\t");
                    continue block9;
                }
                case '\n': {
                    this.buf.add("\\n");
                    continue block9;
                }
                case '\f': {
                    this.buf.add("\\f");
                    continue block9;
                }
                case '\r': {
                    this.buf.add("\\r");
                    continue block9;
                }
                case '\"': {
                    this.buf.add("\\\"");
                    continue block9;
                }
                case '\\': 
            }
            this.buf.add("\\\\");
        }
        this.buf.addChar(34);
    }

    public JsonPrinter(Function replacer, String space) {
        this.replacer = replacer;
        this.indent = space;
        this.pretty = space != null;
        this.nind = 0;
        this.buf = new StringBuf();
    }

    public /* synthetic */ JsonPrinter(EmptyConstructor _) {
    }
}

