/*
 * Decompiled with CFR 0.152.
 */
package com.lightstreamer.client.mpn;

import android.os.MessageQueue;
import com.fasterxml.jackson.annotation.JsonIncludeProperties;
import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.databind.util.Named;
import com.lightstreamer.client.LSSubscription;
import com.lightstreamer.client.internal.MpnSubscriptionManager;
import com.lightstreamer.client.internal._ParseTools.ParseTools_Fields_;
import com.lightstreamer.client.mpn.MpnRequestedMaxFrequency;
import com.lightstreamer.client.mpn.MpnRequestedMaxFrequencyTools;
import com.lightstreamer.client.mpn.MpnSubscriptionListener;
import com.lightstreamer.client.mpn.MpnSubscriptionStatus;
import com.lightstreamer.client.mpn._MpnSubscription.MpnSubscriptionEventDispatcher;
import com.lightstreamer.client.mpn._Types.MpnSubscriptionMode_Impl_;
import com.lightstreamer.internal.InfoMap;
import com.lightstreamer.internal.RLock;
import com.lightstreamer.internal.RequestedBufferSize;
import com.lightstreamer.internal.RequestedBufferSizeTools;
import com.lightstreamer.internal._NativeTypes.NativeArray_Impl_;
import com.lightstreamer.internal._NativeTypes.NativeList_Impl_;
import com.lightstreamer.internal._Types.Fields_Impl_;
import com.lightstreamer.internal._Types.Items_Impl_;
import com.lightstreamer.internal._Types.Name_Impl_;
import com.lightstreamer.log._LoggerTools.LoggerTools_Fields_;
import haxe.ds.StringMap;
import haxe.jvm.EmptyConstructor;
import haxe.jvm.Exception;
import haxe.jvm.Function;
import haxe.jvm.Jvm;
import haxe.jvm.annotation.ClassReflectionInformation;
import haxe.jvm.annotation.EnumReflectionInformation;
import haxe.jvm.annotation.EnumValueReflectionInformation;
import haxe.root.Array;
import haxe.root.Std;
import java.net.ProtocolFamily;
import java.nio.file.WatchEvent;
import java.nio.file.attribute.AttributeView;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.PrimitiveIterator;
import java.util.concurrent.Callable;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import kotlin.jvm.functions.Function0;

@ClassReflectionInformation(hasSuperClass=false)
public class LSMpnSubscription
extends haxe.jvm.Object {
    public MpnSubscriptionEventDispatcher eventDispatcher;
    public String mode;
    public Array<String> items;
    public Array<String> fields;
    public String group;
    public String schema;
    public String dataAdapter;
    public RequestedBufferSize bufferSize;
    public MpnRequestedMaxFrequency requestedMaxFrequency;
    public String requestedTrigger;
    public String requestedFormat;
    public String realTrigger;
    public String realFormat;
    public long m_statusTs;
    public String m_mpnSubId;
    public boolean madeByServer;
    public MpnSubscriptionStatus m_status;
    public MpnSubscriptionManager m_manager;
    public Object wrapper;
    public RLock lock;

    public void reInit(String mpnSubId) {
        this.m_mpnSubId = mpnSubId;
        this.madeByServer = true;
    }

    public void initFromSubscription(LSSubscription subscription) {
        String[] _items = subscription.getItems();
        String[] _fields = subscription.getFields();
        this.items = _items != null ? Items_Impl_.fromArray(NativeArray_Impl_.toHaxe(_items)) : null;
        this.group = Name_Impl_.fromString(subscription.getItemGroup());
        this.fields = _fields != null ? Fields_Impl_.fromArray(NativeArray_Impl_.toHaxe(_fields)) : null;
        this.schema = Name_Impl_.fromString(subscription.getFieldSchema());
        this.dataAdapter = Name_Impl_.fromString(subscription.getDataAdapter());
        this.bufferSize = RequestedBufferSizeTools.fromString(subscription.getRequestedBufferSize());
        this.requestedMaxFrequency = MpnRequestedMaxFrequencyTools.fromString(subscription.getRequestedMaxFrequency());
    }

    public void initFromMpnSubscription(LSMpnSubscription mpnSubscription) {
        this.items = mpnSubscription.items;
        this.group = mpnSubscription.group;
        this.fields = mpnSubscription.fields;
        this.schema = mpnSubscription.schema;
        this.dataAdapter = mpnSubscription.dataAdapter;
        this.bufferSize = mpnSubscription.bufferSize;
        this.requestedMaxFrequency = mpnSubscription.requestedMaxFrequency;
        this.requestedFormat = mpnSubscription.requestedFormat;
        this.requestedTrigger = mpnSubscription.requestedTrigger;
    }

    public void initItemsAndFields(String[] items, String[] fields) {
        if (items != null) {
            if (fields == null) {
                throw new IllegalArgumentException("Please specify a valid field list");
            }
            this.items = Items_Impl_.fromArray(NativeArray_Impl_.toHaxe(items));
            this.fields = Fields_Impl_.fromArray(NativeArray_Impl_.toHaxe(fields));
            return;
        }
        if (fields != null) {
            throw new IllegalArgumentException("Please specify a valid item or item list");
        }
    }

    public void addListener(MpnSubscriptionListener listener) {
        LSMpnSubscription _gthis = this;
        this.lock.synchronized(new Closure_addListener_0(_gthis, listener));
    }

    public void removeListener(MpnSubscriptionListener listener) {
        LSMpnSubscription _gthis = this;
        this.lock.synchronized(new Closure_removeListener_0(_gthis, listener));
    }

    public List getListeners() {
        LSMpnSubscription _gthis = this;
        return (List)this.lock.synchronized(new Closure_getListeners_0(_gthis));
    }

    public String getMode() {
        LSMpnSubscription _gthis = this;
        return (String)this.lock.synchronized(new Closure_getMode_0(_gthis));
    }

    public String getTriggerExpression() {
        LSMpnSubscription _gthis = this;
        return (String)this.lock.synchronized(new Closure_getTriggerExpression_0(_gthis));
    }

    public void setTriggerExpression(String expr) {
        MpnSubscriptionManager[] _manager = new MpnSubscriptionManager[1];
        LSMpnSubscription _gthis = this;
        this.lock.synchronized(new Closure_setTriggerExpression_0(_gthis, expr, _manager));
        if (_manager[0] != null) {
            _manager[0].evtExtMpnSetTrigger();
        }
    }

    public String getActualTriggerExpression() {
        LSMpnSubscription _gthis = this;
        return (String)this.lock.synchronized(new Closure_getActualTriggerExpression_0(_gthis));
    }

    public String getNotificationFormat() {
        LSMpnSubscription _gthis = this;
        return (String)this.lock.synchronized(new Closure_getNotificationFormat_0(_gthis));
    }

    public void setNotificationFormat(String format) {
        MpnSubscriptionManager[] _manager = new MpnSubscriptionManager[1];
        LSMpnSubscription _gthis = this;
        this.lock.synchronized(new Closure_setNotificationFormat_0(_gthis, format, _manager));
        if (_manager[0] != null) {
            _manager[0].evtExtMpnSetFormat();
        }
    }

    public String getActualNotificationFormat() {
        LSMpnSubscription _gthis = this;
        return (String)this.lock.synchronized(new Closure_getActualNotificationFormat_0(_gthis));
    }

    public String getDataAdapter() {
        LSMpnSubscription _gthis = this;
        return (String)this.lock.synchronized(new Closure_getDataAdapter_0(_gthis));
    }

    public void setDataAdapter(String dataAdapter) {
        LSMpnSubscription _gthis = this;
        this.lock.synchronized(new Closure_setDataAdapter_0(_gthis, dataAdapter));
    }

    public String[] getFields() {
        LSMpnSubscription _gthis = this;
        return (String[])this.lock.synchronized(new Closure_getFields_0(_gthis));
    }

    public void setFields(String[] fields) {
        LSMpnSubscription _gthis = this;
        this.lock.synchronized(new Closure_setFields_0(_gthis, fields));
    }

    public String getFieldSchema() {
        LSMpnSubscription _gthis = this;
        return (String)this.lock.synchronized(new Closure_getFieldSchema_0(_gthis));
    }

    public void setFieldSchema(String schema) {
        LSMpnSubscription _gthis = this;
        this.lock.synchronized(new Closure_setFieldSchema_0(_gthis, schema));
    }

    public String[] getItems() {
        LSMpnSubscription _gthis = this;
        return (String[])this.lock.synchronized(new Closure_getItems_0(_gthis));
    }

    public void setItems(String[] items) {
        LSMpnSubscription _gthis = this;
        this.lock.synchronized(new Closure_setItems_0(_gthis, items));
    }

    public String getItemGroup() {
        LSMpnSubscription _gthis = this;
        return (String)this.lock.synchronized(new Closure_getItemGroup_0(_gthis));
    }

    public void setItemGroup(String group) {
        LSMpnSubscription _gthis = this;
        this.lock.synchronized(new Closure_setItemGroup_0(_gthis, group));
    }

    public String getRequestedBufferSize() {
        LSMpnSubscription _gthis = this;
        return (String)this.lock.synchronized(new Closure_getRequestedBufferSize_0(_gthis));
    }

    public void setRequestedBufferSize(String size) {
        LSMpnSubscription _gthis = this;
        this.lock.synchronized(new Closure_setRequestedBufferSize_0(_gthis, size));
    }

    public String getRequestedMaxFrequency() {
        LSMpnSubscription _gthis = this;
        return (String)this.lock.synchronized(new Closure_getRequestedMaxFrequency_0(_gthis));
    }

    public void setRequestedMaxFrequency(String freq) {
        LSMpnSubscription _gthis = this;
        this.lock.synchronized(new Closure_setRequestedMaxFrequency_0(_gthis, freq));
    }

    public boolean isActive() {
        LSMpnSubscription _gthis = this;
        return Jvm.toBoolean(this.lock.synchronized(new Closure_isActive_0(_gthis)));
    }

    public boolean isSubscribed() {
        LSMpnSubscription _gthis = this;
        return Jvm.toBoolean(this.lock.synchronized(new Closure_isSubscribed_0(_gthis)));
    }

    public boolean isTriggered() {
        LSMpnSubscription _gthis = this;
        return Jvm.toBoolean(this.lock.synchronized(new Closure_isTriggered_0(_gthis)));
    }

    public String getStatus() {
        LSMpnSubscription _gthis = this;
        return (String)this.lock.synchronized(new Closure_getStatus_0(_gthis));
    }

    public long getStatusTimestamp() {
        LSMpnSubscription _gthis = this;
        return Jvm.toLong(this.lock.synchronized(new Closure_getStatusTimestamp_0(_gthis)));
    }

    public String getSubscriptionId() {
        LSMpnSubscription _gthis = this;
        return (String)this.lock.synchronized(new Closure_getSubscriptionId_0(_gthis));
    }

    public void checkActive() {
        if (this.isActive()) {
            throw new IllegalStateException("Cannot modify an active MpnSubscription. Please unsubscribe before applying any change");
        }
    }

    public void setSubscriptionId(String mpnSubId) {
        LSMpnSubscription _gthis = this;
        this.lock.synchronized(new Closure_setSubscriptionId_0(_gthis, mpnSubId));
    }

    public void changeStatus(MpnSubscriptionStatus status, String statusTs) {
        LSMpnSubscription _gthis = this;
        this.lock.synchronized(new Closure_changeStatus_0(statusTs, _gthis, status));
    }

    public void changeStatusTs(String rawStatusTs) {
        LSMpnSubscription _gthis = this;
        this.lock.synchronized(new Closure_changeStatusTs_0(rawStatusTs, _gthis));
    }

    public void changeMode(String rawMode) {
        LSMpnSubscription _gthis = this;
        this.lock.synchronized(new Closure_changeMode_0(rawMode, _gthis));
    }

    public void changeGroup(String _group) {
        LSMpnSubscription _gthis = this;
        this.lock.synchronized(new Closure_changeGroup_0(_group, _gthis));
    }

    public void changeSchema(String _schema) {
        LSMpnSubscription _gthis = this;
        this.lock.synchronized(new Closure_changeSchema_0(_schema, _gthis));
    }

    public void changeAdapter(String _adapter) {
        LSMpnSubscription _gthis = this;
        this.lock.synchronized(new Closure_changeAdapter_0(_gthis, _adapter));
    }

    public void changeFormat(String _format) {
        LSMpnSubscription _gthis = this;
        this.lock.synchronized(new Closure_changeFormat_0(_format, _gthis));
    }

    public void changeTrigger(String _trigger) {
        LSMpnSubscription _gthis = this;
        this.lock.synchronized(new Closure_changeTrigger_0(_trigger, _gthis));
    }

    public void changeBufferSize(String rawBufferSize) {
        LSMpnSubscription _gthis = this;
        this.lock.synchronized(new Closure_changeBufferSize_0(rawBufferSize, _gthis));
    }

    public void changeMaxFrequency(String rawFrequency) {
        LSMpnSubscription _gthis = this;
        this.lock.synchronized(new Closure_changeMaxFrequency_0(rawFrequency, _gthis));
    }

    public void reset() {
        LSMpnSubscription _gthis = this;
        this.lock.synchronized(new Closure_reset_0(_gthis));
    }

    public void fireOnSubscription() {
        LSMpnSubscription _gthis = this;
        this.lock.synchronized(new Closure_fireOnSubscription_0(_gthis));
    }

    public void fireOnUnsubscription() {
        LSMpnSubscription _gthis = this;
        this.lock.synchronized(new Closure_fireOnUnsubscription_0(_gthis));
    }

    public void fireOnTriggered() {
        LSMpnSubscription _gthis = this;
        this.lock.synchronized(new Closure_fireOnTriggered_0(_gthis));
    }

    public void fireOnSubscriptionError(int code, String msg) {
        LSMpnSubscription _gthis = this;
        this.lock.synchronized(new Closure_fireOnSubscriptionError_0(_gthis, code, msg));
    }

    public void fireOnUnsubscriptionError(int code, String msg) {
        LSMpnSubscription _gthis = this;
        this.lock.synchronized(new Closure_fireOnUnsubscriptionError_0(_gthis, code, msg));
    }

    public void fireOnModificationError(int code, String message, String property) {
        LSMpnSubscription _gthis = this;
        this.lock.synchronized(new Closure_fireOnModificationError_0(_gthis, property, code, message));
    }

    public void fireOnPropertyChange(String property) {
        LSMpnSubscription _gthis = this;
        this.lock.synchronized(new Closure_fireOnPropertyChange_0(property, _gthis));
    }

    public MpnSubscriptionManager fetch_subManager() {
        LSMpnSubscription _gthis = this;
        return (MpnSubscriptionManager)this.lock.synchronized(new Closure_fetch_subManager_0(_gthis));
    }

    public MpnSubscriptionStatus fetch_status() {
        LSMpnSubscription _gthis = this;
        return (MpnSubscriptionStatus)((Object)this.lock.synchronized(new Closure_fetch_status_0(_gthis)));
    }

    public boolean fetch_madeByServer() {
        LSMpnSubscription _gthis = this;
        return Jvm.toBoolean(this.lock.synchronized(new Closure_fetch_madeByServer_0(_gthis)));
    }

    public String fetch_mpnSubId() {
        LSMpnSubscription _gthis = this;
        return (String)this.lock.synchronized(new Closure_fetch_mpnSubId_0(_gthis));
    }

    public RequestedBufferSize fetch_requestedBufferSize() {
        LSMpnSubscription _gthis = this;
        return (RequestedBufferSize)((Object)this.lock.synchronized(new Closure_fetch_requestedBufferSize_0(_gthis)));
    }

    public String fetch_mode() {
        LSMpnSubscription _gthis = this;
        return (String)this.lock.synchronized(new Closure_fetch_mode_0(_gthis));
    }

    public MpnRequestedMaxFrequency fetch_requestedMaxFrequency() {
        LSMpnSubscription _gthis = this;
        return (MpnRequestedMaxFrequency)((Object)this.lock.synchronized(new Closure_fetch_requestedMaxFrequency_0(_gthis)));
    }

    public String fetch_requestedFormat() {
        LSMpnSubscription _gthis = this;
        return (String)this.lock.synchronized(new Closure_fetch_requestedFormat_0(_gthis));
    }

    public String fetch_requestedTrigger() {
        LSMpnSubscription _gthis = this;
        return (String)this.lock.synchronized(new Closure_fetch_requestedTrigger_0(_gthis));
    }

    public void relate(MpnSubscriptionManager _manager) {
        LSMpnSubscription _gthis = this;
        this.lock.synchronized(new Closure_relate_0(_gthis, _manager));
    }

    public void unrelate(MpnSubscriptionManager _manager) {
        LSMpnSubscription _gthis = this;
        this.lock.synchronized(new Closure_unrelate_0(_manager, _gthis));
    }

    public String toString() {
        LSMpnSubscription _gthis = this;
        return (String)this.lock.synchronized(new Closure_toString_0(_gthis));
    }

    public LSMpnSubscription(String mode, String[] items, String[] fields, Object wrapper) {
        this.eventDispatcher = new MpnSubscriptionEventDispatcher();
        long this1 = 0L;
        this.m_statusTs = this1 = 0L;
        this.m_status = MpnSubscriptionStatus.Unknown;
        this.lock = new RLock();
        this.wrapper = wrapper;
        this.mode = MpnSubscriptionMode_Impl_.fromString(mode);
        this.madeByServer = false;
        this.initItemsAndFields(items, fields);
    }

    /*
     * WARNING - void declaration
     */
    public LSMpnSubscription(LSMpnSubscription mpnSubscription, Object wrapper) {
        void var3_3;
        this.eventDispatcher = new MpnSubscriptionEventDispatcher();
        long this1 = 0L;
        this1 = 0L;
        this.m_statusTs = var3_3;
        this.m_status = MpnSubscriptionStatus.Unknown;
        this.lock = new RLock();
        this.wrapper = wrapper;
        this.mode = mpnSubscription.mode;
        this.madeByServer = false;
        this.initFromMpnSubscription(mpnSubscription);
    }

    /*
     * WARNING - void declaration
     */
    public LSMpnSubscription(LSSubscription subscription, Object wrapper) {
        void var3_3;
        this.eventDispatcher = new MpnSubscriptionEventDispatcher();
        long this1 = 0L;
        this1 = 0L;
        this.m_statusTs = var3_3;
        this.m_status = MpnSubscriptionStatus.Unknown;
        this.lock = new RLock();
        this.wrapper = wrapper;
        this.mode = MpnSubscriptionMode_Impl_.fromString(subscription.getMode());
        this.madeByServer = false;
        this.initFromSubscription(subscription);
    }

    public LSMpnSubscription(String mode, String item, String[] fields, Object wrapper) {
        this.eventDispatcher = new MpnSubscriptionEventDispatcher();
        long this1 = 0L;
        this.m_statusTs = this1 = 0L;
        this.m_status = MpnSubscriptionStatus.Unknown;
        this.lock = new RLock();
        this.wrapper = wrapper;
        this.mode = MpnSubscriptionMode_Impl_.fromString(mode);
        this.madeByServer = false;
        Array<String> a = Array.ofNative(new String[]{item});
        String[] ret = new String[a.length];
        int _g = 0;
        int _g1 = a.length;
        while (_g < _g1) {
            int i = _g++;
            ret[i] = a.__get(i);
        }
        this.initItemsAndFields(ret, fields);
    }

    /*
     * WARNING - void declaration
     */
    public LSMpnSubscription(String mode, Object wrapper) {
        void var3_3;
        this.eventDispatcher = new MpnSubscriptionEventDispatcher();
        long this1 = 0L;
        this1 = 0L;
        this.m_statusTs = var3_3;
        this.m_status = MpnSubscriptionStatus.Unknown;
        this.lock = new RLock();
        this.wrapper = wrapper;
        this.mode = MpnSubscriptionMode_Impl_.fromString(mode);
        this.madeByServer = false;
    }

    public /* synthetic */ LSMpnSubscription(EmptyConstructor _) {
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_fetch_mpnSubId_0
    extends Function
    implements FormatSchema,
    Named,
    PrivilegedAction<String>,
    ProtocolFamily,
    WatchEvent.Modifier,
    AttributeView,
    PrivilegedExceptionAction<String>,
    Callable<String>,
    Supplier<String>,
    Function0<String> {
        public final LSMpnSubscription _gthis;

        public Closure_fetch_mpnSubId_0(LSMpnSubscription _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public String invoke() {
            return this._gthis.m_mpnSubId;
        }

        @Override
        public String get() {
            return this.invoke();
        }

        @Override
        public String call() {
            return this.invoke();
        }

        @Override
        public String run() {
            return this.invoke();
        }

        @Override
        public String name() {
            return this.invoke();
        }

        public String getName() {
            return this.invoke();
        }

        public String getSchemaType() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_fetch_requestedBufferSize_0
    extends Function
    implements PrivilegedAction<RequestedBufferSize>,
    PrivilegedExceptionAction<RequestedBufferSize>,
    Callable<RequestedBufferSize>,
    Supplier<RequestedBufferSize>,
    Function0<RequestedBufferSize> {
        public final LSMpnSubscription _gthis;

        public Closure_fetch_requestedBufferSize_0(LSMpnSubscription _gthis) {
            this._gthis = _gthis;
        }

        public RequestedBufferSize invoke() {
            return this._gthis.bufferSize;
        }

        @Override
        public RequestedBufferSize get() {
            return this.invoke();
        }

        @Override
        public RequestedBufferSize call() {
            return this.invoke();
        }

        @Override
        public RequestedBufferSize run() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_changeGroup_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final String _group;
        public final LSMpnSubscription _gthis;

        /*
         * WARNING - void declaration
         */
        public Closure_changeGroup_0(String _group, LSMpnSubscription lSMpnSubscription) {
            void _gthis;
            this._group = _group;
            this._gthis = _gthis;
        }

        @Override
        public void invoke() {
            if (this._group == null) {
                return;
            }
            if (Jvm.stringCompare(this._gthis.group, this._group) != 0) {
                this._gthis.group = this._group;
                this._gthis.items = null;
                this._gthis.fireOnPropertyChange("group");
            }
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_fetch_requestedFormat_0
    extends Function
    implements FormatSchema,
    Named,
    PrivilegedAction<String>,
    ProtocolFamily,
    WatchEvent.Modifier,
    AttributeView,
    PrivilegedExceptionAction<String>,
    Callable<String>,
    Supplier<String>,
    Function0<String> {
        public final LSMpnSubscription _gthis;

        public Closure_fetch_requestedFormat_0(LSMpnSubscription _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public String invoke() {
            return this._gthis.requestedFormat;
        }

        @Override
        public String get() {
            return this.invoke();
        }

        @Override
        public String call() {
            return this.invoke();
        }

        @Override
        public String run() {
            return this.invoke();
        }

        @Override
        public String name() {
            return this.invoke();
        }

        public String getName() {
            return this.invoke();
        }

        public String getSchemaType() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_getTriggerExpression_0
    extends Function
    implements FormatSchema,
    Named,
    PrivilegedAction<String>,
    ProtocolFamily,
    WatchEvent.Modifier,
    AttributeView,
    PrivilegedExceptionAction<String>,
    Callable<String>,
    Supplier<String>,
    Function0<String> {
        public final LSMpnSubscription _gthis;

        public Closure_getTriggerExpression_0(LSMpnSubscription _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public String invoke() {
            return this._gthis.requestedTrigger;
        }

        @Override
        public String get() {
            return this.invoke();
        }

        @Override
        public String call() {
            return this.invoke();
        }

        @Override
        public String run() {
            return this.invoke();
        }

        @Override
        public String name() {
            return this.invoke();
        }

        public String getName() {
            return this.invoke();
        }

        public String getSchemaType() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_getFields_0
    extends Function
    implements JsonIncludeProperties,
    PrivilegedAction<String[]>,
    PrivilegedExceptionAction<String[]>,
    Callable<String[]>,
    Supplier<String[]>,
    EnumReflectionInformation,
    EnumValueReflectionInformation,
    Function0<String[]> {
        public final LSMpnSubscription _gthis;

        public Closure_getFields_0(LSMpnSubscription _gthis) {
            this._gthis = _gthis;
        }

        public String[] invoke() {
            if (this._gthis.fields == null) {
                return null;
            }
            Array<String> a = this._gthis.fields;
            String[] ret = new String[a.length];
            int _g = 0;
            int _g1 = a.length;
            while (_g < _g1) {
                int i = _g++;
                ret[i] = a.__get(i);
            }
            return ret;
        }

        @Override
        public String[] argumentNames() {
            return this.invoke();
        }

        @Override
        public String[] constructorNames() {
            return this.invoke();
        }

        @Override
        public String[] get() {
            return this.invoke();
        }

        @Override
        public String[] call() {
            return this.invoke();
        }

        @Override
        public String[] run() {
            return this.invoke();
        }

        public String[] value() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_getItems_0
    extends Function
    implements JsonIncludeProperties,
    PrivilegedAction<String[]>,
    PrivilegedExceptionAction<String[]>,
    Callable<String[]>,
    Supplier<String[]>,
    EnumReflectionInformation,
    EnumValueReflectionInformation,
    Function0<String[]> {
        public final LSMpnSubscription _gthis;

        public Closure_getItems_0(LSMpnSubscription _gthis) {
            this._gthis = _gthis;
        }

        public String[] invoke() {
            if (this._gthis.items == null) {
                return null;
            }
            Array<String> a = this._gthis.items;
            String[] ret = new String[a.length];
            int _g = 0;
            int _g1 = a.length;
            while (_g < _g1) {
                int i = _g++;
                ret[i] = a.__get(i);
            }
            return ret;
        }

        @Override
        public String[] argumentNames() {
            return this.invoke();
        }

        @Override
        public String[] constructorNames() {
            return this.invoke();
        }

        @Override
        public String[] get() {
            return this.invoke();
        }

        @Override
        public String[] call() {
            return this.invoke();
        }

        @Override
        public String[] run() {
            return this.invoke();
        }

        public String[] value() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_fireOnUnsubscriptionError_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final LSMpnSubscription _gthis;
        public final int code;
        public final String msg;

        /*
         * WARNING - void declaration
         */
        public Closure_fireOnUnsubscriptionError_0(LSMpnSubscription _gthis, int n, String string) {
            void msg;
            void code;
            this._gthis = _gthis;
            this.code = code;
            this.msg = msg;
        }

        @Override
        public void invoke() {
            if (LoggerTools_Fields_.mpnSubscriptionLogger.isWarnEnabled()) {
                LoggerTools_Fields_.mpnSubscriptionLogger.warn("" + (this._gthis.madeByServer ? "Server " : "") + "MPNSubscription unsubscription error: " + this.code + " - " + this.msg + " pnSubId: " + this._gthis.m_mpnSubId, null);
            }
            this._gthis.eventDispatcher.onUnsubscriptionError(this.code, this.msg);
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_changeTrigger_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final String _trigger;
        public final LSMpnSubscription _gthis;

        /*
         * WARNING - void declaration
         */
        public Closure_changeTrigger_0(String _trigger, LSMpnSubscription lSMpnSubscription) {
            void _gthis;
            this._trigger = _trigger;
            this._gthis = _gthis;
        }

        @Override
        public void invoke() {
            if (Jvm.stringCompare(this._trigger, this._gthis.realTrigger) != 0) {
                this._gthis.realTrigger = this._trigger != null ? this._trigger : null;
                this._gthis.fireOnPropertyChange("trigger");
            }
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_unrelate_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final MpnSubscriptionManager _manager;
        public final LSMpnSubscription _gthis;

        /*
         * WARNING - void declaration
         */
        public Closure_unrelate_0(MpnSubscriptionManager _manager, LSMpnSubscription lSMpnSubscription) {
            void _gthis;
            this._manager = _manager;
            this._gthis = _gthis;
        }

        @Override
        public void invoke() {
            if (this._manager != this._gthis.m_manager) {
                return;
            }
            this._gthis.m_manager = null;
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_setItemGroup_0
    extends Function
    implements PrivilegedAction<Array<String>>,
    PrivilegedExceptionAction<Array<String>>,
    Callable<Array<String>>,
    Supplier<Array<String>>,
    Function0<Array<String>> {
        public final LSMpnSubscription _gthis;
        public final String group;

        /*
         * WARNING - void declaration
         */
        public Closure_setItemGroup_0(LSMpnSubscription _gthis, String string) {
            void group;
            this._gthis = _gthis;
            this.group = group;
        }

        @Override
        public Array invoke() {
            this._gthis.checkActive();
            this._gthis.group = Name_Impl_.fromString(this.group);
            this._gthis.items = null;
            return null;
        }

        @Override
        public Array get() {
            return this.invoke();
        }

        @Override
        public Array call() {
            return this.invoke();
        }

        @Override
        public Array run() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_fetch_status_0
    extends Function
    implements PrivilegedAction<MpnSubscriptionStatus>,
    PrivilegedExceptionAction<MpnSubscriptionStatus>,
    Callable<MpnSubscriptionStatus>,
    Supplier<MpnSubscriptionStatus>,
    Function0<MpnSubscriptionStatus> {
        public final LSMpnSubscription _gthis;

        public Closure_fetch_status_0(LSMpnSubscription _gthis) {
            this._gthis = _gthis;
        }

        public MpnSubscriptionStatus invoke() {
            return this._gthis.m_status;
        }

        @Override
        public MpnSubscriptionStatus get() {
            return this.invoke();
        }

        @Override
        public MpnSubscriptionStatus call() {
            return this.invoke();
        }

        @Override
        public MpnSubscriptionStatus run() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_fireOnModificationError_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final LSMpnSubscription _gthis;
        public final String property;
        public final int code;
        public final String message;

        /*
         * WARNING - void declaration
         */
        public Closure_fireOnModificationError_0(LSMpnSubscription _gthis, String string, int n, String string2) {
            void message;
            void code;
            void property;
            this._gthis = _gthis;
            this.property = property;
            this.code = code;
            this.message = message;
        }

        @Override
        public void invoke() {
            if (LoggerTools_Fields_.mpnSubscriptionLogger.isWarnEnabled()) {
                LoggerTools_Fields_.mpnSubscriptionLogger.warn("" + (this._gthis.madeByServer ? "Server " : "") + "MPNSubscription " + this.property + " modification error: " + this.code + " - " + this.message + " pnSubId: " + this._gthis.m_mpnSubId, null);
            }
            this._gthis.eventDispatcher.onModificationError(this.code, this.message, this.property);
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_setNotificationFormat_0
    extends Function
    implements PrivilegedAction<MpnSubscriptionManager>,
    PrivilegedExceptionAction<MpnSubscriptionManager>,
    Callable<MpnSubscriptionManager>,
    Supplier<MpnSubscriptionManager>,
    Function0<MpnSubscriptionManager> {
        public final LSMpnSubscription _gthis;
        public final String format;
        public final MpnSubscriptionManager[] _manager;

        /*
         * WARNING - void declaration
         */
        public Closure_setNotificationFormat_0(LSMpnSubscription _gthis, String string, MpnSubscriptionManager[] mpnSubscriptionManagerArray) {
            void _manager;
            void format;
            this._gthis = _gthis;
            this.format = format;
            this._manager = _manager;
        }

        @Override
        public MpnSubscriptionManager invoke() {
            this._gthis.requestedFormat = this.format == null ? null : this.format;
            this._manager[0] = this._gthis.m_manager;
            return this._manager[0];
        }

        @Override
        public MpnSubscriptionManager get() {
            return this.invoke();
        }

        @Override
        public MpnSubscriptionManager call() {
            return this.invoke();
        }

        @Override
        public MpnSubscriptionManager run() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_isTriggered_0
    extends Function
    implements MessageQueue.IdleHandler,
    PrivilegedAction<Boolean>,
    PrivilegedExceptionAction<Boolean>,
    Callable<Boolean>,
    Supplier<Boolean>,
    ClassReflectionInformation,
    Function0<Boolean> {
        public final LSMpnSubscription _gthis;

        public Closure_isTriggered_0(LSMpnSubscription _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public boolean invoke() {
            return this._gthis.m_status == MpnSubscriptionStatus.Triggered;
        }

        @Override
        public boolean hasSuperClass() {
            return this.invoke();
        }

        @Override
        public boolean get() {
            return this.invoke();
        }

        @Override
        public boolean call() {
            return this.invoke();
        }

        @Override
        public boolean run() {
            return this.invoke();
        }

        public boolean queueIdle() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_getSubscriptionId_0
    extends Function
    implements FormatSchema,
    Named,
    PrivilegedAction<String>,
    ProtocolFamily,
    WatchEvent.Modifier,
    AttributeView,
    PrivilegedExceptionAction<String>,
    Callable<String>,
    Supplier<String>,
    Function0<String> {
        public final LSMpnSubscription _gthis;

        public Closure_getSubscriptionId_0(LSMpnSubscription _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public String invoke() {
            return this._gthis.m_mpnSubId;
        }

        @Override
        public String get() {
            return this.invoke();
        }

        @Override
        public String call() {
            return this.invoke();
        }

        @Override
        public String run() {
            return this.invoke();
        }

        @Override
        public String name() {
            return this.invoke();
        }

        public String getName() {
            return this.invoke();
        }

        public String getSchemaType() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_changeSchema_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final String _schema;
        public final LSMpnSubscription _gthis;

        /*
         * WARNING - void declaration
         */
        public Closure_changeSchema_0(String _schema, LSMpnSubscription lSMpnSubscription) {
            void _gthis;
            this._schema = _schema;
            this._gthis = _gthis;
        }

        @Override
        public void invoke() {
            if (this._schema == null) {
                return;
            }
            if (Jvm.stringCompare(this._gthis.schema, this._schema) != 0) {
                this._gthis.schema = this._schema;
                this._gthis.fields = null;
                this._gthis.fireOnPropertyChange("schema");
            }
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_changeAdapter_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final LSMpnSubscription _gthis;
        public final String _adapter;

        /*
         * WARNING - void declaration
         */
        public Closure_changeAdapter_0(LSMpnSubscription _gthis, String string) {
            void _adapter;
            this._gthis = _gthis;
            this._adapter = _adapter;
        }

        @Override
        public void invoke() {
            if (Jvm.stringCompare(this._gthis.dataAdapter, this._adapter) != 0) {
                this._gthis.dataAdapter = this._adapter != null ? this._adapter : null;
                this._gthis.fireOnPropertyChange("adapter");
            }
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_fetch_requestedMaxFrequency_0
    extends Function
    implements PrivilegedAction<MpnRequestedMaxFrequency>,
    PrivilegedExceptionAction<MpnRequestedMaxFrequency>,
    Callable<MpnRequestedMaxFrequency>,
    Supplier<MpnRequestedMaxFrequency>,
    Function0<MpnRequestedMaxFrequency> {
        public final LSMpnSubscription _gthis;

        public Closure_fetch_requestedMaxFrequency_0(LSMpnSubscription _gthis) {
            this._gthis = _gthis;
        }

        public MpnRequestedMaxFrequency invoke() {
            return this._gthis.requestedMaxFrequency;
        }

        @Override
        public MpnRequestedMaxFrequency get() {
            return this.invoke();
        }

        @Override
        public MpnRequestedMaxFrequency call() {
            return this.invoke();
        }

        @Override
        public MpnRequestedMaxFrequency run() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_changeStatusTs_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final String rawStatusTs;
        public final LSMpnSubscription _gthis;

        /*
         * WARNING - void declaration
         */
        public Closure_changeStatusTs_0(String rawStatusTs, LSMpnSubscription lSMpnSubscription) {
            void _gthis;
            this.rawStatusTs = rawStatusTs;
            this._gthis = _gthis;
        }

        @Override
        public void invoke() {
            if (this.rawStatusTs == null) {
                return;
            }
            long statusTs = ParseTools_Fields_.parseLong(this.rawStatusTs);
            if (statusTs != this._gthis.m_statusTs) {
                this._gthis.m_statusTs = statusTs;
                this._gthis.fireOnPropertyChange("status_timestamp");
            }
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_changeMode_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final String rawMode;
        public final LSMpnSubscription _gthis;

        /*
         * WARNING - void declaration
         */
        public Closure_changeMode_0(String rawMode, LSMpnSubscription lSMpnSubscription) {
            void _gthis;
            this.rawMode = rawMode;
            this._gthis = _gthis;
        }

        @Override
        public void invoke() {
            if (this.rawMode == null) {
                return;
            }
            String _mode = MpnSubscriptionMode_Impl_.fromString(this.rawMode);
            if (Jvm.stringCompare(this._gthis.mode, _mode) != 0) {
                this._gthis.mode = _mode;
                this._gthis.fireOnPropertyChange("mode");
            }
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_getActualNotificationFormat_0
    extends Function
    implements FormatSchema,
    Named,
    PrivilegedAction<String>,
    ProtocolFamily,
    WatchEvent.Modifier,
    AttributeView,
    PrivilegedExceptionAction<String>,
    Callable<String>,
    Supplier<String>,
    Function0<String> {
        public final LSMpnSubscription _gthis;

        public Closure_getActualNotificationFormat_0(LSMpnSubscription _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public String invoke() {
            return this._gthis.realFormat;
        }

        @Override
        public String get() {
            return this.invoke();
        }

        @Override
        public String call() {
            return this.invoke();
        }

        @Override
        public String run() {
            return this.invoke();
        }

        @Override
        public String name() {
            return this.invoke();
        }

        public String getName() {
            return this.invoke();
        }

        public String getSchemaType() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_getFieldSchema_0
    extends Function
    implements FormatSchema,
    Named,
    PrivilegedAction<String>,
    ProtocolFamily,
    WatchEvent.Modifier,
    AttributeView,
    PrivilegedExceptionAction<String>,
    Callable<String>,
    Supplier<String>,
    Function0<String> {
        public final LSMpnSubscription _gthis;

        public Closure_getFieldSchema_0(LSMpnSubscription _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public String invoke() {
            return this._gthis.schema;
        }

        @Override
        public String get() {
            return this.invoke();
        }

        @Override
        public String call() {
            return this.invoke();
        }

        @Override
        public String run() {
            return this.invoke();
        }

        @Override
        public String name() {
            return this.invoke();
        }

        public String getName() {
            return this.invoke();
        }

        public String getSchemaType() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_getStatusTimestamp_0
    extends Function
    implements PrivilegedAction<Long>,
    PrivilegedExceptionAction<Long>,
    PrimitiveIterator.OfLong,
    Callable<Long>,
    LongSupplier,
    Supplier<Long>,
    Function0<Long> {
        public final LSMpnSubscription _gthis;

        public Closure_getStatusTimestamp_0(LSMpnSubscription _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public long invoke() {
            return this._gthis.m_statusTs;
        }

        @Override
        public long get() {
            return this.invoke();
        }

        @Override
        public long getAsLong() {
            return this.invoke();
        }

        @Override
        public long call() {
            return this.invoke();
        }

        @Override
        public long nextLong() {
            return this.invoke();
        }

        @Override
        public long run() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_changeStatus_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final String statusTs;
        public final LSMpnSubscription _gthis;
        public final MpnSubscriptionStatus status;

        /*
         * WARNING - void declaration
         */
        public Closure_changeStatus_0(String statusTs, LSMpnSubscription lSMpnSubscription, MpnSubscriptionStatus mpnSubscriptionStatus) {
            void status;
            void _gthis;
            this.statusTs = statusTs;
            this._gthis = _gthis;
            this.status = status;
        }

        @Override
        public void invoke() {
            long statusTs;
            long l = statusTs = this.statusTs == null ? this._gthis.m_statusTs : ParseTools_Fields_.parseLong(this.statusTs);
            if (this.status != this._gthis.m_status) {
                this._gthis.m_status = this.status;
                this._gthis.eventDispatcher.onStatusChanged(this._gthis.getStatus(), statusTs);
            }
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_fireOnSubscription_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final LSMpnSubscription _gthis;

        public Closure_fireOnSubscription_0(LSMpnSubscription _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public void invoke() {
            if (LoggerTools_Fields_.mpnSubscriptionLogger.isInfoEnabled()) {
                LoggerTools_Fields_.mpnSubscriptionLogger.info("" + (this._gthis.madeByServer ? "Server " : "") + "MPNSubscription subscribed: pnSubId: " + this._gthis.m_mpnSubId, null);
            }
            this._gthis.eventDispatcher.onSubscription();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_fireOnUnsubscription_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final LSMpnSubscription _gthis;

        public Closure_fireOnUnsubscription_0(LSMpnSubscription _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public void invoke() {
            if (LoggerTools_Fields_.mpnSubscriptionLogger.isInfoEnabled()) {
                LoggerTools_Fields_.mpnSubscriptionLogger.info("" + (this._gthis.madeByServer ? "Server " : "") + "MPNSubscription unsubscribed: pnSubId: " + this._gthis.m_mpnSubId, null);
            }
            this._gthis.eventDispatcher.onUnsubscription();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_isSubscribed_0
    extends Function
    implements MessageQueue.IdleHandler,
    PrivilegedAction<Boolean>,
    PrivilegedExceptionAction<Boolean>,
    Callable<Boolean>,
    Supplier<Boolean>,
    ClassReflectionInformation,
    Function0<Boolean> {
        public final LSMpnSubscription _gthis;

        public Closure_isSubscribed_0(LSMpnSubscription _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public boolean invoke() {
            return this._gthis.m_status == MpnSubscriptionStatus.Subscribed;
        }

        @Override
        public boolean hasSuperClass() {
            return this.invoke();
        }

        @Override
        public boolean get() {
            return this.invoke();
        }

        @Override
        public boolean call() {
            return this.invoke();
        }

        @Override
        public boolean run() {
            return this.invoke();
        }

        public boolean queueIdle() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_changeFormat_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final String _format;
        public final LSMpnSubscription _gthis;

        /*
         * WARNING - void declaration
         */
        public Closure_changeFormat_0(String _format, LSMpnSubscription lSMpnSubscription) {
            void _gthis;
            this._format = _format;
            this._gthis = _gthis;
        }

        @Override
        public void invoke() {
            if (this._format == null) {
                return;
            }
            if (Jvm.stringCompare(this._format, this._gthis.realFormat) != 0) {
                this._gthis.realFormat = this._format;
                this._gthis.fireOnPropertyChange("notification_format");
            }
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_fetch_madeByServer_0
    extends Function
    implements MessageQueue.IdleHandler,
    PrivilegedAction<Boolean>,
    PrivilegedExceptionAction<Boolean>,
    Callable<Boolean>,
    Supplier<Boolean>,
    ClassReflectionInformation,
    Function0<Boolean> {
        public final LSMpnSubscription _gthis;

        public Closure_fetch_madeByServer_0(LSMpnSubscription _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public boolean invoke() {
            return this._gthis.madeByServer;
        }

        @Override
        public boolean hasSuperClass() {
            return this.invoke();
        }

        @Override
        public boolean get() {
            return this.invoke();
        }

        @Override
        public boolean call() {
            return this.invoke();
        }

        @Override
        public boolean run() {
            return this.invoke();
        }

        public boolean queueIdle() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_changeBufferSize_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final String rawBufferSize;
        public final LSMpnSubscription _gthis;

        /*
         * WARNING - void declaration
         */
        public Closure_changeBufferSize_0(String rawBufferSize, LSMpnSubscription lSMpnSubscription) {
            void _gthis;
            this.rawBufferSize = rawBufferSize;
            this._gthis = _gthis;
        }

        @Override
        public void invoke() {
            RequestedBufferSize _bufferSize = RequestedBufferSizeTools.fromString(this.rawBufferSize);
            if (!RequestedBufferSizeTools.extEquals(this._gthis.bufferSize, _bufferSize)) {
                this._gthis.bufferSize = _bufferSize;
                this._gthis.fireOnPropertyChange("requested_buffer_size");
            }
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_fireOnTriggered_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final LSMpnSubscription _gthis;

        public Closure_fireOnTriggered_0(LSMpnSubscription _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public void invoke() {
            if (LoggerTools_Fields_.mpnSubscriptionLogger.isInfoEnabled()) {
                LoggerTools_Fields_.mpnSubscriptionLogger.info("" + (this._gthis.madeByServer ? "Server " : "") + "MPNSubscription triggered: pnSubId: " + this._gthis.m_mpnSubId, null);
            }
            this._gthis.eventDispatcher.onTriggered();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_relate_0
    extends Function
    implements PrivilegedAction<MpnSubscriptionManager>,
    PrivilegedExceptionAction<MpnSubscriptionManager>,
    Callable<MpnSubscriptionManager>,
    Supplier<MpnSubscriptionManager>,
    Function0<MpnSubscriptionManager> {
        public final LSMpnSubscription _gthis;
        public final MpnSubscriptionManager _manager;

        /*
         * WARNING - void declaration
         */
        public Closure_relate_0(LSMpnSubscription _gthis, MpnSubscriptionManager mpnSubscriptionManager) {
            void _manager;
            this._gthis = _gthis;
            this._manager = _manager;
        }

        @Override
        public MpnSubscriptionManager invoke() {
            this._gthis.m_manager = this._manager;
            return this._gthis.m_manager;
        }

        @Override
        public MpnSubscriptionManager get() {
            return this.invoke();
        }

        @Override
        public MpnSubscriptionManager call() {
            return this.invoke();
        }

        @Override
        public MpnSubscriptionManager run() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_getDataAdapter_0
    extends Function
    implements FormatSchema,
    Named,
    PrivilegedAction<String>,
    ProtocolFamily,
    WatchEvent.Modifier,
    AttributeView,
    PrivilegedExceptionAction<String>,
    Callable<String>,
    Supplier<String>,
    Function0<String> {
        public final LSMpnSubscription _gthis;

        public Closure_getDataAdapter_0(LSMpnSubscription _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public String invoke() {
            return this._gthis.dataAdapter;
        }

        @Override
        public String get() {
            return this.invoke();
        }

        @Override
        public String call() {
            return this.invoke();
        }

        @Override
        public String run() {
            return this.invoke();
        }

        @Override
        public String name() {
            return this.invoke();
        }

        public String getName() {
            return this.invoke();
        }

        public String getSchemaType() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_fetch_mode_0
    extends Function
    implements FormatSchema,
    Named,
    PrivilegedAction<String>,
    ProtocolFamily,
    WatchEvent.Modifier,
    AttributeView,
    PrivilegedExceptionAction<String>,
    Callable<String>,
    Supplier<String>,
    Function0<String> {
        public final LSMpnSubscription _gthis;

        public Closure_fetch_mode_0(LSMpnSubscription _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public String invoke() {
            return this._gthis.mode;
        }

        @Override
        public String get() {
            return this.invoke();
        }

        @Override
        public String call() {
            return this.invoke();
        }

        @Override
        public String run() {
            return this.invoke();
        }

        @Override
        public String name() {
            return this.invoke();
        }

        public String getName() {
            return this.invoke();
        }

        public String getSchemaType() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_toString_0
    extends Function
    implements FormatSchema,
    Named,
    PrivilegedAction<String>,
    ProtocolFamily,
    WatchEvent.Modifier,
    AttributeView,
    PrivilegedExceptionAction<String>,
    Callable<String>,
    Supplier<String>,
    Function0<String> {
        public final LSMpnSubscription _gthis;

        public Closure_toString_0(LSMpnSubscription _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public String invoke() {
            StringMap map = InfoMap.InfoMap_Impl_._new();
            InfoMap.InfoMap_Impl_.set(map, "mode", this._gthis.mode);
            InfoMap.InfoMap_Impl_.set(map, "items", this._gthis.items != null ? Std.string(this._gthis.items) : this._gthis.group);
            InfoMap.InfoMap_Impl_.set(map, "fields", this._gthis.fields != null ? Std.string(this._gthis.fields) : this._gthis.schema);
            InfoMap.InfoMap_Impl_.set(map, "dataAdapter", this._gthis.dataAdapter);
            InfoMap.InfoMap_Impl_.set(map, "requestedBufferSize", (Object)this._gthis.bufferSize);
            InfoMap.InfoMap_Impl_.set(map, "requestedMaxFrequency", (Object)this._gthis.requestedMaxFrequency);
            InfoMap.InfoMap_Impl_.set(map, "trigger", this._gthis.requestedTrigger);
            InfoMap.InfoMap_Impl_.set(map, "notificationFormat", this._gthis.requestedFormat);
            return map.toString();
        }

        @Override
        public String get() {
            return this.invoke();
        }

        @Override
        public String call() {
            return this.invoke();
        }

        @Override
        public String run() {
            return this.invoke();
        }

        @Override
        public String name() {
            return this.invoke();
        }

        public String getName() {
            return this.invoke();
        }

        public String getSchemaType() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_setFields_0
    extends Function
    implements FormatSchema,
    Named,
    PrivilegedAction<String>,
    ProtocolFamily,
    WatchEvent.Modifier,
    AttributeView,
    PrivilegedExceptionAction<String>,
    Callable<String>,
    Supplier<String>,
    Function0<String> {
        public final LSMpnSubscription _gthis;
        public final String[] fields;

        /*
         * WARNING - void declaration
         */
        public Closure_setFields_0(LSMpnSubscription _gthis, String[] stringArray) {
            void fields;
            this._gthis = _gthis;
            this.fields = fields;
        }

        @Override
        public String invoke() {
            this._gthis.checkActive();
            Array tmp = this.fields == null ? null : NativeArray_Impl_.toHaxe(this.fields);
            this._gthis.fields = Fields_Impl_.fromArray(tmp);
            this._gthis.schema = null;
            return null;
        }

        @Override
        public String get() {
            return this.invoke();
        }

        @Override
        public String call() {
            return this.invoke();
        }

        @Override
        public String run() {
            return this.invoke();
        }

        @Override
        public String name() {
            return this.invoke();
        }

        public String getName() {
            return this.invoke();
        }

        public String getSchemaType() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_fireOnPropertyChange_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final String property;
        public final LSMpnSubscription _gthis;

        /*
         * WARNING - void declaration
         */
        public Closure_fireOnPropertyChange_0(String property, LSMpnSubscription lSMpnSubscription) {
            void _gthis;
            this.property = property;
            this._gthis = _gthis;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void invoke() {
            block12: {
                String propVal;
                block14: {
                    block13: {
                        if (!LoggerTools_Fields_.mpnSubscriptionLogger.isInfoEnabled()) break block12;
                        propVal = null;
                        String _hx_tmp = this.property;
                        if (_hx_tmp == null) break block13;
                        switch (_hx_tmp.hashCode()) {
                            case -1059891784: {
                                if (!_hx_tmp.equals("trigger")) break;
                                propVal = "newValue: " + this._gthis.realTrigger;
                                break block14;
                            }
                            case -976081655: {
                                if (!_hx_tmp.equals("status_timestamp")) break;
                                propVal = "";
                                break block14;
                            }
                            case -907987551: {
                                if (!_hx_tmp.equals("schema")) break;
                                propVal = "newValue: " + this._gthis.schema;
                                break block14;
                            }
                            case 1476364592: {
                                if (!_hx_tmp.equals("requested_max_frequency")) break;
                                propVal = "newValue: " + MpnRequestedMaxFrequencyTools.toString(this._gthis.requestedMaxFrequency);
                                break block14;
                            }
                            case 1649601871: {
                                if (!_hx_tmp.equals("requested_buffer_size")) break;
                                propVal = "newValue: " + RequestedBufferSizeTools.toString(this._gthis.bufferSize);
                                break block14;
                            }
                            case 815832523: {
                                if (!_hx_tmp.equals("notification_format")) break;
                                propVal = "newValue: " + this._gthis.realFormat;
                                break block14;
                            }
                            case 0x3339A3: {
                                if (!_hx_tmp.equals("mode")) break;
                                propVal = "newValue: " + this._gthis.mode;
                                break block14;
                            }
                            case 98629247: {
                                if (!_hx_tmp.equals("group")) break;
                                propVal = "newValue: " + this._gthis.group;
                                break block14;
                            }
                            case -1150508209: {
                                if (!_hx_tmp.equals("adapter")) break;
                                propVal = "newValue: " + this._gthis.dataAdapter;
                                break block14;
                            }
                        }
                    }
                    propVal = "";
                }
                if (Jvm.stringCompare(this.property, "status_timestamp") != 0 && LoggerTools_Fields_.mpnSubscriptionLogger.isInfoEnabled()) {
                    LoggerTools_Fields_.mpnSubscriptionLogger.info("" + (this._gthis.madeByServer ? "Server " : "") + "MPNSubscription " + this.property + " changed: " + propVal + " pnSubId: " + (this._gthis.m_mpnSubId != null ? this._gthis.m_mpnSubId : "n.a."), null);
                }
            }
            this._gthis.eventDispatcher.onPropertyChanged(this.property);
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_getNotificationFormat_0
    extends Function
    implements FormatSchema,
    Named,
    PrivilegedAction<String>,
    ProtocolFamily,
    WatchEvent.Modifier,
    AttributeView,
    PrivilegedExceptionAction<String>,
    Callable<String>,
    Supplier<String>,
    Function0<String> {
        public final LSMpnSubscription _gthis;

        public Closure_getNotificationFormat_0(LSMpnSubscription _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public String invoke() {
            return this._gthis.requestedFormat;
        }

        @Override
        public String get() {
            return this.invoke();
        }

        @Override
        public String call() {
            return this.invoke();
        }

        @Override
        public String run() {
            return this.invoke();
        }

        @Override
        public String name() {
            return this.invoke();
        }

        public String getName() {
            return this.invoke();
        }

        public String getSchemaType() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_changeMaxFrequency_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final String rawFrequency;
        public final LSMpnSubscription _gthis;

        /*
         * WARNING - void declaration
         */
        public Closure_changeMaxFrequency_0(String rawFrequency, LSMpnSubscription lSMpnSubscription) {
            void _gthis;
            this.rawFrequency = rawFrequency;
            this._gthis = _gthis;
        }

        @Override
        public void invoke() {
            MpnRequestedMaxFrequency maxFreq = MpnRequestedMaxFrequencyTools.fromString(this.rawFrequency);
            if (!MpnRequestedMaxFrequencyTools.extEquals(maxFreq, this._gthis.requestedMaxFrequency)) {
                this._gthis.requestedMaxFrequency = maxFreq;
                this._gthis.fireOnPropertyChange("requested_max_frequency");
            }
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_reset_0
    extends Function
    implements FormatSchema,
    Named,
    PrivilegedAction<String>,
    ProtocolFamily,
    WatchEvent.Modifier,
    AttributeView,
    PrivilegedExceptionAction<String>,
    Callable<String>,
    Supplier<String>,
    Function0<String> {
        public final LSMpnSubscription _gthis;

        public Closure_reset_0(LSMpnSubscription _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public String invoke() {
            this._gthis.realFormat = null;
            this._gthis.realTrigger = null;
            this._gthis.m_statusTs = 0L;
            this._gthis.m_mpnSubId = null;
            return null;
        }

        @Override
        public String get() {
            return this.invoke();
        }

        @Override
        public String call() {
            return this.invoke();
        }

        @Override
        public String run() {
            return this.invoke();
        }

        @Override
        public String name() {
            return this.invoke();
        }

        public String getName() {
            return this.invoke();
        }

        public String getSchemaType() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_getMode_0
    extends Function
    implements FormatSchema,
    Named,
    PrivilegedAction<String>,
    ProtocolFamily,
    WatchEvent.Modifier,
    AttributeView,
    PrivilegedExceptionAction<String>,
    Callable<String>,
    Supplier<String>,
    Function0<String> {
        public final LSMpnSubscription _gthis;

        public Closure_getMode_0(LSMpnSubscription _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public String invoke() {
            return this._gthis.mode;
        }

        @Override
        public String get() {
            return this.invoke();
        }

        @Override
        public String call() {
            return this.invoke();
        }

        @Override
        public String run() {
            return this.invoke();
        }

        @Override
        public String name() {
            return this.invoke();
        }

        public String getName() {
            return this.invoke();
        }

        public String getSchemaType() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_getRequestedBufferSize_0
    extends Function
    implements FormatSchema,
    Named,
    PrivilegedAction<String>,
    ProtocolFamily,
    WatchEvent.Modifier,
    AttributeView,
    PrivilegedExceptionAction<String>,
    Callable<String>,
    Supplier<String>,
    Function0<String> {
        public final LSMpnSubscription _gthis;

        public Closure_getRequestedBufferSize_0(LSMpnSubscription _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public String invoke() {
            return RequestedBufferSizeTools.toString(this._gthis.bufferSize);
        }

        @Override
        public String get() {
            return this.invoke();
        }

        @Override
        public String call() {
            return this.invoke();
        }

        @Override
        public String run() {
            return this.invoke();
        }

        @Override
        public String name() {
            return this.invoke();
        }

        public String getName() {
            return this.invoke();
        }

        public String getSchemaType() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_setItems_0
    extends Function
    implements FormatSchema,
    Named,
    PrivilegedAction<String>,
    ProtocolFamily,
    WatchEvent.Modifier,
    AttributeView,
    PrivilegedExceptionAction<String>,
    Callable<String>,
    Supplier<String>,
    Function0<String> {
        public final LSMpnSubscription _gthis;
        public final String[] items;

        /*
         * WARNING - void declaration
         */
        public Closure_setItems_0(LSMpnSubscription _gthis, String[] stringArray) {
            void items;
            this._gthis = _gthis;
            this.items = items;
        }

        @Override
        public String invoke() {
            this._gthis.checkActive();
            Array tmp = this.items == null ? null : NativeArray_Impl_.toHaxe(this.items);
            this._gthis.items = Items_Impl_.fromArray(tmp);
            this._gthis.group = null;
            return null;
        }

        @Override
        public String get() {
            return this.invoke();
        }

        @Override
        public String call() {
            return this.invoke();
        }

        @Override
        public String run() {
            return this.invoke();
        }

        @Override
        public String name() {
            return this.invoke();
        }

        public String getName() {
            return this.invoke();
        }

        public String getSchemaType() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_isActive_0
    extends Function
    implements MessageQueue.IdleHandler,
    PrivilegedAction<Boolean>,
    PrivilegedExceptionAction<Boolean>,
    Callable<Boolean>,
    Supplier<Boolean>,
    ClassReflectionInformation,
    Function0<Boolean> {
        public final LSMpnSubscription _gthis;

        public Closure_isActive_0(LSMpnSubscription _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public boolean invoke() {
            return this._gthis.m_status != MpnSubscriptionStatus.Unknown;
        }

        @Override
        public boolean hasSuperClass() {
            return this.invoke();
        }

        @Override
        public boolean get() {
            return this.invoke();
        }

        @Override
        public boolean call() {
            return this.invoke();
        }

        @Override
        public boolean run() {
            return this.invoke();
        }

        public boolean queueIdle() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_setSubscriptionId_0
    extends Function
    implements FormatSchema,
    Named,
    PrivilegedAction<String>,
    ProtocolFamily,
    WatchEvent.Modifier,
    AttributeView,
    PrivilegedExceptionAction<String>,
    Callable<String>,
    Supplier<String>,
    Function0<String> {
        public final LSMpnSubscription _gthis;
        public final String mpnSubId;

        /*
         * WARNING - void declaration
         */
        public Closure_setSubscriptionId_0(LSMpnSubscription _gthis, String string) {
            void mpnSubId;
            this._gthis = _gthis;
            this.mpnSubId = mpnSubId;
        }

        @Override
        public String invoke() {
            this._gthis.m_mpnSubId = this.mpnSubId;
            return this._gthis.m_mpnSubId;
        }

        @Override
        public String get() {
            return this.invoke();
        }

        @Override
        public String call() {
            return this.invoke();
        }

        @Override
        public String run() {
            return this.invoke();
        }

        @Override
        public String name() {
            return this.invoke();
        }

        public String getName() {
            return this.invoke();
        }

        public String getSchemaType() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_setRequestedMaxFrequency_0
    extends Function
    implements PrivilegedAction<MpnRequestedMaxFrequency>,
    PrivilegedExceptionAction<MpnRequestedMaxFrequency>,
    Callable<MpnRequestedMaxFrequency>,
    Supplier<MpnRequestedMaxFrequency>,
    Function0<MpnRequestedMaxFrequency> {
        public final LSMpnSubscription _gthis;
        public final String freq;

        /*
         * WARNING - void declaration
         */
        public Closure_setRequestedMaxFrequency_0(LSMpnSubscription _gthis, String string) {
            void freq;
            this._gthis = _gthis;
            this.freq = freq;
        }

        public MpnRequestedMaxFrequency invoke() {
            this._gthis.checkActive();
            this._gthis.requestedMaxFrequency = MpnRequestedMaxFrequencyTools.fromString(this.freq);
            return this._gthis.requestedMaxFrequency;
        }

        @Override
        public MpnRequestedMaxFrequency get() {
            return this.invoke();
        }

        @Override
        public MpnRequestedMaxFrequency call() {
            return this.invoke();
        }

        @Override
        public MpnRequestedMaxFrequency run() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_fireOnSubscriptionError_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final LSMpnSubscription _gthis;
        public final int code;
        public final String msg;

        /*
         * WARNING - void declaration
         */
        public Closure_fireOnSubscriptionError_0(LSMpnSubscription _gthis, int n, String string) {
            void msg;
            void code;
            this._gthis = _gthis;
            this.code = code;
            this.msg = msg;
        }

        @Override
        public void invoke() {
            if (LoggerTools_Fields_.mpnSubscriptionLogger.isWarnEnabled()) {
                LoggerTools_Fields_.mpnSubscriptionLogger.warn("" + (this._gthis.madeByServer ? "Server " : "") + "MPNSubscription error: " + this.code + " - " + this.msg + " pnSubId: " + this._gthis.m_mpnSubId, null);
            }
            this._gthis.eventDispatcher.onSubscriptionError(this.code, this.msg);
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_addListener_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final LSMpnSubscription _gthis;
        public final MpnSubscriptionListener listener;

        /*
         * WARNING - void declaration
         */
        public Closure_addListener_0(LSMpnSubscription _gthis, MpnSubscriptionListener mpnSubscriptionListener) {
            void listener;
            this._gthis = _gthis;
            this.listener = listener;
        }

        @Override
        public void invoke() {
            this._gthis.eventDispatcher.addListenerAndFireOnListenStart(this.listener);
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_getItemGroup_0
    extends Function
    implements FormatSchema,
    Named,
    PrivilegedAction<String>,
    ProtocolFamily,
    WatchEvent.Modifier,
    AttributeView,
    PrivilegedExceptionAction<String>,
    Callable<String>,
    Supplier<String>,
    Function0<String> {
        public final LSMpnSubscription _gthis;

        public Closure_getItemGroup_0(LSMpnSubscription _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public String invoke() {
            return this._gthis.group;
        }

        @Override
        public String get() {
            return this.invoke();
        }

        @Override
        public String call() {
            return this.invoke();
        }

        @Override
        public String run() {
            return this.invoke();
        }

        @Override
        public String name() {
            return this.invoke();
        }

        public String getName() {
            return this.invoke();
        }

        public String getSchemaType() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_setRequestedBufferSize_0
    extends Function
    implements PrivilegedAction<RequestedBufferSize>,
    PrivilegedExceptionAction<RequestedBufferSize>,
    Callable<RequestedBufferSize>,
    Supplier<RequestedBufferSize>,
    Function0<RequestedBufferSize> {
        public final LSMpnSubscription _gthis;
        public final String size;

        /*
         * WARNING - void declaration
         */
        public Closure_setRequestedBufferSize_0(LSMpnSubscription _gthis, String string) {
            void size;
            this._gthis = _gthis;
            this.size = size;
        }

        public RequestedBufferSize invoke() {
            this._gthis.checkActive();
            this._gthis.bufferSize = RequestedBufferSizeTools.fromString(this.size);
            return this._gthis.bufferSize;
        }

        @Override
        public RequestedBufferSize get() {
            return this.invoke();
        }

        @Override
        public RequestedBufferSize call() {
            return this.invoke();
        }

        @Override
        public RequestedBufferSize run() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_removeListener_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final LSMpnSubscription _gthis;
        public final MpnSubscriptionListener listener;

        /*
         * WARNING - void declaration
         */
        public Closure_removeListener_0(LSMpnSubscription _gthis, MpnSubscriptionListener mpnSubscriptionListener) {
            void listener;
            this._gthis = _gthis;
            this.listener = listener;
        }

        @Override
        public void invoke() {
            this._gthis.eventDispatcher.removeListenerAndFireOnListenEnd(this.listener);
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_getRequestedMaxFrequency_0
    extends Function
    implements FormatSchema,
    Named,
    PrivilegedAction<String>,
    ProtocolFamily,
    WatchEvent.Modifier,
    AttributeView,
    PrivilegedExceptionAction<String>,
    Callable<String>,
    Supplier<String>,
    Function0<String> {
        public final LSMpnSubscription _gthis;

        public Closure_getRequestedMaxFrequency_0(LSMpnSubscription _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public String invoke() {
            return MpnRequestedMaxFrequencyTools.toString(this._gthis.requestedMaxFrequency);
        }

        @Override
        public String get() {
            return this.invoke();
        }

        @Override
        public String call() {
            return this.invoke();
        }

        @Override
        public String run() {
            return this.invoke();
        }

        @Override
        public String name() {
            return this.invoke();
        }

        public String getName() {
            return this.invoke();
        }

        public String getSchemaType() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_getStatus_0
    extends Function
    implements FormatSchema,
    Named,
    PrivilegedAction<String>,
    ProtocolFamily,
    WatchEvent.Modifier,
    AttributeView,
    PrivilegedExceptionAction<String>,
    Callable<String>,
    Supplier<String>,
    Function0<String> {
        public final LSMpnSubscription _gthis;

        public Closure_getStatus_0(LSMpnSubscription _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public String invoke() {
            switch (this._gthis.m_status.ordinal()) {
                default: {
                    throw Exception.wrap((Object)"Match failure");
                }
                case 0: {
                    return "UNKNOWN";
                }
                case 1: {
                    return "ACTIVE";
                }
                case 2: {
                    return "SUBSCRIBED";
                }
                case 3: 
            }
            return "TRIGGERED";
        }

        @Override
        public String get() {
            return this.invoke();
        }

        @Override
        public String call() {
            return this.invoke();
        }

        @Override
        public String run() {
            return this.invoke();
        }

        @Override
        public String name() {
            return this.invoke();
        }

        public String getName() {
            return this.invoke();
        }

        public String getSchemaType() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_fetch_subManager_0
    extends Function
    implements PrivilegedAction<MpnSubscriptionManager>,
    PrivilegedExceptionAction<MpnSubscriptionManager>,
    Callable<MpnSubscriptionManager>,
    Supplier<MpnSubscriptionManager>,
    Function0<MpnSubscriptionManager> {
        public final LSMpnSubscription _gthis;

        public Closure_fetch_subManager_0(LSMpnSubscription _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public MpnSubscriptionManager invoke() {
            return this._gthis.m_manager;
        }

        @Override
        public MpnSubscriptionManager get() {
            return this.invoke();
        }

        @Override
        public MpnSubscriptionManager call() {
            return this.invoke();
        }

        @Override
        public MpnSubscriptionManager run() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_setFieldSchema_0
    extends Function
    implements PrivilegedAction<Array<String>>,
    PrivilegedExceptionAction<Array<String>>,
    Callable<Array<String>>,
    Supplier<Array<String>>,
    Function0<Array<String>> {
        public final LSMpnSubscription _gthis;
        public final String schema;

        /*
         * WARNING - void declaration
         */
        public Closure_setFieldSchema_0(LSMpnSubscription _gthis, String string) {
            void schema;
            this._gthis = _gthis;
            this.schema = schema;
        }

        @Override
        public Array invoke() {
            this._gthis.checkActive();
            this._gthis.schema = Name_Impl_.fromString(this.schema);
            this._gthis.fields = null;
            return null;
        }

        @Override
        public Array get() {
            return this.invoke();
        }

        @Override
        public Array call() {
            return this.invoke();
        }

        @Override
        public Array run() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_setTriggerExpression_0
    extends Function
    implements PrivilegedAction<MpnSubscriptionManager>,
    PrivilegedExceptionAction<MpnSubscriptionManager>,
    Callable<MpnSubscriptionManager>,
    Supplier<MpnSubscriptionManager>,
    Function0<MpnSubscriptionManager> {
        public final LSMpnSubscription _gthis;
        public final String expr;
        public final MpnSubscriptionManager[] _manager;

        /*
         * WARNING - void declaration
         */
        public Closure_setTriggerExpression_0(LSMpnSubscription _gthis, String string, MpnSubscriptionManager[] mpnSubscriptionManagerArray) {
            void _manager;
            void expr;
            this._gthis = _gthis;
            this.expr = expr;
            this._manager = _manager;
        }

        @Override
        public MpnSubscriptionManager invoke() {
            this._gthis.requestedTrigger = this.expr == null ? null : this.expr;
            this._manager[0] = this._gthis.m_manager;
            return this._manager[0];
        }

        @Override
        public MpnSubscriptionManager get() {
            return this.invoke();
        }

        @Override
        public MpnSubscriptionManager call() {
            return this.invoke();
        }

        @Override
        public MpnSubscriptionManager run() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_fetch_requestedTrigger_0
    extends Function
    implements FormatSchema,
    Named,
    PrivilegedAction<String>,
    ProtocolFamily,
    WatchEvent.Modifier,
    AttributeView,
    PrivilegedExceptionAction<String>,
    Callable<String>,
    Supplier<String>,
    Function0<String> {
        public final LSMpnSubscription _gthis;

        public Closure_fetch_requestedTrigger_0(LSMpnSubscription _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public String invoke() {
            return this._gthis.requestedTrigger;
        }

        @Override
        public String get() {
            return this.invoke();
        }

        @Override
        public String call() {
            return this.invoke();
        }

        @Override
        public String run() {
            return this.invoke();
        }

        @Override
        public String name() {
            return this.invoke();
        }

        public String getName() {
            return this.invoke();
        }

        public String getSchemaType() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_getListeners_0
    extends Function
    implements PrivilegedAction<List<MpnSubscriptionListener>>,
    PrivilegedExceptionAction<List<MpnSubscriptionListener>>,
    Callable<List<MpnSubscriptionListener>>,
    Supplier<List<MpnSubscriptionListener>>,
    Function0<List<MpnSubscriptionListener>> {
        public final LSMpnSubscription _gthis;

        public Closure_getListeners_0(LSMpnSubscription _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public List invoke() {
            return NativeList_Impl_._new(this._gthis.eventDispatcher.getListeners());
        }

        @Override
        public List get() {
            return this.invoke();
        }

        @Override
        public List call() {
            return this.invoke();
        }

        @Override
        public List run() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_getActualTriggerExpression_0
    extends Function
    implements FormatSchema,
    Named,
    PrivilegedAction<String>,
    ProtocolFamily,
    WatchEvent.Modifier,
    AttributeView,
    PrivilegedExceptionAction<String>,
    Callable<String>,
    Supplier<String>,
    Function0<String> {
        public final LSMpnSubscription _gthis;

        public Closure_getActualTriggerExpression_0(LSMpnSubscription _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public String invoke() {
            return this._gthis.realTrigger;
        }

        @Override
        public String get() {
            return this.invoke();
        }

        @Override
        public String call() {
            return this.invoke();
        }

        @Override
        public String run() {
            return this.invoke();
        }

        @Override
        public String name() {
            return this.invoke();
        }

        public String getName() {
            return this.invoke();
        }

        public String getSchemaType() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_setDataAdapter_0
    extends Function
    implements FormatSchema,
    Named,
    PrivilegedAction<String>,
    ProtocolFamily,
    WatchEvent.Modifier,
    AttributeView,
    PrivilegedExceptionAction<String>,
    Callable<String>,
    Supplier<String>,
    Function0<String> {
        public final LSMpnSubscription _gthis;
        public final String dataAdapter;

        /*
         * WARNING - void declaration
         */
        public Closure_setDataAdapter_0(LSMpnSubscription _gthis, String string) {
            void dataAdapter;
            this._gthis = _gthis;
            this.dataAdapter = dataAdapter;
        }

        @Override
        public String invoke() {
            this._gthis.checkActive();
            this._gthis.dataAdapter = Name_Impl_.fromString(this.dataAdapter);
            return this._gthis.dataAdapter;
        }

        @Override
        public String get() {
            return this.invoke();
        }

        @Override
        public String call() {
            return this.invoke();
        }

        @Override
        public String run() {
            return this.invoke();
        }

        @Override
        public String name() {
            return this.invoke();
        }

        public String getName() {
            return this.invoke();
        }

        public String getSchemaType() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }
}

