/*
 * Decompiled with CFR 0.152.
 */
package com.lightstreamer.client.internal;

import android.os.MessageQueue;
import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.databind.util.Named;
import com.lightstreamer.client.ItemUpdate;
import com.lightstreamer.client.internal.Encodable;
import com.lightstreamer.client.internal.MpnClientMachine;
import com.lightstreamer.client.mpn.LSMpnSubscription;
import com.lightstreamer.client.mpn.MpnRequestedMaxFrequency;
import com.lightstreamer.client.mpn.MpnSubscriptionStatus;
import com.lightstreamer.internal.NullTools;
import com.lightstreamer.internal.RLock;
import com.lightstreamer.internal.RequestBuilder;
import com.lightstreamer.internal.RequestedBufferSize;
import com.lightstreamer.internal._NativeTypes.NativeArray_Impl_;
import com.lightstreamer.log._LoggerTools.LoggerTools_Fields_;
import haxe.jvm.EmptyConstructor;
import haxe.jvm.Enum;
import haxe.jvm.Function;
import haxe.jvm.Jvm;
import haxe.jvm.annotation.ClassReflectionInformation;
import haxe.jvm.annotation.EnumReflectionInformation;
import haxe.jvm.annotation.EnumValueReflectionInformation;
import haxe.root.Std;
import java.net.ProtocolFamily;
import java.nio.file.WatchEvent;
import java.nio.file.attribute.AttributeView;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import kotlin.jvm.functions.Function0;

@ClassReflectionInformation(hasSuperClass=false)
public class MpnSubscriptionManager
extends haxe.jvm.Object
implements Encodable {
    public State state;
    public RLock lock;
    public Integer m_subId;
    public boolean m_coalescing;
    public Integer m_lastActivateReqId;
    public Integer m_lastConfigureReqId;
    public Integer m_lastDeactivateReqId;
    public String m_initFormat;
    public String m_initTrigger;
    public String m_currentFormat;
    public String m_currentTrigger;
    public LSMpnSubscription m_subscription;
    public MpnClientMachine m_client;

    public void finalize() {
        this.m_subscription.reset();
        this.m_client.unrelate(this);
        this.m_subscription.unrelate(this);
    }

    public String fetch_mpnSubId() {
        MpnSubscriptionManager _gthis = this;
        return (String)this.lock.synchronized(new Closure_fetch_mpnSubId_0(_gthis));
    }

    public void start() {
        this.lock.synchronized(Closure_start_0.MpnSubscriptionManager$Closure_start_0);
    }

    public void evtExtMpnUnsubscribe() {
        MpnSubscriptionManager _gthis = this;
        this.lock.synchronized(new Closure_evtExtMpnUnsubscribe_0(_gthis));
    }

    public boolean evtExtMpnUnsubscribe_UnsubRegion() {
        this.traceEvent("unsubscribe");
        if (this.state.s_uu == 10) {
            this.state.s_uu = 11;
            this.state.traceState();
        } else if (this.state.s_uu == 12) {
            this.state.s_uu = 11;
            this.state.traceState();
        }
        return false;
    }

    public void evtAbort() {
        MpnSubscriptionManager _gthis = this;
        this.lock.synchronized(new Closure_evtAbort_0(_gthis));
    }

    public void evtAbort_AbortRegion() {
        this.traceEvent("abort");
        boolean forward = true;
        Integer n = this.state.s_ab;
        if (n == null ? false : Jvm.toInt(n) == 80) {
            this.state.s_ab = 81;
            this.state.traceState();
            forward = this.evtAbort_ControlRegion();
        }
        if (forward) {
            this.evtAbort_ControlRegion();
        }
    }

    public boolean evtAbort_ControlRegion() {
        block3: {
            block2: {
                this.traceEvent("abort");
                Integer n = this.state.s_ct;
                if (!(n == null ? true : Jvm.toInt(n) != 70)) break block2;
                Integer n2 = this.state.s_ct;
                if (!(n2 == null ? true : Jvm.toInt(n2) != 71)) break block2;
                Integer n3 = this.state.s_ct;
                if (!(n3 == null ? true : Jvm.toInt(n3) != 72)) break block2;
                Integer n4 = this.state.s_ct;
                if (!(n4 == null ? true : Jvm.toInt(n4) != 73)) break block2;
                Integer n5 = this.state.s_ct;
                if (!(n5 == null ? false : Jvm.toInt(n5) == 74)) break block3;
            }
            this.state.s_ct = 76;
            this.state.traceState();
            this.evtAbortFormat();
            this.evtAbortTrigger();
            this.evtAbortUnsubscribe();
        }
        return false;
    }

    public void evtRestoreSession() {
        MpnSubscriptionManager _gthis = this;
        this.lock.synchronized(new Closure_evtRestoreSession_0(_gthis));
    }

    public void evtREQOK(int reqId) {
        MpnSubscriptionManager _gthis = this;
        this.lock.synchronized(new Closure_evtREQOK_0(_gthis, reqId));
    }

    /*
     * Unable to fully structure code
     */
    public boolean evtREQOK_TriggerRegion(int reqId) {
        this.traceEvent("REQOK");
        forward = true;
        if (this.state.s_tu != 32) ** GOTO lbl-1000
        v0 = this.m_lastConfigureReqId;
        if (v0 == null ? false : reqId == Jvm.toInt(v0)) {
            this.state.s_tu = 30;
            this.state.traceState();
            forward = this.evtREQOK_MainRegion(reqId);
        } else if (this.state.s_tu == 33) {
            v1 = this.m_lastConfigureReqId;
            if (v1 == null ? false : reqId == Jvm.toInt(v1)) {
                this.state.s_tu = 31;
                this.state.traceState();
                forward = this.evtREQOK_MainRegion(reqId);
            }
        }
        if (forward) {
            this.evtREQOK_MainRegion(reqId);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean evtREQOK_MainRegion(int reqId) {
        this.traceEvent("REQOK");
        if (this.state.s_m == 42) {
            Integer n = this.m_lastActivateReqId;
            if (n == null ? false : reqId == Jvm.toInt(n)) {
                this.state.s_m = 43;
                this.state.traceState();
                return false;
            }
        }
        if (this.state.s_m != 44) return false;
        this.state.s_m = 44;
        this.state.traceState();
        this.evtREQOK_ControlRegion(reqId);
        return false;
    }

    public void evtREQOK_ControlRegion(int reqId) {
        block7: {
            block6: {
                this.traceEvent("REQOK");
                Integer n = this.state.s_ct;
                if (n == null ? false : Jvm.toInt(n) == 72) {
                    Integer n2 = this.m_lastDeactivateReqId;
                    if (n2 == null ? false : reqId == Jvm.toInt(n2)) {
                        this.notifyStatus(MpnSubscriptionStatus.Unknown, null);
                        this.notifyOnUnsubscription();
                        this.notifyOnSubscriptionsUpdated();
                        this.finalize();
                        this.state.s_m = 52;
                        this.state.s_st = null;
                        this.state.s_ct = null;
                        this.state.s_ab = null;
                        this.state.traceState();
                        return;
                    }
                }
                Integer n3 = this.state.s_ct;
                if (!(n3 == null ? true : Jvm.toInt(n3) != 73)) break block6;
                Integer n4 = this.state.s_ct;
                if (!(n4 == null ? false : Jvm.toInt(n4) == 74)) break block7;
            }
            Integer n = this.m_lastConfigureReqId;
            if (n == null ? false : reqId == Jvm.toInt(n)) {
                this.state.s_ct = 70;
                this.state.traceState();
                this.evtCheck();
            }
        }
    }

    public void evtREQERR(int reqId, int code, String msg) {
        MpnSubscriptionManager _gthis = this;
        this.lock.synchronized(new Closure_evtREQERR_0(_gthis, reqId, code, msg));
    }

    /*
     * Unable to fully structure code
     */
    public boolean evtREQERR_FormatRegion(int reqId, int code, String msg) {
        this.traceEvent("REQERR");
        forward = true;
        if (this.state.s_fu != 22) ** GOTO lbl-1000
        v0 = this.m_lastConfigureReqId;
        if (v0 == null ? false : reqId == Jvm.toInt(v0)) {
            this.notifyOnModificationError_Format(code, msg);
            this.state.s_fu = 20;
            this.state.traceState();
            forward = this.evtREQERR_TriggerRegion(reqId, code, msg);
        } else if (this.state.s_fu == 23) {
            v1 = this.m_lastConfigureReqId;
            if (v1 == null ? false : reqId == Jvm.toInt(v1)) {
                this.state.s_fu = 21;
                this.state.traceState();
                forward = this.evtREQERR_TriggerRegion(reqId, code, msg);
            }
        }
        if (forward) {
            this.evtREQERR_TriggerRegion(reqId, code, msg);
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public boolean evtREQERR_TriggerRegion(int reqId, int code, String msg) {
        this.traceEvent("REQERR");
        forward = true;
        if (this.state.s_tu != 32) ** GOTO lbl-1000
        v0 = this.m_lastConfigureReqId;
        if (v0 == null ? false : reqId == Jvm.toInt(v0)) {
            this.notifyOnModificationError_Trigger(code, msg);
            this.state.s_tu = 30;
            this.state.traceState();
            forward = this.evtREQERR_MainRegion(reqId, code, msg);
        } else if (this.state.s_tu == 33) {
            v1 = this.m_lastConfigureReqId;
            if (v1 == null ? false : reqId == Jvm.toInt(v1)) {
                this.state.s_tu = 31;
                this.state.traceState();
                forward = this.evtREQERR_MainRegion(reqId, code, msg);
            }
        }
        if (forward) {
            this.evtREQERR_MainRegion(reqId, code, msg);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean evtREQERR_MainRegion(int reqId, int code, String msg) {
        this.traceEvent("REQERR");
        if (this.state.s_m == 42) {
            Integer n = this.m_lastActivateReqId;
            if (n == null ? false : reqId == Jvm.toInt(n)) {
                this.notifyStatus(MpnSubscriptionStatus.Unknown, null);
                this.notifyOnSubscriptionError(code, msg);
                this.finalize();
                this.state.s_m = 50;
                this.state.traceState();
                return false;
            }
        }
        if (this.state.s_m != 44) return false;
        this.state.s_m = 44;
        this.state.traceState();
        this.evtREQERR_ControlRegion(reqId, code, msg);
        return false;
    }

    public void evtREQERR_ControlRegion(int reqId, int code, String msg) {
        block7: {
            block6: {
                this.traceEvent("REQERR");
                Integer n = this.state.s_ct;
                if (n == null ? false : Jvm.toInt(n) == 72) {
                    Integer n2 = this.m_lastDeactivateReqId;
                    if (n2 == null ? false : reqId == Jvm.toInt(n2)) {
                        this.state.s_ct = 70;
                        this.state.traceState();
                        this.evtCheck();
                        return;
                    }
                }
                Integer n3 = this.state.s_ct;
                if (!(n3 == null ? true : Jvm.toInt(n3) != 73)) break block6;
                Integer n4 = this.state.s_ct;
                if (!(n4 == null ? false : Jvm.toInt(n4) == 74)) break block7;
            }
            Integer n = this.m_lastConfigureReqId;
            if (n == null ? false : reqId == Jvm.toInt(n)) {
                this.state.s_ct = 70;
                this.state.traceState();
                this.evtCheck();
            }
        }
    }

    public void evtAbortUnsubscribe() {
        MpnSubscriptionManager _gthis = this;
        this.lock.synchronized(new Closure_evtAbortUnsubscribe_0(_gthis));
    }

    public void evtExtMpnSetFormat() {
        MpnSubscriptionManager _gthis = this;
        this.lock.synchronized(new Closure_evtExtMpnSetFormat_0(_gthis));
    }

    public boolean evtExtMpnSetFormat_ControlRegion() {
        this.traceEvent("setFormat");
        Integer n = this.state.s_ct;
        if (n == null ? false : Jvm.toInt(n) == 71) {
            this.state.s_ct = 70;
            this.state.traceState();
            this.evtCheck();
        }
        return false;
    }

    public void evtExtMpnSetTrigger() {
        MpnSubscriptionManager _gthis = this;
        this.lock.synchronized(new Closure_evtExtMpnSetTrigger_0(_gthis));
    }

    public boolean evtExtMpnSetTrigger_ControlRegion() {
        this.traceEvent("setTrigger");
        Integer n = this.state.s_ct;
        if (n == null ? false : Jvm.toInt(n) == 71) {
            this.state.s_ct = 70;
            this.state.traceState();
            this.evtCheck();
        }
        return false;
    }

    public void evtChangeFormat() {
        MpnSubscriptionManager _gthis = this;
        this.lock.synchronized(new Closure_evtChangeFormat_0(_gthis));
    }

    public void evtChangeTrigger() {
        MpnSubscriptionManager _gthis = this;
        this.lock.synchronized(new Closure_evtChangeTrigger_0(_gthis));
    }

    public void evtAbortFormat() {
        MpnSubscriptionManager _gthis = this;
        this.lock.synchronized(new Closure_evtAbortFormat_0(_gthis));
    }

    public void evtAbortTrigger() {
        MpnSubscriptionManager _gthis = this;
        this.lock.synchronized(new Closure_evtAbortTrigger_0(_gthis));
    }

    public void evtCheck() {
        MpnSubscriptionManager _gthis = this;
        this.lock.synchronized(new Closure_evtCheck_0(_gthis));
    }

    public void evtExtMpnSubscribe() {
        MpnSubscriptionManager _gthis = this;
        this.lock.synchronized(new Closure_evtExtMpnSubscribe_0(_gthis));
    }

    public void evtDeviceActive() {
        MpnSubscriptionManager _gthis = this;
        this.lock.synchronized(new Closure_evtDeviceActive_0(_gthis));
    }

    public void evtMPNOK(String mpnSubId) {
        MpnSubscriptionManager _gthis = this;
        this.lock.synchronized(new Closure_evtMPNOK_0(_gthis, mpnSubId));
    }

    public void evtMPNDEL() {
        MpnSubscriptionManager _gthis = this;
        this.lock.synchronized(new Closure_evtMPNDEL_0(_gthis));
    }

    public void evtMpnUpdate(ItemUpdate update) {
        MpnSubscriptionManager _gthis = this;
        this.lock.synchronized(new Closure_evtMpnUpdate_0(_gthis, update));
    }

    public void evtMpnUpdate_AbortRegion(ItemUpdate update) {
        this.traceEvent("update");
        boolean forward = true;
        Integer n = this.state.s_ab;
        if (n == null ? false : Jvm.toInt(n) == 81) {
            this.state.s_ab = 80;
            this.state.traceState();
            forward = this.evtMpnUpdate_StatusRegion(update);
            this.evtRestoreSession();
        }
        if (forward) {
            this.evtMpnUpdate_StatusRegion(update);
        }
    }

    public boolean evtMpnUpdate_StatusRegion(ItemUpdate update) {
        this.traceEvent("update");
        String ts = update.getValue("status_timestamp");
        String nextStatus = update.getValue("status");
        nextStatus = nextStatus != null ? nextStatus.toUpperCase() : null;
        Integer n = this.state.s_st;
        if (n == null ? false : Jvm.toInt(n) == 60) {
            if (Jvm.stringCompare(nextStatus, "ACTIVE") == 0) {
                this.notifyUpdate(update);
                this.state.s_st = 60;
                this.state.traceState();
            } else if (Jvm.stringCompare(nextStatus, "TRIGGERED") == 0) {
                this.notifyStatus(MpnSubscriptionStatus.Triggered, ts);
                this.notifyOnTriggered();
                this.notifyUpdate(update);
                this.state.s_st = 61;
                this.state.traceState();
            }
        } else {
            Integer n2 = this.state.s_st;
            if (n2 == null ? false : Jvm.toInt(n2) == 61) {
                if (Jvm.stringCompare(nextStatus, "ACTIVE") == 0) {
                    this.notifyStatus(MpnSubscriptionStatus.Subscribed, ts);
                    this.notifyUpdate(update);
                    this.state.s_st = 60;
                    this.state.traceState();
                } else if (Jvm.stringCompare(nextStatus, "TRIGGERED") == 0) {
                    this.notifyUpdate(update);
                    this.state.s_st = 61;
                    this.state.traceState();
                }
            }
        }
        return false;
    }

    public void evtMpnEOS() {
        MpnSubscriptionManager _gthis = this;
        this.lock.synchronized(new Closure_evtMpnEOS_0(_gthis));
    }

    @Override
    public boolean isPending() {
        MpnSubscriptionManager _gthis = this;
        return Jvm.toBoolean(this.lock.synchronized(new Closure_isPending_0(_gthis)));
    }

    @Override
    public String encode(boolean isWS) {
        MpnSubscriptionManager _gthis = this;
        return (String)this.lock.synchronized(new Closure_encode_0(_gthis));
    }

    @Override
    public String encodeWS() {
        MpnSubscriptionManager _gthis = this;
        return (String)this.lock.synchronized(new Closure_encodeWS_0(_gthis));
    }

    public String encodeActivate() {
        RequestedBufferSize buff;
        MpnRequestedMaxFrequency freq;
        RequestBuilder req = new RequestBuilder();
        this.m_lastActivateReqId = this.m_client.generateFreshReqId();
        req.LS_reqId(Jvm.toInt(this.m_lastActivateReqId));
        req.LS_op("activate");
        req.LS_subId(Jvm.toInt(NullTools.sure(this.m_subId)));
        req.LS_mode(NullTools.sure(this.m_subscription.fetch_mode()));
        String group = this.m_subscription.getItemGroup();
        String[] items = this.m_subscription.getItems();
        if (group != null) {
            req.LS_group(group);
        } else if (items != null) {
            req.LS_group(NativeArray_Impl_.toHaxe(items).join(" "));
        }
        String schema = this.m_subscription.getFieldSchema();
        String[] fields = this.m_subscription.getFields();
        if (schema != null) {
            req.LS_schema(schema);
        } else if (fields != null) {
            req.LS_schema(NativeArray_Impl_.toHaxe(fields).join(" "));
        }
        String adapter = this.m_subscription.getDataAdapter();
        if (adapter != null) {
            req.LS_data_adapter(adapter);
        }
        if ((freq = this.m_subscription.fetch_requestedMaxFrequency()) != null) {
            switch (freq.ordinal()) {
                case 0: {
                    req.LS_requested_max_frequency_Float(((MpnRequestedMaxFrequency.FreqLimited)freq).max);
                    break;
                }
                case 1: {
                    req.LS_requested_max_frequency("unlimited");
                }
            }
        }
        if ((buff = this.m_subscription.fetch_requestedBufferSize()) != null) {
            switch (buff.ordinal()) {
                case 0: {
                    req.LS_requested_buffer_size_Int(((RequestedBufferSize.BSLimited)buff).size);
                    break;
                }
                case 1: {
                    req.LS_requested_buffer_size("unlimited");
                }
            }
        }
        req.PN_deviceId(NullTools.sure(this.m_client.fetch_mpn_deviceId()));
        req.PN_notificationFormat(NullTools.sure(this.m_initFormat));
        String trigger = this.m_initTrigger;
        if (trigger != null) {
            req.PN_trigger(trigger);
        }
        if (this.m_coalescing) {
            req.PN_coalescing(true);
        }
        if (LoggerTools_Fields_.protocolLogger.isInfoEnabled()) {
            LoggerTools_Fields_.protocolLogger.info("Sending MPNSubscription activate: " + Std.string(req), null);
        }
        return req.getEncodedString();
    }

    public String encodeDeactivate() {
        RequestBuilder req = new RequestBuilder();
        this.m_lastDeactivateReqId = this.m_client.generateFreshReqId();
        req.LS_reqId(Jvm.toInt(this.m_lastDeactivateReqId));
        req.LS_op("deactivate");
        req.PN_deviceId(NullTools.sure(this.m_client.fetch_mpn_deviceId()));
        req.PN_subscriptionId(NullTools.sure(this.m_subscription.getSubscriptionId()));
        if (LoggerTools_Fields_.protocolLogger.isInfoEnabled()) {
            LoggerTools_Fields_.protocolLogger.info("Sending MPNSubscription deactivate: " + Std.string(req), null);
        }
        return req.getEncodedString();
    }

    public String encodeConfigure() {
        RequestBuilder req = new RequestBuilder();
        this.m_lastConfigureReqId = this.m_client.generateFreshReqId();
        req.LS_reqId(Jvm.toInt(this.m_lastConfigureReqId));
        req.LS_op("pn_reconf");
        req.LS_mode(NullTools.sure(this.m_subscription.fetch_mode()));
        String group = this.m_subscription.getItemGroup();
        String[] items = this.m_subscription.getItems();
        if (group != null) {
            req.LS_group(group);
        } else if (items != null) {
            req.LS_group(NativeArray_Impl_.toHaxe(items).join(" "));
        }
        String schema = this.m_subscription.getFieldSchema();
        String[] fields = this.m_subscription.getFields();
        if (schema != null) {
            req.LS_schema(schema);
        } else if (fields != null) {
            req.LS_schema(NativeArray_Impl_.toHaxe(fields).join(" "));
        }
        String adapter = this.m_subscription.getDataAdapter();
        if (adapter != null) {
            req.LS_data_adapter(adapter);
        }
        req.PN_deviceId(NullTools.sure(this.m_client.fetch_mpn_deviceId()));
        req.PN_subscriptionId(NullTools.sure(this.m_subscription.getSubscriptionId()));
        Integer n = this.state.s_ct;
        if (n == null ? false : Jvm.toInt(n) == 74) {
            req.PN_notificationFormat(NullTools.sure(this.m_currentFormat));
        }
        Integer n2 = this.state.s_ct;
        if (n2 == null ? false : Jvm.toInt(n2) == 73) {
            String tmp = this.m_currentTrigger;
            req.PN_trigger(tmp != null ? tmp : "");
        }
        if (LoggerTools_Fields_.protocolLogger.isInfoEnabled()) {
            LoggerTools_Fields_.protocolLogger.info("Sending MPNSubscription configuration: " + Std.string(req), null);
        }
        return req.getEncodedString();
    }

    public void genSendSubscribe() {
        this.m_client.evtSendControl(this);
    }

    public void genSendConfigure() {
        this.m_client.evtSendControl(this);
    }

    public void genSendUnsubscribe() {
        this.m_client.evtSendControl(this);
    }

    public void notifyStatus(MpnSubscriptionStatus status, String statusTs) {
        this.m_subscription.changeStatus(status, statusTs);
    }

    public void notifyOnSubscriptionError(int code, String msg) {
        this.m_subscription.fireOnSubscriptionError(code, msg);
    }

    public void notifyOnSubscriptionAbort() {
        this.m_subscription.fireOnSubscriptionError(54, "The request was aborted because the operation could not be completed");
    }

    public void notifyOnSubscriptionDiscarded() {
        this.m_subscription.fireOnSubscriptionError(55, "The request was discarded because the operation could not be completed");
    }

    public void notifyOnUnsubscriptionError(int code, String msg) {
        this.m_subscription.fireOnUnsubscriptionError(code, msg);
    }

    public void notifyOnUnsubscriptionAbort() {
        this.m_subscription.fireOnUnsubscriptionError(54, "The request was aborted because the operation could not be completed");
    }

    public void doMPNOK(String mpnSubId) {
        this.m_subscription.setSubscriptionId(mpnSubId);
    }

    public void notifyOnSubscription() {
        this.m_subscription.fireOnSubscription();
    }

    public void notifyOnUnsubscription() {
        this.m_subscription.fireOnUnsubscription();
    }

    public void notifyOnTriggered() {
        this.m_subscription.fireOnTriggered();
    }

    public void notifyOnSubscriptionsUpdated() {
        NullTools.sure(this.m_client.fetch_mpn_device()).fireOnSubscriptionsUpdated();
    }

    public void notifyUpdate(ItemUpdate update) {
        this.m_subscription.changeStatusTs(update.getValue("status_timestamp"));
        this.m_subscription.changeMode(update.getValue("mode"));
        this.m_subscription.changeAdapter(update.getValue("adapter"));
        this.m_subscription.changeGroup(update.getValue("group"));
        this.m_subscription.changeSchema(update.getValue("schema"));
        this.m_subscription.changeFormat(update.getValue("notification_format"));
        this.m_subscription.changeTrigger(update.getValue("trigger"));
        this.m_subscription.changeBufferSize(update.getValue("requested_buffer_size"));
        this.m_subscription.changeMaxFrequency(update.getValue("requested_max_frequency"));
    }

    public void doSetCurrentFormat() {
        this.m_currentFormat = this.m_subscription.fetch_requestedFormat();
    }

    public void doSetCurrentTrigger() {
        this.m_currentTrigger = this.m_subscription.fetch_requestedTrigger();
    }

    public void notifyOnModificationError_Format(int code, String msg) {
        this.m_subscription.fireOnModificationError(code, msg, "notification_format");
    }

    public void notifyOnModificationAbort_Format() {
        this.m_subscription.fireOnModificationError(54, "The request was aborted because the operation could not be completed", "notification_format");
    }

    public void notifyOnModificationError_Trigger(int code, String msg) {
        this.m_subscription.fireOnModificationError(code, msg, "trigger");
    }

    public void notifyOnModificationAbort_Trigger() {
        this.m_subscription.fireOnModificationError(54, "The request was aborted because the operation could not be completed", "trigger");
    }

    public void traceEvent(String evt) {
        if (LoggerTools_Fields_.internalLogger.isTraceEnabled()) {
            LoggerTools_Fields_.internalLogger.trace("mpn#sub#" + evt + "(" + this.m_subId + ":" + this.fetch_mpnSubId() + ") in " + Std.string(this.state), null);
        }
    }

    public MpnSubscriptionManager(CtorArgs args) {
        LSMpnSubscription sub = null;
        Boolean coalescing = null;
        MpnClientMachine client = null;
        String mpnSubId = null;
        switch (args.ordinal()) {
            case 0: {
                sub = ((CtorArgs.Ctor1)args).sub;
                coalescing = ((CtorArgs.Ctor1)args).coalescing;
                client = ((CtorArgs.Ctor1)args).client;
                break;
            }
            case 1: {
                mpnSubId = ((CtorArgs.Ctor2)args).mpnSubId;
                client = ((CtorArgs.Ctor2)args).client;
            }
        }
        if (mpnSubId == null) {
            this.lock = client.lock;
            this.m_subId = client.generateFreshSubId();
            this.m_coalescing = Jvm.toBoolean(coalescing);
            this.m_initFormat = sub.getNotificationFormat();
            this.m_initTrigger = sub.getTriggerExpression();
            this.m_subscription = sub;
            this.m_client = client;
            this.state = new State(40, this);
            this.m_subscription.relate(this);
            this.m_client.relate(this);
            return;
        }
        this.lock = client.lock;
        this.m_subId = null;
        this.m_coalescing = false;
        this.m_initFormat = null;
        this.m_initTrigger = null;
        this.m_subscription = new LSMpnSubscription("MERGE", null, null, (Object)null);
        this.m_subscription.reInit(mpnSubId);
        this.m_client = client;
        this.state = new State(45, this);
        this.m_subscription.relate(this);
        this.m_client.relate(this);
    }

    public /* synthetic */ MpnSubscriptionManager(EmptyConstructor _) {
    }

    public static final class Closure_evtREQERR_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final MpnSubscriptionManager _gthis;
        public final int reqId;
        public final int code;
        public final String msg;

        /*
         * WARNING - void declaration
         */
        public Closure_evtREQERR_0(MpnSubscriptionManager _gthis, int n, int n2, String string) {
            void msg;
            void code;
            void reqId;
            this._gthis = _gthis;
            this.reqId = reqId;
            this.code = code;
            this.msg = msg;
        }

        @Override
        public void invoke() {
            this._gthis.traceEvent("REQERR");
            boolean forward = true;
            if (this._gthis.state.s_uu == 11) {
                Integer n = this._gthis.m_lastDeactivateReqId;
                if (n == null ? false : this.reqId == Jvm.toInt(n)) {
                    this._gthis.notifyOnUnsubscriptionError(this.code, this.msg);
                    this._gthis.state.s_uu = 12;
                    this._gthis.state.traceState();
                    forward = this._gthis.evtREQERR_FormatRegion(this.reqId, this.code, this.msg);
                }
            }
            if (forward) {
                this._gthis.evtREQERR_FormatRegion(this.reqId, this.code, this.msg);
            }
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_encode_0
    extends Function
    implements FormatSchema,
    Named,
    PrivilegedAction<String>,
    ProtocolFamily,
    WatchEvent.Modifier,
    AttributeView,
    PrivilegedExceptionAction<String>,
    Callable<String>,
    Supplier<String>,
    Function0<String> {
        public final MpnSubscriptionManager _gthis;

        public Closure_encode_0(MpnSubscriptionManager _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public String invoke() {
            block6: {
                block5: {
                    if (this._gthis.state.s_m == 42) {
                        return this._gthis.encodeActivate();
                    }
                    Integer n = this._gthis.state.s_ct;
                    if (n == null ? false : Jvm.toInt(n) == 72) {
                        return this._gthis.encodeDeactivate();
                    }
                    Integer n2 = this._gthis.state.s_ct;
                    if (!(n2 == null ? true : Jvm.toInt(n2) != 73)) break block5;
                    Integer n3 = this._gthis.state.s_ct;
                    if (!(n3 == null ? false : Jvm.toInt(n3) == 74)) break block6;
                }
                return this._gthis.encodeConfigure();
            }
            throw new IllegalStateException("Can't encode request");
        }

        @Override
        public String get() {
            return this.invoke();
        }

        @Override
        public String call() {
            return this.invoke();
        }

        @Override
        public String run() {
            return this.invoke();
        }

        @Override
        public String name() {
            return this.invoke();
        }

        public String getName() {
            return this.invoke();
        }

        public String getSchemaType() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_fetch_mpnSubId_0
    extends Function
    implements FormatSchema,
    Named,
    PrivilegedAction<String>,
    ProtocolFamily,
    WatchEvent.Modifier,
    AttributeView,
    PrivilegedExceptionAction<String>,
    Callable<String>,
    Supplier<String>,
    Function0<String> {
        public final MpnSubscriptionManager _gthis;

        public Closure_fetch_mpnSubId_0(MpnSubscriptionManager _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public String invoke() {
            return this._gthis.m_subscription.fetch_mpnSubId();
        }

        @Override
        public String get() {
            return this.invoke();
        }

        @Override
        public String call() {
            return this.invoke();
        }

        @Override
        public String run() {
            return this.invoke();
        }

        @Override
        public String name() {
            return this.invoke();
        }

        public String getName() {
            return this.invoke();
        }

        public String getSchemaType() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_evtExtMpnUnsubscribe_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final MpnSubscriptionManager _gthis;

        public Closure_evtExtMpnUnsubscribe_0(MpnSubscriptionManager _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public void invoke() {
            this._gthis.traceEvent("unsubscribe");
            boolean forward = true;
            if (this._gthis.state.s_m == 41) {
                this._gthis.notifyStatus(MpnSubscriptionStatus.Unknown, null);
                this._gthis.notifyOnSubscriptionDiscarded();
                this._gthis.finalize();
                this._gthis.state.s_m = 50;
                this._gthis.state.traceState();
                forward = this._gthis.evtExtMpnUnsubscribe_UnsubRegion();
            } else {
                Integer n = this._gthis.state.s_ct;
                if (n == null ? false : Jvm.toInt(n) == 71) {
                    this._gthis.state.s_ct = 70;
                    this._gthis.state.traceState();
                    forward = this._gthis.evtExtMpnUnsubscribe_UnsubRegion();
                    this._gthis.evtCheck();
                }
            }
            if (forward) {
                this._gthis.evtExtMpnUnsubscribe_UnsubRegion();
            }
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_evtMpnEOS_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final MpnSubscriptionManager _gthis;

        public Closure_evtMpnEOS_0(MpnSubscriptionManager _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public void invoke() {
            this._gthis.traceEvent("EOS");
            Integer n = this._gthis.state.s_ab;
            if (n == null ? false : Jvm.toInt(n) == 81) {
                this._gthis.notifyStatus(MpnSubscriptionStatus.Unknown, null);
                this._gthis.notifyOnUnsubscription();
                this._gthis.notifyOnSubscriptionsUpdated();
                this._gthis.finalize();
                this._gthis.state.s_m = 51;
                this._gthis.state.s_st = null;
                this._gthis.state.s_ct = null;
                this._gthis.state.s_ab = null;
                this._gthis.state.traceState();
            }
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_evtAbortUnsubscribe_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final MpnSubscriptionManager _gthis;

        public Closure_evtAbortUnsubscribe_0(MpnSubscriptionManager _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public void invoke() {
            this._gthis.traceEvent("abort.unsubscribe");
            if (this._gthis.state.s_uu == 11) {
                this._gthis.notifyOnUnsubscriptionAbort();
                this._gthis.state.s_uu = 12;
                this._gthis.state.traceState();
            }
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_evtChangeTrigger_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final MpnSubscriptionManager _gthis;

        public Closure_evtChangeTrigger_0(MpnSubscriptionManager _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public void invoke() {
            this._gthis.traceEvent("change.trigger");
            if (this._gthis.state.s_tu == 31) {
                this._gthis.doSetCurrentTrigger();
                this._gthis.state.s_tu = 32;
                this._gthis.state.traceState();
            }
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_evtMpnUpdate_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final MpnSubscriptionManager _gthis;
        public final ItemUpdate update;

        /*
         * WARNING - void declaration
         */
        public Closure_evtMpnUpdate_0(MpnSubscriptionManager _gthis, ItemUpdate itemUpdate) {
            void update;
            this._gthis = _gthis;
            this.update = update;
        }

        @Override
        public void invoke() {
            this._gthis.traceEvent("update");
            String ts = this.update.getValue("status_timestamp");
            String nextStatus = this.update.getValue("status");
            nextStatus = nextStatus != null ? nextStatus.toUpperCase() : null;
            String command = this.update.getValue("command");
            String string = command = command != null ? command.toUpperCase() : null;
            if (this._gthis.state.s_m == 44 && Jvm.stringCompare(command, "DELETE") == 0) {
                this._gthis.notifyStatus(MpnSubscriptionStatus.Unknown, null);
                this._gthis.notifyOnUnsubscription();
                this._gthis.notifyOnSubscriptionsUpdated();
                this._gthis.finalize();
                this._gthis.state.s_m = 52;
                this._gthis.state.s_st = null;
                this._gthis.state.s_ct = null;
                this._gthis.state.s_ab = null;
                this._gthis.state.traceState();
                return;
            }
            if (this._gthis.state.s_m == 45) {
                if (Jvm.stringCompare(nextStatus, "ACTIVE") == 0) {
                    this._gthis.notifyStatus(MpnSubscriptionStatus.Subscribed, ts);
                    this._gthis.notifyOnSubscription();
                    this._gthis.notifyUpdate(this.update);
                    this._gthis.state.s_m = 44;
                    this._gthis.state.s_st = 60;
                    this._gthis.state.s_ct = 70;
                    this._gthis.state.s_ab = 80;
                    this._gthis.state.traceState();
                    this._gthis.evtCheck();
                    return;
                }
                if (Jvm.stringCompare(nextStatus, "TRIGGERED") == 0) {
                    this._gthis.notifyStatus(MpnSubscriptionStatus.Triggered, ts);
                    this._gthis.notifyOnSubscription();
                    this._gthis.notifyOnTriggered();
                    this._gthis.notifyUpdate(this.update);
                    this._gthis.state.s_m = 44;
                    this._gthis.state.s_st = 61;
                    this._gthis.state.s_ct = 70;
                    this._gthis.state.s_ab = 80;
                    this._gthis.state.traceState();
                    this._gthis.evtCheck();
                }
                return;
            }
            if (this._gthis.state.s_m == 44) {
                this._gthis.state.s_m = 44;
                this._gthis.state.traceState();
                this._gthis.evtMpnUpdate_AbortRegion(this.update);
            }
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_start_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public static final Closure_start_0 MpnSubscriptionManager$Closure_start_0 = new Closure_start_0();

        Closure_start_0() {
        }

        @Override
        public void invoke() {
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_evtExtMpnSetFormat_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final MpnSubscriptionManager _gthis;

        public Closure_evtExtMpnSetFormat_0(MpnSubscriptionManager _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public void invoke() {
            this._gthis.traceEvent("setFormat");
            boolean forward = true;
            if (this._gthis.state.s_fu == 20) {
                this._gthis.state.s_fu = 21;
                this._gthis.state.traceState();
                forward = this._gthis.evtExtMpnSetFormat_ControlRegion();
            } else if (this._gthis.state.s_fu == 22) {
                this._gthis.state.s_fu = 23;
                this._gthis.state.traceState();
                forward = this._gthis.evtExtMpnSetFormat_ControlRegion();
            }
            if (forward) {
                this._gthis.evtExtMpnSetFormat_ControlRegion();
            }
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_evtRestoreSession_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final MpnSubscriptionManager _gthis;

        public Closure_evtRestoreSession_0(MpnSubscriptionManager _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public void invoke() {
            this._gthis.traceEvent("restore.session");
            Integer n = this._gthis.state.s_ct;
            if (n == null ? false : Jvm.toInt(n) == 76) {
                this._gthis.state.s_ct = 70;
                this._gthis.state.traceState();
                this._gthis.evtCheck();
            }
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_evtCheck_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final MpnSubscriptionManager _gthis;

        public Closure_evtCheck_0(MpnSubscriptionManager _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public void invoke() {
            this._gthis.traceEvent("check");
            Integer n = this._gthis.state.s_ct;
            if (n == null ? false : Jvm.toInt(n) == 70) {
                if (this._gthis.state.s_uu == 11) {
                    this._gthis.state.s_ct = 72;
                    this._gthis.state.traceState();
                    this._gthis.genSendUnsubscribe();
                } else if (this._gthis.state.s_fu == 21) {
                    this._gthis.state.s_ct = 74;
                    this._gthis.state.traceState();
                    this._gthis.evtChangeFormat();
                    this._gthis.genSendConfigure();
                } else if (this._gthis.state.s_tu == 31) {
                    this._gthis.state.s_ct = 73;
                    this._gthis.state.traceState();
                    this._gthis.evtChangeTrigger();
                    this._gthis.genSendConfigure();
                } else {
                    this._gthis.state.s_ct = 71;
                    this._gthis.state.traceState();
                }
            }
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_evtExtMpnSubscribe_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final MpnSubscriptionManager _gthis;

        public Closure_evtExtMpnSubscribe_0(MpnSubscriptionManager _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public void invoke() {
            this._gthis.traceEvent("subscribe");
            if (this._gthis.state.s_m == 40) {
                if (this._gthis.m_client.state.s_mpn.m == 405) {
                    this._gthis.notifyStatus(MpnSubscriptionStatus.Active, null);
                    this._gthis.state.s_m = 42;
                    this._gthis.state.traceState();
                    this._gthis.genSendSubscribe();
                } else {
                    this._gthis.notifyStatus(MpnSubscriptionStatus.Active, null);
                    this._gthis.state.s_m = 41;
                    this._gthis.state.traceState();
                }
            }
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_evtMPNDEL_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final MpnSubscriptionManager _gthis;

        public Closure_evtMPNDEL_0(MpnSubscriptionManager _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public void invoke() {
            this._gthis.traceEvent("MPNDEL");
            Integer n = this._gthis.state.s_ct;
            if (n == null ? false : Jvm.toInt(n) == 72) {
                this._gthis.notifyStatus(MpnSubscriptionStatus.Unknown, null);
                this._gthis.notifyOnUnsubscription();
                this._gthis.notifyOnSubscriptionsUpdated();
                this._gthis.finalize();
                this._gthis.state.s_m = 52;
                this._gthis.state.s_st = null;
                this._gthis.state.s_ct = null;
                this._gthis.state.s_ab = null;
                this._gthis.state.traceState();
            }
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_encodeWS_0
    extends Function
    implements FormatSchema,
    Named,
    PrivilegedAction<String>,
    ProtocolFamily,
    WatchEvent.Modifier,
    AttributeView,
    PrivilegedExceptionAction<String>,
    Callable<String>,
    Supplier<String>,
    Function0<String> {
        public final MpnSubscriptionManager _gthis;

        public Closure_encodeWS_0(MpnSubscriptionManager _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public String invoke() {
            return "control\r\n" + this._gthis.encode(true);
        }

        @Override
        public String get() {
            return this.invoke();
        }

        @Override
        public String call() {
            return this.invoke();
        }

        @Override
        public String run() {
            return this.invoke();
        }

        @Override
        public String name() {
            return this.invoke();
        }

        public String getName() {
            return this.invoke();
        }

        public String getSchemaType() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_evtDeviceActive_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final MpnSubscriptionManager _gthis;

        public Closure_evtDeviceActive_0(MpnSubscriptionManager _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public void invoke() {
            this._gthis.traceEvent("device.active");
            if (this._gthis.state.s_m == 41) {
                this._gthis.state.s_m = 42;
                this._gthis.state.traceState();
                this._gthis.genSendSubscribe();
            }
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_evtMPNOK_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final MpnSubscriptionManager _gthis;
        public final String mpnSubId;

        /*
         * WARNING - void declaration
         */
        public Closure_evtMPNOK_0(MpnSubscriptionManager _gthis, String string) {
            void mpnSubId;
            this._gthis = _gthis;
            this.mpnSubId = mpnSubId;
        }

        @Override
        public void invoke() {
            this._gthis.traceEvent("MPNOK");
            if (this._gthis.state.s_m == 42) {
                this._gthis.doMPNOK(this.mpnSubId);
                this._gthis.notifyStatus(MpnSubscriptionStatus.Subscribed, null);
                this._gthis.notifyOnSubscription();
                this._gthis.notifyOnSubscriptionsUpdated();
                this._gthis.state.s_m = 44;
                this._gthis.state.s_st = 60;
                this._gthis.state.s_ct = 70;
                this._gthis.state.s_ab = 80;
                this._gthis.state.traceState();
                this._gthis.evtCheck();
                return;
            }
            if (this._gthis.state.s_m == 43) {
                this._gthis.doMPNOK(this.mpnSubId);
                this._gthis.notifyStatus(MpnSubscriptionStatus.Subscribed, null);
                this._gthis.notifyOnSubscription();
                this._gthis.notifyOnSubscriptionsUpdated();
                this._gthis.state.s_m = 44;
                this._gthis.state.s_st = 60;
                this._gthis.state.s_ct = 70;
                this._gthis.state.s_ab = 80;
                this._gthis.state.traceState();
                this._gthis.evtCheck();
            }
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    @ClassReflectionInformation(hasSuperClass=false)
    public static class State
    extends haxe.jvm.Object {
        public int s_m;
        public int s_uu;
        public int s_fu;
        public int s_tu;
        public Integer s_st;
        public Integer s_ab;
        public Integer s_ct;
        public MpnSubscriptionManager manager;

        public String toString() {
            String s = "<m=" + this.s_m;
            s = Jvm.stringConcat(s, " uu=" + this.s_uu);
            s = Jvm.stringConcat(s, " fu=" + this.s_fu);
            s = Jvm.stringConcat(s, " tu=" + this.s_tu);
            if (this.s_st != null) {
                s = Jvm.stringConcat(s, " st=" + this.s_st);
            }
            if (this.s_ab != null) {
                s = Jvm.stringConcat(s, " ab=" + this.s_ab);
            }
            if (this.s_ct != null) {
                s = Jvm.stringConcat(s, " ct=" + this.s_ct);
            }
            s = Jvm.stringConcat(s, ">");
            return s;
        }

        public void traceState() {
            if (LoggerTools_Fields_.internalLogger.isTraceEnabled()) {
                LoggerTools_Fields_.internalLogger.trace("mpn#sub#goto(" + this.manager.m_subId + ":" + this.manager.fetch_mpnSubId() + ") " + this.toString(), null);
            }
        }

        public State(int m, MpnSubscriptionManager manager) {
            this.s_uu = 10;
            this.s_fu = 20;
            this.s_tu = 30;
            this.s_m = m;
            this.manager = manager;
        }

        public /* synthetic */ State(EmptyConstructor _) {
        }
    }

    public static final class Closure_evtExtMpnSetTrigger_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final MpnSubscriptionManager _gthis;

        public Closure_evtExtMpnSetTrigger_0(MpnSubscriptionManager _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public void invoke() {
            this._gthis.traceEvent("setTrigger");
            boolean forward = true;
            if (this._gthis.state.s_tu == 30) {
                this._gthis.state.s_tu = 31;
                this._gthis.state.traceState();
                forward = this._gthis.evtExtMpnSetTrigger_ControlRegion();
            } else if (this._gthis.state.s_tu == 32) {
                this._gthis.state.s_tu = 33;
                this._gthis.state.traceState();
                forward = this._gthis.evtExtMpnSetTrigger_ControlRegion();
            }
            if (forward) {
                this._gthis.evtExtMpnSetTrigger_ControlRegion();
            }
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_evtAbortFormat_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final MpnSubscriptionManager _gthis;

        public Closure_evtAbortFormat_0(MpnSubscriptionManager _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public void invoke() {
            this._gthis.traceEvent("abort.format");
            switch (this._gthis.state.s_fu) {
                default: {
                    return;
                }
                case 21: 
                case 22: 
                case 23: 
            }
            this._gthis.notifyOnModificationAbort_Format();
            this._gthis.state.s_fu = 20;
            this._gthis.state.traceState();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_isPending_0
    extends Function
    implements MessageQueue.IdleHandler,
    PrivilegedAction<Boolean>,
    PrivilegedExceptionAction<Boolean>,
    Callable<Boolean>,
    Supplier<Boolean>,
    ClassReflectionInformation,
    Function0<Boolean> {
        public final MpnSubscriptionManager _gthis;

        public Closure_isPending_0(MpnSubscriptionManager _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public boolean invoke() {
            if (this._gthis.state.s_m != 42) {
                Integer n = this._gthis.state.s_ct;
                if (n == null ? true : Jvm.toInt(n) != 72) {
                    Integer n2 = this._gthis.state.s_ct;
                    if (n2 == null ? true : Jvm.toInt(n2) != 73) {
                        Integer n3 = this._gthis.state.s_ct;
                        return n3 == null ? false : Jvm.toInt(n3) == 74;
                    }
                }
            }
            return true;
        }

        @Override
        public boolean hasSuperClass() {
            return this.invoke();
        }

        @Override
        public boolean get() {
            return this.invoke();
        }

        @Override
        public boolean call() {
            return this.invoke();
        }

        @Override
        public boolean run() {
            return this.invoke();
        }

        public boolean queueIdle() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_evtChangeFormat_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final MpnSubscriptionManager _gthis;

        public Closure_evtChangeFormat_0(MpnSubscriptionManager _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public void invoke() {
            this._gthis.traceEvent("change.format");
            if (this._gthis.state.s_fu == 21) {
                this._gthis.doSetCurrentFormat();
                this._gthis.state.s_fu = 22;
                this._gthis.state.traceState();
            }
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    @EnumReflectionInformation(constructorNames={"Ctor1", "Ctor2"})
    public static abstract class CtorArgs
    extends Enum {
        /*
         * WARNING - void declaration
         */
        protected CtorArgs(int n, String string) {
            void name;
            void index;
        }

        /*
         * WARNING - void declaration
         */
        public static CtorArgs Ctor1(LSMpnSubscription lSMpnSubscription, boolean bl, MpnClientMachine mpnClientMachine) {
            void client;
            void coalescing;
            LSMpnSubscription sub;
            return new Ctor1(sub, (boolean)coalescing, (MpnClientMachine)client);
        }

        /*
         * WARNING - void declaration
         */
        public static CtorArgs Ctor2(String string, MpnClientMachine mpnClientMachine) {
            void client;
            String mpnSubId;
            return new Ctor2(mpnSubId, (MpnClientMachine)client);
        }

        @EnumValueReflectionInformation(argumentNames={"mpnSubId", "client"})
        public static final class Ctor2
        extends CtorArgs {
            public final String mpnSubId;
            public final MpnClientMachine client;

            /*
             * WARNING - void declaration
             */
            public Ctor2(String string, MpnClientMachine mpnClientMachine) {
                void client;
                void mpnSubId;
                this.mpnSubId = mpnSubId;
                this.client = client;
            }

            @Override
            public /* synthetic */ Object[] _hx_getParameters() {
                return new Object[]{this.mpnSubId, this.client};
            }

            public boolean equals(Enum other) {
                if (!(other instanceof Ctor2)) {
                    return false;
                }
                Ctor2 other2 = (Ctor2)other;
                if (other2.ordinal() != this.ordinal()) {
                    return false;
                }
                if (Jvm.stringCompare(other2.mpnSubId, this.mpnSubId) != 0) {
                    return false;
                }
                return other2.client == this.client;
            }
        }

        @EnumValueReflectionInformation(argumentNames={"sub", "coalescing", "client"})
        public static final class Ctor1
        extends CtorArgs {
            public final LSMpnSubscription sub;
            public final boolean coalescing;
            public final MpnClientMachine client;

            /*
             * WARNING - void declaration
             */
            public Ctor1(LSMpnSubscription lSMpnSubscription, boolean bl, MpnClientMachine mpnClientMachine) {
                void client;
                void coalescing;
                void sub;
                this.sub = sub;
                this.coalescing = coalescing;
                this.client = client;
            }

            @Override
            public /* synthetic */ Object[] _hx_getParameters() {
                return new Object[]{this.sub, this.coalescing, this.client};
            }

            public boolean equals(Enum other) {
                if (!(other instanceof Ctor1)) {
                    return false;
                }
                Ctor1 other2 = (Ctor1)other;
                if (other2.ordinal() != this.ordinal()) {
                    return false;
                }
                if (other2.sub != this.sub) {
                    return false;
                }
                if (other2.coalescing != this.coalescing) {
                    return false;
                }
                return other2.client == this.client;
            }
        }
    }

    public static final class Closure_evtAbort_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final MpnSubscriptionManager _gthis;

        public Closure_evtAbort_0(MpnSubscriptionManager _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public void invoke() {
            this._gthis.traceEvent("abort");
            if (this._gthis.state.s_m == 41) {
                this._gthis.notifyStatus(MpnSubscriptionStatus.Unknown, null);
                this._gthis.notifyOnSubscriptionDiscarded();
                this._gthis.finalize();
                this._gthis.state.s_m = 50;
                this._gthis.state.traceState();
                return;
            }
            if (this._gthis.state.s_m == 42 || this._gthis.state.s_m == 43) {
                this._gthis.notifyStatus(MpnSubscriptionStatus.Unknown, null);
                this._gthis.notifyOnSubscriptionAbort();
                this._gthis.finalize();
                this._gthis.state.s_m = 50;
                this._gthis.state.traceState();
                return;
            }
            if (this._gthis.state.s_m == 44) {
                this._gthis.state.s_m = 44;
                this._gthis.state.traceState();
                this._gthis.evtAbort_AbortRegion();
            }
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_evtREQOK_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final MpnSubscriptionManager _gthis;
        public final int reqId;

        /*
         * WARNING - void declaration
         */
        public Closure_evtREQOK_0(MpnSubscriptionManager _gthis, int n) {
            void reqId;
            this._gthis = _gthis;
            this.reqId = reqId;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void invoke() {
            this._gthis.traceEvent("REQOK");
            forward = true;
            if (this._gthis.state.s_fu != 22) ** GOTO lbl-1000
            v0 = this._gthis.m_lastConfigureReqId;
            if (v0 == null ? false : this.reqId == Jvm.toInt(v0)) {
                this._gthis.state.s_fu = 20;
                this._gthis.state.traceState();
                forward = this._gthis.evtREQOK_TriggerRegion(this.reqId);
            } else if (this._gthis.state.s_fu == 23) {
                v1 = this._gthis.m_lastConfigureReqId;
                if (v1 == null ? false : this.reqId == Jvm.toInt(v1)) {
                    this._gthis.state.s_fu = 21;
                    this._gthis.state.traceState();
                    forward = this._gthis.evtREQOK_TriggerRegion(this.reqId);
                }
            }
            if (forward) {
                this._gthis.evtREQOK_TriggerRegion(this.reqId);
            }
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_evtAbortTrigger_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final MpnSubscriptionManager _gthis;

        public Closure_evtAbortTrigger_0(MpnSubscriptionManager _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public void invoke() {
            this._gthis.traceEvent("abort.trigger");
            switch (this._gthis.state.s_tu) {
                default: {
                    return;
                }
                case 31: 
                case 32: 
                case 33: 
            }
            this._gthis.notifyOnModificationAbort_Trigger();
            this._gthis.state.s_tu = 30;
            this._gthis.state.traceState();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }
}

