/*
 * Decompiled with CFR 0.152.
 */
package haxe.root;

import haxe.jvm.DynamicObject;
import haxe.jvm.EmptyConstructor;
import haxe.jvm.Function;
import haxe.jvm.Jvm;
import haxe.jvm.Object;
import haxe.jvm.annotation.ClassReflectionInformation;
import haxe.jvm.annotation.EnumReflectionInformation;
import haxe.jvm.annotation.EnumValueReflectionInformation;
import haxe.root.Array;
import haxe.root.ValueType;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

@ClassReflectionInformation(hasSuperClass=false)
public class Type
extends Object {
    public static <T> boolean isEnumValueClass(Class<T> c) {
        return c.isAnnotationPresent(EnumValueReflectionInformation.class);
    }

    public static <T> Class<T> getClass(T o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Class) {
            return null;
        }
        Class<?> c = o.getClass();
        if (Type.isEnumValueClass(c)) {
            return null;
        }
        if (c == DynamicObject.class || o instanceof DynamicObject) {
            return null;
        }
        return c;
    }

    public static Class getEnum(Enum o) {
        if (o == null) {
            return null;
        }
        Class<?> c = o.getClass().getSuperclass();
        if (!c.isAnnotationPresent(EnumReflectionInformation.class)) {
            return null;
        }
        return c;
    }

    public static Class getSuperClass(Class c) {
        if (c == String.class) {
            return null;
        }
        Class c2 = c;
        Class cSuper = c2.getSuperclass();
        if (cSuper == null) {
            return null;
        }
        ClassReflectionInformation annotation = c2.getAnnotation(ClassReflectionInformation.class);
        if (annotation != null && !annotation.hasSuperClass()) {
            return null;
        }
        return cSuper;
    }

    public static <T> Array<String> getFields(Class<T> c, boolean statics) {
        int _g;
        Array<String> ret = Array.ofNative(new String[0]);
        AccessibleObject[] _g1 = c.getDeclaredFields();
        for (_g = 0; _g < _g1.length; ++_g) {
            Field f = _g1[_g];
            if (Modifier.isStatic(f.getModifiers()) != statics || f.isSynthetic()) continue;
            ret.push(f.getName());
        }
        _g1 = c.getDeclaredMethods();
        for (_g = 0; _g < _g1.length; ++_g) {
            AccessibleObject m = _g1[_g];
            if (Modifier.isStatic(((Method)m).getModifiers()) != statics || ((Method)m).isSynthetic()) continue;
            ret.push(((Method)m).getName());
        }
        return ret;
    }

    public static Array getInstanceFields(Class c) {
        Array<String> fields = Array.ofNative(new String[0]);
        while (c != null) {
            Array<String> _g1 = fields.concat(Type.getFields(c, false));
            for (int _g = 0; _g < _g1.length; ++_g) {
                String field = _g1.__get(_g);
                if (fields.indexOf(field, null) != -1) continue;
                fields.push(field);
            }
            c = Type.getSuperClass(c);
        }
        return fields;
    }

    public static Array getClassFields(Class c) {
        return Type.getFields(c, true);
    }

    public static Array getEnumConstructs(Class e) {
        Class<EnumReflectionInformation> clInfo = EnumReflectionInformation.class;
        EnumReflectionInformation annotation = e.getAnnotation(clInfo);
        if (annotation != null) {
            return Array.ofNative((java.lang.Object[])annotation.constructorNames());
        }
        Enum[] vals = (Enum[])((Function)Jvm.readField(e, "values")).invoke();
        Array<String> ret = Array.ofNative(new String[0]);
        int _g = 0;
        int _g1 = vals.length;
        while (_g < _g1) {
            int i = _g++;
            ret.__set(i, vals[i].name());
        }
        return ret;
    }

    public static ValueType typeof(java.lang.Object v) {
        if (v == null) {
            return ValueType.TNull;
        }
        if (v instanceof Number) {
            Number v2 = (Number)v;
            if ((double)v2.intValue() == v2.doubleValue()) {
                return ValueType.TInt;
            }
            return ValueType.TFloat;
        }
        if (v instanceof Boolean) {
            return ValueType.TBool;
        }
        if (v instanceof DynamicObject) {
            return ValueType.TObject;
        }
        if (v instanceof Function) {
            return ValueType.TFunction;
        }
        Class<?> c = v.getClass();
        if (Type.isEnumValueClass(c)) {
            return ValueType.TEnum(c.getSuperclass());
        }
        if (v instanceof Class) {
            return ValueType.TObject;
        }
        return ValueType.TClass(c);
    }

    public static <T> boolean enumEq(T a, T b) {
        if (a == null) {
            return b == null;
        }
        haxe.jvm.Enum a2 = (haxe.jvm.Enum)((java.lang.Object)a);
        haxe.jvm.Enum b2 = (haxe.jvm.Enum)((java.lang.Object)b);
        return a2.equals(b2);
    }

    public static Array enumParameters(Enum e) {
        java.lang.Object[] a = ((haxe.jvm.Enum)e)._hx_getParameters();
        return Array.ofNative(a);
    }

    public static int enumIndex(Enum e) {
        return e.ordinal();
    }

    public /* synthetic */ Type(EmptyConstructor _) {
    }
}

