/*
 * Decompiled with CFR 0.152.
 */
package com.lightstreamer.log._ConsoleLoggerProvider;

import com.lightstreamer.log.AbstractLogger;
import com.lightstreamer.log.LSConsoleLogLevel;
import haxe.Exception;
import haxe.jvm.EmptyConstructor;
import haxe.jvm.annotation.ClassReflectionInformation;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

@ClassReflectionInformation(hasSuperClass=true)
public class ConsoleLogger
extends AbstractLogger {
    public int level;
    public String category;
    public boolean traceEnabled;
    public boolean debugEnabled;
    public boolean infoEnabled;
    public boolean warnEnabled;
    public boolean errorEnabled;
    public boolean fatalEnabled;

    public void printLog(String msg) {
        System.out.println((Object)msg);
    }

    public String format(String level, String line) {
        String javaTime = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS"));
        String msg = "" + javaTime + "|" + level + "|" + this.category + "|" + Thread.currentThread().getName() + "|" + line;
        return msg;
    }

    public void logFatal(String msg) {
        System.out.println((Object)msg);
    }

    public void logError(String msg) {
        System.out.println((Object)msg);
    }

    public void logWarn(String msg) {
        System.out.println((Object)msg);
    }

    public void logInfo(String msg) {
        System.out.println((Object)msg);
    }

    public void logDebug(String msg) {
        System.out.println((Object)msg);
    }

    public void logTrace(String msg) {
        System.out.println((Object)msg);
    }

    @Override
    public void fatal(String line, Throwable exception) {
        if (this.fatalEnabled) {
            System.out.println((Object)this.format("FATAL", line));
            if (exception != null) {
                System.out.println((Object)Exception.caught(exception).details());
            }
        }
    }

    @Override
    public void error(String line, Throwable exception) {
        if (this.errorEnabled) {
            System.out.println((Object)this.format("ERROR", line));
            if (exception != null) {
                System.out.println((Object)Exception.caught(exception).details());
            }
        }
    }

    @Override
    public void warn(String line, Throwable exception) {
        if (this.warnEnabled) {
            System.out.println((Object)this.format("WARN ", line));
            if (exception != null) {
                System.out.println((Object)Exception.caught(exception).details());
            }
        }
    }

    @Override
    public void info(String line, Throwable exception) {
        if (this.infoEnabled) {
            System.out.println((Object)this.format("INFO ", line));
            if (exception != null) {
                System.out.println((Object)Exception.caught(exception).details());
            }
        }
    }

    @Override
    public void debug(String line, Throwable exception) {
        if (this.debugEnabled) {
            System.out.println((Object)this.format("DEBUG", line));
            if (exception != null) {
                System.out.println((Object)Exception.caught(exception).details());
            }
        }
    }

    @Override
    public void trace(String line, Throwable exception) {
        if (this.traceEnabled) {
            System.out.println((Object)this.format("TRACE", line));
            if (exception != null) {
                System.out.println((Object)Exception.caught(exception).details());
            }
        }
    }

    @Override
    public boolean isFatalEnabled() {
        return this.fatalEnabled;
    }

    @Override
    public boolean isErrorEnabled() {
        return this.errorEnabled;
    }

    @Override
    public boolean isWarnEnabled() {
        return this.warnEnabled;
    }

    @Override
    public boolean isInfoEnabled() {
        return this.infoEnabled;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    @Override
    public boolean isTraceEnabled() {
        return this.traceEnabled;
    }

    public ConsoleLogger(int level, String category) {
        super(null);
        this.level = level;
        this.category = category;
        this.traceEnabled = level <= LSConsoleLogLevel.TRACE;
        this.debugEnabled = level <= LSConsoleLogLevel.DEBUG;
        this.infoEnabled = level <= LSConsoleLogLevel.INFO;
        this.warnEnabled = level <= LSConsoleLogLevel.WARN;
        this.errorEnabled = level <= LSConsoleLogLevel.ERROR;
        this.fatalEnabled = level <= LSConsoleLogLevel.FATAL;
    }

    public /* synthetic */ ConsoleLogger(EmptyConstructor _) {
        super(_);
    }
}

