/*
 * Decompiled with CFR 0.152.
 */
package com.lightstreamer.internal.patch;

import haxe.Exception;
import haxe.jvm.EmptyConstructor;
import haxe.jvm.Jvm;
import haxe.jvm.StringExt;
import haxe.jvm.annotation.ClassReflectionInformation;
import haxe.root.StringBuf;

@ClassReflectionInformation(hasSuperClass=false)
public class DiffDecoder
extends haxe.jvm.Object {
    public static int VARINT_RADIX = 26;
    public String diff;
    public String base;
    public int diffPos;
    public int basePos;
    public StringBuf buf;

    public static String apply(String base, String diff) {
        return new DiffDecoder(base, diff).decode();
    }

    public String decode() {
        try {
            while (this.diffPos != this.diff.length()) {
                this.applyCopy();
                if (this.diffPos == this.diff.length()) break;
                this.applyAdd();
                if (this.diffPos == this.diff.length()) break;
                this.applyDel();
            }
            return this.buf.toString();
        }
        catch (Throwable _g) {
            throw new Exception("Bad TLCP-diff", Exception.caught(_g), null);
        }
    }

    public void applyCopy() {
        int count = this.decodeVarint();
        if (count > 0) {
            this.appendToBuf(this.base, this.basePos, count);
            this.basePos += count;
        }
    }

    public void applyAdd() {
        int count = this.decodeVarint();
        if (count > 0) {
            this.appendToBuf(this.diff, this.diffPos, count);
            this.diffPos += count;
        }
    }

    public void applyDel() {
        int count = this.decodeVarint();
        if (count > 0) {
            this.basePos += count;
        }
    }

    public int decodeVarint() {
        int c;
        int n = 0;
        while (true) {
            c = this.charAt(this.diff, this.diffPos);
            ++this.diffPos;
            if (c >= 97 && c < 123) {
                return n * 26 + (c - 97);
            }
            if (c < 65 || c >= 91) break;
            n = n * 26 + (c - 65);
        }
        throw new Exception("The code point " + c + " is not in the range A-Z", null, null);
    }

    public void appendToBuf(String s, int startIndex, int count) {
        if (startIndex + count <= s.length()) {
            this.buf.addSub(s, startIndex, count);
            return;
        }
        throw new Exception("Index out of range: startIndex=" + startIndex + " count=" + count + " length=" + s.length(), null, null);
    }

    public int charAt(String s, int pos) {
        if (pos < s.length()) {
            return Jvm.toInt(StringExt.charCodeAt(StringExt.charAt(s, pos), 0));
        }
        throw new Exception("Index out of range: pos=" + pos + " length=" + s.length(), null, null);
    }

    public DiffDecoder(String base, String diff) {
        this.diffPos = 0;
        this.basePos = 0;
        this.buf = new StringBuf();
        this.diff = diff;
        this.base = base;
    }

    public /* synthetic */ DiffDecoder(EmptyConstructor _) {
    }
}

