/*
 * Decompiled with CFR 0.152.
 */
package hx.concurrent.lock;

import haxe.Exception;
import haxe.java.vm.Mutex;
import haxe.jvm.EmptyConstructor;
import haxe.jvm.Function;
import haxe.jvm.Jvm;
import haxe.jvm.annotation.ClassReflectionInformation;
import hx.concurrent.lock.AbstractAcquirable;
import hx.concurrent.thread.Threads;

@ClassReflectionInformation(hasSuperClass=true)
public class RLock
extends AbstractAcquirable {
    public static boolean isSupported = true;
    public Mutex _rlock;
    public Object _holder;
    public int _holderEntranceCount;

    @Override
    public int get_availablePermits() {
        if (this._holder != null) {
            return 0;
        }
        return 1;
    }

    public boolean get_isAcquiredByAnyThread() {
        return this._holder != null;
    }

    public boolean get_isAcquiredByCurrentThread() {
        return Jvm.compare(this._holder, Threads.get_current()) == 0;
    }

    public boolean get_isAcquiredByOtherThread() {
        if (this._holder != null) {
            return Jvm.compare(this._holder, Threads.get_current()) != 0;
        }
        return false;
    }

    @Override
    public void acquire() {
        this._rlock.acquire();
        this._holder = Threads.get_current();
        ++this._holderEntranceCount;
    }

    @Override
    public boolean tryAcquire(Integer timeoutMS) throws Object {
        int timeoutMS2;
        int n = timeoutMS2 = timeoutMS == null ? 0 : Jvm.toInt(timeoutMS);
        if (timeoutMS2 < 0) {
            throw (RuntimeException)Exception.thrown("[timeoutMS] must be >= 0");
        }
        RLock _gthis = this;
        if (Threads.await(new Closure_tryAcquire_0(_gthis), timeoutMS2, null)) {
            this._holder = Threads.get_current();
            ++this._holderEntranceCount;
            return true;
        }
        return false;
    }

    public boolean tryAcquireInternal(Integer timeoutMS) {
        int timeoutMS2 = timeoutMS == null ? 0 : Jvm.toInt(timeoutMS);
        RLock _gthis = this;
        return Threads.await(new Closure_tryAcquireInternal_0(_gthis), timeoutMS2, null);
    }

    @Override
    public void release() throws Object {
        if (Jvm.compare(this._holder, Threads.get_current()) == 0) {
            --this._holderEntranceCount;
            if (this._holderEntranceCount == 0) {
                this._holder = null;
            }
        } else {
            if (this._holder != null && Jvm.compare(this._holder, Threads.get_current()) != 0) {
                throw (RuntimeException)Exception.thrown("Lock was aquired by another thread!");
            }
            throw (RuntimeException)Exception.thrown("Lock was not aquired by any thread!");
        }
        this._rlock.release();
    }

    public RLock() {
        this._rlock = new Mutex();
        this._holder = null;
        this._holderEntranceCount = 0;
        super(null);
    }

    public /* synthetic */ RLock(EmptyConstructor _) {
        super(_);
    }

    public static final class Closure_tryAcquire_0
    extends Function {
        public final RLock _gthis;

        public Closure_tryAcquire_0(RLock _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public boolean invoke() {
            return this._gthis._rlock.tryAcquire();
        }
    }

    public static final class Closure_tryAcquireInternal_0
    extends Function {
        public final RLock _gthis;

        public Closure_tryAcquireInternal_0(RLock _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public boolean invoke() {
            return this._gthis._rlock.tryAcquire();
        }
    }
}

