/*
 * Decompiled with CFR 0.152.
 */
package hx.concurrent.executor;

import haxe.Exception;
import haxe.jvm.EmptyConstructor;
import haxe.jvm.Enum;
import haxe.jvm.Function;
import haxe.jvm.Jvm;
import haxe.jvm.annotation.ClassReflectionInformation;
import haxe.root.Array;
import haxe.root.Std;
import haxe.root.Sys;
import hx.concurrent.ConcurrentException;
import hx.concurrent.ServiceState;
import hx.concurrent.collection.Queue;
import hx.concurrent.executor.AbstractTaskFuture;
import hx.concurrent.executor.Executor;
import hx.concurrent.executor.Schedule;
import hx.concurrent.executor.ScheduleTools;
import hx.concurrent.executor.TaskFuture;
import hx.concurrent.internal.Either2;
import hx.concurrent.thread.ThreadContext;
import hx.concurrent.thread.ThreadPool;
import hx.concurrent.thread.Threads;
import java.util.function.Consumer;
import sys.thread.Thread;

@ClassReflectionInformation(hasSuperClass=true)
public class ThreadPoolExecutor
extends Executor {
    public static int SCHEDULER_RESOLUTION_MS = 10;
    public static double SCHEDULER_RESOLUTION_SEC = 0.01;
    public ThreadPool _threadPool;
    public Array<TaskFutureImpl<Object>> _scheduledTasks;
    public Queue<TaskFutureImpl<Object>> _newScheduledTasks;

    @Override
    public void onStart() {
        this.set_state(ServiceState.RUNNING);
        ThreadPoolExecutor _gthis = this;
        Thread.HaxeThread.create(new Closure_onStart_0(_gthis), false);
    }

    @Override
    public <T> TaskFuture<T> submit(Either2._Either2<Function, Function> task, Schedule schedule) {
        Schedule schedule2 = schedule == null ? Executor.NOW_ONCE : schedule;
        ThreadPoolExecutor _gthis = this;
        return (TaskFutureImpl)this._stateLock.execute(new Closure_submit_0(_gthis, task, schedule2), null);
    }

    @Override
    public void stop() {
        ThreadPoolExecutor _gthis = this;
        this._stateLock.execute(new Closure_stop_0(_gthis), null);
    }

    public ThreadPoolExecutor(int threadPoolSize, Boolean autostart) throws Object {
        boolean autostart2;
        this._scheduledTasks = new Array();
        this._newScheduledTasks = new Queue();
        boolean bl = autostart2 = autostart == null ? true : Jvm.toBoolean(autostart);
        if (threadPoolSize < 1) {
            throw (RuntimeException)Exception.thrown("[threadPoolSize] must be > 0");
        }
        this._threadPool = new ThreadPool(threadPoolSize, autostart2);
        if (autostart2) {
            this.start();
        }
    }

    public /* synthetic */ ThreadPoolExecutor(EmptyConstructor _) {
        super(_);
    }

    @ClassReflectionInformation(hasSuperClass=true)
    public static class TaskFutureImpl<T>
    extends AbstractTaskFuture<T> {
        public double _nextRunAt;

        public boolean isDue() {
            if (this.isStopped || this._nextRunAt == -1.0) {
                return false;
            }
            if ((double)System.currentTimeMillis() >= this._nextRunAt) {
                Schedule _g = this.schedule;
                switch (_g.ordinal()) {
                    case 0: {
                        this._nextRunAt = -1.0;
                        break;
                    }
                    case 1: {
                        this._nextRunAt = -1.0;
                        break;
                    }
                    case 2: {
                        this._nextRunAt += (double)((Schedule.FIXED_RATE)_g).intervalMS;
                        break;
                    }
                    case 3: {
                        this._nextRunAt += 3600000.0;
                        break;
                    }
                    case 4: {
                        this._nextRunAt += 8.64E7;
                        break;
                    }
                    case 5: {
                        this._nextRunAt += 6.048E8;
                    }
                }
                return true;
            }
            return false;
        }

        public void run() {
            Enum _g;
            if (this.isStopped) {
                return;
            }
            Either2._Either2 fnResult = null;
            try {
                _g = this._task;
                switch (_g.ordinal()) {
                    case 0: {
                        fnResult = Either2._Either2.a(((Function)((Either2._Either2.a)_g).v).invoke());
                        break;
                    }
                    case 1: {
                        ((Function)((Either2._Either2.b)_g).v).invoke();
                        fnResult = null;
                    }
                }
            }
            catch (Throwable _g2) {
                fnResult = Either2._Either2.b(new ConcurrentException(Exception.caught(_g2)));
            }
            _g = this.schedule;
            switch (_g.ordinal()) {
                default: {
                    break;
                }
                case 0: {
                    this.isStopped = true;
                    break;
                }
                case 1: {
                    this._nextRunAt = (double)System.currentTimeMillis() + (double)((Schedule.FIXED_DELAY)_g).intervalMS;
                }
            }
            this.complete(fnResult, true);
            this._executor.notifyResult(this.result);
        }

        public TaskFutureImpl(ThreadPoolExecutor executor, Either2._Either2<Function, Function> task, Schedule schedule) {
            super(executor, task, schedule);
            this._nextRunAt = ScheduleTools.firstRunAt(this.schedule);
        }

        public /* synthetic */ TaskFutureImpl(EmptyConstructor _) {
            super(_);
        }
    }

    public static final class Closure_submit_0
    extends Function {
        public final ThreadPoolExecutor _gthis;
        public final Either2._Either2 task;
        public final Schedule schedule;

        /*
         * WARNING - void declaration
         */
        public Closure_submit_0(ThreadPoolExecutor _gthis, Either2._Either2 _Either22, Schedule schedule) {
            void schedule2;
            void task;
            this._gthis = _gthis;
            this.task = task;
            this.schedule = schedule2;
        }

        @Override
        public TaskFutureImpl invoke() throws Object {
            if (this._gthis.state != ServiceState.RUNNING) {
                throw (RuntimeException)Exception.thrown("Cannot accept new tasks. Executor is not in state [RUNNING] but [" + Std.string((Object)this._gthis.state) + "].");
            }
            TaskFutureImpl future = new TaskFutureImpl(this._gthis, (Either2._Either2<Function, Function>)this.task, this.schedule);
            switch (this.schedule.ordinal()) {
                default: {
                    break;
                }
                case 0: {
                    if (!future.isDue()) break;
                    this._gthis._threadPool.submit(new Closure_invoke_0(future));
                    return future;
                }
            }
            this._gthis._newScheduledTasks.push(future);
            return future;
        }

        public static final class Closure_invoke_0
        extends Function
        implements java.util.function.Function<Object, Object>,
        Consumer<ThreadContext> {
            public final TaskFutureImpl future;

            public Closure_invoke_0(TaskFutureImpl future) {
                this.future = future;
            }

            public void invoke(ThreadContext ctx) {
                this.future.run();
            }

            @Override
            public void accept(ThreadContext arg0) {
                this.invoke(arg0);
            }

            @Override
            public void accept(Object arg0) {
                this.invoke(arg0);
            }

            @Override
            public Object apply(Object arg0) {
                return this.invoke(arg0);
            }
        }
    }

    public static final class Closure_onStart_0
    extends Function
    implements Runnable {
        public final ThreadPoolExecutor _gthis;

        public Closure_onStart_0(ThreadPoolExecutor _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public void invoke() {
            TaskFutureImpl<Object> t;
            TaskFutureImpl<Object> t2;
            Array<TaskFutureImpl<Object>> _g1;
            Array<TaskFutureImpl<Object>> doneTasks = new Array<TaskFutureImpl<Object>>();
            while (this._gthis.state == ServiceState.RUNNING) {
                TaskFutureImpl<Object> t3;
                TaskFutureImpl<Object> t4;
                int _g;
                _g1 = this._gthis._scheduledTasks;
                for (_g = 0; _g < _g1.length; ++_g) {
                    t2 = _g1.__get(_g);
                    if (!t2.isDue()) continue;
                    this._gthis._threadPool.submit(new Closure_invoke_0(t2));
                }
                if (doneTasks.length > 0) {
                    for (_g = 0; _g < doneTasks.length; ++_g) {
                        TaskFutureImpl t5 = (TaskFutureImpl)doneTasks.__get(_g);
                        this._gthis._scheduledTasks.remove(t5);
                    }
                    doneTasks.resize(0);
                }
                if ((t4 = this._gthis._newScheduledTasks.pop(null)) == null) {
                    Sys.sleep(0.01);
                    continue;
                }
                double startAt = System.currentTimeMillis();
                this._gthis._scheduledTasks.push(t4);
                while (!((double)System.currentTimeMillis() - startAt > 10.0) && (t3 = this._gthis._newScheduledTasks.pop(null)) != null) {
                    this._gthis._scheduledTasks.push(t3);
                }
            }
            _g1 = this._gthis._scheduledTasks;
            for (int _g = 0; _g < _g1.length; ++_g) {
                t2 = _g1.__get(_g);
                t2.cancel();
            }
            while ((t = this._gthis._newScheduledTasks.pop(null)) != null) {
                t.cancel();
            }
            Threads.await(new Closure_invoke_1(this._gthis), -1, null);
            this._gthis.set_state(ServiceState.STOPPED);
        }

        @Override
        public void run() {
            this.invoke();
        }

        public static final class Closure_invoke_1
        extends Function {
            public final ThreadPoolExecutor _gthis;

            public Closure_invoke_1(ThreadPoolExecutor _gthis) {
                this._gthis = _gthis;
            }

            @Override
            public boolean invoke() {
                return this._gthis._threadPool.state == ServiceState.STOPPED;
            }
        }

        public static final class Closure_invoke_0
        extends Function
        implements java.util.function.Function<Object, Object>,
        Consumer<ThreadContext> {
            public final TaskFutureImpl t;

            public Closure_invoke_0(TaskFutureImpl t) {
                this.t = t;
            }

            public void invoke(ThreadContext ctx) {
                this.t.run();
            }

            @Override
            public void accept(ThreadContext arg0) {
                this.invoke(arg0);
            }

            @Override
            public void accept(Object arg0) {
                this.invoke(arg0);
            }

            @Override
            public Object apply(Object arg0) {
                return this.invoke(arg0);
            }
        }
    }

    public static final class Closure_stop_0
    extends Function
    implements Runnable {
        public final ThreadPoolExecutor _gthis;

        public Closure_stop_0(ThreadPoolExecutor _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public void invoke() {
            if (this._gthis.state == ServiceState.RUNNING) {
                this._gthis.set_state(ServiceState.STOPPING);
                this._gthis._threadPool.stop();
            }
        }

        @Override
        public void run() {
            this.invoke();
        }
    }
}

