/*
 * Decompiled with CFR 0.152.
 */
package hx.concurrent.executor;

import haxe.Exception;
import haxe.jvm.EmptyConstructor;
import haxe.jvm.Jvm;
import haxe.jvm.Object;
import haxe.jvm.annotation.ClassReflectionInformation;
import haxe.root.Date;
import hx.concurrent.executor.Schedule;
import java.util.Calendar;

@ClassReflectionInformation(hasSuperClass=false)
public class ScheduleTools
extends Object {
    public static int HOUR_IN_MS = 3600000;
    public static int DAY_IN_MS = 86400000;
    public static int WEEK_IN_MS = 604800000;

    public static Schedule applyDefaults(Schedule schedule) {
        switch (schedule.ordinal()) {
            case 0: {
                if (((Schedule.ONCE)schedule).initialDelayMS != null) break;
                return Schedule.ONCE(0);
            }
            case 1: {
                if (((Schedule.FIXED_DELAY)schedule).initialDelayMS != null) break;
                return Schedule.FIXED_DELAY(((Schedule.FIXED_DELAY)schedule).intervalMS, 0);
            }
            case 2: {
                if (((Schedule.FIXED_RATE)schedule).initialDelayMS != null) break;
                return Schedule.FIXED_RATE(((Schedule.FIXED_RATE)schedule).intervalMS, 0);
            }
            case 3: {
                Integer _g = ((Schedule.HOURLY)schedule).minute;
                Integer _g1 = ((Schedule.HOURLY)schedule).second;
                if (_g != null && _g1 != null) break;
                return Schedule.HOURLY(_g == null ? Integer.valueOf(0) : _g, _g1 == null ? Integer.valueOf(0) : _g1);
            }
            case 4: {
                Integer _g = ((Schedule.DAILY)schedule).hour;
                Integer _g1 = ((Schedule.DAILY)schedule).minute;
                Integer _g2 = ((Schedule.DAILY)schedule).second;
                if (_g != null && _g1 != null && _g2 != null) break;
                return Schedule.DAILY(_g == null ? Integer.valueOf(0) : _g, _g1 == null ? Integer.valueOf(0) : _g1, _g2 == null ? Integer.valueOf(0) : _g2);
            }
            case 5: {
                Integer _g = ((Schedule.WEEKLY)schedule).day;
                Integer _g1 = ((Schedule.WEEKLY)schedule).hour;
                Integer _g2 = ((Schedule.WEEKLY)schedule).minute;
                Integer _g3 = ((Schedule.WEEKLY)schedule).second;
                if (_g != null && _g1 != null && _g2 != null && _g3 != null) break;
                return Schedule.WEEKLY(_g == null ? Integer.valueOf(0) : _g, _g1 == null ? Integer.valueOf(0) : _g1, _g2 == null ? Integer.valueOf(0) : _g2, _g3 == null ? Integer.valueOf(0) : _g3);
            }
        }
        return schedule;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Schedule assertValid(Schedule schedule) throws java.lang.Object {
        schedule = ScheduleTools.applyDefaults(schedule);
        switch (schedule.ordinal()) {
            case 0: {
                Integer n = ((Schedule.ONCE)schedule).initialDelayMS;
                if (!(n == null ? false : Jvm.toInt(n) < 0)) return schedule;
                throw (RuntimeException)Exception.thrown("[Schedule.ONCE.initialDelayMS] must be >= 0");
            }
            case 1: {
                Integer _g = ((Schedule.FIXED_DELAY)schedule).initialDelayMS;
                if (((Schedule.FIXED_DELAY)schedule).intervalMS <= 0) {
                    throw (RuntimeException)Exception.thrown("[Schedule.FIXED_DELAY.intervalMS] must be > 0");
                }
                if (_g == null) throw (RuntimeException)Exception.thrown("[Schedule.FIXED_DELAY.initialDelayMS] must be >= 0");
                Integer n = _g;
                if (!(n == null ? false : Jvm.toInt(n) < 0)) return schedule;
                throw (RuntimeException)Exception.thrown("[Schedule.FIXED_DELAY.initialDelayMS] must be >= 0");
            }
            case 2: {
                if (((Schedule.FIXED_RATE)schedule).intervalMS <= 0) {
                    throw (RuntimeException)Exception.thrown("[Schedule.FIXED_RATE.intervalMS] must be > 0");
                }
                Integer n = ((Schedule.FIXED_RATE)schedule).initialDelayMS;
                if (!(n == null ? false : Jvm.toInt(n) < 0)) return schedule;
                throw (RuntimeException)Exception.thrown("[Schedule.FIXED_RATE.initialDelayMS] must be >= 0");
            }
            case 3: {
                Integer _g = ((Schedule.HOURLY)schedule).minute;
                Integer _g1 = ((Schedule.HOURLY)schedule).second;
                if (_g == null) throw (RuntimeException)Exception.thrown("[Schedule.DAILY.minute] must be between >= 0 and <= 59");
                Integer n = _g;
                if (n == null ? false : Jvm.toInt(n) < 0) {
                    throw (RuntimeException)Exception.thrown("[Schedule.DAILY.minute] must be between >= 0 and <= 59");
                }
                if (_g1 == null) throw (RuntimeException)Exception.thrown("[Schedule.DAILY.second] must be between >= 0 and <= 59");
                Integer n2 = _g1;
                if (!(n2 == null ? false : Jvm.toInt(n2) < 0)) return schedule;
                throw (RuntimeException)Exception.thrown("[Schedule.DAILY.second] must be between >= 0 and <= 59");
            }
            case 4: {
                Integer _g = ((Schedule.DAILY)schedule).hour;
                Integer _g1 = ((Schedule.DAILY)schedule).minute;
                Integer _g2 = ((Schedule.DAILY)schedule).second;
                if (_g == null) throw (RuntimeException)Exception.thrown("[Schedule.DAILY.hour] must be between >= 0 and <= 23");
                Integer n = _g;
                if (n == null ? false : Jvm.toInt(n) < 0) {
                    throw (RuntimeException)Exception.thrown("[Schedule.DAILY.hour] must be between >= 0 and <= 23");
                }
                if (_g1 == null) throw (RuntimeException)Exception.thrown("[Schedule.DAILY.minute] must be between >= 0 and <= 59");
                Integer n3 = _g1;
                if (n3 == null ? false : Jvm.toInt(n3) < 0) {
                    throw (RuntimeException)Exception.thrown("[Schedule.DAILY.minute] must be between >= 0 and <= 59");
                }
                if (_g2 == null) throw (RuntimeException)Exception.thrown("[Schedule.DAILY.second] must be between >= 0 and <= 59");
                Integer n4 = _g2;
                if (!(n4 == null ? false : Jvm.toInt(n4) < 0)) return schedule;
                throw (RuntimeException)Exception.thrown("[Schedule.DAILY.second] must be between >= 0 and <= 59");
            }
            case 5: {
                Integer _g = ((Schedule.WEEKLY)schedule).hour;
                Integer _g1 = ((Schedule.WEEKLY)schedule).minute;
                Integer _g2 = ((Schedule.WEEKLY)schedule).second;
                if (_g == null) throw (RuntimeException)Exception.thrown("[Schedule.WEEKLY.hour] must be between >= 0 and <= 23");
                Integer n = _g;
                if (n == null ? false : Jvm.toInt(n) < 0) {
                    throw (RuntimeException)Exception.thrown("[Schedule.WEEKLY.hour] must be between >= 0 and <= 23");
                }
                if (_g1 == null) throw (RuntimeException)Exception.thrown("[Schedule.WEEKLY.minute] must be between >= 0 and <= 59");
                Integer n5 = _g1;
                if (n5 == null ? false : Jvm.toInt(n5) < 0) {
                    throw (RuntimeException)Exception.thrown("[Schedule.WEEKLY.minute] must be between >= 0 and <= 59");
                }
                if (_g2 == null) throw (RuntimeException)Exception.thrown("[Schedule.WEEKLY.second] must be between >= 0 and <= 59");
                Integer n6 = _g2;
                if (!(n6 == null ? false : Jvm.toInt(n6) < 0)) return schedule;
                throw (RuntimeException)Exception.thrown("[Schedule.WEEKLY.second] must be between >= 0 and <= 59");
            }
        }
        return schedule;
    }

    public static double firstRunAt(Schedule schedule) {
        schedule = ScheduleTools.assertValid(schedule);
        switch (schedule.ordinal()) {
            default: {
                throw haxe.jvm.Exception.wrap((java.lang.Object)"Match failure");
            }
            case 0: {
                return (double)System.currentTimeMillis() + Jvm.toDouble(((Schedule.ONCE)schedule).initialDelayMS);
            }
            case 1: {
                return (double)System.currentTimeMillis() + Jvm.toDouble(((Schedule.FIXED_DELAY)schedule).initialDelayMS);
            }
            case 2: {
                return (double)System.currentTimeMillis() + Jvm.toDouble(((Schedule.FIXED_RATE)schedule).initialDelayMS);
            }
            case 3: {
                double nowMS = System.currentTimeMillis();
                Date now = Date.fromTime(nowMS);
                int runAtSecondOfHour = Jvm.toInt(((Schedule.HOURLY)schedule).minute) * 60 + Jvm.toInt(((Schedule.HOURLY)schedule).second);
                int elapsedSecondsThisHour = now.date.get(Calendar.MINUTE) * 60 + now.date.get(Calendar.SECOND);
                return nowMS + (double)((runAtSecondOfHour - elapsedSecondsThisHour) * 1000) + (double)(elapsedSecondsThisHour > runAtSecondOfHour ? (int)3600000.0 : (int)0.0);
            }
            case 4: {
                double nowMS = System.currentTimeMillis();
                Date now = Date.fromTime(nowMS);
                int runAtSecondOfDay = Jvm.toInt(((Schedule.DAILY)schedule).hour) * 60 * 60 + Jvm.toInt(((Schedule.DAILY)schedule).minute) * 60 + Jvm.toInt(((Schedule.DAILY)schedule).second);
                int elapsedSecondsToday = now.date.get(Calendar.HOUR_OF_DAY) * 60 * 60 + now.date.get(Calendar.MINUTE) * 60 + now.date.get(Calendar.SECOND);
                return nowMS + (double)((runAtSecondOfDay - elapsedSecondsToday) * 1000) + (double)(elapsedSecondsToday > runAtSecondOfDay ? (int)8.64E7 : (int)0.0);
            }
            case 5: 
        }
        double nowMS = System.currentTimeMillis();
        Date now = Date.fromTime(nowMS);
        int runAtSecondOfDay = Jvm.toInt(((Schedule.WEEKLY)schedule).hour) * 60 * 60 + Jvm.toInt(((Schedule.WEEKLY)schedule).minute) * 60 + Jvm.toInt(((Schedule.WEEKLY)schedule).second);
        int elapsedSecondsToday = now.date.get(Calendar.HOUR_OF_DAY) * 60 * 60 + now.date.get(Calendar.MINUTE) * 60 + now.date.get(Calendar.SECOND);
        int dayIndex = Jvm.toInt(((Schedule.WEEKLY)schedule).day);
        if (dayIndex == now.date.get(Calendar.DAY_OF_WEEK) - 1) {
            return nowMS + (double)((runAtSecondOfDay - elapsedSecondsToday) * 1000) + (double)(elapsedSecondsToday > runAtSecondOfDay ? (int)6.048E8 : (int)0.0);
        }
        if (now.date.get(Calendar.DAY_OF_MONTH) < dayIndex) {
            return nowMS + (double)((runAtSecondOfDay - elapsedSecondsToday) * 1000) + (double)(86400000 * (dayIndex - now.date.get(Calendar.DAY_OF_MONTH)));
        }
        return nowMS + (double)((runAtSecondOfDay - elapsedSecondsToday) * 1000) + (double)(86400000 * (7 - (dayIndex - now.date.get(Calendar.DAY_OF_MONTH))));
    }

    public /* synthetic */ ScheduleTools(EmptyConstructor _) {
    }
}

