/*
 * Decompiled with CFR 0.152.
 */
package com.lightstreamer.client.mpn;

import android.content.Context;
import com.lightstreamer.client.mpn.MpnDeviceListener;
import com.lightstreamer.client.mpn._AndroidTools.AndroidTools_Fields_;
import com.lightstreamer.client.mpn._MpnDevice.MpnDeviceEventDispatcher;
import com.lightstreamer.internal.InfoMap;
import com.lightstreamer.internal.RLock;
import com.lightstreamer.internal._NativeTypes.NativeList_Impl_;
import com.lightstreamer.log._LoggerTools.LoggerTools_Fields_;
import haxe.ds.StringMap;
import haxe.jvm.EmptyConstructor;
import haxe.jvm.Function;
import haxe.jvm.Jvm;
import haxe.jvm.annotation.ClassReflectionInformation;
import hx.concurrent.lock.RLock;
import java.util.List;

@ClassReflectionInformation(hasSuperClass=false)
public class LSMpnDevice
extends haxe.jvm.Object {
    public MpnDeviceEventDispatcher eventDispatcher;
    public String platform;
    public String applicationId;
    public String deviceToken;
    public String prevDeviceToken;
    public String status;
    public long statusTs;
    public String deviceId;
    public String adapterName;
    public RLock lock;

    public void addListener(MpnDeviceListener listener) {
        LSMpnDevice _gthis = this;
        RLock.RLock_Impl_.synchronized(this.lock, new Closure_addListener_0(_gthis, listener));
    }

    public void removeListener(MpnDeviceListener listener) {
        LSMpnDevice _gthis = this;
        RLock.RLock_Impl_.synchronized(this.lock, new Closure_removeListener_0(_gthis, listener));
    }

    public List getListeners() {
        LSMpnDevice _gthis = this;
        return (List)RLock.RLock_Impl_.synchronized(this.lock, new Closure_getListeners_0(_gthis));
    }

    public boolean isRegistered() {
        LSMpnDevice _gthis = this;
        return Jvm.toBoolean(RLock.RLock_Impl_.synchronized(this.lock, new Closure_isRegistered_0(_gthis)));
    }

    public boolean isSuspended() {
        LSMpnDevice _gthis = this;
        return Jvm.toBoolean(RLock.RLock_Impl_.synchronized(this.lock, new Closure_isSuspended_0(_gthis)));
    }

    public String getStatus() {
        LSMpnDevice _gthis = this;
        return (String)RLock.RLock_Impl_.synchronized(this.lock, new Closure_getStatus_0(_gthis));
    }

    public long getStatusTimestamp() {
        LSMpnDevice _gthis = this;
        return Jvm.toLong(RLock.RLock_Impl_.synchronized(this.lock, new Closure_getStatusTimestamp_0(_gthis)));
    }

    public String getPlatform() {
        LSMpnDevice _gthis = this;
        return (String)RLock.RLock_Impl_.synchronized(this.lock, new Closure_getPlatform_0(_gthis));
    }

    public String getApplicationId() {
        LSMpnDevice _gthis = this;
        return (String)RLock.RLock_Impl_.synchronized(this.lock, new Closure_getApplicationId_0(_gthis));
    }

    public String getDeviceToken() {
        LSMpnDevice _gthis = this;
        return (String)RLock.RLock_Impl_.synchronized(this.lock, new Closure_getDeviceToken_0(_gthis));
    }

    public String getPreviousDeviceToken() {
        LSMpnDevice _gthis = this;
        return (String)RLock.RLock_Impl_.synchronized(this.lock, new Closure_getPreviousDeviceToken_0(_gthis));
    }

    public String getDeviceId() {
        LSMpnDevice _gthis = this;
        return (String)RLock.RLock_Impl_.synchronized(this.lock, new Closure_getDeviceId_0(_gthis));
    }

    public void setDeviceId(String deviceId, String adapterName) {
        LSMpnDevice _gthis = this;
        RLock.RLock_Impl_.synchronized(this.lock, new Closure_setDeviceId_0(deviceId, _gthis, adapterName));
    }

    public void onRegistered(long timestamp) {
        LSMpnDevice _gthis = this;
        RLock.RLock_Impl_.synchronized(this.lock, new Closure_onRegistered_0(_gthis, timestamp));
    }

    public void onSuspend(long timestamp) {
        LSMpnDevice _gthis = this;
        RLock.RLock_Impl_.synchronized(this.lock, new Closure_onSuspend_0(_gthis, timestamp));
    }

    public void onResume(long timestamp) {
        LSMpnDevice _gthis = this;
        RLock.RLock_Impl_.synchronized(this.lock, new Closure_onResume_0(_gthis, timestamp));
    }

    public void onError(int code, String msg) {
        LSMpnDevice _gthis = this;
        RLock.RLock_Impl_.synchronized(this.lock, new Closure_onError_0(code, msg, _gthis));
    }

    public void onReset() {
        LSMpnDevice _gthis = this;
        RLock.RLock_Impl_.synchronized(this.lock, new Closure_onReset_0(_gthis));
    }

    public void fireOnSubscriptionsUpdated() {
        LSMpnDevice _gthis = this;
        RLock.RLock_Impl_.synchronized(this.lock, new Closure_fireOnSubscriptionsUpdated_0(_gthis));
    }

    public void fireOnBadgeResetFailed(int code, String msg) {
        LSMpnDevice _gthis = this;
        RLock.RLock_Impl_.synchronized(this.lock, new Closure_fireOnBadgeResetFailed_0(code, msg, _gthis));
    }

    public void fireOnBadgeReset() {
        LSMpnDevice _gthis = this;
        RLock.RLock_Impl_.synchronized(this.lock, new Closure_fireOnBadgeReset_0(_gthis));
    }

    public String toString() {
        LSMpnDevice _gthis = this;
        return (String)RLock.RLock_Impl_.synchronized(this.lock, new Closure_toString_0(_gthis));
    }

    public LSMpnDevice(Context appContext, String token) {
        this.eventDispatcher = new MpnDeviceEventDispatcher();
        this.status = "UNKNOWN";
        long this1 = 0L;
        this.statusTs = this1 = 0L;
        RLock this2 = null;
        this.lock = this2 = new RLock();
        if (appContext == null) {
            throw new IllegalArgumentException("Please specify a valid appContext");
        }
        if (token == null) {
            throw new IllegalArgumentException("Please specify a valid token");
        }
        try {
            Class.forName("com.google.android.gms.common.GooglePlayServicesUtil");
        }
        catch (Exception e) {
            throw new IllegalStateException("Couldn't check for availability of Google Play Services", e);
        }
        if (!AndroidTools_Fields_.isGooglePlayServicesAvailable(appContext)) {
            throw new IllegalStateException("Google Play Services Not Available");
        }
        String previousToken = AndroidTools_Fields_.readTokenFromSharedPreferences(appContext);
        if (previousToken != null) {
            if (LoggerTools_Fields_.mpnDeviceLogger.isDebugEnabled()) {
                LoggerTools_Fields_.mpnDeviceLogger.debug("Previous registration ID found (" + previousToken + ")", null);
            }
        } else if (LoggerTools_Fields_.mpnDeviceLogger.isDebugEnabled()) {
            LoggerTools_Fields_.mpnDeviceLogger.debug("No previous registration ID found", null);
        }
        if (LoggerTools_Fields_.mpnDeviceLogger.isDebugEnabled()) {
            LoggerTools_Fields_.mpnDeviceLogger.debug("Registration ID obtained (" + token + "), storing...", null);
        }
        AndroidTools_Fields_.writeTokenToSharedPreferences(appContext, token);
        if (LoggerTools_Fields_.mpnDeviceLogger.isDebugEnabled()) {
            LoggerTools_Fields_.mpnDeviceLogger.debug("Registration ID stored", null);
        }
        this.platform = "Google";
        this.applicationId = appContext.getPackageName();
        this.deviceToken = token;
        this.prevDeviceToken = previousToken == null ? null : previousToken;
    }

    public /* synthetic */ LSMpnDevice(EmptyConstructor _) {
    }

    public static final class Closure_isSuspended_0
    extends Function {
        public final LSMpnDevice _gthis;

        public Closure_isSuspended_0(LSMpnDevice _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public boolean invoke() {
            return Jvm.stringCompare(this._gthis.status, "SUSPENDED") == 0;
        }
    }

    public static final class Closure_getApplicationId_0
    extends Function {
        public final LSMpnDevice _gthis;

        public Closure_getApplicationId_0(LSMpnDevice _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public String invoke() {
            return this._gthis.applicationId;
        }
    }

    public static final class Closure_getDeviceId_0
    extends Function {
        public final LSMpnDevice _gthis;

        public Closure_getDeviceId_0(LSMpnDevice _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public String invoke() {
            return this._gthis.deviceId;
        }
    }

    public static final class Closure_fireOnSubscriptionsUpdated_0
    extends Function
    implements Runnable {
        public final LSMpnDevice _gthis;

        public Closure_fireOnSubscriptionsUpdated_0(LSMpnDevice _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public void invoke() {
            if (LoggerTools_Fields_.mpnDeviceLogger.isInfoEnabled()) {
                LoggerTools_Fields_.mpnDeviceLogger.info("MPN subscriptions have been updated: " + this._gthis.deviceId, null);
            }
            this._gthis.eventDispatcher.onSubscriptionsUpdated();
        }

        @Override
        public void run() {
            this.invoke();
        }
    }

    public static final class Closure_fireOnBadgeReset_0
    extends Function
    implements Runnable {
        public final LSMpnDevice _gthis;

        public Closure_fireOnBadgeReset_0(LSMpnDevice _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public void invoke() {
            if (LoggerTools_Fields_.mpnDeviceLogger.isInfoEnabled()) {
                LoggerTools_Fields_.mpnDeviceLogger.info("MPN badge successfully reset: " + this._gthis.deviceId, null);
            }
        }

        @Override
        public void run() {
            this.invoke();
        }
    }

    public static final class Closure_setDeviceId_0
    extends Function {
        public final String deviceId;
        public final LSMpnDevice _gthis;
        public final String adapterName;

        /*
         * WARNING - void declaration
         */
        public Closure_setDeviceId_0(String deviceId, LSMpnDevice lSMpnDevice, String string) {
            void adapterName;
            void _gthis;
            this.deviceId = deviceId;
            this._gthis = _gthis;
            this.adapterName = adapterName;
        }

        @Override
        public String invoke() {
            String this1;
            this._gthis.deviceId = this1 = this.deviceId;
            this._gthis.adapterName = this.adapterName;
            return this._gthis.adapterName;
        }
    }

    public static final class Closure_removeListener_0
    extends Function
    implements Runnable {
        public final LSMpnDevice _gthis;
        public final MpnDeviceListener listener;

        /*
         * WARNING - void declaration
         */
        public Closure_removeListener_0(LSMpnDevice _gthis, MpnDeviceListener mpnDeviceListener) {
            void listener;
            this._gthis = _gthis;
            this.listener = listener;
        }

        @Override
        public void invoke() {
            this._gthis.eventDispatcher.removeListenerAndFireOnListenEnd(this.listener);
        }

        @Override
        public void run() {
            this.invoke();
        }
    }

    public static final class Closure_getListeners_0
    extends Function {
        public final LSMpnDevice _gthis;

        public Closure_getListeners_0(LSMpnDevice _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public List invoke() {
            return NativeList_Impl_._new(this._gthis.eventDispatcher.getListeners());
        }
    }

    public static final class Closure_getStatus_0
    extends Function {
        public final LSMpnDevice _gthis;

        public Closure_getStatus_0(LSMpnDevice _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public String invoke() {
            return this._gthis.status;
        }
    }

    public static final class Closure_onRegistered_0
    extends Function
    implements Runnable {
        public final LSMpnDevice _gthis;
        public final long timestamp;

        /*
         * WARNING - void declaration
         */
        public Closure_onRegistered_0(LSMpnDevice _gthis, long l) {
            void timestamp;
            this._gthis = _gthis;
            this.timestamp = timestamp;
        }

        @Override
        public void invoke() {
            long this1;
            if (LoggerTools_Fields_.mpnDeviceLogger.isInfoEnabled()) {
                LoggerTools_Fields_.mpnDeviceLogger.info("MPN device registered: " + this._gthis.deviceId + ")", null);
            }
            this._gthis.status = "REGISTERED";
            this._gthis.statusTs = this1 = this.timestamp;
            this._gthis.eventDispatcher.onStatusChanged("REGISTERED", this.timestamp);
            this._gthis.eventDispatcher.onRegistered();
        }

        @Override
        public void run() {
            this.invoke();
        }
    }

    public static final class Closure_getPlatform_0
    extends Function {
        public final LSMpnDevice _gthis;

        public Closure_getPlatform_0(LSMpnDevice _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public String invoke() {
            return this._gthis.platform;
        }
    }

    public static final class Closure_onError_0
    extends Function
    implements Runnable {
        public final int code;
        public final String msg;
        public final LSMpnDevice _gthis;

        /*
         * WARNING - void declaration
         */
        public Closure_onError_0(int code, String string, LSMpnDevice lSMpnDevice) {
            void _gthis;
            void msg;
            this.code = code;
            this.msg = msg;
            this._gthis = _gthis;
        }

        @Override
        public void invoke() {
            long this1;
            if (LoggerTools_Fields_.mpnDeviceLogger.isWarnEnabled()) {
                LoggerTools_Fields_.mpnDeviceLogger.warn("MPN device error: " + this.code + " - " + this.msg + " " + this._gthis.deviceId, null);
            }
            this._gthis.status = "UNKNOWN";
            this._gthis.statusTs = this1 = 0L;
            this._gthis.deviceId = null;
            this._gthis.adapterName = null;
            this._gthis.eventDispatcher.onRegistrationFailed(this.code, this.msg);
            this._gthis.eventDispatcher.onStatusChanged("UNKNOWN", 0L);
        }

        @Override
        public void run() {
            this.invoke();
        }
    }

    public static final class Closure_getDeviceToken_0
    extends Function {
        public final LSMpnDevice _gthis;

        public Closure_getDeviceToken_0(LSMpnDevice _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public String invoke() {
            return this._gthis.deviceToken;
        }
    }

    public static final class Closure_onResume_0
    extends Function
    implements Runnable {
        public final LSMpnDevice _gthis;
        public final long timestamp;

        /*
         * WARNING - void declaration
         */
        public Closure_onResume_0(LSMpnDevice _gthis, long l) {
            void timestamp;
            this._gthis = _gthis;
            this.timestamp = timestamp;
        }

        @Override
        public void invoke() {
            long this1;
            if (LoggerTools_Fields_.mpnDeviceLogger.isInfoEnabled()) {
                LoggerTools_Fields_.mpnDeviceLogger.info("MPN device resumed: " + this._gthis.deviceId, null);
            }
            this._gthis.status = "REGISTERED";
            this._gthis.statusTs = this1 = this.timestamp;
            this._gthis.eventDispatcher.onStatusChanged("REGISTERED", this.timestamp);
            this._gthis.eventDispatcher.onResumed();
        }

        @Override
        public void run() {
            this.invoke();
        }
    }

    public static final class Closure_toString_0
    extends Function {
        public final LSMpnDevice _gthis;

        public Closure_toString_0(LSMpnDevice _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public String invoke() {
            StringMap map = InfoMap.InfoMap_Impl_._new();
            InfoMap.InfoMap_Impl_.set(map, "platform", this._gthis.platform);
            InfoMap.InfoMap_Impl_.set(map, "applicationId", this._gthis.applicationId);
            InfoMap.InfoMap_Impl_.set(map, "deviceToken", this._gthis.deviceToken);
            InfoMap.InfoMap_Impl_.set(map, "prevDeviceToken", this._gthis.prevDeviceToken);
            return map.toString();
        }
    }

    public static final class Closure_onSuspend_0
    extends Function
    implements Runnable {
        public final LSMpnDevice _gthis;
        public final long timestamp;

        /*
         * WARNING - void declaration
         */
        public Closure_onSuspend_0(LSMpnDevice _gthis, long l) {
            void timestamp;
            this._gthis = _gthis;
            this.timestamp = timestamp;
        }

        @Override
        public void invoke() {
            long this1;
            if (LoggerTools_Fields_.mpnDeviceLogger.isInfoEnabled()) {
                LoggerTools_Fields_.mpnDeviceLogger.info("MPN device suspended: " + this._gthis.deviceId, null);
            }
            this._gthis.status = "SUSPENDED";
            this._gthis.statusTs = this1 = this.timestamp;
            this._gthis.eventDispatcher.onStatusChanged("SUSPENDED", this.timestamp);
            this._gthis.eventDispatcher.onSuspended();
        }

        @Override
        public void run() {
            this.invoke();
        }
    }

    public static final class Closure_onReset_0
    extends Function
    implements Runnable {
        public final LSMpnDevice _gthis;

        public Closure_onReset_0(LSMpnDevice _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public void invoke() {
            long this1;
            if (LoggerTools_Fields_.mpnDeviceLogger.isInfoEnabled()) {
                LoggerTools_Fields_.mpnDeviceLogger.info("MPN device NOT registered", null);
            }
            String oldStatus = this._gthis.status;
            this._gthis.status = "UNKNOWN";
            this._gthis.statusTs = this1 = 0L;
            this._gthis.deviceId = null;
            this._gthis.adapterName = null;
            if (Jvm.stringCompare(oldStatus, "UNKNOWN") != 0) {
                this._gthis.eventDispatcher.onStatusChanged("UNKNOWN", 0L);
            }
        }

        @Override
        public void run() {
            this.invoke();
        }
    }

    public static final class Closure_fireOnBadgeResetFailed_0
    extends Function
    implements Runnable {
        public final int code;
        public final String msg;
        public final LSMpnDevice _gthis;

        /*
         * WARNING - void declaration
         */
        public Closure_fireOnBadgeResetFailed_0(int code, String string, LSMpnDevice lSMpnDevice) {
            void _gthis;
            void msg;
            this.code = code;
            this.msg = msg;
            this._gthis = _gthis;
        }

        @Override
        public void invoke() {
            if (LoggerTools_Fields_.mpnDeviceLogger.isWarnEnabled()) {
                LoggerTools_Fields_.mpnDeviceLogger.warn("MPN badge reset failed: " + this.code + " - " + this.msg + " " + this._gthis.deviceId, null);
            }
        }

        @Override
        public void run() {
            this.invoke();
        }
    }

    public static final class Closure_getStatusTimestamp_0
    extends Function {
        public final LSMpnDevice _gthis;

        public Closure_getStatusTimestamp_0(LSMpnDevice _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public long invoke() {
            return this._gthis.statusTs;
        }
    }

    public static final class Closure_isRegistered_0
    extends Function {
        public final LSMpnDevice _gthis;

        public Closure_isRegistered_0(LSMpnDevice _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public boolean invoke() {
            return Jvm.stringCompare(this._gthis.status, "REGISTERED") == 0;
        }
    }

    public static final class Closure_addListener_0
    extends Function
    implements Runnable {
        public final LSMpnDevice _gthis;
        public final MpnDeviceListener listener;

        /*
         * WARNING - void declaration
         */
        public Closure_addListener_0(LSMpnDevice _gthis, MpnDeviceListener mpnDeviceListener) {
            void listener;
            this._gthis = _gthis;
            this.listener = listener;
        }

        @Override
        public void invoke() {
            this._gthis.eventDispatcher.addListenerAndFireOnListenStart(this.listener);
        }

        @Override
        public void run() {
            this.invoke();
        }
    }

    public static final class Closure_getPreviousDeviceToken_0
    extends Function {
        public final LSMpnDevice _gthis;

        public Closure_getPreviousDeviceToken_0(LSMpnDevice _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public String invoke() {
            return this._gthis.prevDeviceToken;
        }
    }
}

