/*
 * Decompiled with CFR 0.152.
 */
package com.lightstreamer.client;

import com.lightstreamer.client.ClientEventDispatcher;
import com.lightstreamer.client.ClientListener;
import com.lightstreamer.client.ClientMessageListener;
import com.lightstreamer.client.LSConnectionDetails;
import com.lightstreamer.client.LSConnectionOptions;
import com.lightstreamer.client.LSProxy;
import com.lightstreamer.client.LSSubscription;
import com.lightstreamer.client.internal.ClientMachine;
import com.lightstreamer.client.internal.MpnClientMachine;
import com.lightstreamer.client.mpn.LSMpnDevice;
import com.lightstreamer.client.mpn.LSMpnSubscription;
import com.lightstreamer.internal.CookieHelper;
import com.lightstreamer.internal.Globals;
import com.lightstreamer.internal.HttpClient;
import com.lightstreamer.internal.IHttpClient;
import com.lightstreamer.internal.IReachability;
import com.lightstreamer.internal.ITimer;
import com.lightstreamer.internal.IWsClient;
import com.lightstreamer.internal.RLock;
import com.lightstreamer.internal.ReachabilityManager;
import com.lightstreamer.internal.Timer;
import com.lightstreamer.internal.WsClient;
import com.lightstreamer.internal._Constants.Constants_Fields_;
import com.lightstreamer.internal._NativeTypes.NativeList_Impl_;
import com.lightstreamer.log.LogManager;
import com.lightstreamer.log.LoggerProvider;
import haxe.ds.StringMap;
import haxe.jvm.EmptyConstructor;
import haxe.jvm.annotation.ClassReflectionInformation;
import haxe.root.Array;
import haxe.root.Std;
import hx.concurrent.lock.RLock;
import java.net.URI;
import java.util.List;
import java.util.function.Function;
import javax.net.ssl.TrustManagerFactory;

@ClassReflectionInformation(hasSuperClass=false)
public class LSLightstreamerClient
extends haxe.jvm.Object {
    public static String LIB_NAME = Constants_Fields_.LS_LIB_NAME;
    public static String LIB_VERSION = Constants_Fields_.LS_LIB_VERSION;
    public LSConnectionDetails connectionDetails;
    public LSConnectionOptions connectionOptions;
    public ClientEventDispatcher eventDispatcher;
    public ClientMachine machine;
    public RLock lock;

    public static void setLoggerProvider(LoggerProvider provider) {
        LogManager.setLoggerProvider(provider);
    }

    public static void addCookies(URI uri, List cookies) {
        CookieHelper.instance.addCookies(uri, cookies);
    }

    public static List getCookies(URI uri) {
        return CookieHelper.instance.getCookies(uri);
    }

    public static void setTrustManagerFactory(TrustManagerFactory factory) {
        Globals.instance.setTrustManagerFactory(factory);
    }

    public void addListener(ClientListener listener) {
        LSLightstreamerClient _gthis = this;
        RLock.RLock_Impl_.synchronized(this.lock, new Closure_addListener_0(_gthis, listener));
    }

    public void removeListener(ClientListener listener) {
        LSLightstreamerClient _gthis = this;
        RLock.RLock_Impl_.synchronized(this.lock, new Closure_removeListener_0(_gthis, listener));
    }

    public List getListeners() {
        LSLightstreamerClient _gthis = this;
        return (List)RLock.RLock_Impl_.synchronized(this.lock, new Closure_getListeners_0(_gthis));
    }

    public void connect() {
        LSLightstreamerClient _gthis = this;
        RLock.RLock_Impl_.synchronized(this.lock, new Closure_connect_0(_gthis));
    }

    public void disconnect() {
        LSLightstreamerClient _gthis = this;
        RLock.RLock_Impl_.synchronized(this.lock, new Closure_disconnect_0(_gthis));
    }

    public String getStatus() {
        LSLightstreamerClient _gthis = this;
        return (String)RLock.RLock_Impl_.synchronized(this.lock, new Closure_getStatus_0(_gthis));
    }

    public void sendMessage(String message) {
        LSLightstreamerClient _gthis = this;
        RLock.RLock_Impl_.synchronized(this.lock, new Closure_sendMessage_0(_gthis, message));
    }

    public void sendMessage(String message, String sequence, int delayTimeout, ClientMessageListener listener, boolean enqueueWhileDisconnected) {
        LSLightstreamerClient _gthis = this;
        RLock.RLock_Impl_.synchronized(this.lock, new Closure_sendMessage_1(_gthis, message, sequence, delayTimeout, listener, enqueueWhileDisconnected));
    }

    public void subscribe(LSSubscription subscription) {
        LSLightstreamerClient _gthis = this;
        RLock.RLock_Impl_.synchronized(this.lock, new Closure_subscribe_0(_gthis, subscription));
    }

    public void unsubscribe(LSSubscription subscription) {
        LSLightstreamerClient _gthis = this;
        RLock.RLock_Impl_.synchronized(this.lock, new Closure_unsubscribe_0(_gthis, subscription));
    }

    public List getSubscriptions() {
        LSLightstreamerClient _gthis = this;
        return (List)RLock.RLock_Impl_.synchronized(this.lock, new Closure_getSubscriptions_0(_gthis));
    }

    public List getSubscriptionWrappers() {
        LSLightstreamerClient _gthis = this;
        return (List)RLock.RLock_Impl_.synchronized(this.lock, new Closure_getSubscriptionWrappers_0(_gthis));
    }

    public void registerForMpn(LSMpnDevice mpnDevice) {
        LSLightstreamerClient _gthis = this;
        RLock.RLock_Impl_.synchronized(this.lock, new Closure_registerForMpn_0(_gthis, mpnDevice));
    }

    public void subscribeMpn(LSMpnSubscription mpnSubscription, boolean coalescing) {
        LSLightstreamerClient _gthis = this;
        RLock.RLock_Impl_.synchronized(this.lock, new Closure_subscribeMpn_0(_gthis, mpnSubscription, coalescing));
    }

    public void unsubscribeMpn(LSMpnSubscription mpnSubscription) {
        LSLightstreamerClient _gthis = this;
        RLock.RLock_Impl_.synchronized(this.lock, new Closure_unsubscribeMpn_0(_gthis, mpnSubscription));
    }

    public void unsubscribeMpnSubscriptions(String filter) {
        LSLightstreamerClient _gthis = this;
        RLock.RLock_Impl_.synchronized(this.lock, new Closure_unsubscribeMpnSubscriptions_0(_gthis, filter));
    }

    public List getMpnSubscriptions(String filter) {
        LSLightstreamerClient _gthis = this;
        return (List)RLock.RLock_Impl_.synchronized(this.lock, new Closure_getMpnSubscriptions_0(_gthis, filter));
    }

    public List getMpnSubscriptionWrappers(String filter) {
        LSLightstreamerClient _gthis = this;
        return (List)RLock.RLock_Impl_.synchronized(this.lock, new Closure_getMpnSubscriptionWrappers_0(_gthis, filter));
    }

    public LSMpnSubscription findMpnSubscription(String subscriptionId) {
        LSLightstreamerClient _gthis = this;
        return (LSMpnSubscription)RLock.RLock_Impl_.synchronized(this.lock, new Closure_findMpnSubscription_0(_gthis, subscriptionId));
    }

    public Object findMpnSubscriptionWrapper(String subscriptionId) {
        LSLightstreamerClient _gthis = this;
        return RLock.RLock_Impl_.synchronized(this.lock, new Closure_findMpnSubscriptionWrapper_0(_gthis, subscriptionId));
    }

    public IWsClient createWsClient(String url, StringMap headers, haxe.jvm.Function onOpen, haxe.jvm.Function onText, haxe.jvm.Function onError) {
        LSProxy proxy = this.connectionOptions.getProxy();
        TrustManagerFactory trustManager = Globals.instance.getTrustManagerFactory();
        return new WsClient(url, headers, proxy, trustManager, onOpen, onText, onError);
    }

    public IHttpClient createHttpClient(String url, String body, StringMap headers, haxe.jvm.Function onText, haxe.jvm.Function onError, haxe.jvm.Function onDone) {
        LSProxy proxy = this.connectionOptions.getProxy();
        TrustManagerFactory trustManager = Globals.instance.getTrustManagerFactory();
        return new HttpClient(url, body, headers, proxy, trustManager, onText, onError, onDone);
    }

    public IReachability createReachabilityManager(String host) {
        return new ReachabilityManager();
    }

    public ITimer createTimer(String id, long delay, haxe.jvm.Function callback) {
        return new Timer(id, delay, callback);
    }

    public long randomMillis(long max) {
        return Std.random((int)max);
    }

    /*
     * WARNING - void declaration
     */
    public LSLightstreamerClient(String serverAddress, String adapterSet) {
        void var3_3;
        this.eventDispatcher = new ClientEventDispatcher();
        RLock this1 = null;
        this1 = new RLock();
        this.lock = var3_3;
        this.connectionDetails = new LSConnectionDetails(this);
        this.connectionOptions = new LSConnectionOptions(this);
        this.machine = new MpnClientMachine(this, new LSLightstreamerClient_createWsClient(this), new LSLightstreamerClient_createHttpClient(this), new LSLightstreamerClient_createHttpClient(this), new LSLightstreamerClient_createTimer(this), new LSLightstreamerClient_randomMillis(this), new LSLightstreamerClient_createReachabilityManager(this));
        if (serverAddress != null) {
            this.connectionDetails.setServerAddress(serverAddress);
        }
        if (adapterSet != null) {
            this.connectionDetails.setAdapterSet(adapterSet);
        }
    }

    public /* synthetic */ LSLightstreamerClient(EmptyConstructor _) {
    }

    public static final class Closure_getMpnSubscriptions_0
    extends haxe.jvm.Function {
        public final LSLightstreamerClient _gthis;
        public final String filter;

        /*
         * WARNING - void declaration
         */
        public Closure_getMpnSubscriptions_0(LSLightstreamerClient _gthis, String string) {
            void filter;
            this._gthis = _gthis;
            this.filter = filter;
        }

        @Override
        public List invoke() {
            MpnClientMachine machine = (MpnClientMachine)this._gthis.machine;
            return NativeList_Impl_._new(machine.getMpnSubscriptions(this.filter));
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static final class LSLightstreamerClient_createWsClient
    extends haxe.jvm.Function {
        public final LSLightstreamerClient this;

        public LSLightstreamerClient_createWsClient(LSLightstreamerClient lSLightstreamerClient) {
            this.this = lSLightstreamerClient;
        }

        public IWsClient invoke(String arg0, StringMap arg1, haxe.jvm.Function arg2, haxe.jvm.Function arg3, haxe.jvm.Function arg4) {
            return this.this.createWsClient(arg0, arg1, arg2, arg3, arg4);
        }

        public boolean equals(Object other) {
            if (!(other instanceof LSLightstreamerClient_createWsClient)) {
                return false;
            }
            LSLightstreamerClient_createWsClient other2 = (LSLightstreamerClient_createWsClient)other;
            return this.this == other2.this;
        }
    }

    public static final class Closure_removeListener_0
    extends haxe.jvm.Function
    implements Runnable {
        public final LSLightstreamerClient _gthis;
        public final ClientListener listener;

        /*
         * WARNING - void declaration
         */
        public Closure_removeListener_0(LSLightstreamerClient _gthis, ClientListener clientListener) {
            void listener;
            this._gthis = _gthis;
            this.listener = listener;
        }

        @Override
        public void invoke() {
            this._gthis.eventDispatcher.removeListenerAndFireOnListenEnd(this.listener);
        }

        @Override
        public void run() {
            this.invoke();
        }
    }

    public static final class Closure_sendMessage_1
    extends haxe.jvm.Function
    implements Runnable {
        public final LSLightstreamerClient _gthis;
        public final String message;
        public final String sequence;
        public final int delayTimeout;
        public final ClientMessageListener listener;
        public final boolean enqueueWhileDisconnected;

        /*
         * WARNING - void declaration
         */
        public Closure_sendMessage_1(LSLightstreamerClient _gthis, String string, String string2, int n, ClientMessageListener clientMessageListener, boolean bl) {
            void enqueueWhileDisconnected;
            void listener;
            void delayTimeout;
            void sequence;
            void message;
            this._gthis = _gthis;
            this.message = message;
            this.sequence = sequence;
            this.delayTimeout = delayTimeout;
            this.listener = listener;
            this.enqueueWhileDisconnected = enqueueWhileDisconnected;
        }

        @Override
        public void invoke() {
            this._gthis.machine.sendMessage(this.message, this.sequence, this.delayTimeout, this.listener, this.enqueueWhileDisconnected);
        }

        @Override
        public void run() {
            this.invoke();
        }
    }

    public static final class Closure_unsubscribeMpnSubscriptions_0
    extends haxe.jvm.Function
    implements Runnable {
        public final LSLightstreamerClient _gthis;
        public final String filter;

        /*
         * WARNING - void declaration
         */
        public Closure_unsubscribeMpnSubscriptions_0(LSLightstreamerClient _gthis, String string) {
            void filter;
            this._gthis = _gthis;
            this.filter = filter;
        }

        @Override
        public void invoke() {
            MpnClientMachine machine = (MpnClientMachine)this._gthis.machine;
            machine.unsubscribeMpnSubscriptions(this.filter);
        }

        @Override
        public void run() {
            this.invoke();
        }
    }

    public static final class Closure_connect_0
    extends haxe.jvm.Function
    implements Runnable {
        public final LSLightstreamerClient _gthis;

        public Closure_connect_0(LSLightstreamerClient _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public void invoke() {
            this._gthis.machine.connect();
        }

        @Override
        public void run() {
            this.invoke();
        }
    }

    public static final class Closure_unsubscribeMpn_0
    extends haxe.jvm.Function
    implements Runnable {
        public final LSLightstreamerClient _gthis;
        public final LSMpnSubscription mpnSubscription;

        /*
         * WARNING - void declaration
         */
        public Closure_unsubscribeMpn_0(LSLightstreamerClient _gthis, LSMpnSubscription lSMpnSubscription) {
            void mpnSubscription;
            this._gthis = _gthis;
            this.mpnSubscription = mpnSubscription;
        }

        @Override
        public void invoke() {
            MpnClientMachine machine = (MpnClientMachine)this._gthis.machine;
            machine.unsubscribeMpn(this.mpnSubscription);
        }

        @Override
        public void run() {
            this.invoke();
        }
    }

    public static final class Closure_findMpnSubscription_0
    extends haxe.jvm.Function {
        public final LSLightstreamerClient _gthis;
        public final String subscriptionId;

        /*
         * WARNING - void declaration
         */
        public Closure_findMpnSubscription_0(LSLightstreamerClient _gthis, String string) {
            void subscriptionId;
            this._gthis = _gthis;
            this.subscriptionId = subscriptionId;
        }

        @Override
        public LSMpnSubscription invoke() {
            MpnClientMachine machine = (MpnClientMachine)this._gthis.machine;
            return machine.findMpnSubscription(this.subscriptionId);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static final class LSLightstreamerClient_createTimer
    extends haxe.jvm.Function {
        public final LSLightstreamerClient this;

        public LSLightstreamerClient_createTimer(LSLightstreamerClient lSLightstreamerClient) {
            this.this = lSLightstreamerClient;
        }

        public ITimer invoke(String arg0, long arg1, haxe.jvm.Function arg2) {
            return this.this.createTimer(arg0, arg1, arg2);
        }

        public boolean equals(Object other) {
            if (!(other instanceof LSLightstreamerClient_createTimer)) {
                return false;
            }
            LSLightstreamerClient_createTimer other2 = (LSLightstreamerClient_createTimer)other;
            return this.this == other2.this;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static final class LSLightstreamerClient_createHttpClient
    extends haxe.jvm.Function {
        public final LSLightstreamerClient this;

        public LSLightstreamerClient_createHttpClient(LSLightstreamerClient lSLightstreamerClient) {
            this.this = lSLightstreamerClient;
        }

        public IHttpClient invoke(String arg0, String arg1, StringMap arg2, haxe.jvm.Function arg3, haxe.jvm.Function arg4, haxe.jvm.Function arg5) {
            return this.this.createHttpClient(arg0, arg1, arg2, arg3, arg4, arg5);
        }

        public boolean equals(Object other) {
            if (!(other instanceof LSLightstreamerClient_createHttpClient)) {
                return false;
            }
            LSLightstreamerClient_createHttpClient other2 = (LSLightstreamerClient_createHttpClient)other;
            return this.this == other2.this;
        }
    }

    public static final class Closure_getMpnSubscriptionWrappers_0
    extends haxe.jvm.Function {
        public final LSLightstreamerClient _gthis;
        public final String filter;

        /*
         * WARNING - void declaration
         */
        public Closure_getMpnSubscriptionWrappers_0(LSLightstreamerClient _gthis, String string) {
            void filter;
            this._gthis = _gthis;
            this.filter = filter;
        }

        @Override
        public List invoke() {
            MpnClientMachine machine = (MpnClientMachine)this._gthis.machine;
            Array<Object> _g = Array.ofNative(new Object[0]);
            Array _g2 = machine.getMpnSubscriptions(this.filter);
            for (int _g1 = 0; _g1 < _g2.length; ++_g1) {
                LSMpnSubscription sub = (LSMpnSubscription)_g2.__get(_g1);
                if (sub.wrapper == null) continue;
                _g.push(sub.wrapper);
            }
            return NativeList_Impl_._new(_g);
        }
    }

    public static final class Closure_subscribe_0
    extends haxe.jvm.Function
    implements Runnable {
        public final LSLightstreamerClient _gthis;
        public final LSSubscription subscription;

        /*
         * WARNING - void declaration
         */
        public Closure_subscribe_0(LSLightstreamerClient _gthis, LSSubscription lSSubscription) {
            void subscription;
            this._gthis = _gthis;
            this.subscription = subscription;
        }

        @Override
        public void invoke() {
            this._gthis.machine.subscribeExt(this.subscription, null);
        }

        @Override
        public void run() {
            this.invoke();
        }
    }

    public static final class Closure_getSubscriptionWrappers_0
    extends haxe.jvm.Function {
        public final LSLightstreamerClient _gthis;

        public Closure_getSubscriptionWrappers_0(LSLightstreamerClient _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public List invoke() {
            Array<Object> _g = Array.ofNative(new Object[0]);
            Array _g2 = this._gthis.machine.getSubscriptions();
            for (int _g1 = 0; _g1 < _g2.length; ++_g1) {
                LSSubscription sub = (LSSubscription)_g2.__get(_g1);
                if (sub.wrapper == null) continue;
                _g.push(sub.wrapper);
            }
            return NativeList_Impl_._new(_g);
        }
    }

    public static final class Closure_sendMessage_0
    extends haxe.jvm.Function
    implements Runnable {
        public final LSLightstreamerClient _gthis;
        public final String message;

        /*
         * WARNING - void declaration
         */
        public Closure_sendMessage_0(LSLightstreamerClient _gthis, String string) {
            void message;
            this._gthis = _gthis;
            this.message = message;
        }

        @Override
        public void invoke() {
            this._gthis.machine.sendMessage(this.message, null, -1, null, false);
        }

        @Override
        public void run() {
            this.invoke();
        }
    }

    public static final class Closure_addListener_0
    extends haxe.jvm.Function
    implements Runnable {
        public final LSLightstreamerClient _gthis;
        public final ClientListener listener;

        /*
         * WARNING - void declaration
         */
        public Closure_addListener_0(LSLightstreamerClient _gthis, ClientListener clientListener) {
            void listener;
            this._gthis = _gthis;
            this.listener = listener;
        }

        @Override
        public void invoke() {
            this._gthis.eventDispatcher.addListenerAndFireOnListenStart(this.listener);
        }

        @Override
        public void run() {
            this.invoke();
        }
    }

    public static final class Closure_disconnect_0
    extends haxe.jvm.Function
    implements Runnable {
        public final LSLightstreamerClient _gthis;

        public Closure_disconnect_0(LSLightstreamerClient _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public void invoke() {
            this._gthis.machine.disconnect();
        }

        @Override
        public void run() {
            this.invoke();
        }
    }

    public static final class Closure_getSubscriptions_0
    extends haxe.jvm.Function {
        public final LSLightstreamerClient _gthis;

        public Closure_getSubscriptions_0(LSLightstreamerClient _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public List invoke() {
            return NativeList_Impl_._new(this._gthis.machine.getSubscriptions());
        }
    }

    public static final class Closure_registerForMpn_0
    extends haxe.jvm.Function
    implements Runnable {
        public final LSLightstreamerClient _gthis;
        public final LSMpnDevice mpnDevice;

        /*
         * WARNING - void declaration
         */
        public Closure_registerForMpn_0(LSLightstreamerClient _gthis, LSMpnDevice lSMpnDevice) {
            void mpnDevice;
            this._gthis = _gthis;
            this.mpnDevice = mpnDevice;
        }

        @Override
        public void invoke() {
            MpnClientMachine machine = (MpnClientMachine)this._gthis.machine;
            machine.registerForMpn(this.mpnDevice);
        }

        @Override
        public void run() {
            this.invoke();
        }
    }

    public static final class Closure_getStatus_0
    extends haxe.jvm.Function {
        public final LSLightstreamerClient _gthis;

        public Closure_getStatus_0(LSLightstreamerClient _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public String invoke() {
            return this._gthis.machine.getStatus();
        }
    }

    public static final class Closure_subscribeMpn_0
    extends haxe.jvm.Function
    implements Runnable {
        public final LSLightstreamerClient _gthis;
        public final LSMpnSubscription mpnSubscription;
        public final boolean coalescing;

        /*
         * WARNING - void declaration
         */
        public Closure_subscribeMpn_0(LSLightstreamerClient _gthis, LSMpnSubscription lSMpnSubscription, boolean bl) {
            void coalescing;
            void mpnSubscription;
            this._gthis = _gthis;
            this.mpnSubscription = mpnSubscription;
            this.coalescing = coalescing;
        }

        @Override
        public void invoke() {
            MpnClientMachine machine = (MpnClientMachine)this._gthis.machine;
            machine.subscribeMpn(this.mpnSubscription, this.coalescing);
        }

        @Override
        public void run() {
            this.invoke();
        }
    }

    public static final class Closure_getListeners_0
    extends haxe.jvm.Function {
        public final LSLightstreamerClient _gthis;

        public Closure_getListeners_0(LSLightstreamerClient _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public List invoke() {
            return NativeList_Impl_._new(this._gthis.eventDispatcher.getListeners());
        }
    }

    public static final class Closure_unsubscribe_0
    extends haxe.jvm.Function
    implements Runnable {
        public final LSLightstreamerClient _gthis;
        public final LSSubscription subscription;

        /*
         * WARNING - void declaration
         */
        public Closure_unsubscribe_0(LSLightstreamerClient _gthis, LSSubscription lSSubscription) {
            void subscription;
            this._gthis = _gthis;
            this.subscription = subscription;
        }

        @Override
        public void invoke() {
            this._gthis.machine.unsubscribe(this.subscription);
        }

        @Override
        public void run() {
            this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static final class LSLightstreamerClient_randomMillis
    extends haxe.jvm.Function
    implements Function<Long, Long> {
        public final LSLightstreamerClient this;

        public LSLightstreamerClient_randomMillis(LSLightstreamerClient lSLightstreamerClient) {
            this.this = lSLightstreamerClient;
        }

        @Override
        public long invoke(long arg0) {
            return this.this.randomMillis(arg0);
        }

        @Override
        public long apply(long arg0) {
            return this.invoke(arg0);
        }

        @Override
        public long apply(Object arg0) {
            return this.invoke(arg0);
        }

        @Override
        public Object apply(Object arg0) {
            return this.invoke(arg0);
        }

        public boolean equals(Object other) {
            if (!(other instanceof LSLightstreamerClient_randomMillis)) {
                return false;
            }
            LSLightstreamerClient_randomMillis other2 = (LSLightstreamerClient_randomMillis)other;
            return this.this == other2.this;
        }
    }

    public static final class Closure_findMpnSubscriptionWrapper_0
    extends haxe.jvm.Function {
        public final LSLightstreamerClient _gthis;
        public final String subscriptionId;

        /*
         * WARNING - void declaration
         */
        public Closure_findMpnSubscriptionWrapper_0(LSLightstreamerClient _gthis, String string) {
            void subscriptionId;
            this._gthis = _gthis;
            this.subscriptionId = subscriptionId;
        }

        @Override
        public Object invoke() {
            LSMpnSubscription sub = this._gthis.findMpnSubscription(this.subscriptionId);
            if (sub != null) {
                return sub.wrapper;
            }
            return null;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static final class LSLightstreamerClient_createReachabilityManager
    extends haxe.jvm.Function
    implements Function<String, IReachability> {
        public final LSLightstreamerClient this;

        public LSLightstreamerClient_createReachabilityManager(LSLightstreamerClient lSLightstreamerClient) {
            this.this = lSLightstreamerClient;
        }

        public IReachability invoke(String arg0) {
            return this.this.createReachabilityManager(arg0);
        }

        @Override
        public IReachability apply(String arg0) {
            return this.invoke(arg0);
        }

        @Override
        public Object apply(Object arg0) {
            return this.invoke(arg0);
        }

        public boolean equals(Object other) {
            if (!(other instanceof LSLightstreamerClient_createReachabilityManager)) {
                return false;
            }
            LSLightstreamerClient_createReachabilityManager other2 = (LSLightstreamerClient_createReachabilityManager)other;
            return this.this == other2.this;
        }
    }
}

