/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.transport;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.util.transport.DatagramHandler;
import java.io.InputStream;
import java.net.DatagramPacket;
import java.util.zip.GZIPInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MulticastDatagramHandler
implements DatagramHandler {
    private static Log _log = LogFactory.getLog(MulticastDatagramHandler.class);
    private boolean _gzipData;
    private boolean _shortData;

    public MulticastDatagramHandler(boolean gzipData, boolean shortData) {
        this._gzipData = gzipData;
        this._shortData = shortData;
    }

    @Override
    public void errorReceived(Throwable t) {
        _log.error((Object)t, t);
    }

    @Override
    public void process(DatagramPacket packet) {
        byte[] bytes = packet.getData();
        if (this._gzipData) {
            try {
                bytes = this.getUnzippedBytes(bytes);
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
        if (this._shortData) {
            byte[] temp = new byte[96];
            System.arraycopy(bytes, 0, temp, 0, 96);
            bytes = temp;
        }
        StringBundler sb = new StringBundler(4);
        sb.append("[");
        sb.append((Object)packet.getSocketAddress());
        sb.append("] ");
        sb.append(new String(bytes));
        if (_log.isInfoEnabled()) {
            _log.info((Object)sb);
        }
    }

    protected byte[] getUnzippedBytes(byte[] bytes) throws Exception {
        GZIPInputStream is = new GZIPInputStream((InputStream)new UnsyncByteArrayInputStream(bytes));
        UnsyncByteArrayOutputStream ubaos = new UnsyncByteArrayOutputStream(bytes.length);
        byte[] buffer = new byte[1500];
        int c = 0;
        while (c != -1) {
            c = ((InputStream)is).read(buffer, 0, 1500);
            if (c == -1) continue;
            ubaos.write(buffer, 0, c);
        }
        ((InputStream)is).close();
        ubaos.flush();
        ubaos.close();
        return ubaos.toByteArray();
    }
}

