/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.resiliency.spi.provider;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.process.ClassPathUtil;
import com.liferay.portal.kernel.resiliency.mpi.MPIHelperUtil;
import com.liferay.portal.kernel.resiliency.spi.provider.SPIProvider;
import com.liferay.portal.kernel.util.ReflectionUtil;
import com.liferay.portal.kernel.util.StringBundler;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

public class SPIClassPathContextListener
implements ServletContextListener {
    public static volatile String SPI_CLASS_PATH = "";
    protected static final AtomicReference<SPIProvider> spiProviderReference = new AtomicReference();
    private static Log _log = LogFactoryUtil.getLog(SPIClassPathContextListener.class);

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        SPIProvider spiProvider = spiProviderReference.getAndSet(null);
        if (spiProvider != null) {
            MPIHelperUtil.unregisterSPIProvider((SPIProvider)spiProvider);
        }
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        String spiEmbeddedLibDirName;
        ServletContext servletContext = servletContextEvent.getServletContext();
        String contextPath = servletContext.getRealPath("");
        File spiEmbeddedLibDir = new File(contextPath, spiEmbeddedLibDirName = servletContext.getInitParameter("spiEmbeddedLibDir"));
        if (!spiEmbeddedLibDir.exists() || !spiEmbeddedLibDir.isDirectory()) {
            _log.error((Object)("Unable to find SPI embedded lib directory " + spiEmbeddedLibDir.getAbsolutePath()));
            return;
        }
        ArrayList<File> jarFiles = new ArrayList<File>();
        File[] fileArray = spiEmbeddedLibDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String fileName = file.getName();
            if (fileName.endsWith(".jar")) {
                jarFiles.add(file);
            }
            ++n2;
        }
        StringBundler sb = new StringBundler(jarFiles.size() * 2 + 4);
        for (File file : jarFiles) {
            sb.append(file.getAbsolutePath());
            sb.append(File.pathSeparator);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("SPI embedded lib class path " + sb.toString()));
        }
        sb.append(contextPath);
        sb.append("/WEB-INF/classes");
        sb.append(File.pathSeparator);
        sb.append(ClassPathUtil.getGlobalClassPath());
        SPI_CLASS_PATH = sb.toString();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("SPI class path " + SPI_CLASS_PATH));
        }
        String spiProviderClassName = servletContext.getInitParameter("spiProviderClassName");
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            Class<?> spiProviderClass = SPIClassPathContextListener.loadClassDirectly(contextClassLoader, spiProviderClassName);
            SPIProvider spiProvider = (SPIProvider)spiProviderClass.newInstance();
            boolean result = spiProviderReference.compareAndSet(null, spiProvider);
            if (!result) {
                _log.error((Object)("Duplicate SPI provider " + spiProvider + " is already registered in servlet context " + servletContext.getContextPath()));
            } else {
                MPIHelperUtil.registerSPIProvider((SPIProvider)spiProvider);
            }
        }
        catch (Exception e) {
            _log.error((Object)("Unable to create SPI provider with name " + spiProviderClassName), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Class<?> loadClassDirectly(ClassLoader classLoader, String className) throws Exception {
        ClassLoader classLoader2 = classLoader;
        synchronized (classLoader2) {
            Method findLoadedClassMethod = ReflectionUtil.getDeclaredMethod(ClassLoader.class, (String)"findLoadedClass", (Class[])new Class[]{String.class});
            Class clazz = (Class)findLoadedClassMethod.invoke((Object)classLoader, className);
            if (clazz == null) {
                Method findClassMethod = ReflectionUtil.getDeclaredMethod(ClassLoader.class, (String)"findClass", (Class[])new Class[]{String.class});
                clazz = (Class)findClassMethod.invoke((Object)classLoader, className);
            }
            Method resolveClassMethod = ReflectionUtil.getDeclaredMethod(ClassLoader.class, (String)"resolveClass", (Class[])new Class[]{Class.class});
            resolveClassMethod.invoke((Object)classLoader, clazz);
            return clazz;
        }
    }
}

