/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.mail;

import com.liferay.mail.model.FileAttachment;
import com.liferay.mail.service.MailServiceUtil;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.log.LogUtil;
import com.liferay.portal.kernel.mail.Account;
import com.liferay.portal.kernel.mail.MailMessage;
import com.liferay.portal.kernel.mail.SMTPAccount;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InfrastructureUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.util.mail.InternetAddressUtil;
import com.liferay.util.mail.LiferayMimeMessage;
import com.liferay.util.mail.MailEngineException;
import java.io.File;
import java.io.InputStream;
import java.net.SocketException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.lang.time.StopWatch;

public class MailEngine {
    private static final int _BATCH_SIZE = 0;
    private static final String _MULTIPART_TYPE_ALTERNATIVE = "alternative";
    private static final String _MULTIPART_TYPE_MIXED = "mixed";
    private static final String _TEXT_HTML = "text/html;charset=\"UTF-8\"";
    private static final String _TEXT_PLAIN = "text/plain;charset=\"UTF-8\"";
    private static Log _log = LogFactoryUtil.getLog(MailEngine.class);

    public static Session getSession() {
        return MailEngine.getSession(false);
    }

    public static Session getSession(Account account) {
        Properties properties = MailEngine._getProperties(account);
        Session session = Session.getInstance((Properties)properties);
        if (_log.isDebugEnabled()) {
            session.setDebug(true);
            session.getProperties().list(System.out);
        }
        return session;
    }

    public static Session getSession(boolean cache) {
        Session session = null;
        try {
            session = MailServiceUtil.getSession();
        }
        catch (SystemException se) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)se, (Throwable)se);
            }
            session = InfrastructureUtil.getMailSession();
        }
        if (_log.isDebugEnabled()) {
            session.setDebug(true);
            session.getProperties().list(System.out);
        }
        return session;
    }

    public static void send(byte[] bytes) throws MailEngineException {
        try {
            Session session = MailEngine.getSession();
            MimeMessage message = new MimeMessage(session, (InputStream)new UnsyncByteArrayInputStream(bytes));
            MailEngine._send(session, (Message)message, null, 0);
        }
        catch (Exception e) {
            throw new MailEngineException(e);
        }
    }

    public static void send(InternetAddress from, InternetAddress to, String subject, String body) throws MailEngineException {
        MailEngine.send(from, new InternetAddress[]{to}, null, null, subject, body, false, null, null, null);
    }

    public static void send(InternetAddress from, InternetAddress to, String subject, String body, boolean htmlFormat) throws MailEngineException {
        MailEngine.send(from, new InternetAddress[]{to}, null, null, subject, body, htmlFormat, null, null, null);
    }

    public static void send(InternetAddress from, InternetAddress[] to, InternetAddress[] cc, InternetAddress[] bcc, InternetAddress[] bulkAddresses, String subject, String body, boolean htmlFormat, InternetAddress[] replyTo, String messageId, String inReplyTo) throws MailEngineException {
        MailEngine.send(from, to, cc, bcc, bulkAddresses, subject, body, htmlFormat, replyTo, messageId, inReplyTo, null);
    }

    public static void send(InternetAddress from, InternetAddress[] to, InternetAddress[] cc, InternetAddress[] bcc, InternetAddress[] bulkAddresses, String subject, String body, boolean htmlFormat, InternetAddress[] replyTo, String messageId, String inReplyTo, List<FileAttachment> fileAttachments) throws MailEngineException {
        MailEngine.send(from, to, cc, bcc, bulkAddresses, subject, body, htmlFormat, replyTo, messageId, inReplyTo, fileAttachments, null);
    }

    public static void send(InternetAddress from, InternetAddress[] to, InternetAddress[] cc, InternetAddress[] bcc, InternetAddress[] bulkAddresses, String subject, String body, boolean htmlFormat, InternetAddress[] replyTo, String messageId, String inReplyTo, List<FileAttachment> fileAttachments, SMTPAccount smtpAccount) throws MailEngineException {
        StopWatch stopWatch = null;
        if (_log.isDebugEnabled()) {
            stopWatch = new StopWatch();
            stopWatch.start();
            _log.debug((Object)("From: " + from));
            _log.debug((Object)("To: " + Arrays.toString(to)));
            _log.debug((Object)("CC: " + Arrays.toString(cc)));
            _log.debug((Object)("BCC: " + Arrays.toString(bcc)));
            _log.debug((Object)("List Addresses: " + Arrays.toString(bulkAddresses)));
            _log.debug((Object)("Subject: " + subject));
            _log.debug((Object)("Body: " + body));
            _log.debug((Object)("HTML Format: " + htmlFormat));
            _log.debug((Object)("Reply to: " + Arrays.toString(replyTo)));
            _log.debug((Object)("Message ID: " + messageId));
            _log.debug((Object)("In Reply To: " + inReplyTo));
            if (fileAttachments != null && _log.isDebugEnabled()) {
                int i = 0;
                while (i < fileAttachments.size()) {
                    FileAttachment fileAttachment = fileAttachments.get(i);
                    File file = fileAttachment.getFile();
                    if (file != null) {
                        _log.debug((Object)("Attachment " + i + " file " + file.getAbsolutePath() + " and file name " + fileAttachment.getFileName()));
                    }
                    ++i;
                }
            }
        }
        try {
            InternetAddressUtil.validateAddress((Address)from);
            if (to != null) {
                InternetAddressUtil.validateAddresses((Address[])to);
            }
            if (cc != null) {
                InternetAddressUtil.validateAddresses((Address[])cc);
            }
            if (bcc != null) {
                InternetAddressUtil.validateAddresses((Address[])bcc);
            }
            if (replyTo != null) {
                InternetAddressUtil.validateAddresses((Address[])replyTo);
            }
            if (bulkAddresses != null) {
                InternetAddressUtil.validateAddresses((Address[])bulkAddresses);
            }
            Session session = null;
            session = smtpAccount == null ? MailEngine.getSession() : MailEngine.getSession((Account)smtpAccount);
            LiferayMimeMessage message = new LiferayMimeMessage(session);
            message.addHeader("X-Auto-Response-Suppress", "AutoReply, DR, NDR, NRN, OOF, RN");
            message.setFrom((Address)from);
            if (to != null) {
                message.setRecipients(Message.RecipientType.TO, (Address[])to);
            }
            if (cc != null) {
                message.setRecipients(Message.RecipientType.CC, (Address[])cc);
            }
            if (bcc != null) {
                message.setRecipients(Message.RecipientType.BCC, (Address[])bcc);
            }
            subject = GetterUtil.getString((String)subject);
            message.setSubject(subject);
            if (fileAttachments != null && fileAttachments.size() > 0) {
                MimeBodyPart bodyPart;
                MimeMultipart rootMultipart = new MimeMultipart(_MULTIPART_TYPE_MIXED);
                MimeMultipart messageMultipart = new MimeMultipart(_MULTIPART_TYPE_ALTERNATIVE);
                MimeBodyPart messageBodyPart = new MimeBodyPart();
                messageBodyPart.setContent((Multipart)messageMultipart);
                rootMultipart.addBodyPart((BodyPart)messageBodyPart);
                if (htmlFormat) {
                    bodyPart = new MimeBodyPart();
                    bodyPart.setContent((Object)body, _TEXT_HTML);
                    messageMultipart.addBodyPart((BodyPart)bodyPart);
                } else {
                    bodyPart = new MimeBodyPart();
                    bodyPart.setText(body);
                    messageMultipart.addBodyPart((BodyPart)bodyPart);
                }
                int i = 0;
                while (i < fileAttachments.size()) {
                    FileAttachment fileAttachment = fileAttachments.get(i);
                    File file = fileAttachment.getFile();
                    if (file != null) {
                        MimeBodyPart mimeBodyPart = new MimeBodyPart();
                        FileDataSource dataSource = new FileDataSource(file);
                        mimeBodyPart.setDataHandler(new DataHandler((DataSource)dataSource));
                        mimeBodyPart.setDisposition("attachment");
                        if (fileAttachment.getFileName() != null) {
                            mimeBodyPart.setFileName(fileAttachment.getFileName());
                        } else {
                            mimeBodyPart.setFileName(file.getName());
                        }
                        rootMultipart.addBodyPart((BodyPart)mimeBodyPart);
                    }
                    ++i;
                }
                message.setContent((Multipart)rootMultipart);
                message.saveChanges();
            } else if (htmlFormat) {
                message.setContent(body, _TEXT_HTML);
            } else {
                message.setContent(body, _TEXT_PLAIN);
            }
            message.setSentDate(new Date());
            if (replyTo != null) {
                message.setReplyTo((Address[])replyTo);
            }
            if (messageId != null) {
                message.setHeader("Message-ID", messageId);
            }
            if (inReplyTo != null) {
                message.setHeader("In-Reply-To", inReplyTo);
                message.setHeader("References", inReplyTo);
            }
            int batchSize = GetterUtil.getInteger((String)PropsUtil.get((String)"mail.batch.size"), (int)0);
            MailEngine._send(session, (Message)message, bulkAddresses, batchSize);
        }
        catch (SendFailedException sfe) {
            _log.error((Throwable)sfe);
        }
        catch (Exception e) {
            throw new MailEngineException(e);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Sending mail takes " + stopWatch.getTime() + " ms"));
        }
    }

    public static void send(InternetAddress from, InternetAddress[] to, InternetAddress[] cc, InternetAddress[] bcc, String subject, String body) throws MailEngineException {
        MailEngine.send(from, to, cc, bcc, subject, body, false, null, null, null);
    }

    public static void send(InternetAddress from, InternetAddress[] to, InternetAddress[] cc, InternetAddress[] bcc, String subject, String body, boolean htmlFormat, InternetAddress[] replyTo, String messageId, String inReplyTo) throws MailEngineException {
        MailEngine.send(from, to, cc, bcc, null, subject, body, htmlFormat, replyTo, messageId, inReplyTo, null);
    }

    public static void send(InternetAddress from, InternetAddress[] to, InternetAddress[] cc, String subject, String body) throws MailEngineException {
        MailEngine.send(from, to, cc, null, subject, body, false, null, null, null);
    }

    public static void send(InternetAddress from, InternetAddress[] to, InternetAddress[] cc, String subject, String body, boolean htmlFormat) throws MailEngineException {
        MailEngine.send(from, to, cc, null, subject, body, htmlFormat, null, null, null);
    }

    public static void send(InternetAddress from, InternetAddress[] to, String subject, String body) throws MailEngineException {
        MailEngine.send(from, to, null, null, subject, body, false, null, null, null);
    }

    public static void send(InternetAddress from, InternetAddress[] to, String subject, String body, boolean htmlFormat) throws MailEngineException {
        MailEngine.send(from, to, null, null, subject, body, htmlFormat, null, null, null);
    }

    public static void send(MailMessage mailMessage) throws MailEngineException {
        MailEngine.send(mailMessage.getFrom(), mailMessage.getTo(), mailMessage.getCC(), mailMessage.getBCC(), mailMessage.getBulkAddresses(), mailMessage.getSubject(), mailMessage.getBody(), mailMessage.isHTMLFormat(), mailMessage.getReplyTo(), mailMessage.getMessageId(), mailMessage.getInReplyTo(), mailMessage.getFileAttachments(), mailMessage.getSMTPAccount());
    }

    public static void send(String from, String to, String subject, String body) throws MailEngineException {
        try {
            MailEngine.send(new InternetAddress(from), new InternetAddress(to), subject, body);
        }
        catch (AddressException ae) {
            throw new MailEngineException(ae);
        }
    }

    private static Address[] _getBatchAddresses(Address[] addresses, int index, int batchSize) {
        if (batchSize == 0 && index == 0) {
            return addresses;
        }
        if (batchSize == 0) {
            return null;
        }
        int start = index * batchSize;
        if (start > addresses.length) {
            return null;
        }
        int end = (index + 1) * batchSize;
        if (end > addresses.length) {
            end = addresses.length;
        }
        return (Address[])ArrayUtil.subset((Object[])addresses, (int)start, (int)end);
    }

    private static Properties _getProperties(Account account) {
        Properties properties = new Properties();
        String protocol = account.getProtocol();
        properties.setProperty("mail.transport.protocol", protocol);
        properties.setProperty("mail." + protocol + ".host", account.getHost());
        properties.setProperty("mail." + protocol + ".port", String.valueOf(account.getPort()));
        if (account.isRequiresAuthentication()) {
            properties.setProperty("mail." + protocol + ".auth", "true");
            properties.setProperty("mail." + protocol + ".user", account.getUser());
            properties.setProperty("mail." + protocol + ".password", account.getPassword());
        }
        if (account.isSecure()) {
            properties.setProperty("mail." + protocol + ".socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            properties.setProperty("mail." + protocol + ".socketFactory.fallback", "false");
            properties.setProperty("mail." + protocol + ".socketFactory.port", String.valueOf(account.getPort()));
        }
        return properties;
    }

    private static String _getSMTPProperty(Session session, String suffix) {
        String protocol = GetterUtil.getString((String)session.getProperty("mail.transport.protocol"));
        if (protocol.equals("smtps")) {
            return session.getProperty("mail.smtps." + suffix);
        }
        return session.getProperty("mail.smtp." + suffix);
    }

    private static void _send(Session session, Message message, InternetAddress[] bulkAddresses, int batchSize) {
        try {
            boolean smtpAuth = GetterUtil.getBoolean((String)MailEngine._getSMTPProperty(session, "auth"), (boolean)false);
            String smtpHost = MailEngine._getSMTPProperty(session, "host");
            int smtpPort = GetterUtil.getInteger((String)MailEngine._getSMTPProperty(session, "port"), (int)25);
            String user = MailEngine._getSMTPProperty(session, "user");
            String password = MailEngine._getSMTPProperty(session, "password");
            if (smtpAuth && Validator.isNotNull((String)user) && Validator.isNotNull((String)password)) {
                Address[] batchAddresses;
                String protocol = GetterUtil.getString((String)session.getProperty("mail.transport.protocol"), (String)"smtp");
                Transport transport = session.getTransport(protocol);
                transport.connect(smtpHost, smtpPort, user, password);
                Object[] addresses = null;
                addresses = Validator.isNotNull((Object[])bulkAddresses) ? bulkAddresses : message.getAllRecipients();
                int i = 0;
                while ((batchAddresses = MailEngine._getBatchAddresses(addresses, i, batchSize)) != null && batchAddresses.length != 0) {
                    transport.sendMessage(message, batchAddresses);
                    ++i;
                }
                transport.close();
            } else if (Validator.isNotNull((Object[])bulkAddresses)) {
                int curBatch = 0;
                Object[] portion = MailEngine._getBatchAddresses((Address[])bulkAddresses, curBatch, batchSize);
                while (Validator.isNotNull((Object[])portion)) {
                    Transport.send((Message)message, (Address[])portion);
                    portion = MailEngine._getBatchAddresses((Address[])bulkAddresses, ++curBatch, batchSize);
                }
            } else {
                Transport.send((Message)message);
            }
        }
        catch (MessagingException me) {
            if (me.getNextException() instanceof SocketException) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Failed to connect to a valid mail server. Please make sure one is properly configured. " + me.getMessage()));
                }
            }
            _log.error((Object)me.getMessage());
            LogUtil.log((Log)_log, (Throwable)me);
        }
    }
}

