/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import java.awt.Color;

public class ColorUtil {
    private static final String _KEY = "0123456789ABCDEF";

    public static Color blend(Color color1, Color color2, double ratio) {
        int[] rgb1 = new int[]{color1.getRed(), color1.getGreen(), color1.getBlue()};
        int[] rgb2 = new int[]{color2.getRed(), color2.getGreen(), color2.getBlue()};
        return ColorUtil.blend(rgb1, rgb2, ratio);
    }

    public static Color blend(int[] color1, int[] color2, double ratio) {
        Color blended = new Color((int)((double)(color2[0] - color1[0]) * ratio + (double)color1[0]), (int)((double)(color2[1] - color1[1]) * ratio + (double)color1[1]), (int)((double)(color2[2] - color1[2]) * ratio + (double)color1[2]));
        return blended;
    }

    public static Color darker(int[] color, double ratio) {
        Color darkened = new Color((int)((double)color[0] - (double)color[0] * ratio), (int)((double)color[1] - (double)color[1] * ratio), (int)((double)color[2] - (double)color[2] * ratio));
        return darkened;
    }

    public static String getHex(int[] rgb) {
        StringBundler sb = new StringBundler(7);
        sb.append("#");
        sb.append(_KEY.substring((int)Math.floor(rgb[0] / 16), (int)Math.floor(rgb[0] / 16) + 1));
        sb.append(_KEY.substring(rgb[0] % 16, rgb[0] % 16 + 1));
        sb.append(_KEY.substring((int)Math.floor(rgb[1] / 16), (int)Math.floor(rgb[1] / 16) + 1));
        sb.append(_KEY.substring(rgb[1] % 16, rgb[1] % 16 + 1));
        sb.append(_KEY.substring((int)Math.floor(rgb[2] / 16), (int)Math.floor(rgb[2] / 16) + 1));
        sb.append(_KEY.substring(rgb[2] % 16, rgb[2] % 16 + 1));
        return sb.toString();
    }

    public static int[] getRGB(String hex) {
        hex = hex.startsWith("#") ? hex.substring(1, hex.length()).toUpperCase() : hex.toUpperCase();
        int[] hexArray = new int[6];
        if (hex.length() == 6) {
            char[] c = hex.toCharArray();
            int i = 0;
            while (i < hex.length()) {
                hexArray[i] = c[i] == 'A' ? 10 : (c[i] == 'B' ? 11 : (c[i] == 'C' ? 12 : (c[i] == 'D' ? 13 : (c[i] == 'E' ? 14 : (c[i] == 'F' ? 15 : GetterUtil.getInteger((String)new Character(c[i]).toString()))))));
                ++i;
            }
        }
        int[] rgb = new int[]{hexArray[0] * 16 + hexArray[1], hexArray[2] * 16 + hexArray[3], hexArray[4] * 16 + hexArray[5]};
        return rgb;
    }

    public static Color lighter(int[] color, double ratio) {
        Color lightened = new Color((int)((double)(255 - color[0]) * ratio + (double)color[0]), (int)((double)(255 - color[1]) * ratio + (double)color[1]), (int)((double)(255 - color[2]) * ratio + (double)color[2]));
        return lightened;
    }
}

