/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.sl4fj;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.util.sl4fj.LiferayLoggerAdapter;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;

public class LiferayLoggerFactory
implements ILoggerFactory {
    private Map<String, Logger> _loggers = new HashMap<String, Logger>();
    private Lock _readLock;
    private Lock _writeLock;

    public LiferayLoggerFactory() {
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        this._readLock = readWriteLock.readLock();
        this._writeLock = readWriteLock.writeLock();
    }

    public Logger getLogger(String name) {
        Object logger = null;
        this._readLock.lock();
        try {
            logger = this._loggers.get(name);
        }
        finally {
            this._readLock.unlock();
        }
        if (logger == null) {
            this._writeLock.lock();
            try {
                Log log = LogFactoryUtil.getLog((String)name);
                logger = new LiferayLoggerAdapter(log);
                this._loggers.put(name, (Logger)logger);
            }
            finally {
                this._writeLock.unlock();
            }
        }
        return logger;
    }
}

