/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.servlet.filters;

import com.liferay.portal.kernel.servlet.Header;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.util.servlet.filters.CacheResponseData;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheResponseUtil {
    public static void setHeaders(HttpServletResponse response, Map<String, List<Header>> headers) {
        for (Map.Entry<String, List<Header>> entry : headers.entrySet()) {
            String headerKey = entry.getKey();
            List headerValues = ListUtil.copy(entry.getValue());
            for (Header header : headerValues) {
                int type = header.getType();
                if (type == 4) {
                    response.addCookie(header.getCookieValue());
                    continue;
                }
                if (type == 2) {
                    response.setDateHeader(headerKey, header.getDateValue());
                    continue;
                }
                if (type == 1) {
                    response.setIntHeader(headerKey, header.getIntValue());
                    continue;
                }
                if (type != 3) continue;
                response.setHeader(headerKey, header.getStringValue());
            }
        }
    }

    public static void write(HttpServletResponse response, CacheResponseData cacheResponseData) throws IOException {
        CacheResponseUtil.setHeaders(response, cacheResponseData.getHeaders());
        response.setContentType(cacheResponseData.getContentType());
        ServletResponseUtil.write((HttpServletResponse)response, (ByteBuffer)cacheResponseData.getByteBuffer());
    }
}

