/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.dao.orm;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.util.PortalUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class CustomSQL {
    public static final String DB2_FUNCTION_IS_NOT_NULL = "CAST(? AS VARCHAR(32672)) IS NOT NULL";
    public static final String DB2_FUNCTION_IS_NULL = "CAST(? AS VARCHAR(32672)) IS NULL";
    public static final String INFORMIX_FUNCTION_IS_NOT_NULL = "NOT lportal.isnull(?)";
    public static final String INFORMIX_FUNCTION_IS_NULL = "lportal.isnull(?)";
    public static final String MYSQL_FUNCTION_IS_NOT_NULL = "IFNULL(?, '1') = '0'";
    public static final String MYSQL_FUNCTION_IS_NULL = "IFNULL(?, '1') = '1'";
    public static final String SYBASE_FUNCTION_IS_NOT_NULL = "CONVERT(VARCHAR,?) IS NOT NULL";
    public static final String SYBASE_FUNCTION_IS_NULL = "CONVERT(VARCHAR,?) IS NULL";
    private static final String _GROUP_BY_CLAUSE = " GROUP BY ";
    private static final String _ORDER_BY_CLAUSE = " ORDER BY ";
    private static Log _log = LogFactoryUtil.getLog(CustomSQL.class);
    private String _functionIsNotNull;
    private String _functionIsNull;
    private Map<String, String> _sqlPool;
    private boolean _vendorDB2;
    private boolean _vendorInformix;
    private boolean _vendorMySQL;
    private boolean _vendorOracle;
    private boolean _vendorPostgreSQL;
    private boolean _vendorSybase;

    public CustomSQL() throws SQLException {
        this.reloadCustomSQL();
    }

    public String appendCriteria(String sql, String criteria) {
        int pos;
        if (Validator.isNull((String)criteria)) {
            return sql;
        }
        if (!criteria.startsWith(" ")) {
            criteria = " ".concat(criteria);
        }
        if (!criteria.endsWith(" ")) {
            criteria = criteria.concat(" ");
        }
        if ((pos = sql.indexOf(_GROUP_BY_CLAUSE)) != -1) {
            return sql.substring(0, pos + 1).concat(criteria).concat(sql.substring(pos + 1));
        }
        pos = sql.indexOf(_ORDER_BY_CLAUSE);
        if (pos != -1) {
            return sql.substring(0, pos + 1).concat(criteria).concat(sql.substring(pos + 1));
        }
        return sql.concat(criteria);
    }

    public String get(String id) {
        return this._sqlPool.get(id);
    }

    public boolean isVendorDB2() {
        return this._vendorDB2;
    }

    public boolean isVendorInformix() {
        return this._vendorInformix;
    }

    public boolean isVendorMySQL() {
        return this._vendorMySQL;
    }

    public boolean isVendorOracle() {
        return this._vendorOracle;
    }

    public boolean isVendorPostgreSQL() {
        return this._vendorPostgreSQL;
    }

    public boolean isVendorSybase() {
        return this._vendorSybase;
    }

    public String[] keywords(String keywords) {
        return this.keywords(keywords, true);
    }

    public String[] keywords(String keywords, boolean lowerCase) {
        if (Validator.isNull((String)keywords)) {
            return new String[1];
        }
        if (lowerCase) {
            keywords = keywords.toLowerCase();
        }
        keywords = keywords.trim();
        String[] keywordsArray = keywords.split("\\s+");
        int i = 0;
        while (i < keywordsArray.length) {
            String keyword = keywordsArray[i];
            keywordsArray[i] = "%" + keyword + "%";
            ++i;
        }
        return keywordsArray;
    }

    public String[] keywords(String[] keywordsArray) {
        return this.keywords(keywordsArray, true);
    }

    public String[] keywords(String[] keywordsArray, boolean lowerCase) {
        if (keywordsArray == null || keywordsArray.length == 0) {
            return new String[1];
        }
        if (lowerCase) {
            int i = 0;
            while (i < keywordsArray.length) {
                keywordsArray[i] = StringUtil.lowerCase((String)keywordsArray[i]);
                ++i;
            }
        }
        return keywordsArray;
    }

    public void reloadCustomSQL() throws SQLException {
        block34: {
            PortalUtil.initCustomSQL();
            Connection con = DataAccess.getConnection();
            String functionIsNull = PortalUtil.getCustomSQLFunctionIsNull();
            String functionIsNotNull = PortalUtil.getCustomSQLFunctionIsNotNull();
            try {
                try {
                    if (Validator.isNotNull((String)functionIsNull) && Validator.isNotNull((String)functionIsNotNull)) {
                        this._functionIsNull = functionIsNull;
                        this._functionIsNotNull = functionIsNotNull;
                        if (_log.isDebugEnabled()) {
                            _log.info((Object)("functionIsNull is manually set to " + functionIsNull));
                            _log.info((Object)("functionIsNotNull is manually set to " + functionIsNotNull));
                        }
                    } else if (con != null) {
                        DatabaseMetaData metaData = con.getMetaData();
                        String dbName = GetterUtil.getString((String)metaData.getDatabaseProductName());
                        if (_log.isInfoEnabled()) {
                            _log.info((Object)("Database name " + dbName));
                        }
                        if (dbName.startsWith("DB2")) {
                            this._vendorDB2 = true;
                            this._functionIsNull = DB2_FUNCTION_IS_NULL;
                            this._functionIsNotNull = DB2_FUNCTION_IS_NOT_NULL;
                            if (_log.isInfoEnabled()) {
                                _log.info((Object)("Detected DB2 with database name " + dbName));
                            }
                        } else if (dbName.startsWith("Informix")) {
                            this._vendorInformix = true;
                            this._functionIsNull = INFORMIX_FUNCTION_IS_NULL;
                            this._functionIsNotNull = INFORMIX_FUNCTION_IS_NOT_NULL;
                            if (_log.isInfoEnabled()) {
                                _log.info((Object)("Detected Informix with database name " + dbName));
                            }
                        } else if (dbName.startsWith("MySQL")) {
                            this._vendorMySQL = true;
                            if (_log.isInfoEnabled()) {
                                _log.info((Object)("Detected MySQL with database name " + dbName));
                            }
                        } else if (dbName.startsWith("Sybase") || dbName.equals("ASE")) {
                            this._vendorSybase = true;
                            this._functionIsNull = SYBASE_FUNCTION_IS_NULL;
                            this._functionIsNotNull = SYBASE_FUNCTION_IS_NOT_NULL;
                            if (_log.isInfoEnabled()) {
                                _log.info((Object)("Detected Sybase with database name " + dbName));
                            }
                        } else if (dbName.startsWith("Oracle")) {
                            this._vendorOracle = true;
                            if (_log.isInfoEnabled()) {
                                _log.info((Object)("Detected Oracle with database name " + dbName));
                            }
                        } else if (dbName.startsWith("PostgreSQL")) {
                            this._vendorPostgreSQL = true;
                            if (_log.isInfoEnabled()) {
                                _log.info((Object)("Detected PostgreSQL with database name " + dbName));
                            }
                        } else if (_log.isDebugEnabled()) {
                            _log.debug((Object)("Unable to detect database with name " + dbName));
                        }
                    }
                }
                catch (Exception e) {
                    _log.error((Object)e, (Throwable)e);
                    DataAccess.cleanUp((Connection)con);
                    break block34;
                }
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp((Connection)con);
                throw throwable;
            }
            DataAccess.cleanUp((Connection)con);
        }
        if (this._sqlPool == null) {
            this._sqlPool = new HashMap<String, String>();
        } else {
            this._sqlPool.clear();
        }
        try {
            String[] configs;
            Class<?> clazz = this.getClass();
            ClassLoader classLoader = clazz.getClassLoader();
            String[] stringArray = configs = this.getConfigs();
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                String _config = stringArray[n2];
                this.read(classLoader, _config);
                ++n2;
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public String removeGroupBy(String sql) {
        int x = sql.indexOf(_GROUP_BY_CLAUSE);
        if (x != -1) {
            int y = sql.indexOf(_ORDER_BY_CLAUSE);
            sql = y == -1 ? sql.substring(0, x) : String.valueOf(sql.substring(0, x)) + sql.substring(y);
        }
        return sql;
    }

    public String removeOrderBy(String sql) {
        int pos = sql.indexOf(_ORDER_BY_CLAUSE);
        if (pos != -1) {
            sql = sql.substring(0, pos);
        }
        return sql;
    }

    public String replaceAndOperator(String sql, boolean andOperator) {
        String andOrConnector = "OR";
        String andOrNullCheck = "AND ? IS NOT NULL";
        if (andOperator) {
            andOrConnector = "AND";
            andOrNullCheck = "OR ? IS NULL";
        }
        sql = StringUtil.replace((String)sql, (String[])new String[]{"[$AND_OR_CONNECTOR$]", "[$AND_OR_NULL_CHECK$]"}, (String[])new String[]{andOrConnector, andOrNullCheck});
        if (this._vendorPostgreSQL) {
            sql = StringUtil.replace((String)sql, (String[])new String[]{"Date >= ? AND ? IS NOT NULL", "Date <= ? AND ? IS NOT NULL", "Date >= ? OR ? IS NULL", "Date <= ? OR ? IS NULL"}, (String[])new String[]{"Date >= ? AND CAST(? AS TIMESTAMP) IS NOT NULL", "Date <= ? AND CAST(? AS TIMESTAMP) IS NOT NULL", "Date >= ? OR CAST(? AS TIMESTAMP) IS NULL", "Date <= ? OR CAST(? AS TIMESTAMP) IS NULL"});
        }
        sql = this.replaceIsNull(sql);
        return sql;
    }

    public String replaceGroupBy(String sql, String groupBy) {
        if (groupBy == null) {
            return sql;
        }
        int x = sql.indexOf(_GROUP_BY_CLAUSE);
        if (x != -1) {
            int y = sql.indexOf(_ORDER_BY_CLAUSE);
            sql = y == -1 ? sql.substring(0, x + _GROUP_BY_CLAUSE.length()).concat(groupBy) : sql.substring(0, x + _GROUP_BY_CLAUSE.length()).concat(groupBy).concat(sql.substring(y));
        } else {
            int y = sql.indexOf(_ORDER_BY_CLAUSE);
            if (y == -1) {
                sql = sql.concat(_GROUP_BY_CLAUSE).concat(groupBy);
            } else {
                StringBundler sb = new StringBundler();
                sb.append(sql.substring(0, y));
                sb.append(_GROUP_BY_CLAUSE);
                sb.append(groupBy);
                sb.append(sql.substring(y));
                sql = sb.toString();
            }
        }
        return sql;
    }

    public String replaceIsNull(String sql) {
        if (Validator.isNotNull((String)this._functionIsNull)) {
            sql = StringUtil.replace((String)sql, (String[])new String[]{"? IS NULL", "? IS NOT NULL"}, (String[])new String[]{this._functionIsNull, this._functionIsNotNull});
        }
        return sql;
    }

    public String replaceKeywords(String sql, String field, boolean last, int[] values) {
        if (values != null && values.length == 1) {
            return sql;
        }
        StringBundler oldSql = new StringBundler(4);
        oldSql.append("(");
        oldSql.append(field);
        oldSql.append(" = ?)");
        if (!last) {
            oldSql.append(" [$AND_OR_CONNECTOR$]");
        }
        if (values == null || values.length == 0) {
            return StringUtil.replace((String)sql, (String)oldSql.toString(), (String)"");
        }
        StringBundler newSql = new StringBundler(values.length * 4 + 3);
        newSql.append("(");
        int i = 0;
        while (i < values.length) {
            if (i > 0) {
                newSql.append(" OR ");
            }
            newSql.append("(");
            newSql.append(field);
            newSql.append(" = ?)");
            ++i;
        }
        newSql.append(")");
        if (!last) {
            newSql.append(" [$AND_OR_CONNECTOR$]");
        }
        return StringUtil.replace((String)sql, (String)oldSql.toString(), (String)newSql.toString());
    }

    public String replaceKeywords(String sql, String field, boolean last, long[] values) {
        if (values != null && values.length == 1) {
            return sql;
        }
        StringBundler oldSql = new StringBundler(4);
        oldSql.append("(");
        oldSql.append(field);
        oldSql.append(" = ?)");
        if (!last) {
            oldSql.append(" [$AND_OR_CONNECTOR$]");
        }
        if (values == null || values.length == 0) {
            return StringUtil.replace((String)sql, (String)oldSql.toString(), (String)"");
        }
        StringBundler newSql = new StringBundler(values.length * 4 + 3);
        newSql.append("(");
        int i = 0;
        while (i < values.length) {
            if (i > 0) {
                newSql.append(" OR ");
            }
            newSql.append("(");
            newSql.append(field);
            newSql.append(" = ?)");
            ++i;
        }
        newSql.append(")");
        if (!last) {
            newSql.append(" [$AND_OR_CONNECTOR$]");
        }
        return StringUtil.replace((String)sql, (String)oldSql.toString(), (String)newSql.toString());
    }

    public String replaceKeywords(String sql, String field, String operator, boolean last, String[] values) {
        if (values != null && values.length <= 1) {
            return sql;
        }
        StringBundler oldSql = new StringBundler(6);
        oldSql.append("(");
        oldSql.append(field);
        oldSql.append(" ");
        oldSql.append(operator);
        oldSql.append(" ? [$AND_OR_NULL_CHECK$])");
        if (!last) {
            oldSql.append(" [$AND_OR_CONNECTOR$]");
        }
        StringBundler newSql = new StringBundler(values.length * 6 + 3);
        newSql.append("(");
        int i = 0;
        while (i < values.length) {
            if (i > 0) {
                newSql.append(" OR ");
            }
            newSql.append("(");
            newSql.append(field);
            newSql.append(" ");
            newSql.append(operator);
            newSql.append(" ? [$AND_OR_NULL_CHECK$])");
            ++i;
        }
        newSql.append(")");
        if (!last) {
            newSql.append(" [$AND_OR_CONNECTOR$]");
        }
        return StringUtil.replace((String)sql, (String)oldSql.toString(), (String)newSql.toString());
    }

    public String replaceOrderBy(String sql, OrderByComparator obc) {
        if (obc == null) {
            return sql;
        }
        String orderBy = obc.getOrderBy();
        int pos = sql.indexOf(_ORDER_BY_CLAUSE);
        sql = pos != -1 && pos < sql.length() ? sql.substring(0, pos + _ORDER_BY_CLAUSE.length()).concat(orderBy) : sql.concat(_ORDER_BY_CLAUSE).concat(orderBy);
        return sql;
    }

    protected String[] getConfigs() {
        if (PortalClassLoaderUtil.getClassLoader() == CustomSQL.class.getClassLoader()) {
            Properties propsUtil = PortalUtil.getPortalProperties();
            return StringUtil.split((String)propsUtil.getProperty("custom.sql.configs"));
        }
        return new String[]{"custom-sql/default.xml"};
    }

    protected void read(ClassLoader classLoader, String source) throws Exception {
        InputStream is = classLoader.getResourceAsStream(source);
        if (is == null) {
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Loading " + source));
        }
        Document document = SAXReaderUtil.read((InputStream)is);
        Element rootElement = document.getRootElement();
        for (Element sqlElement : rootElement.elements("sql")) {
            String file = sqlElement.attributeValue("file");
            if (Validator.isNotNull((String)file)) {
                this.read(classLoader, file);
                continue;
            }
            String id = sqlElement.attributeValue("id");
            String content = this.transform(sqlElement.getText());
            content = this.replaceIsNull(content);
            this._sqlPool.put(id, content);
        }
    }

    protected String transform(String sql) {
        sql = PortalUtil.transformCustomSQL((String)sql);
        StringBundler sb = new StringBundler();
        try {
            UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(sql));
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                sb.append(line.trim());
                sb.append(" ");
            }
            unsyncBufferedReader.close();
        }
        catch (IOException iOException) {
            return sql;
        }
        return sb.toString();
    }
}

