/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.ant;

import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Time;
import com.liferay.portal.kernel.xml.Attribute;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.util.ant.AntUtil;
import com.liferay.util.ant.DeleteTask;
import java.io.File;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import org.apache.axis.tools.ant.wsdl.Java2WsdlAntTask;
import org.apache.axis.tools.ant.wsdl.NamespaceMapping;
import org.apache.axis.tools.ant.wsdl.Wsdl2javaAntTask;
import org.apache.tools.ant.Project;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Java2WsddTask {
    public static String[] generateWsdd(String className, String serviceName) throws Exception {
        File tempDir = new File(Time.getTimestamp());
        tempDir.mkdir();
        String wsdlFileName = tempDir + "/service.wsdl";
        int pos = className.lastIndexOf(".");
        String packagePath = className.substring(0, pos);
        String[] packagePaths = StringUtil.split((String)packagePath, (char)'.');
        String namespace = "urn:";
        int i = packagePaths.length - 1;
        while (i >= 0) {
            namespace = String.valueOf(namespace) + packagePaths[i];
            if (i > 0) {
                namespace = String.valueOf(namespace) + ".";
            }
            --i;
        }
        String location = "http://localhost/services/" + serviceName;
        String mappingPackage = String.valueOf(packagePath.substring(0, packagePath.lastIndexOf("."))) + ".ws";
        Project project = AntUtil.getProject();
        Java2WsdlAntTask java2Wsdl = new Java2WsdlAntTask();
        NamespaceMapping mapping = new NamespaceMapping();
        mapping.setNamespace(namespace);
        mapping.setPackage(mappingPackage);
        java2Wsdl.setProject(project);
        java2Wsdl.setClassName(className);
        java2Wsdl.setOutput(new File(wsdlFileName));
        java2Wsdl.setLocation(location);
        java2Wsdl.setNamespace(namespace);
        java2Wsdl.addMapping(mapping);
        java2Wsdl.execute();
        Wsdl2javaAntTask wsdl2Java = new Wsdl2javaAntTask();
        wsdl2Java.setProject(project);
        wsdl2Java.setURL(wsdlFileName);
        wsdl2Java.setOutput(tempDir);
        wsdl2Java.setServerSide(true);
        wsdl2Java.setTestCase(false);
        wsdl2Java.setVerbose(false);
        wsdl2Java.execute();
        String deployContent = FileUtil.read((String)(tempDir + "/" + StringUtil.replace((String)packagePath, (String)".", (String)"/") + "/deploy.wsdd"));
        deployContent = StringUtil.replace((String)deployContent, (String)(String.valueOf(packagePath) + "." + serviceName + "SoapBindingImpl"), (String)className);
        deployContent = Java2WsddTask._format(deployContent);
        String undeployContent = FileUtil.read((String)(tempDir + "/" + StringUtil.replace((String)packagePath, (String)".", (String)"/") + "/undeploy.wsdd"));
        undeployContent = Java2WsddTask._format(undeployContent);
        DeleteTask.deleteDirectory(tempDir);
        return new String[]{deployContent, undeployContent};
    }

    private static void _addElements(Element element, Map<String, Element> elements) {
        for (Map.Entry<String, Element> entry : elements.entrySet()) {
            Element childElement = entry.getValue();
            element.add(childElement);
        }
    }

    private static String _format(String content) throws Exception {
        content = HtmlUtil.stripComments((String)content);
        Document document = SAXReaderUtil.read((String)content);
        Element rootElement = document.getRootElement();
        Element serviceElement = rootElement.element("service");
        TreeMap<String, Element> arrayMappingElements = new TreeMap<String, Element>();
        TreeMap<String, Element> typeMappingElements = new TreeMap<String, Element>();
        TreeMap<String, Element> operationElements = new TreeMap<String, Element>();
        TreeMap<String, Element> parameterElements = new TreeMap<String, Element>();
        for (Element element : serviceElement.elements()) {
            String elementName = element.getName();
            if (elementName.equals("arrayMapping")) {
                element.detach();
                arrayMappingElements.put(element.formattedString(), element);
                continue;
            }
            if (elementName.equals("operation")) {
                element.detach();
                StringBundler sb = new StringBundler();
                String name = element.attributeValue("name");
                sb.append(name);
                sb.append("_METHOD_");
                for (Element parameterElement : element.elements("parameter")) {
                    String type = parameterElement.attributeValue("type");
                    sb.append(type);
                    sb.append("_PARAMETER_");
                }
                operationElements.put(sb.toString(), element);
                continue;
            }
            if (elementName.equals("parameter")) {
                Object[] values;
                Attribute valueAttribute;
                element.detach();
                String name = element.attributeValue("name");
                if (name.equals("allowedMethods")) {
                    valueAttribute = element.attribute("value");
                    values = StringUtil.split((String)valueAttribute.getValue(), (char)' ');
                    Arrays.sort(values);
                    valueAttribute.setValue(StringUtil.merge((Object[])values, (String)" "));
                } else if (name.equals("schemaUnqualified")) {
                    valueAttribute = element.attribute("value");
                    values = StringUtil.split((String)valueAttribute.getValue());
                    Arrays.sort(values);
                    valueAttribute.setValue(StringUtil.merge((Object[])values));
                }
                parameterElements.put(name, element);
                continue;
            }
            if (!elementName.equals("typeMapping")) continue;
            element.detach();
            typeMappingElements.put(element.formattedString(), element);
        }
        Java2WsddTask._addElements(serviceElement, arrayMappingElements);
        Java2WsddTask._addElements(serviceElement, typeMappingElements);
        Java2WsddTask._addElements(serviceElement, operationElements);
        Java2WsddTask._addElements(serviceElement, parameterElements);
        content = StringUtil.replace((String)document.formattedString(), (String)"\"/>", (String)"\" />");
        return content;
    }
}

